unit Donnees;
// 22/01/01 DL ajout chemin molecules

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

const
  MainCaption='Phylogne ';
  //CheminIcones='..\Icones\S_';   // les noms de fichiers contenant des icones
                                 // sont les noms des images prcds de S_
  //CheminTaxons='..\Taxons\';
  //CheminCaract='..\Caract\';           // jfr modifie le 27/05/02
  //CheminCaracTxt='..\CaracTxt\';
  //CheminMolecules='..\Molecules\';
  ExtIcone='.bmp';                // obligatoire pour TBitBtn
  ExtImage='.jpg';
  ExtTxt='.rtf';
  ExtFicPhylo='.phg';
  ExtFicMat='.tab';
  ExtFicCar='.car';
  ExtFicCod='.cod';
  ExtFicArb='.arb';
  HauteurPetiteImage=220;
  LargeurPetiteImage=352;
type
// un taxon
  TTaxon=class
    Nom: string;
    Image: string;
    ImageCars: TStringList;
  end;

// liste des taxons
  TTaxons=class(TList)
   NbTaxons: integer;
   NbCaract: integer;
   procedure AddTaxon(T:TTaxon);
   function GetNom(Num: integer): string;
   function GetImage(Num: integer): string;
   function GetIcone(Num: integer): string;
   function GetImageCar(NumEsp: integer; NumCar: integer):string;
   function GetImageCarBig(NumEsp: integer; NumCar: integer):string;
   function GetTexteCar(NumEsp: integer; NumCar: integer):string;
   function GetNumTaxon(NomTaxon: string):integer;
   procedure LireFichier(Fich: string);
  end;

// Caractres
  TCaracteres=class
   TypeCaract:TStringList;
   NCarParType:TStringList;
   Noms: TStringList;
   NomsCourts: TStringList;   // 5 car max
   CarD: TList;               // Caractres dtaills (utiliss ds "Choisir")
                              // Liste de StringList avec 1er elt=Nom, 
                              // 2me=NomCarParent, et suivants=Etats Possibles
   NumTypeComp: TStringList;  // liste des numros de caractres pour la comparaison
   function GetNbCar(NumType: integer):integer;
   function GetNumCar(NumType: integer; Num: integer):integer;
   function GetNomCourt(NumC:integer):string;
   function GetNom(NumC:integer):string;
   function GetNomCarD(NumCarD: integer):string;
   function GetNumCarD(NomCarD: string):integer;
   function GetEtats(NumCarD: integer):TStringList;
   function GetNumCarParent(NumCarD: integer):integer;
   function GetNumTypeComp(Index:integer):integer;
   procedure LireCar(Fich:string);
  end;

 var
    Taxons : TTaxons;
    Caracteres: TCaracteres;
  CheminProg:string ;
  CheminColl:string ;
  CheminCollSelect :string ;
  CheminIcones :string;   // les noms de fichiers contenant des icones
  CheminsArbres:string ;                              // sont les noms des images prcds de S_
  CheminTaxons:string;
  CheminCaract:string;
  CheminCaracTxt:string;
  CheminMolecules:string;
  CheminCodage:string;
  CheminClustal:string;
  CheminAlign :string; //  jfr modifi 2/10/2003
  CheminAide, adresseaide,cheminimages,cheminarbres:string;
  TypePolytom:string;
  ModifRacine:String;
  ExempleArbre:String;
  Quadrillage:string;
  ModifRacineUnordered:string;
   CollectionDefaut:string;
  AfficherArbre:string;
  EnleverTaxon:string;

implementation


procedure TTaxons.AddTaxon(T:TTaxon);
begin
  Add(T);
  inc(NbTaxons);
end;


function TTaxons.GetNom(Num: integer):string;
// renvoie le nom du taxon d'index Num dans la liste
begin
   GetNom:=TTaxon(Items[Num]).Nom;
end;

function TTaxons.GetImage(Num: integer):string;
// renvoie le pathname complet de l'image du taxon d'index Num dans la liste
begin
   GetImage:=CheminTaxons+TTaxon(Items[Num]).Image+ExtImage;
end;

function TTaxons.GetIcone(Num: integer):string;
// renvoie le pathname complet de l'icone du taxon d'index Num dans la liste
begin
   GetIcone:=CheminIcones+TTaxon(Items[Num]).Image+ExtIcone;
end;

function TTaxons.GetNumTaxon(NomTaxon: string):integer;
// renvoie le rang de NomTaxon ds Taxons (de 0  Count-1)
// -1 si NomTaxon n'existe pas
var
  i:integer;
  Trouve:boolean;
begin
  Trouve:=false;
  i:=0;
  while (not Trouve) and (i < Taxons.Count) do
  if (NomTaxon=Taxons.GetNom(i)) then Trouve:=True else inc(i);

  if Trouve then GetNumTaxon:=i else GetNumTaxon:=-1;
end;

function TTaxons.GetImageCar(NumEsp: integer; NumCar: integer):string;
// renvoie le pathname complet de l'image du caractere NumCar pour le taxon NumEsp
begin
    GetImageCar:=CheminCaract+TTaxon(Items[NumEsp]).ImageCars[NumCar]+ExtImage;
end;

function TTaxons.GetImageCarBig(NumEsp: integer; NumCar: integer):string;
// renvoie le pathname complet de l'image de grande taille  ('B'  la fin)
// du caractere NumCar pour le taxon NumEsp
begin
    GetImageCarBig:=CheminCaract+TTaxon(Items[NumEsp]).ImageCars[NumCar]+'B'+ExtImage;
end;

function TTaxons.GetTexteCar(NumEsp: integer; NumCar: integer):string;
// renvoie le pathname complet du texte associ au caractere NumCar
// pour le taxon NumEsp
begin
    GetTexteCar:=CheminCaracTxt+TTaxon(Items[NumEsp]).ImageCars[NumCar]+ExtTxt;
end;

procedure TTaxons.LireFichier(Fich: string);
var
  ListeLignes: TStringList;
  L:TStringList;
  T:TTaxon;
  i,j:integer;
begin
   ListeLignes:=TStringList.Create;
   L:=TStringList.Create;
   if FileExists(Fich) then
      ListeLignes.LoadFromFile(Fich)
   else begin
      ShowMessage('Le fichier '+Fich+' n''existe pas');
      Exit;
   end;
   for i:=0 to ListeLignes.Count - 1 do
   begin
      L.CommaText:=ListeLignes[i];
      T:=TTaxon.Create;
      T.Nom:=L[0];
      T.Image:=L[1];
      T.ImageCars:=TStringList.Create;
      for j:=2 to L.Count-1 do T.ImageCars.Add(L[j]);
      AddTaxon(T);
   end;
   ListeLignes.Free;
   L.Free;
    // NbCaract :=  NbCaract du premier taxon
   NbCaract:=TTaxon(Items[0]).ImageCars.Count;
end;

//================== Caracteres =====================

function TCaracteres.GetNbCar(NumType: integer):integer;
// renvoie le Nb de caractres de type Num (Ex: nb de car biologiques)
begin
  GetNbCar:=StrToInt(NCarParType[NumType]);
end;

function TCaracteres.GetNumCar(NumType: integer; Num: integer):integer;
// renvoie le numro "absolu" du caractre, cad son rang ds la liste
// complte des caractres
var i,N: integer;
begin
   N:=Num;
   for i:=0 to NumType-1 do N:=N+GetNbCar(i);
   GetNumCar:=N;
end;

function TCaracteres.GetNomCourt(NumC:integer):string;
// renvoie le nom court d'un caractre (Ex: Teg., Circ., ...)
begin
 GetNomCourt:=NomsCourts[NumC];
end;

function TCaracteres.GetNom(NumC:integer):string;
// renvoie le nom d'un caractre (Ex: Tgument, App. Circulatoire, ...)
begin
 GetNom:=Noms[NumC];
end;

function TCaracteres.GetNomCarD(NumCarD: integer):string;
begin
   GetNomCarD:=TStringList(CarD.Items[NumCarD])[0];
end;

function TCaracteres.GetNumCarD(NomCarD: string):integer;
// renvoie le rang de NomCarD ds CarD (de 0  Count-1)
// -1 si NomCarD n'existe pas
var
  i:integer;
  Trouve:boolean;
begin
  Trouve:=false;
  i:=0;
  while (not Trouve) and (i < CarD.Count) do
  if (NomCarD=GetNomCarD(i)) then Trouve:=True else inc(i);

  if Trouve then GetNumCarD:=i else GetNumCarD:=-1;
end;

function TCaracteres.GetEtats(NumCarD: integer):TStringList;
var
   Etats: TStringList;
   i: integer;
begin
   Etats:=TStringList.Create;
   for i:=2 to  TStringList(CarD.Items[NumCarD]).Count-1 do
    Etats.Add(TStringList(CarD.Items[NumCarD])[i]);
   GetEtats:=Etats;
end;

function TCaracteres.GetNumCarParent(NumCarD: integer):integer;
begin
   GetNumCarParent:=Noms.IndexOf(TStringList(CarD.Items[NumCarD])[1]);
end;

procedure TCaracteres.LireCar(Fich:string);
var
  ListeLignes: TStringList;
  L: TStringList;
  i: integer;
begin
   ListeLignes:=TStringList.Create;
   if FileExists(Fich) then
      ListeLignes.LoadFromFile(Fich)
   else begin
      ShowMessage('Le fichier '+Fich+' n''existe pas');
      Exit;
   end;
   TypeCaract:=TStringList.create;
   TypeCaract.CommaText:=ListeLignes[0];
   NumTypeComp:=TStringList.create;
   NumTypeComp.CommaText:=ListeLignes[1];
   NCarParType:=TStringList.create;
   NCarParType.CommaText:=ListeLignes[2];
   Noms:=TStringList.create;
   Noms.CommaText:=ListeLignes[3];
   CarD:=TList.Create;
   for i:=4 to ListeLignes.Count-1 do
   begin
      L:=TStringList.Create;
      L.CommaText:=ListeLignes[i];
      CarD.Add(L);
   end;
   ListeLignes.Free;
end;

function TCaracteres.GetNumTypeComp(Index: integer): integer;
begin
   GetNumTypeComp:=StrToInt(NumTypeComp[Index])-1; // -1 car numrotation de 1  n ds le fichier
end;

end.
