unit GraphControlTreeCL;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  CustomGraph,ListArray2,arbre,dataselmat,mynewgrid,fenarbre,typedef,group2,boite;

const
 crRoot = 1;
 crSwap = 2;
 crPolytom = 3;
 crCut = 4;
 crHandPoint = 5;

type
 TBeforeInsert = procedure (sender:TObject) of object;
 TGraphControlTree = class(TGraphControl)

  protected
  FTabGrid: TMyCustomGrid;
  FListArray : TStrListArray;

  Flag_Root:boolean;
  Flag_Swap:boolean;
  Flag_Polytom:boolean;
  Flag_Normal:boolean;
  Flag_Cut :boolean;



  public

  constructor Create(AOwner: TComponent); override;

  procedure InitTree(ATabGrid:TMyCustomGrid);virtual;

  procedure OnFlagRoot;
  procedure OnFlagSwap;
  procedure OnFlagPolytom(polytom :boolean);
  procedure OnFlagNormal;
  procedure OnFlagCut;
  // JFR Modifie le 10/07/00 procdure rajoute
  procedure OnChangeScale(TypeZoom:string);
 end;

 //****************************************************************************/

 TGraphControlTreeDist = class(TGraphControlTree)


  protected

  FTree   : TTree;
  FTreepage: TTreePage;
  FData : TDataSelectDist;

   FFormatDistance : TFormatDistance;
   FCalcDistance : TCalcDistance;
   FBaseCount : TBaseCount;
   FDeleteDistance : TDeleteDistance;

   // jfr modifie le 07/07/00
   // La procdure suivante a t rajoute
   procedure RespClicUp(ClientPoint:TPoint);override;
    procedure RespMouseMove(ClientPoint :TPoint);override;
    
  public
  procedure  setDataOptions;

  function TabDistCreate(ATabGrid :TMyCustomGrid):boolean;
  constructor Create(AOwner: TComponent); override;

  property BaseCount :TBaseCount read FBaseCount write FBaseCount;
  property DeleteDistance : TDeleteDistance read FDeleteDistance write FDeleteDistance;
  property FormatDistance : TFormatDistance read FFormatDistance write FFormatDistance;
  property CalcDistance : TCalcDistance read  FCalcDistance write FCalcDistance;
  

  property Treepage: TTreePage read FTreepage;
  property Tree: TTree read FTree;
 end;

 //****************************************************************************/

 TGraphControlTreeUPGMA = class(TGraphControlTreeDist)

  public
   procedure InitTree(ATabGrid:TMyCustomGrid); override;
 end;

 //****************************************************************************/

 TGraphControlTreeNJ = class(TGraphControlTreeDist)

  public
    procedure InitTree(ATabGrid:TMyCustomGrid); override;
 end;

//******************************************************************************/

 TGraphControlTreeCL = class(TGraphControlTree)
  private

  FTabCod : TStrListArray;
  FDataCL : TDataSelectCL;
  FTreeCL   : TTreeCL;
  FTreepage: TTreePageVert;
  FBeforeInsert: TBeforeInsert;
  protected


  function GetTotalLength:integer;
  function GetUnitLength:integer;



  //procedure RespClicDown(ClientPoint :TPoint);override;
  procedure RespClicUp(ClientPoint:TPoint);override;
  procedure RespMouseMove(ClientPoint :TPoint);override;
  procedure RespMouseDrag(ClientPoint :TPoint);override;

  public

  
  function NameOfFlagTaxonPro :string;
  function GetStrTree:string;

  procedure BeforeInsert(Sender:TObject);

  procedure InitTree(ATabGrid:TMyCustomGrid); override;

  // jfr modifie le 10/04/00
  // procedure rajoute
  procedure InitTreeFile(ATabGrid:TMyCustomGrid; _DND :string);
  procedure InitTreeGroup(ATabGrid:TMyCustomGrid;TreeGroup:TTreegroup);
   procedure InitTreeBoite(ATabGrid:TMyCustomGrid;TreeBoite:TTreeBoite);

  procedure OnChangeListCarac(ATabGrid :TTabGrid; ANameCarac :string);
  procedure OnChangeSelectCarac(AName : string);
  procedure OnChangeTabCod(newTabCod:TStrListArray);
  procedure OnChangeAuto;
 // jfr modifie le 10/07/00
 // procdure enleve OnChangeScale
  procedure OnChangeTree(newTreestr :string);
  procedure UndoTreeAction;
  procedure FirstTreeAction;
  procedure AddTaxonToDataList(num :integer);
  procedure AddTaxonPro(NameTaxon :string);
  procedure DeleteTaxon(NameTaxon :string);

  property Treepage: TTreePageVert read FTreepage;
  property TreeTotalLength : integer read GetTotalLength;
  property TreeUnitLength :integer read GetUnitLength;
  property Tabcod :TstrListarray read FTabCod;

    { Dclarations publiques }
  published
  // JFR modifie le 07/07/00 pour corriger bug li au rajout de taxons
   property OnBeforeInsert:TBeforeInsert read FBeforeInsert write FBeforeInsert ;
    { Dclarations publies }
  end;

procedure Register;

implementation

constructor TGraphControlTree.Create(AOwner: TComponent);
begin
 inherited create(AOwner);

 FListArray:=TStrListArray.CreateListArray;

 Flag_Root:=false;      // jfr modifie le /06/2003
 Flag_Swap:=false;
 Flag_Polytom:=false;
 Flag_Normal:=true;
 Flag_Cut:=false;

 screen.Cursors[crHandPoint]:=LoadCursor(HInstance, 'CRHANDPOINT');
 screen.Cursors[crRoot]:= LoadCursor(HInstance, 'CRROOT');
 screen.Cursors[crSwap]:=LoadCursor(HInstance, 'CRSWAP');
 screen.Cursors[crCut]:=LoadCursor(HInstance, 'CRCUT');
 screen.Cursors[crPolytom]:=LoadCursor(HInstance, 'CRPOLYTOM');
 end;

constructor TGraphControlTreeDist.Create(AOwner: TComponent);
begin
 inherited create(AOwner);
 FData:=nil;
 FTree:=nil;
 FTreepage:=nil;
  FFormatDistance := TPercentage;
  FCalcDistance := observed;
  FBaseCount:=allBase;
  FDeleteDistance:=allremoved;
 end;

procedure TGraphControlTree.InitTree(ATabGrid:TMyCustomGrid);
 begin
  FTabGrid:=ATabGrid;
  FTabgrid.CopyToAListArray(0,0,FListArray);  // la premire ligne est le compteur
 end;

function TGraphControlTreeDist.TabDistCreate(ATabGrid :TMyCustomGrid):boolean;
var
 AStrListArray :TStrListArray;
begin
 result:=true;
 if FData=nil then
    begin result:=false; exit; end;
 AStrListArray:=FData.DistMatrix.TabMatrix;
 ATabGrid.CopyFromAlistArray(0,0,AStrListArray);
 end;



procedure TGraphControlTreeDist.setDataOptions;
 begin
   if FData<>nil then
    begin
     FData.FormatDistance:=FormatDistance;
     FData.BaseCount:=FBaseCount;
     FData.DeleteDistance:=FDeleteDistance;
     FData.CalcDistance:=FCalcDistance;
     end;
 end;



 procedure TGraphControlTree.OnFlagRoot;
begin
 if Flag_Root=False then
  begin
   Flag_Root:=true;
   Flag_Swap:=false;
   Flag_Normal:=false;
   Flag_Cut:=false;
  end
  else
  begin
    Flag_Normal:=true;
    Flag_Root:=false;
    Flag_Swap:=false;
   Flag_Cut:=false;
  end
end;

procedure TGraphControlTree.OnFlagSwap;
begin
 if Flag_Swap=False then
  begin
   Flag_Swap:=true;
   Flag_Root:=false;
   Flag_Normal:=false;
    Flag_Cut:=false;
  end
  else
    begin
    Flag_Normal:=true;
    Flag_Root:=false;
    Flag_Swap:=false;
    Flag_Cut:=false;
  end
end;

procedure TGraphControlTree.OnFlagPolytom(polytom:boolean);
 begin
 if polytom=true then Flag_Polytom:=true
 else  Flag_Polytom:=false;
end;

procedure TGraphControlTree.OnFlagCut;
 begin
 if Flag_Cut=False then
  begin
   Flag_Cut:=true ;
   Flag_Swap:=false;
   Flag_Root:=false;
   Flag_Normal:=false;
   end
  else
   begin
    Flag_Normal:=true;
    Flag_Root:=false;
    Flag_Swap:=false;
    Flag_Cut:=false;
  end
end;

procedure TGraphControlTree.OnFlagNormal;
begin
 Flag_Normal:=true;
 Flag_Root:=false;
 Flag_Swap:=false;
 Flag_Cut:=false;
end;

//*************************************************************************/
//*************************************************************************/
                        // TGraphControlTreeDist
//*************************************************************************/
//*************************************************************************/

// jfr modifie le 07/07/00
// Pour que les Arbres UPGMA et NJ soient swapables et enrainables
procedure TGraphControlTreeDist.RespClicUp(ClientPoint:TPoint); // modifi le 30/03
var
nodeG1,NodeG2 :TGraphNode;
begin
if Flag_Normal=true then  screen.cursor:=crArrow;

if Flag_Swap=true then
begin
 if ClicDownObject= ClicUpObject then       // Pour le swap
 begin
  if (ClicUpObject is TGraphNode) then
   begin
   NodeG2:= ClicUpObject as TGraphNode;
   (TTreePage(ActivePage)).TreeSwap(nodeG2);
   end;
 end;
end;

if Flag_Root=true then
begin
 if ClicDownObject= ClicUpObject then       // Pour le root
  begin
   if (ClicUpObject is TGraphNode) then
    begin
     NodeG2:= ClicUpObject as TGraphNode;
     if NodeG2.IsRoot=false then  (TTreePage(ActivePage)).TreeRoot(nodeG2);
    end;
  end;
 end;

end;

procedure TGraphControlTreeDist.RespMouseMove(ClientPoint:TPoint);// modifi le 30/03
var
nodeG1:TGraphNode;
begin
if MouseMoveObject<>nil then
 begin
  if (MouseMoveObject is TGraphNode) then
   begin
    NodeG1:= MouseMoveObject as TGraphNode;
     if (Flag_cut=true) and (NodeG1.AsChild=false)      then screen.Cursor:=crCut
     else if (Flag_root=true) and (NodeG1.IsRoot=false) then screen.cursor:=crRoot
     else if (Flag_swap=true) and (NodeG1.AsChild=true) then screen.cursor:=crswap
     else if (Flag_root=false) and (Flag_swap=false) and (flag_cut=false)
          then screen.cursor := crcross
          else screen.cursor:=crArrow;
   end;
  end
 else screen.cursor:=crArrow;
end;
procedure TGraphControlTreeUPGMA.InitTree(ATabGrid:TMyCustomGrid);
 var
 TreeStr:string;

 begin

 inherited InitTree(ATabGrid);
 if TMolGrid(ATabGrid).TypeSetMol=notalign then
   begin
    Application.MessageBox('Molcules non alignes','Erreur',MB_OK);
    exit;
   end;

 if FData<>nil then FData.free;

FData:=TDataSelectDistUPGMA.createDataSelect(FListArray);

 SetDataOptions;

 FData.createListMax(FTabgrid.ListSelectRow, FTabgrid.ListSelectCol);
 FData.createList;

 TreeStr:=FData.calculate_DND;

 if FTree<>nil then FTree.free;

 Ftree:=TTreeUPGMA.CreateTree(TreeStr);

 if FTreePage<>nil then FTreePage.free;

 FTreepage:=TTreePage.createpage(self,FTree);

 InsertPage(0,FTreepage);
 invalidate;
 end;

//*************************************************************************/
//*************************************************************************/
                        // TGraphControlTreeNJ
//*************************************************************************/
//*************************************************************************/
procedure TGraphControlTreeNJ.InitTree(ATabGrid:TMyCustomGrid);
 begin

 inherited InitTree(ATabGrid);

  if TMolGrid(ATabGrid).TypeSetMol=notalign then
   begin
    Application.MessageBox('Molcules non alignes','Erreur',MB_OK);
    exit;
   end;

 if FData<>nil then FData.free;
 FData:=TDataSelectDistNJ.createDataSelect(FListArray);

 SetDataOptions;

  FData.createListMax(FTabgrid.ListSelectRow, FTabgrid.ListSelectCol);
  FData.createList;

 if FTree<>nil then FTree.free;

 FTree:=TTreeNJ.CreateTree(FData.calculate_DND);

 if FTreePage<>nil then FTreePage.free;

 FTreepage:=TTreePage.createpage(self,FTree);

 InsertPage(0,FTreepage);
 invalidate;
 end;


 //*************************************************************************/
//*************************************************************************/
                        // TGraphControlTreeCL
//*************************************************************************/
//*************************************************************************/

 function TGraphControlTreeCL.NameOfFlagTaxonPro :string;
 begin
  result:= FTreePage.NameOfFlagTaxonPro;
 end;
  var node,nodef :TnodeBoite;


procedure TGraphControlTreeCL.InitTreeBoite(ATabGrid:TMyCustomGrid; Treeboite:TTreeBoite);
 var temp:String;

 begin

 inherited InitTree(ATabGrid);
 // pour des tests : aucune utilit
 // jfr 06/07
 // node:=tnodeBoite(treeboite.root.nodeChilds.list[0]);
 // nodef:=tnodeBoite(node.nodeChilds.list[0]);
  
 FTabCod:=TStrListArray.createListArray;
 TTabGrid(FTabGrid).CreateTabCod(FTabCod);

 FDataCL:=TDataSelectCL.createDataSelectCL(FListArray,FTabCod);
 FDataCL.createListMax(FTabgrid.ListSelectRow, FTabgrid.ListSelectCol);
 FDataCL.createList;


 FTreepage:=TTreePageVert.createpagevertBoite(self,FDataCL,treeBoite);
 FTreeCL:= TTreeCL(FTreepage.Tree);
                                                
 Insertpage(0,FTreepage);
 invalidate;
 end;


procedure TGraphControlTreeCL.InitTreeGroup(ATabGrid:TMyCustomGrid;TreeGroup:TTreegroup);
 begin

 inherited InitTree(ATabGrid);

 FTabCod:=TStrListArray.createListArray;
 TTabGrid(FTabGrid).CreateTabCod(FTabCod);

 FDataCL:=TDataSelectCL.createDataSelectCL(FListArray,FTabCod);
 FDataCL.createListMax(FTabgrid.ListSelectRow, FTabgrid.ListSelectCol);
 FDataCL.createList;


 FTreepage:=TTreePageVert.createpagevertGroup(self,FDataCL,treeGroup);
 FTreeCL:= TTreeCL(FTreepage.Tree);

 Insertpage(0,FTreepage);
 invalidate;
 end;
// jfr modifie le 10/04/00
// procdure rajoute
procedure TGraphControlTreeCL.InitTreeFile(ATabGrid:TMyCustomGrid;_DND :string);
 begin

 inherited InitTree(ATabGrid);

 FTabCod:=TStrListArray.createListArray;
 TTabGrid(FTabGrid).CreateTabCod(FTabCod);

 FDataCL:=TDataSelectCL.createDataSelectCL(FListArray,FTabCod);
 FDataCL.createListMax(FTabgrid.ListSelectRow, FTabgrid.ListSelectCol);
 FDataCL.createList;


 FTreepage:=TTreePageVert.createpagevert(self,FDataCL,_DND);
 FTreeCL:= TTreeCL(FTreepage.Tree);

 Insertpage(0,FTreepage);
 invalidate;
 end;

procedure TGraphControlTreeCL.InitTree(ATabGrid:TMyCustomGrid);
var
 ClassRef: TClass;
 Typegrid:string;
 begin

 inherited InitTree(ATabGrid);
  ClassRef := ATabGrid.ClassType;
   TypeGrid:= ClassRef.ClassName;

 if TypeGrid='TMolGrid' then
  begin
   if (TMolGrid(ATabGrid)).TypeMol=prot then
      FDataCL:=TDataSelectCLMolPro.createDataSelectCL(FListArray,FTabCod)
   else FDataCL:=TDataSelectCLMolPro.createDataSelectCL(FListArray,FTabCod);
   TDataSelectCLMol(FDataCL).TabCodageCreate;
 end
 else
 begin
   FTabCod:=TStrListArray.createListArray;
   TTabGrid(FTabGrid).CreateTabCod(FTabCod);
   FDataCL:=TDataSelectCL.createDataSelectCL(FListArray,FTabCod);
 end;
 
 FDataCL.createListMax(FTabgrid.ListSelectRow, FTabgrid.ListSelectCol);
 FDataCL.createList;

 // jfr modifie le 10/04/00
 FTreepage:=TTreePageVert.createpagevert(self,FDataCL,'');       // '' rajout
 FTreeCL:= TTreeCL(FTreepage.Tree);

 Insertpage(0,FTreepage);
 invalidate;
 end;

function TGraphControlTreeCL.GetTotalLength:integer;
begin
 result:=FTreeCL.TotalLength;
end;

function TGraphControlTreeCL.GetUnitLength:integer;
begin
 result:=FTreeCL.UnitLength;
end;

procedure TGraphControlTreeCL.RespMouseDrag(ClientPoint:TPoint);
var
nodeG1:TGraphNode;
begin
if (MouseDragObject<>nil) and (Flag_Normal=true) then
 begin
  if (MouseDragObject is TGraphNode) and (MouseDragObject<>ClicDownObject) then
   begin
    NodeG1:= MouseDragObject as TGraphNode;
     if (NodeG1.AsChild=true)and (NodeG1.IsPointAtTop(ClientPoint)=true) then
      begin
       OnFlagPolytom(true);
       screen.Cursor:=crPolytom;
      end
     else
      begin
       OnFlagPolytom(false);
       screen.cursor := crHandPoint;
      end;
   end
  else begin OnFlagPolytom(false);screen.cursor:=crcross; end;
 end
 else begin OnFlagPolytom(false);screen.cursor:=crcross;end;
end;

procedure TGraphControlTreeCL.RespMouseMove(ClientPoint:TPoint);// modifi le 30/03
var
nodeG1:TGraphNode;
begin
if MouseMoveObject<>nil then
 begin
  if (MouseMoveObject is TGraphNode) then
   begin
    NodeG1:= MouseMoveObject as TGraphNode;
     if (Flag_cut=true) and (NodeG1.AsChild=false)      then screen.Cursor:=crCut
     else if (Flag_root=true) and (NodeG1.IsRoot=false) then screen.cursor:=crRoot
     else if (Flag_swap=true) and (NodeG1.AsChild=true) then screen.cursor:=crswap
     else
        begin if (Flag_root=false) and (Flag_swap=false) and (flag_cut=false)
          then screen.cursor := crcross
          else screen.cursor:=crArrow;
        end;  
   end;
  end
 else screen.cursor:=crArrow;
end;

{procedure TGraphControlTreeCL.RespMouseMove(ClientPoint:TPoint);
var
nodeG1:TGraphNode;
begin
if MouseMoveObject<>nil then
 begin
  if (MouseMoveObject is TGraphNode) then
   begin
    NodeG1:= MouseMoveObject as TGraphNode;
     if (Flag_cut=true) and (NodeG1.AsChild=false)      then screen.Cursor:=crCut
     else if (Flag_root=true) and (NodeG1.IsRoot=false) then screen.cursor:=crRoot
     else if (Flag_swap=true) and (NodeG1.AsChild=true) then screen.cursor:=crswap
     else screen.cursor := crcross;
   end;
  end
 else screen.cursor:=crArrow;
end;
}

procedure TGraphControlTreeCL.BeforeInsert(sender:TObject);
 begin
  If Assigned(FBeforeInsert) then FBeforeInsert(sender);
 end;

procedure TGraphControlTreeCL.RespClicUp(ClientPoint:TPoint); // modifi le 30/03
var
nodeG1,NodeG2 :TGraphNode;
begin
if Flag_Normal=true then
begin
screen.cursor:=crArrow;
if ClicDownObject<> ClicUpObject then
 begin
  if (ClicDownObject is TGraphNode) and  (ClicUpObject is TGraphNode) then
   begin
   NodeG1:= ClicDownObject as TGraphNode;
   NodeG2:= ClicUpObject as TGraphNode;

   if NodeG2.IsNodepro=true then exit;

   if NodeG1.IsNodepro=true then
      begin
      // JFR modifie le 07/07/00
       BeforeInsert(self);
       if (Flag_Polytom=false) then
       begin
           (ActivePage as TTreePageVert).GraftTaxonPro(NodeG1,NodeG2);
        end
       else (ActivePage as TTreePageVert).GraftPolytomTaxonPro(NodeG1,NodeG2);
      end
   else begin
   if (NodeG1.IsParent(NodeG2)=false) and (NodeG2.IsParent(NodeG1)=false)then
    begin
     if (NodeG1.IsBrother(NodeG2)=true)and(Flag_Polytom=true) then
       (ActivePage as TTreePageVert).TreeRemoveAndGraftPolytom(NodeG1,NodeG2)

     else if (NodeG1.IsBrother(NodeG2)=false)and (Flag_Polytom=false) then
         (ActivePage as TTreePageVert).TreeRemoveAndGraft(NodeG1,NodeG2)

     else if (NodeG1.IsBrother(NodeG2)=false)and (Flag_Polytom=true) then
         (ActivePage as TTreePageVert).TreeRemoveAndGraftPolytom(NodeG1,NodeG2);
     end;

    if (NodeG1.IsBrother(NodeG2)=true) and (Flag_Polytom=false)
     and (NodeG1.IsInPolytom=true) then
         (ActivePage as TTreePageVert).TreeRemoveAndGraft(NodeG1,NodeG2);
    end;
    end;
   end;
 end;

if Flag_Swap=true then
begin
 if ClicDownObject= ClicUpObject then       // Pour le swap
 begin
  if (ClicUpObject is TGraphNode) then
   begin
   NodeG2:= ClicUpObject as TGraphNode;
     if ActivePage is TTreePageVert then
        (ActivePage as TTreePageVert).TreeSwap(nodeG2);
   end;
 end;
end;

if Flag_Root=true then
begin
if ClicDownObject= ClicUpObject then       // Pour le root
 begin
  if (ClicUpObject is TGraphNode) then
   begin
   NodeG2:= ClicUpObject as TGraphNode;
   if NodeG2.IsRoot=false then
    begin
     if ActivePage is TTreePageVert then
          (ActivePage as TTreePageVert).TreeRoot(nodeG2);
    end;
   end;
 end;
end;
end;
{
procedure TGraphControlTreeCL.RespClicUp(ClientPoint:TPoint);
var
nodeG1,NodeG2 :TGraphNode;
begin
if Flag_Normal=true then
begin
screen.cursor:=crArrow;
if ClicDownObject<> ClicUpObject then
 begin
  if (ClicDownObject is TGraphNode) and  (ClicUpObject is TGraphNode) then
   begin
   NodeG1:= ClicDownObject as TGraphNode;
   NodeG2:= ClicUpObject as TGraphNode;

   if NodeG2.IsNodepro=true then exit;

   if NodeG1.IsNodepro=true then
      begin
       if (Flag_Polytom=false) then
        (ActivePage as TTreePageVert).GraftTaxonPro(NodeG1,NodeG2)
       else (ActivePage as TTreePageVert).GraftPolytomTaxonPro(NodeG1,NodeG2);
      end
   else begin
   if (NodeG1.IsParent(NodeG2)=false) and (NodeG2.IsParent(NodeG1)=false)then
    begin
     if (NodeG1.IsBrother(NodeG2)=true)and(Flag_Polytom=true) then
       (ActivePage as TTreePageVert).TreeRemoveAndGraftPolytom(NodeG1,NodeG2)

     else if (NodeG1.IsBrother(NodeG2)=false)and (Flag_Polytom=false) then
         (ActivePage as TTreePageVert).TreeRemoveAndGraft(NodeG1,NodeG2)

     else if (NodeG1.IsBrother(NodeG2)=false)and (Flag_Polytom=true) then
         (ActivePage as TTreePageVert).TreeRemoveAndGraftPolytom(NodeG1,NodeG2);
     end;

    if (NodeG1.IsBrother(NodeG2)=true) and (Flag_Polytom=false)
     and (NodeG1.IsInPolytom=true) then
         (ActivePage as TTreePageVert).TreeRemoveAndGraft(NodeG1,NodeG2);
    end;
    end;
   end;
 end;

if Flag_Swap=true then
begin
 if ClicDownObject= ClicUpObject then       // Pour le swap
 begin
  if (ClicUpObject is TGraphNode) then
   begin
   NodeG2:= ClicUpObject as TGraphNode;
   if ActivePage is TTreePageVert then
   (ActivePage as TTreePageVert).TreeSwap(nodeG2);
   end;
 end;
end;

if Flag_Root=true then
begin
if ClicDownObject= ClicUpObject then       // Pour le root
 begin
  if (ClicUpObject is TGraphNode) then
   begin
   NodeG2:= ClicUpObject as TGraphNode;
     if ActivePage is TTreePageVert then
          (ActivePage as TTreePageVert).TreeRoot(nodeG2);
   end;
 end;
end;
end;
}

procedure TGraphControlTreeCL.OnChangeTabCod(newtabcod :TStrListArray);
begin
 FtabCod.free;
 FTabCod:=newtabcod;
(ActivePage as TTreePageVert).ChangeTabCod(newtabcod);
 invalidate;
end;

procedure TGraphControlTreeCL.AddTaxonToDataList(num :integer);
begin
  (ActivePage as TTreePageVert).AddTaxonToDataList(num);
end;
//******************************************************************************/
procedure TGraphControlTreeCL.AddTaxonPro(NameTaxon :string);
 begin
 (ActivePage as TTreePageVert).AddTaxonPro(NameTaxon);
 invalidate;
 end;
//******************************************************************************/
procedure TGraphControlTreeCL.DeleteTaxon(NameTaxon :string);
 begin
 (ActivePage as TTreePageVert).TreeTaxonRemove(NameTaxon);
 invalidate;
 end;

//******************************************************************************/
// si le changement dans la liste des caractres est d  une simple invalidation
// ou  une validation, il n'y a pas lieu de changer TabCod. Si le changement est d
//  une modification du TabGrid alors on change Tabcod
procedure TGraphControlTreeCL.OnChangeListCarac(ATabGrid :TTabGrid; ANameCarac :string);
begin
 if ATabGrid <>nil then
 begin

  FListArray.free;
  FtabCod.free;

  FTabGrid:=ATabGrid;
  FTabgrid.CopyToAListArray(0,0,FListArray);
  TTabGrid(FTabGrid).CreateTabCod(FTabCod);
  FDataCL.ChangeTabCod(FTabCod);
 end;

 FDataCL.changeListMaxCol(FTabgrid.ListSelectCol);
 FDataCL.createList;
 (ActivePage as TTreePageVert).ChangeListCarac(ANameCarac);

end;

procedure TGraphControlTreeCL.OnChangeAuto;
var
 data :TDataSelectDistNJ;
 newTreeStr :string;

begin
data:=TdataSelectDistNJ.createDataSelect(FListArray);
data.CopyListMax(FDataCL.ListMaxRow, FDataCL.ListMaxCol);
data.createList;

newTreeStr:=data.calculate_DND;
OnChangeTree(newTreeStr);
data.free;
end;

procedure TGraphControlTreeCL.FirstTreeAction;
var
 lastTree :string;
 begin
  lastTree:=(ActivePage as TTreePageVert).GetFirstTreeAction;
  if lastTree<>'' then
  begin
  (ActivePage as TTreePageVert).ChangeTree(lastTree);
  invalidate;
  end;
 end;

procedure TGraphControlTreeCL.UndoTreeAction;
var
 lastTree :string;
 begin
  lastTree:=(ActivePage as TTreePageVert).GetPriorTreeAction;
  if lastTree<>'' then
  begin
  (ActivePage as TTreePageVert).ChangeTree(lastTree);
  invalidate;
  end;
 end;
 
// JFR modifie le 10/07/00
procedure TGraphControlTree.OnChangeScale(TypeZoom:string);
 begin
 ChangeScale(Typezoom);
 invalidate;
end;

function TGraphControlTreeCL.GetStrTree:string;
var
Tree :TTree ;

begin
  Tree:=(ActivePage as TTreePageVert).Tree;
  GetStrTree:=Tree.Transform_L_DND;
 end;

procedure TGraphControlTreeCL.OnChangeTree(newTreeStr :String);
begin
(ActivePage as TTreePageVert).ChangeTree(newTreeStr);
 invalidate;
end;

procedure TGraphControlTreeCL.OnChangeSelectCarac(AName : string);
begin
(ActivePage as TTreePageVert).ChangeSelectCarac(AName);
 invalidate;
end;


procedure Register;
begin
  RegisterComponents('phylo',[TGraphControlTreeUPGMA,TGraphControlTreeNJ,
                             TGraphControlTreeCL]);
end;

end.
