
unit GraphObject;

interface

 uses
 Windows, SysUtils, Graphics, Controls,classes,typedef;

 type

 PCursorObj=^TCursorObj;
 TCursorObj= record
              index:integer;
              Name:string;
              end;

TActiveObject =class;

TGraphObject = class(TObject)
 protected
 FPenColor     :TColor;
 FPenWidth     :integer;
 FPenStyle     :TPenStyle;

 FBrushColor   :TColor;
 FBrushStyle   :TBrushStyle;

 FOrgX         :integer;
 FOrgY         :integer;

 FParent       : TCustomControl;
 FObjectParent : TGraphObject;
 FObjectAssoc  : Pointer;

 CurDown       :TCursorObj;
 CurMove       :TCursorObj;
 CurUp         :TCursorObj;
 CurDrag       :TCursorObj;

 
  
 public

constructor CreateObject(AParent: TCustomControl);virtual;
function PtInObject(APoint:TPoint):boolean;virtual;

function CreateActiveObject(Apoint :TPoint): TActiveObject;virtual;
 function MouseDown(Button: TMouseButton; Shift: TShiftState; APoint:TPoint):TGraphObject;virtual;
 function MouseMove(Shift: TShiftState;APoint:TPoint):TGraphObject;virtual;
 function MouseDrag(Shift: TShiftState;APoint:TPoint):TGraphObject;virtual;
 function MouseUp(Button: TMouseButton; Shift: TShiftState;APoint:TPoint):TGraphObject;virtual;


function GetPCursorObj(index:TCursorIndex):PCursorObj;
property Parent       :TCustomControl read FParent       write FParent;

property ObjectParent :TGraphObject   read FObjectParent write FObjectParent;
property ObjectAssoc  : Pointer       read FObjectAssoc  write FObjectAssoc;

property OrgX         :integer        read FOrgX         write FOrgX;
property OrgY         :integer        read FOrgY         write FOrgY;

property PenColor     :TColor         read FPenColor     write FPenColor;
property PenWidth     :integer        read FPenWidth     write FPenWidth;
property PenStyle     :TPenStyle      read FPenStyle     write FPenStyle;

property BrushColor   :TColor         read FBrushColor write FBrushColor;
property BrushStyle   :TBrushStyle    read FBrushStyle write FBrushStyle;

procedure Paint(ACanvas:TCanvas);virtual;//S'occupe de TPen et de TBrush puis appelle Draw
procedure Draw(ACanvas:TCanvas);virtual;

end;


//******************************************************************************/

TActiveObject = class(TObject)
 private

 FCanvas       : TCanvas;
 FParent :       TGraphObject;
 CurDown       : TCursorObj;

 protected

 

 

 public

 FStartPt : TPoint;
 FEndPt   : TPoint;

 function GetPCursorObj(index:TCursorIndex):PCursorObj;
 property Canvas       : TCanvas read FCanvas write FCanvas;
 property Parent  : TGraphObject read FParent  write FParent ;

 property StartPt      : TPoint read FStartPt write FStartPt;
 property EndPt        : TPoint read FEndPt write FEndPt;

 procedure Draw (NewPoint :TPoint); virtual ; // doit tre redfinie pour chaque object actif
 procedure paint(NewPoint :TPoint);
 procedure Hide ;
 destructor Destroy;override;
 constructor createActif (ACanvas:TCanvas);virtual;

 end;

//******************************************************************************/
TLineGrow=class (TActiveObject)
 public
  constructor createLine (ACanvas : TCanvas;  APoint:TPoint);
  procedure Draw (NewPoint :TPoint); override;
 end;
//******************************************************************************/
TRectGrow=class (TActiveObject)
 public
  procedure Draw (NewPoint :TPoint); override;
 end;
//******************************************************************************/
TEllipseGrow=class (TActiveObject)
 public
  procedure Draw (NewPoint :TPoint); override;
 end;

//******************************************************************************/
implementation
{*****************************************************************************
                            TActiveObject
*****************************************************************************}
procedure TActiveObject.Draw (NewPoint :TPoint); // doit tre redfinie pour chaque object actif
begin
end;
{*****************************************************************************}
procedure TActiveObject.paint(NewPoint :TPoint);

begin

  with  Canvas do begin
   pen.mode:=pmnotxor;
   pen.color:=clblack;
   brush.style:=bsClear;
  end;
 draw(NewPoint);
end;
{*****************************************************************************}
procedure TActiveObject.Hide;
var
Apoint:TPoint;
 begin

 APoint.x:=0;
 APoint.y:=0;

  with  canvas do begin
   pen.mode:=pmnotxor;
   pen.color:=clblack;
   brush.style:=bsClear;
  end;
 draw(APoint);
end;
{*****************************************************************************}
destructor TActiveObject.Destroy;
 begin
 with  canvas do begin
   pen.mode:=pmcopy;
   pen.color:=clblack;
   brush.style:=bsClear;
  end;
 inherited destroy;
end;
{*****************************************************************************}
function TActiveObject.GetPCursorObj(index:TCursorIndex):PCursorObj;
begin
 result := @CurDown;
 case index of
  crdown : result := @CurDown;
  end;
end;
{*****************************************************************************}
constructor TActiveObject.createActif (ACanvas : TCanvas);
 begin
  Fcanvas:=ACanvas;
  FParent :=nil;
  CurDown.Index:=0; CurDown.name:='';
 end;
 {*****************************************************************************
                            TLineGrow
*****************************************************************************}
constructor TLineGrow.createLine (ACanvas : TCanvas; APoint:TPoint);
 begin
  inherited createActif(ACanvas);
  FStartPt.x:=APoint.x;
  FStartPt.y:=APoint.y;
  FEndPt.x:=APoint.x;
  FEndPt.y:=APoint.y;
 end;

procedure TLineGrow.Draw (NewPoint :TPoint);
 begin
 if(NewPoint.x<>0) and (NewPoint.y<>0) then begin
  FEndPt.x:=NewPoint.x;
  FEndPt.y:=NewPoint.y;
 end;

 with  Canvas do begin
  moveTo(FStartPt.x,FStartPt.y);
  LineTo (FEndPt.x,FEndPt.y);
  end;
end;
{*****************************************************************************
                            TRectGrow
*****************************************************************************}
procedure TRectGrow.Draw (NewPoint :TPoint);
 begin
  FEndPt.x:=FEndPt.x+NewPoint.x;
  FEndPt.y:=FEndPt.y+NewPoint.y;

  Canvas.Rectangle(FStartPt.x,FStartPt.y,FEndPt.x,FEndPt.y);
 end;

{*****************************************************************************
                            TRectGrow
*****************************************************************************}

procedure TEllipseGrow.Draw (NewPoint :TPoint);
begin
  FEndPt.x:=FEndPt.x+NewPoint.x;
  FEndPt.y:=FEndPt.y+NewPoint.y;
   Canvas.Ellipse(FStartPt.x,FStartPt.y,FEndPt.x,FEndPt.y);
 end;
{ *****************************************************************************
                              TGraphObject
*****************************************************************************}
constructor TGraphObject.CreateObject(AParent:TCustomControl);
begin
FParent:=AParent;

FObjectParent:=nil;
FObjectAssoc:=nil;

FPenColor:=clblack;
FPenWidth:=1;
FPenStyle:= psSolid;

FBrushColor:=clblack;
FBrushStyle:=bsSolid;

FOrgX:=0;
FOrgY:=0;

CurDown.Index:=0; CurDown.name:='';
CurUp.Index:=0;   CurUp.name:='';
CurMove.Index:=0; CurMove.name:='';
CurDrag.Index:=0; CurDrag.name:='';
end;

//*******************************************************************************/

procedure TGraphObject.Draw(ACanvas:TCanvas);
begin
end;
//*******************************************************************************/

procedure TGraphObject.Paint(ACanvas:TCanvas);
var
 OldPen:TPen;
 OldBrush:TBrush;

begin
 Oldpen:=TPen.Create;
 OldBrush:=TBrush.Create;

 Oldpen.Assign(ACanvas.pen);
 Oldbrush.Assign(ACanvas.brush);

 ACanvas.pen.color:=FPenColor;
 ACanvas.pen.width:=FPenWidth;
 ACanvas.pen.Style:=FPenStyle;

 ACanvas.brush.style:=FBrushStyle;
 ACanvas.brush.color:=FBrushColor;

 Draw(ACanvas);     // Fonction de dessin proprement dit

 ACanvas.pen.Assign(Oldpen);
 ACanvas.brush.Assign(Oldbrush);

 Oldpen.free;
 OldBrush.free;
end;

 {******************************************************************************}
function TGraphObject.MouseDown(Button: TMouseButton; Shift: TShiftState; APoint:TPoint):TGraphObject;
 begin
  Result := self;
 end;
 {******************************************************************************}
function TGraphObject.MouseMove(Shift: TShiftState;APoint:TPoint):TGraphObject;
begin
Result := self;
end;
 {******************************************************************************}
function TGraphObject.MouseDrag(Shift: TShiftState;APoint:TPoint):TGraphObject;
begin
Result := self;
end;
 {******************************************************************************}
function TGraphObject.MouseUp(Button: TMouseButton; Shift: TShiftState;APoint:TPoint):TGraphObject;
begin
Result := self;
end;
{******************************************************************************}
function TGraphObject.PtInObject(APoint:TPoint):boolean;
begin
result:= false;
end;
 {******************************************************************************}
function TGraphObject.GetPCursorObj(index:TCursorIndex):PCursorObj;
begin
 case index of
  crdown : result := @CurDown;
  crmove : result := @CurMove;
  crup   : result := @CurUp;
  crDrag : result := @CurDrag;
 end;
 end;

 {******************************************************************************}
function TGraphObject.CreateActiveObject(Apoint :TPoint): TActiveObject;
begin
result := nil;
end;

end.
 