unit PhylGlo;
// Fiche contenant la listbox des termes du glossaire
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls ;

type
  TFormGlossaire = class(TForm)
    ListBox1: TListBox;
    procedure ListBox1Click(Sender: TObject);
  private
    { Dclarations prives}
  public
    { Dclarations publiques}
    procedure LireGlossaire;
  end;

var
  FormGlossaire: TFormGlossaire;

  
implementation

uses PhylDef,phylmain;

{$R *.DFM}
procedure TFormGlossaire.LireGlossaire;
// lit le glossaire dans un fichier et affiche les termes dans ListBox1
var
  f:TextFile;
  Ligne,nombis:string;
  Terme: string;    
  p: integer;
begin
   ListBox1.Clear;
   FicGlossaire:='Glossaire.txt';
   Nombis:= ExtractFileName(FicGlossaire);      // jfr modifie le 27/05/02
   FicGlossaire:=searchFile(GetCurrentDir,Nombis,'');
   if FileExists(FicGlossaire) then AssignFile(f,FicGlossaire) else exit;
   Reset(f);
   while not eof(f) do
   begin
      readln(f,Ligne);
      if (Ligne <> '') and (Ligne[1] = CarGlossaire) then
      begin
          // on affiche le premier terme de la ligne
          p:=pos(',',Ligne);
          if p=0 then p:=length(Ligne)+1;
          Terme:=copy(Ligne,2,p-2);
          ListBox1.Items.Add(Terme);
      end;
   end;
   CloseFile(f);
end;


procedure TFormGlossaire.ListBox1Click(Sender: TObject);
var
   Terme: string;
begin
   Terme:=ListBox1.Items[ListBox1.ItemIndex];
   FormDefinition.AfficheDefinition(Terme);
end;

end.
