unit PhylMain;
// DL 9/11/99 ajout fermeture FormMol dans ToutFermer
// DL 16/11/99 ajout appel FormPlche.CreeIcones ds Taxons1Click
// DL 28/11/99 modif EnregistrerMatrice1Click (TableauModifie:=false)
// DL 30/04/00 ajout d'une ligne ds EnregistrerMatrice1Click
//             Arbre1Click (2 espces ncessaires)

interface


uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus,StdCtrls,ExtCtrls,listarray2,group2,typedef,Prtgrids, jpeg,ShellAPI,boite,FileCtrl;

// jfr modifie le 10/04/00
// typedef rajout dans les uses

const
  MsgDonneeAbsente = 'Donne non disponible';
  DateLimite = '07/07/2006';
  //  DateLimite = '01/01/2001'  ou '' pour version illimite;

type
  TFormPrinc = class(TForm)
    MainMenu1: TMainMenu;
    Fichier1: TMenuItem;
    Ouvrir1: TMenuItem;
    Quitter1: TMenuItem;
    Observer1: TMenuItem;
    Comparer1: TMenuItem;
    Choisir1: TMenuItem;
    Aide1: TMenuItem;
    Apropos1: TMenuItem;
    OpenDialog1: TOpenDialog;
    Planche1: TMenuItem;
    Imprimer1: TMenuItem;
    EnregistrerMatrice1: TMenuItem;
    SaveDialog1: TSaveDialog;
    Arbre1: TMenuItem;
    Taxons1: TMenuItem;
    Tableaudecaractres1: TMenuItem;
    Tableaudemolcules1: TMenuItem;
    Classer1: TMenuItem;
    Glossaire1: TMenuItem;
    OuvrirArbre: TMenuItem;
    Enregistrerlarbre1: TMenuItem;
    Image1: TImage;
    LabelLimite: TLabel;
    Label1: TLabel;
    LabelCopyright: TLabel;
    Toutfermer1: TMenuItem;
    Aide2: TMenuItem;
    Aideenligne1: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    Classer2: TMenuItem;
    classerbis: TMenuItem;
    Slectionnernecollection1: TMenuItem;
    N3: TMenuItem;
    Collectionslectionne1: TMenuItem;
    Image2: TImage;
    Label2: TLabel;
    //Label1: TLabel;
    procedure Quitter1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Observer1Click(Sender: TObject);
    procedure Apropos1Click(Sender: TObject);
    procedure Choisir1Click(Sender: TObject);
    procedure Planche1Click(Sender: TObject);
    procedure Comparer1Click(Sender: TObject);
    procedure Imprimer1Click(Sender: TObject);
    procedure EnregistrerMatrice1Click(Sender: TObject);
    procedure Taxons1Click(Sender: TObject);
    procedure Tableaudemolcules1Click(Sender: TObject);
    procedure Arbre1Click(Sender: TObject);
    procedure Tableaudecaractres1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Classer(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Glossaire1Click(Sender: TObject);
    procedure OuvrirArbreClick(Sender: TObject);
    procedure Enregistrerlarbre1Click(Sender: TObject);
    procedure Toutfermer1Click(Sender: TObject);
    procedure Aideenligne1Click(Sender: TObject);
    procedure Aide2Click(Sender: TObject);
    procedure classerbisClick(Sender: TObject);
    procedure Slectionnernecollection1Click(Sender: TObject);
    procedure Collectionslectionne1Click(Sender: TObject);
    procedure chargerImageFond(fileName : String);
   
  private
    { Dclarations prives }
    function ToutFermer(Sender: TObject): boolean;
    function EnregOK(Sender: TObject): boolean;
    function LireNomFicRef(FTab: string): string;
    procedure InitVars;
//    procedure FermerFiches;
  public
    { Dclarations publiques }
    AData : TstrListArray;
    ATri :TTreeGroup;
    AClasse : TTreeBoite ;
    NomFicSansExt : string;
    FichierTableauCourant : string;
    bitmap_save :TBitmap ;
    // jfr modifie le 19/04/02
    FichierAide :string;
    AdresseAide :string;
    FlagAligner :boolean;
    FlagFichierDejaOuvert:boolean;
    TableauModifie : boolean;
    Activite : string;       // activit en cours : Observer,Comparer,Choisir
    function  ExecuteFile(const FileName, Params, DefaultDir: string;  ShowCmd: Integer): THandle;
    function initCollection(collection:string; namecollection:string): boolean;
    procedure Fille(Sender: TForm);
  end;

var
  FormPrinc: TFormPrinc;
// jfr modifie le 27/05/02
function GetDossier( DirCurrent: string; dir :string; stopdir :string):string;
function GetDossierParent(dir :string):string;
function searchFile( Dossier :string; NameFile:string ;stopDir:string):string;
function searchDir(Dossier :string; NameDir:string ;stopDir:string):string;

implementation

uses PhylAbout,Donnees, BarreCar, PhylObs, PhylChoi, PhylPlch, PhylComp,
     DataselMat, CustomGraph,arbre,fenarbre, PhylClade, PhylMol, TreeCLGR,
     PhylTrier, BarreIc, PhylGlo, Mynewgrid,strbox,inifiles, phylClasser;


{$R *.DFM}

// jfr modifie le 27/05/02
function PeekRight(List:TStringList):string;
 begin
  if List.count>=1 then
    begin
      result:=List.Strings[List.Count-1];
      List.Delete(List.Count-1);
    end
  else result:='';
   end;
// jfr modifie le 27/05/02
// Cette fonction cherche le dossier 'dir' dans le dossier 'Dossier' ou dans l'un de ses sous-repertoires
//  l'exceptionn de nodir
function searchdowndir(Dossier :string; dir :string; nodir : string):string;
var
filtre, sousdir,PathDossierTrouve, path:string;
SearchRec:TSearchRec;
Resultat:integer;
Pile :TStringList;
                                                                          
 begin
 filtre:='*.*'; PathDossierTrouve:='';
 pile:=TStringList.Create;
 pile.add( Dossier);
 dir:=lowercase(dir);


 while (Dossier<>'') do
 begin

 If Dossier[length(Dossier)]='\' then Dossier:=copy(Dossier,1,length(Dossier)-1);
  Resultat:=FindFirst(Dossier+'\'+filtre,faDirectory,SearchRec);
  while Resultat=0 do
  begin
    Application.ProcessMessages; // rend la main  windows pour qu'il traite les autres applications (vite que l'application garde trop longtemps la main
     if (SearchRec.Name<>'.') and (SearchRec.Name<>'..')and ((SearchRec.Attr and faDirectory)>0) then // On a trouv un dossier)
     begin
      if ( lowercase(SearchRec.Name)=dir) then
       begin
       PathDossierTrouve:=Dossier+'\'+SearchRec.Name;
       break;
       end
      else
      begin
       sousdir:= Dossier+'\'+SearchRec.Name;
       if (lowercase(sousdir)<>lowercase(nodir)) then pile.add( sousdir);
       
      end;
     end;
    Resultat:=FindNext(SearchRec);
  end;
 if  (PathDossierTrouve='') then Dossier:= PeekRight(Pile)
 else break;
 end;
  FindClose(SearchRec);// libration de la mmoire
  result:=PathDossierTrouve;

end;

// jfr modifie le 27/05/02
function searchdownFile(Dossier :string; afile :string ; nodir :string):string;
var
filtre, sousdir,FichierTrouve, path:string;
SearchRec:TSearchRec;
Resultat,FileAttrs:integer;
Pile :TStringList;

 begin
 filtre:='*.*';  FichierTrouve:='';
 pile:=TStringList.Create;

 pile.add( Dossier);
 FileAttrs := faAnyFile;
 afile:=lowercase(afile);
 FileAttrs := FileAttrs + faDirectory;
 Dossier:= PeekRight(Pile);

 while (Dossier<>'') do
 begin
 Resultat:=FindFirst(Dossier+'\'+filtre,faDirectory+fareadonly+faarchive ,SearchRec);   // tant qu'on trouve un fichier ou un dossier

  while Resultat=0 do
  begin
    Application.ProcessMessages; // rend la main  windows pour qu'il traite les autres applications (vite que l'application garde trop longtemps la main
     if ((SearchRec.Attr and faDirectory)<=0) then // On a trouv un Fichier (et non un dossier)
       begin
           if (lowercase(SearchRec.Name)=afile) then
           begin
           FichierTrouve:=Dossier+'\'+SearchRec.Name;
           break ;
           end
           else FichierTrouve:='';
       end
         else
             if (SearchRec.Name<>'.') and (SearchRec.Name<>'..')
                                      and ((SearchRec.Attr and faDirectory)>0) then // On a trouv un dossier)
               begin
                if ( lowercase(SearchRec.Name)<>lowercase(nodir)) then
                begin
                 sousdir:= Dossier+'\'+SearchRec.Name;
                 pile.add( sousdir);
                 end;
               end;
      
    Resultat:=FindNext(SearchRec);
  end;
 if  (FichierTrouve='') then Dossier:= PeekRight(Pile)
 else break;
 end;
  FindClose(SearchRec);// libration de la mmoire
  result:=FichierTrouve;
end;

function GetDossierParent(dir :string):string;
var
temp:string;
begin
temp:=StripLastToken(dir,'\');
if (temp=dir) then temp:='';
GetDossierParent :=temp;
end;

// Cette une fonction qui recherche le sous-dossier 'namedir' sans son path dans le
// rpertoire 'Dossier' avec son path et qui remonte dans la hirarchie de 'Dossier' jusqu' ce qu'elle
// arrive au disque dur ou au dossier 'stopdir' avec son path


function searchFile( Dossier :string; NameFile:string ;stopDir:string):string;
 var
Resultat :string;
//Dossier :string;
temp, nodir:string;

begin

Resultat:= searchDownFile(Dossier,NameFile,'');
 while (Resultat='')   do
   begin
     nodir:=ExtractFileName(Dossier);

     temp:=StripLastToken(Dossier,'\');
     if (temp=Dossier) then        // On est remont en haut de la hierarchie
        break
     else Dossier:=temp;
     if Dossier=stopDir then break;

    Resultat:= searchDownFile(Dossier,NameFile,nodir);
    end;
result:= Resultat;
end;

function searchDir(Dossier :string; NameDir:string ;stopDir:string):string;
var
Resultat :string;
//Dossier :string;
temp, nodir:string;

begin
// Dossier:=ExtractFilePath(Application.ExeName);

Resultat:= searchDowndir(Dossier,NameDir,'');

// rajout par jfr le 20/06/06
if (Resultat='') and  (Dossier = stopDir) then begin result:='' ; exit; end;

 if (Resultat='')   then
   begin
     nodir:=ExtractFileName(Dossier);
     temp:=StripLastToken(Dossier,'\');
     if (temp<>Dossier) then        // On est remont en haut de la hierarchie
       begin
       Dossier:=temp;
       if Dossier<>stopDir then  Resultat:= searchDowndir(Dossier,NameDir,nodir);
      end; 
    end;
result:= Resultat;
end;

function GetDossier(DirCurrent: string; dir :string; stopdir :string):string;
var
dossier,temp:string;
begin
dossier:=searchdir(DirCurrent,dir,stopdir);
  if (dossier<>'') then dossier :=dossier+'\'
  else
  begin
   temp:=GetcurrentDir ;
   If temp[length(temp)]='\' then temp:=copy(temp,1,length(temp)-1);
   dossier:=temp+'\';
   end;
GetDossier:=dossier;
end;

procedure ControleDate;
var
  NbJours: integer;
   aDate :TDateTime ;
   madate,dateinit,jour,mois,annee:string;
   jour2,mois2,annee2 :word;
   badDate :boolean;

begin
  if (DateLimite = '') then
   begin
    // Version illimite
    FormPrinc.LabelLimite.Visible:=false;
   end
  else
    // VersTDateTimeion limite
    begin
       badDate:=false;
       dateinit:=Datelimite;

        // modifie par jf le 12/10/04
       jour:=RemoveFirst(dateinit,'/');
       mois:=RemoveFirst(dateinit,'/');
       annee:=dateinit;

       FormPrinc.Label1.Caption := 'Nous sommes aujourd''hui le ' + DateToStr(Date);
       DecodeDate(Date,annee2,mois2,jour2);
       if(strToInt(annee)<annee2) then badDate:=true
       else if((strToInt(annee)=annee2)and( strToInt(mois)<mois2)) then badDate:=true
       else if((strToInt(annee)=annee2)and( strToInt(mois)=mois2)and(strToInt(jour)<jour2)) then badDate:=true;

      // NbJours:= Trunc(StrToDate(DateLimite)-Date);
      // if (NbJours < 0) then
      if (badDate=true) then
       begin
          ShowMessage('La dure d''utilisation est dpasse');
          Application.Terminate;
       end;
      // FormPrinc.LabelLimite.Caption:='Version limite au '+DateLimite;
    end;
end;

procedure TFormPrinc.FormCreate(Sender: TObject);
var
repert,section:string;
FIni: TiniFile;
   retour : boolean;
  sr: TSearchRec;
  FileAttrs: Integer;

begin
  Top:=0;
  Left:=0;
  FlagFichierDejaOuvert:=false;


  //bitmap_save.Assign(Image1.Picture.Bitmap);
  //Image1.Picture.Bitmap;

  if (Screen.Height<600) or (Screen.Width<800) then
  begin
    ShowMessage('Ce programme ne peut fonctionner qu''avec une rsolution'+
                ' minimum de 800x600.');
    Application.Terminate;
  end;
  Height:=Screen.Height;
  Width:=Screen.Width;

  // ControleDate;
  // jfr modifie le 19/04/02

  section:='repertoires';

  FIni:=TiniFile.Create(ExtractFilePath(Application.ExeName)+'phylini.ini');

  CheminProg:= ExtractFilePath(Application.ExeName);
  repert :=  GetCurrentdir;

  // on cherche dans le "phylini" le chemin des collections ; si ce chemin n'existe pas on cherche dans le rpertoire
  // parent du programme le rpertoire Collections. Si on ne le trouve pas alors on bloque le programme
   CheminColl:= FIni.ReadString(section,'Chemin-Collections','');

   if (CheminColl='') then CheminColl:=searchDir(repert, 'Collections' , '') ;
   if (CheminColl='') then CheminColl:=searchDir(repert, 'collections' , '') ;

   if (CheminColl='')  then  begin
    ShowMessage('Le programme ne trouve pas le rpertoire des collections : il ne peut fonctionner');
    Application.Terminate;
  end;

    CollectionDefaut:= FIni.ReadString(section,'Collection-defaut','');
    if (CollectionDefaut='') then
    begin
     FileAttrs :=  faAnyFile;
     if FindFirst(CheminColl+'\*.*', FileAttrs, sr) = 0 then
       begin
             repeat
              if ((sr.Name<>'.' )and (sr.Name<>'..')) then begin CollectionDefaut:= sr.Name;  break;end;
             until (FindNext(sr) <> 0);
        FindClose(sr);
       end;
      end;
   if (CollectionDefaut='')  then  begin
    ShowMessage('Le programme ne peut initialiser une collection par dfaut : il ne peut fonctionner');
    Application.Terminate;
  end;


    retour := initCollection(CheminColl+'\'+CollectionDefaut,CollectionDefaut);

   if (retour=true)  then  begin
    ShowMessage('La collection par dfaut est incomplte : le programme ne peut fonctionner');
    Application.Terminate;
  end;
    FormPrinc.caption :='Phylogne - Collection slectionne : '+ CollectionDefaut  ;
    Collectionslectionne1.Caption :=  Collectionslectionne1.Caption +  CollectionDefaut     ;
    Slectionnernecollection1.enabled:=true;

   CheminCollSelect :=  CheminColl+'\'+CollectionDefaut ;

  FIni:=TiniFile.Create(ExtractFilePath(Application.ExeName)+'phylini.ini');

  CheminAide:=FIni.ReadString(section,'aide','');
  if (CheminAide='') then  CheminAide:=GetDossier(GetCurrentdir,'aide','')
  else CheminAide:=GetDossier(GetCurrentdir,CheminAide,'phylogene-C') ;
  FichierAide :=CheminAide+'aide.htm';

  

  AdresseAide:=FIni.ReadString(section,'adresse','');
  if (adresseaide='') then AdresseAide :='http://www.inrp.fr/Acces/biotic/evolut/phylogene/accueil.htm';
   {
  CheminIcones :=FIni.ReadString(section,'icones','');
  if (CheminIcones ='') then CheminIcones:=GetDossier(GetCurrentdir,'Icones','')
  else CheminIcones:=GetDossier(GetCurrentdir,CheminIcones,'');   // les noms de fichiers contenant des icones
  CheminIcones:=CheminIcones+'S_' ;

  CheminTaxons :=FIni.ReadString(section,'taxons','');                                                             // sont les noms des images prcds de S_
  if (CheminTaxons ='') then CheminTaxons:=GetDossier(GetCurrentdir,'Taxons','')
  else  CheminTaxons:=GetDossier(GetCurrentdir,CheminTaxons ,'') ;   // jfr modifie le 27/05/02

  CheminCaract :=FIni.ReadString(section,'caract','');
  if (CheminCaract ='') then CheminCaract:=GetDossier(GetCurrentdir,'Caract','')
  else  CheminCaract:=GetDossier(GetCurrentdir,CheminCaract ,'');


  CheminCaracTxt :=FIni.ReadString(section,'caractTxt','');
  if (CheminCaracTxt ='') then CheminCaracTxt:=GetDossier(GetCurrentdir,'CaracTxt','')
  else CheminCaracTxt:=GetDossier(GetCurrentdir,CheminCaracTxt,'');


   CheminMolecules :=FIni.ReadString(section,'molecules','');
  if (CheminMolecules ='') then CheminMolecules:=GetDossier(GetCurrentdir,'Molecules','')
  else  CheminMolecules:=GetDossier(GetCurrentdir,CheminMolecules ,'');

  // jfr modifi le 02/10/2003
   CheminAlign :=FIni.ReadString(section,'alignement','');
  if (CheminAlign ='') then CheminAlign:=CheminMolecules ;


  CheminArbres :=FIni.ReadString(section,'arbres','');
  if (CheminArbres ='') then CheminArbres:=GetDossier(GetCurrentdir,'Arbres','')
  else CheminArbres:=GetDossier(GetCurrentdir, CheminArbres,'')  ;


  CheminImages :=FIni.ReadString(section,'images','');
  if (CheminImages ='') then CheminImages:=GetDossier(GetCurrentdir,'Images','')
  else CheminImages:=GetDossier(GetCurrentdir,CheminImages ,'');
   }
   
  cheminCodage:=FIni.ReadString(section,'codage','');
  if  (cheminCodage='') then CheminCodage:=GetDossier(GetCurrentdir,'Prog','')
  else CheminCodage:=GetDossier(GetCurrentdir,CheminCodage,'');

  typePolytom:=FIni.ReadString(section,'TypePolytom','');
  if  (typePolytom='')  then TypePolytom:='hard';

 ModifRacine:=FIni.ReadString(section,'ModifRacine','');
  if  (ModifRacine='')  then ModifRacine:='oui';

 Quadrillage:=FIni.ReadString(section,'Quadrillage','');
  if  (Quadrillage='')  then Quadrillage:='oui';


 AfficherArbre:=  FIni.ReadString(section,'Afficher-arbre','');
 if (AfficherArbre='') then AfficherArbre:= 'oui';

 EnleverTaxon:=  FIni.ReadString(section,'enlever-taxon','');
 if (EnleverTaxon='') then EnleverTaxon:= 'oui';

  Fini.Free;
   // ExempleArbre:=FIni.ReadString(section,'ExempleArbre','');
//  if  (ExempleArbre='')  then ExempleArbre:='non';
//   Fini.Free;

  InitVars;

end;

procedure TFormPrinc.InitVars;

begin
  Adata:=TstrListArray.createListarray;
  ATri:=nil;
  AClasse := nil ;
  TableauModifie:=false; // pour tester les modif de tableau ds PhylChoi
  Activite:='Observer';
end;

procedure LireTaxons(NomFic:string);
begin
     // Taxons
     Taxons.Free; // si une autre liste tait en mmoire on la libre
     Taxons:=TTaxons.Create;
     Taxons.LireFichier(NomFic);
end;

procedure LireCar(NomFic:string);
begin
     // Caractres
     Caracteres.Free;
     Caracteres:=TCaracteres.Create;
     Caracteres.LireCar(NomFic);
     Application.CreateForm(TBarreCaract, BarreCaract);
end;

function LireFicsPhylo(NomFic:string):boolean;
// lire les taxons et les caractres
var
  L:integer;
  NomFicCar,Nombis:string;
begin

  Nombis:= ExtractFileName(NomFic);      // jfr modifie le 27/05/02
  Nomfic:=searchFile(GetCurrentDir,Nombis,'');
                       
  if not FileExists(NomFic) then
  begin
    
     ShowMessage('Le fichier '+NomFic+' n''existe pas');
     LireFicsPhylo:=false;
     exit;
  end;
  
  L:=length(ExtractFileExt(NomFic));
  FormPrinc.NomFicSansExt:=copy(NomFic,1,length(NomFic)-L);
  NomFicCar:= FormPrinc.NomFicSansExt + ExtFicCar;
  Nombis:= ExtractFileName(NomFicCar);

  if not FileExists(NomFicCar) then
  begin
     NomFicCar:=searchFile(GetCurrentDir,Nombis,'');
     if (NomFicCar='')  then
     begin
     ShowMessage('Le fichier '+NomFicCar+' n''existe pas');
     LireFicsPhylo:=false;
     exit;
     end;
  end;

  LireTaxons(NomFic);
  LireCar(NomFicCar);

  with FormPrinc do begin
    Observer1.Enabled:=True;
    Comparer1.Enabled:=True;
    Choisir1.Enabled:=True;
    Planche1.Enabled:=True;
  end;
//  if not Assigned(FormChoisir) then
//     Application.CreateForm(TFormChoisir, FormChoisir);
  FormChoisir.Initialise;
  FormPlanche.CreeIcones;


  LireFicsPhylo:=true;
end;

function TFormPrinc.EnregOK(Sender: TObject): boolean;
// propose l'enregistrement du tableau en cours et
// renvoie false si la rponse est Annuler, true sinon
var
   Reponse: Word;
begin
   Reponse:=MessageDlg('Voulez-vous sauvegarder le tableau courant ?',mtCustom,
   [mbYes,mbNo,mbCancel],0);
   if Reponse = mrYes then EnregistrerMatrice1Click(Sender);
   EnregOK:=(Reponse <> mrCancel);
end;

function TFormPrinc.ToutFermer(Sender: TObject):boolean;
// videmment on doit pouvoir faire mieux ...
begin
   if TableauModifie then
        if EnregOK(Sender) then TableauModifie:=false
                           else begin
                                   ToutFermer:=false;
                                   exit;
                                end;
   if Assigned(FormPlanche) then FormPlanche.Close;
   if Assigned(FormObs) then FormObs.Close;
   if Assigned(FormComp) then FormComp.Close;
   if Assigned(FormChoisir) then FormChoisir.Close;
   if Assigned(BarreIcones) then BarreIcones.Close;
   if Assigned(BarreCaract) then BarreCaract.Close;
   if Assigned(FormClasser)  then FormClasser.Close;
   if Assigned(FormTri) then FormTri.Close;
   if Assigned(FormArbre) then FormArbre.Close;
   if Assigned(FormMol) then FormMol.Close;
ToutFermer:=true;
end;



procedure TFormPrinc.Taxons1Click(Sender: TObject);
 var
 index1,index2 : integer;
 chaine1, chaine2: String;
begin

  FlagAligner:=false; // jfr modifie le 10/07/02
  EnregistrerMatrice1.Enabled:=false;
   FlagFichierDejaOuvert:=true;
  openDialog1.InitialDir:=CheminImages;   // jfr modifie le 23/05/02
  with OpenDialog1 do
  begin
     if not ToutFermer(Sender) then exit;
     Title:='Ouverture d''un fichier d''images';
     Filter:='Fichiers Phylogne (*'+ExtFicPhylo+')|*'+ExtFicPhylo;
     Filename:='';
     if Execute then
       if (ExtractFileExt(FileName)=ExtFicPhylo) then
        begin// Fichier phylo
             // ShowMessage('nom du fichier '+FileName);
       if (pos(LowerCase(CheminImages),LowerCase(FileName))=0) then
          begin
           index1:=pos('Collections',FileName);
           if (index1>0) then
            begin
             chaine1:=copy(Filename,index1+12,length(FileName) );
             index2:=pos('/',chaine1);
             if (index2=0) then index2:=pos('\',chaine1);
              chaine2:=copy(chaine1,0,index2-1);
              ShowMessage('Le fichier choisi appartient  la collection  "'+ chaine2 + '" ; ce n''est pas la collection slectionne. Vous devez donc la modifier si vous voulez choisir ce fichier');
             end else
               ShowMessage('Erreur : le fichier choisi n''appartient pas  la collection slectionne');
           exit;
           end;
          end;
          if LireFicsPhylo(FileName)then
          begin
             InitVars;
             FormPlanche.Show;
             Arbre1.enabled:=false;
             Classer1.Enabled:=false;
             Classerbis.Enabled:=false;
          end;
  end;
end;                          

function TFormPrinc.LireNomFicRef(FTab:string):string;
// Lit le nom du fichier de rfrence au dbut d'un fichier .tab
var
   f:TextFile;
   FRef:string;
begin
   if FileExists(FTab) then AssignFile(f,FTab)
                       else begin LireNomFicRef:=''; exit;end;
   Reset(f);
   if not eof(f) then readln(f,FRef);
   CloseFile(f);
   LireNomFicRef:=FRef;
end;

procedure TFormPrinc.Tableaudecaractres1Click(Sender: TObject);
var
  FicTab : string;
  FicRef,NomBis : string;
  DataR,Data : TMemoryStream;
  strRef:string;
  
 index1,index2 : integer;
 chaine1, chaine2: String;
begin
FlagFichierDejaOuvert:=true;
  // openDialog1.InitialDir:=GetDossier(GetCurrentDir,'caract','');   // jfr modifie le 23/05/02
  openDialog1.InitialDir:=CheminCaract;
  with OpenDialog1 do
  begin
  FlagAligner:=false; // jfr modifie le 10/07/02
  EnregistrerMatrice1.Enabled:=false;
    if not ToutFermer(Sender) then exit;
    Title:='Ouverture d''un tableau de caractres';
    Filter:='Tableaux de caractres (*'+ExtFicMat+')|*'+ExtFicMat;
    FileName:='';

    if Execute then
    begin
      FicTab:=FileName;
      if (ExtractFileExt(FicTab)=ExtFicMat) then
      begin
         
          if (pos(LowerCase(CheminCaract),LowerCase(FileName))=0) then
          begin
           index1:=pos('Collections',FileName);
           if (index1>0) then
            begin
                 chaine1:=copy(Filename,index1+12,length(FileName) );
                 index2:=pos('/',chaine1);
                 if (index2=0) then index2:=pos('\',chaine1);
                 chaine2:=copy(chaine1,0,index2-1);
                 ShowMessage('Le fichier choisi appartient  la collection  "'+ chaine2 + '" ; ce n''est pas la collection slectionne. Vous devez donc la modifier si vous voulez choisir ce fichier');
            end else
                  ShowMessage('Erreur : le fichier choisi n''appartient pas  la collection slectionne');
           exit;
            
          end;
          FicRef:=LireNomFicRef(FicTab);
            if not FileExists(FicRef) then
            begin
               Nombis:= ExtractFileName(FicRef);      // jfr modifie le 27/05/02
               FicRef:=searchFile(GetCurrentDir,Nombis,'');
               if (FicRef='') then
               begin
               ShowMessage('Fichier de rfrence introuvable');
               with OpenDialog1 do
               begin
                 Title:='Fichier de rfrence';
                 Filter:='Fichier d''espces (*'+ExtFicPhylo+')|*'+ExtFicPhylo;
                 Filename:='';
                 if Execute then
                 begin
                    FicRef:=FileName;
                    // ajout de FicRef au dbut du fichier FicTab
                    // ncessaire pour compatibilit anciens fichiers
                    StrRef:=FicRef+#13+#10;
                    Data:=TMemoryStream.Create;
                    Data.Write(StrRef[1],length(StrRef));
                    DataR:=TMemoryStream.Create;
                    DataR.LoadFromFile(FicTab);
                    Data.CopyFrom(DataR,DataR.Size);
                    Data.Savetofile(FicTab);
                    Data.Free;
                    DataR.Free;
                 end;   
               end;
               end;
            end;
            if LireFicsPhylo(FicRef) then
            begin
               FichierTableauCourant:=FicTab;
               FormChoisir.ChargeTabGrid(FicTab);
               Choisir1.Click;
               Classer1.Enabled:=true;    // jfr modifie septembre 2001
               Classerbis.Enabled:=true;
               if (AfficherArbre = 'oui') then  begin arbre1.Enabled:=true;   end;
            end;
      end;
    end;
  end;
end;

// jfr modifie le 10/04/00
procedure TFormPrinc.Tableaudemolcules1Click(Sender: TObject);
begin
  FlagFichierDejaOuvert:=true;
   FormMol.ouvrirfichmolClick(Sender);
   if FormMol.Molgrid1.TypeMol<>nul then  FormMol.Show;
   FlagAligner:=false; // jfr modifie le 10/07/02

  EnregistrerMatrice1.Enabled:=false;
end;

procedure TFormPrinc.Planche1Click(Sender: TObject);
begin
  FormPlanche.Show;
end;

procedure TFormPrinc.Imprimer1Click(Sender: TObject);
begin
 //Prtgrid(FormChoisir.TabGrid1,'Titre','Text');
//PrintScale ;
  Print;
end;

procedure TFormPrinc.EnregistrerMatrice1Click(Sender: TObject);
var
   Reponse: Word;
begin
 if (FlagAligner=true) then // jfr modifie le 10/07/02
 begin
   SaveDialog1.InitialDir:=CheminMolecules;
   saveDialog1.Title:='Tableaux de molcules alignes';
   saveDialog1.Filter:='Molcules alignes (*'+' .aln'+')|*'+'.aln';
   if saveDialog1.Execute then FormMol.MolGrid1.SaveToFileALN(savedialog1.filename);
   end
   else
   begin
     SaveDialog1.InitialDir:=CheminCaract ;
   with SaveDialog1 do
   begin
      Title:='Enregistrement d''un tableau de caractres';
      Filter:='Tableaux de caractres (*'+ExtFicMat+')|*'+ExtFicMat;
// Dl 30/04/00
      FileName:=FichierTableauCourant;
      if Execute then
      begin
        if ExtractFileExt(FileName) <> ExtFicMat then
           FileName:=FileName+ExtFicMat;
        if FileExists(FileName) then
        begin
           Reponse:=MessageDlg('Remplacer le fichier ?',mtCustom,
                                 [mbYes,mbNo,mbCancel],0);
           if Reponse <> mrYes then  exit;
        end;
        FormChoisir.TabGrid1.FicRef:=ExtractFileName(NomFicSansExt)+ExtFicPhylo;
        FormChoisir.TabGrid1.SaveToFile(FileName);
        FichierTableauCourant:=FileName;
        TableauModifie:=false;
      end;
   end;
end;
end;

procedure TFormPrinc.Quitter1Click(Sender: TObject);
{ Termine le programme }
begin
    Close;
end;

procedure TFormPrinc.Observer1Click(Sender: TObject);
var
activ:string;
begin
 { if ((Pos('Arbre',Activite)=0) and (Pos('Classer',Activite)=0)
      and (Activite<>'Classer') and (Activite<>'Arbre'))
  then Activite:='Observer';      }     // jfr modifie septembre 2001
  //Activite:='Observer';
  if(Pos('Arbre',Activite)<>0) or (Pos('Classer',Activite)<>0) then
  begin
   Activ:='';
   if(Pos('Arbre',Activite)<>0)then Activ :=Activ +'Arbre ';
   if(Pos('Classer',Activite)<>0)then Activ :=Activ +'Classer ';
   Activ :=Activ +'Observer' ;// jfr modifie 15 octobre 2001
   Activite:=activ;
  end
  else Activite:='Observer' ;
  {if(Pos('Arbre',Activite)<>0) then  Activite:=Arbre+'-'+'Observer'
  else if (Pos('Classer',Activite)<>0) then  Activite:=Classer+'-'+'Observer' 
  else  Activite:='Observer'; }

  

  FormObs.ImageCar.tag:=-1;             // jfr modifie 16 octobre 2001
  FormObs.ImageCar.Hide;                // pour cacher les fenetres d'image et de texte
  FormObs.texteCar.Visible:=false;
  FormObs.invalidate;  

  FormObs.Show;
  Choisir1.Enabled:=true;     // jfr modifie 12/12/01
  FormComp.Hide;
  FormChoisir.Hide;
end;

procedure TFormPrinc.Comparer1Click(Sender: TObject);
var
activ:string;
begin
 {if (Activite<>'Comparer-Arbre')    // jfr modifie septembre 2001
   then Activite:='Comparer';   }
  //Activite:='Comparer';
  {if(Pos('Arbre',Activite)<>0) or (Pos('Classer',Activite)<>0) then
    Activite:=Activite+'-'+'Comparer' // jfr modifie 15 octobre 2001    }
  if(Pos('Arbre',Activite)<>0) or (Pos('Classer',Activite)<>0) then
  begin
   Activ:='';
   if(Pos('Arbre',Activite)<>0)then Activ:=Activ+'Arbre ';
   if(Pos('Classer',Activite)<>0)then Activ:=Activ+'Classer ';
   Activ:=Activ+'Comparer'; ;// jfr modifie 15 octobre 2001
   Activite:=activ ;
  end
    else    Activite:='Comparer';
    Choisir1.Enabled:=true;     // jfr modifie 12/12/01
  FormComp.Show;
  FormChoisir.Hide;
  FormObs.Hide;
end;


procedure TFormPrinc.Choisir1Click(Sender: TObject);
begin
   ATri:=nil;
   AClasse:=nil;
   Activite:='Choisir';
   FormChoisir.Show;
   FormComp.Hide;
   FormObs.Hide;

// sans doute mal plac : il faudrait s'assurer que des espces et des car ont
//   t choisis
   Choisir1.Enabled:=false;
   Classer1.Enabled:=false;    // jfr modifie septembre 2001
   Classerbis.Enabled:=false;
   Arbre1.Enabled:=false;
   EnregistrerMatrice1.Enabled:=true;
end;

procedure TFormPrinc.Classer(Sender: TObject);
begin
   if (FormChoisir.TabGrid1.ColCount > 1) and (FormChoisir.TabGrid1.RowCount > 1) then
     begin
     Arbre1.Enabled:=false;
     if ((pos('Classer',Activite)<>0)or (Activite='Classer')) then
       FormTri.Show                            // jfr modifie septembre 2001
     else
      begin
      FormTri.Close;
      FormClasser.Close;
      Activite:='Classer';
   // ligne suivante ajoute par JFR et DL le 20/03/00
      FormTri.TabGrid1.FFileName:=NomFicSansExt;
      FormTri.ChargeTabGrid(Sender);
       FormTri.Show;
      end
     end
   else
      Classer1.Enabled:=false;
      Classerbis.Enabled:=true;
      Choisir1.Enabled:=true;     // jfr modifie 12/12/01
  FormObs.Hide;        //jfr modifie 16 octobre 2001
  FormComp.Hide;     // Pour que les options du menu s'affichent si besoin
end;

procedure TFormPrinc.Arbre1Click(Sender: TObject);
begin
   if (FormChoisir.TabGrid1.ColCount > 1) and (FormChoisir.TabGrid1.RowCount > 2) then
     begin
      if((pos('Arbre',Activite)<>0)or (Activite='Arbre'))
      then  FormArbre.show        // jfr modifie septembre 2001
      else
      begin
        FormArbre.Close;
        if (Activite='Classer')
           then Activite:='Classer Arbre'
        else  if (Activite ='boite')
           then Activite:= 'boite Arbre'
        else   
         Activite:='Arbre';

         FormArbre.TabGrid1.FFileName:=NomFicSansExt;
         FormArbre.ChargeTabGrid(Sender);
         // jfr modifie le 10/04/00 (bug sinon)
          FormArbre.Optionslegendes.Enabled:=false;
          FormArbre.removelabel;
          FormArbre.Show;
          Enregistrerlarbre1.Enabled:=true;
          OuvrirArbre.Enabled:=true;  // provisoire pour LoadTree
          end
     end
   else
      Arbre1.Enabled:=false;
      Classerbis.Enabled:=true;
  Choisir1.Enabled:=true;     // jfr modifie 12/12/01
    
  FormObs.Hide;        //jfr modifie 16 octobre 2001
  FormComp.Hide;     // Pour que les options du menu s'affichent si besoin
end;

procedure TFormPrinc.Apropos1Click(Sender: TObject);
begin
   AboutBox.ShowModal;
end;

procedure TFormPrinc.Fille(Sender: TForm);
// Sender devient "fille" de FormPrinc  et FicheActive
begin
   with Sender do
   begin
      Parent:=Self;
      BoundsRect:=Self.ClientRect;
      BorderStyle:=bsNone;
   end;
end;

procedure TFormPrinc.FormDestroy(Sender: TObject);
begin
   AData.free;
   if Atri<>nil then Atri.free;
   if AClasse<>nil then AClasse.free;
end;

procedure TFormPrinc.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if not ToutFermer(Sender) then CanClose := False;
end;

procedure TFormPrinc.Glossaire1Click(Sender: TObject);
begin
  FormGlossaire.LireGlossaire;
  FormGlossaire.Show;
end;

// jfr modifie le 10/04/00
// toute la procdure est modifie
procedure TFormPrinc.OuvrirArbreClick(Sender: TObject);
var
  FicArb : string;
  ListArray: TStrListArray;
  strlist:TStringList;
  data:TFileStream;
  strTree,strTab,strRef,nombis :string;
  L:integer;
    index1,index2 : integer;
   chaine1, chaine2: String;
begin
 // openDialog1.InitialDir:=getdossier(GetCurrentdir,'Arbres','');
 FlagFichierDejaOuvert:=true;
 FlagAligner:=false;
 EnregistrerMatrice1.Enabled:=false;

 openDialog1.InitialDir:=CheminArbres;
  with OpenDialog1 do
  begin
    if not ToutFermer(Sender) then exit;
       Title:='Ouverture d''un arbre';
       Filter:='Arbres (*'+ExtFicArb+')|*'+ExtFicArb;
       FileName:='';

    if Execute then
    begin
     if (pos(LowerCase(CheminArbres),LowerCase(FileName))=0)   then
       
          begin
           index1:=pos('Collections', FileName);
           if (index1>0) then
            begin
                 chaine1:=copy( Filename,index1+12,length( FileName) );
                 index2:=pos('/',chaine1);
                 if (index2=0) then index2:=pos('\',chaine1);
                 chaine2:=copy(chaine1,0,index2-1);
                 ShowMessage('Le fichier choisi appartient  la collection  "'+ chaine2 + '" ; ce n''est pas la collection slectionne. Vous devez donc la modifier si vous voulez choisir ce fichier');
            end else
                  ShowMessage('Erreur : le fichier choisi n''appartient pas  la collection slectionne');
           exit;
            
          end;
      FicArb:=FileName;    // Fic Arb est un nom gnrique qui contient les noms
                           // du fichier arbre : strTree
                           // du fichier Tab : strTab
                           // et du fichier gnral : strRef
      if (ExtractFileExt(FicArb)=ExtFicArb) then
      begin
         try
            strlist:=TStringlist.Create;
            data:=TFileStream.Create(filename,fmOpenRead);
            ListArray:=TStrListArray.createlistArray;

             data.seek(0,0);
             strlist.loadfromstream(data);

             strtab:=StrList.strings[0];
             strRef:=StrList.strings[1];
             strtree:= StrList.strings[2];

            if LireFicsPhylo(strRef) then
              begin
               Nombis:= ExtractFileName(strtab);      // jfr modifie le 27/05/02
               strtab:=searchFile(GetCurrentDir,Nombis,'');
               if FileExists(strtab)  then
                  begin
                    FichierTableauCourant:=strTab;
                    FormChoisir.ChargeTabGrid(strTab);
                    Choisir1.click;

                    FormChoisir.TabGrid1.CopyToAListArray(0,0,ListArray);
                   with FormArbre do
                    begin
                      Tabgrid1.RowCount:=FormChoisir.Tabgrid1.RowCount;
                      Tabgrid1.ColCount:=FormChoisir.Tabgrid1.ColCount;

                      TabGrid1.CopyFromAlistArray(0,0,ListArray);

                      L:=length(ExtractFileExt(strref));  // JFR modifie le 07/07/00  ligne ajoute
                      Tabgrid1.FFileName:=copy(strref,1,length(strref)-L) ; // JFR modifie le 07/07/00 :=strtab;

                      TabGrid1.SelectAllCol(true);
                      TabGrid1.SelectAllRow(true);

                       GCT1.InitTreeFile(TabGrid1,strtree);
                       LongTot.Text:=intToStr(GCT1.TreeTotalLength);
                       LongPart.Text:=intToStr(GCT1.TreeUnitLength);

                       FormArbre.Optionslegendes.Enabled:=false;
                       FormArbre.removelabel;
                       FormArbre.Show;
                       Enregistrerlarbre1.Enabled:=true;
                       OuvrirArbre.Enabled:=true;
                     end;
                    end
                 else
                  ShowMessage('Le fichier '+ strTab+' n''existe pas');
              end;
         finally
         strlist.free;
         data.free;
         ListArray.free;
         end;
   end;
end;
end;
end;

// jfr modifie le 10/04/00
// toute la procdure est modifie
procedure TFormPrinc.Enregistrerlarbre1Click(Sender: TObject);
var
   Reponse: Word;
   StrTab,StrTree,StrRef:String;
   Stream: TMemorystream;
begin
   if TableauModifie then
   begin
     ShowMessage('Vous devez enregistrer le tableau avant d''enregistrer l''arbre');
     exit;
   end;
  // SaveDialog1.InitialDir:=getdossier(GetCurrentdir,'Arbres','');
  SaveDialog1.InitialDir:=CheminArbres;
   with SaveDialog1 do
   begin
      FileName:='';
      Title:='Enregistrement d''un arbre';
      Filter:='Arbre (*'+ExtFicArb+')|*'+ExtFicArb;
      if Execute then
      begin
       if  (ExtractFileExt(FileName) <> '') then
        begin
          if ExtractFileExt(FileName) <> ExtFicArb then
          begin
            FileName:=ChangeFileExt(FileName,'');
            FileName:=FileName+ExtFicArb;
           end;
         end else FileName:=FileName+ExtFicArb;

        if FileExists(FileName) then
        begin
           Reponse:=MessageDlg('Remplacer le fichier ?',mtCustom,
                                 [mbYes,mbNo,mbCancel],0);
           if Reponse <> mrYes then  exit;
        end;
        // jfr modifie le 10/04/00
        // remplace savetree dans TreeCLGR
         try
          Stream:=TMemorystream.Create;
          StrTab:=ExtractFilename(FichierTableauCourant)+#13+#10;
          StrRef:=NomFicSansExt+ExtFicPhylo;
          StrRef:=ExtractFilename(StrRef)+#13+#10;
          Stream.Write(StrTab[1],length(StrTab));
          Stream.Write(StrRef[1],length(StrRef));
          StrTree:=FormArbre.GCT1.GetStrTree+#13+#10;
          Stream.Write(Strtree[1],length(StrTree));
          Stream.savetofile(FileName);
         finally
            Stream.free;
         end;

      end;
   end;
end;

procedure TFormPrinc.Toutfermer1Click(Sender: TObject);
begin
ToutFermer(sender);

Observer1.Enabled:=false;
Comparer1.Enabled:=false;
Choisir1.Enabled:=false;
Classer1.Enabled:=false;    // jfr modifie septembre 2001
Arbre1.Enabled:=false;
Classerbis.Enabled:=false;
FlagFichierDejaOuvert:=false;
EnregistrerMatrice1.Enabled:=false;
EnregistrerlArbre1.Enabled:=false;
Planche1.Enabled:=false;
Imprimer1.Enabled:=true;     // jfr modifie septembre 2007 (pour viter que
// cette option disparaisse : il faudrait affiner pour que son apparition soit plus contextualise

end;

 // jfr modifie le 19/04/02 : les trois fonctions suivantes ont t rajoutes
function TFormPrinc.ExecuteFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
var
  zFileName, zParams, zDir: array[0..79] of Char;
begin
  Result := ShellExecute(Application.MainForm.Handle, nil,
    StrPCopy(zFileName, FileName), StrPCopy(zParams, Params),
    StrPCopy(zDir, DefaultDir), ShowCmd);
end;

procedure TFormPrinc.Aideenligne1Click(Sender: TObject);
begin
ExecuteFile('IEXPLORE.EXE',AdresseAide ,AdresseAide ,SW_SHOWMAXIMIZED);
end;

procedure TFormPrinc.Aide2Click(Sender: TObject);
begin
ExecuteFile('IEXPLORE.EXE',FichierAide ,FichierAide ,SW_SHOWMAXIMIZED);
end;

 

procedure TFormPrinc.classerbisClick(Sender: TObject);
begin
 if (FormChoisir.TabGrid1.ColCount > 1) and (FormChoisir.TabGrid1.RowCount > 1) then
     begin
      Arbre1.Enabled:=false;
      if ((pos('boite',Activite)<>0)or (Activite='boite')) then
       FormClasser.Show                            // jfr modifie septembre 2001
       else
       begin
        FormClasser.Close;  // remet AClasse  Nil
        FormTri.Close;
        Activite:='boite';

        FormClasser.TabGrid1.FFileName:=NomFicSansExt;
        FormClasser.ChargeTabGrid(Sender);
        FormClasser.Show;
        end
     end
   else
      Classer1.Enabled:=true;
      Classerbis.Enabled:=false;
      Choisir1.Enabled:=true;     // jfr modifie 12/12/01
  FormObs.Hide;        //jfr modifie 16 octobre 2001
  FormComp.Hide;     // Pour que les options du menu s'affichent si besoin
end;

procedure TFormPrinc.Slectionnernecollection1Click(Sender: TObject);

var
sDirectory,CheminIconesProv,CheminTaxonsProv,CheminCaractProv,CheminCaracTxtProv,CheminMoleculesProv,CheminAlignProv: String;
repert,section,CheminArbresProv,CheminImagesProv, cheminCodageProv, namecol:string;
FIni: TiniFile;
probleme :boolean;
    Reponse: Word;
begin
probleme:=false;
section:='repertoires';
sDirectory := CheminColl;
if (FlagFichierDejaOuvert=true)then
 begin
 if (application.messagebox('Changer de collection fermera tous les fichiers ouverts  :  continuer ?' , 'Attention !',mb_okcancel)=IDCANCEL)then exit;
 end;

if SelectDirectory('Slectionnez la collection dsire en cliquant sur son nom. Cliquez ensuite sur OK', CheminColl, sDirectory) then
begin
     namecol:=ExtractFilename( sDirectory);
if (namecol='Collections') then       begin ShowMessage('Vous n''avez pas slectionn une collection : recommencez !' );exit;end;
if (namecol='Arbres') or (namecol='Aide')  or ( namecol='Carac-Images') or (namecol='Carac-Textes') or (namecol='Fichiers-Images') or (namecol='Icones') or (namecol='Molecules')or (namecol='Programmes') or (namecol='Tableaux-Caracteres') or(namecol='Taxons') or (namecol='Utiles')
then       begin ShowMessage('Le dossier slectionn n''est pas une collection mais un sous-dossier d''une collection : recommencez !' );exit;end;
Reponse:=MessageDlg('Nouvelle collection slectionne : '+namecol,mtWarning ,  [mbYes,mbCancel],0);
if Reponse = mrCancel then exit;

FIni:=TiniFile.Create(ExtractFilePath(Application.ExeName)+'phylini.ini');

CheminIconesProv:= CheminIcones;
CheminTaxonsProv:=CheminTaxons;
CheminCaractProv:=CheminCaract;
CheminCaracTxtProv:=CheminCaracTxt;
CheminMoleculesProv:=CheminMolecules;
CheminAlignProv:=CheminAlign ;


CheminIcones :=FIni.ReadString(section,'icones','');
  if (CheminIcones ='') then CheminIcones:=searchdir(sdirectory,'Icones',sDirectory)
  else CheminIcones:= searchdir(sdirectory,CheminIcones,sDirectory);   // les noms de fichiers contenant des icones

  if (CheminIcones = '') then begin ShowMessage('La collection est incomplte : il manque le dossier "Icones"') ; probleme :=true;   end
  else CheminIcones:=CheminIcones+'\S_' ;

 if (probleme = false ) then begin
  CheminTaxons :=FIni.ReadString(section,'taxons',sDirectory);                                                             // sont les noms des images prcds de S_
  if (CheminTaxons ='') then CheminTaxons:=searchdir(sdirectory,'Taxons',sDirectory)
  else  CheminTaxons:=searchdir(sdirectory,CheminTaxons ,'') ;   // jfr modifie le 27/05/02
  if (CheminTaxons = '') then  begin ShowMessage('La collection est incomplte : il manque le dossier "Taxons"') ; probleme :=true;   end
  else  CheminTaxons := CheminTaxons +'\';
  end;

 if (probleme = false ) then begin
  CheminCaract :=FIni.ReadString(section,'caract','');
  if (CheminCaract ='') then CheminCaract:=searchdir(sdirectory,'Caract',sDirectory)
  else  CheminCaract:=searchdir(sdirectory,CheminCaract ,sDirectory);
 if (CheminCaract = '') then begin ShowMessage('La collection est incomplte : il manque le dossier "carac-images" ') ; probleme :=true;   end
 else CheminCaract := CheminCaract+'\';
  end;

 if (probleme = false ) then begin
  CheminCaracTxt :=FIni.ReadString(section,'caractTxt','');
  if (CheminCaracTxt ='') then CheminCaracTxt:=searchdir(sdirectory,'CaracTxt',sDirectory)
  else CheminCaracTxt:=searchdir(sdirectory,CheminCaracTxt,sDirectory);
if (CheminCaracTxt = '') then begin ShowMessage('La collection est incomplte : il manque le dossier "carac-texte" ') ; probleme :=true;   end
else CheminCaracTxt := CheminCaracTxt+'\';
  end;

 if (probleme = false ) then begin
   CheminMolecules :=FIni.ReadString(section,'molecules','');
  if (CheminMolecules ='') then CheminMolecules:=searchdir(sdirectory,'Molecules',sDirectory)
  else  CheminMolecules:=searchdir(sdirectory,CheminMolecules ,sDirectory);

  if (CheminMolecules  = '') then begin ShowMessage('La collection est incomplte : il manque le dossier "molcules"') ; probleme :=true;   end
  // jfr modifi le 02/10/2003
   else CheminMolecules := CheminMolecules+'\';
   CheminAlign :=FIni.ReadString(section,'alignement',sDirectory);
  if (CheminAlign ='') then CheminAlign:=CheminMolecules ;
 end;

 if (probleme = false ) then begin
  CheminArbres :=FIni.ReadString(section,'arbres','');
  if (CheminArbres ='') then CheminArbres:=searchdir(sdirectory,'Arbres',sDirectory)
  else CheminArbres:=searchdir(sdirectory, CheminArbres,sDirectory)  ;
if (CheminArbres = '') then begin ShowMessage('La collection est incomplte : il manque le dossier "Arbres"') ; probleme :=true;   end
else    CheminArbres := CheminArbres+'\';
 end;

 if (probleme = false ) then begin
  CheminImages :=FIni.ReadString(section,'images','');
  if (CheminImages ='') then CheminImages:=searchdir(sdirectory,'Images',sDirectory)
  else CheminImages:=searchdir(sdirectory,CheminImages ,sDirectory);
if (CheminImages = '') then begin ShowMessage('La collection est incomplte : il manque le dossier "Fichier-Images"') ; probleme :=true;   end
else    CheminImages :=CheminImages+'\';
 end;

 if (probleme = false ) then begin
  cheminCodage:=FIni.ReadString(section,'codage','');
  if  (cheminCodage='') then CheminCodage:=searchdir(sdirectory,'Prog',sDirectory)
  else CheminCodage:=searchdir(sdirectory,CheminCodage,sDirectory);
if (CheminCodage = '') then begin ShowMessage('La collection est incomplte : il manque le dossier "Utiles"') ; probleme :=true;   end
else  CheminCodage := CheminCodage+'\';
end;

Collectionslectionne1.Caption :=  'Collection slectionne :' + ExtractFileName(sDirectory) ;

if (probleme = true)then
 begin
   CheminIcones:= CheminIconesProv;
   CheminTaxons:=CheminTaxonsProv;
   CheminCaract:=CheminCaractProv;
   CheminCaracTxt:=CheminCaracTxtProv;
   CheminMolecules:=CheminMoleculesProv;
   CheminAlign:=CheminAlignProv ;
 end
 else
 begin
   CheminCollSelect := sDirectory ;
   Collectionslectionne1.Caption :=  'Collection slectionne : ' + ExtractFileName(sDirectory) ;
    FormPrinc.caption :='Phylogne - Collection slectionne : '+ ExtractFileName(sDirectory) ; ;
   Toutfermer1Click(Sender)  ;
   chargerImageFond(ExtractFileName(sDirectory)+'.jpg');
   FlagFichierDejaOuvert:=false;
 end;
 end;
 end;


function TFormprinc.initCollection(collection:string; namecollection:string): boolean;

var
section:string;
FIni: TiniFile;
probleme :boolean;
begin
section:='repertoires';
probleme:=false;

FIni:=TiniFile.Create(ExtractFilePath(Application.ExeName)+'phylini.ini');
CheminIcones :=FIni.ReadString(section,'icones','');
  if (CheminIcones ='') then CheminIcones:=searchdir(collection,'Icones',collection)
  else CheminIcones:= searchdir(collection,CheminIcones,collection);   // les noms de fichiers contenant des icones

  if (CheminIcones = '') then begin ShowMessage('La collection '+namecollection+' est incomplte : il manque le dossier "Icones"') ; probleme :=true;   end
  else CheminIcones:=CheminIcones+'\S_' ;

 if (probleme = false ) then begin
  CheminTaxons :=FIni.ReadString(section,'taxons',collection);                                                             // sont les noms des images prcds de S_
  if (CheminTaxons ='') then CheminTaxons:=searchdir(collection,'Taxons',collection)
  else  CheminTaxons:=searchdir(collection,CheminTaxons ,'') ;   // jfr modifie le 27/05/02
  if (CheminTaxons = '') then  begin ShowMessage('La collection '+namecollection+' est incomplte : il manque le dossier "Taxons"') ; probleme :=true;   end
  else  CheminTaxons := CheminTaxons +'\';
  end;

 if (probleme = false ) then begin
  CheminCaract :=FIni.ReadString(section,'caract','');
  if (CheminCaract ='') then CheminCaract:=searchdir(collection,'Caract',collection)
  else  CheminCaract:=searchdir(collection,CheminCaract ,collection);
 if (CheminCaract = '') then begin ShowMessage('La collection '+namecollection+' est incomplte : il manque le dossier "carac-images" ') ; probleme :=true;   end
 else CheminCaract := CheminCaract+'\';
  end;

 if (probleme = false ) then begin
  CheminCaracTxt :=FIni.ReadString(section,'caractTxt','');
  if (CheminCaracTxt ='') then CheminCaracTxt:=searchdir(collection,'CaracTxt',collection)
  else CheminCaracTxt:=searchdir(collection,CheminCaracTxt,collection);
if (CheminCaracTxt = '') then begin ShowMessage('La collection '+namecollection+' est incomplte : il manque le dossier "carac-texte" ') ; probleme :=true;   end
else CheminCaracTxt := CheminCaracTxt+'\';
  end;

 if (probleme = false ) then begin
   CheminMolecules :=FIni.ReadString(section,'molecules','');
  if (CheminMolecules ='') then CheminMolecules:=searchdir(collection,'Molecules',collection)
  else  CheminMolecules:=searchdir(collection,CheminMolecules ,collection);

  if (CheminMolecules  = '') then begin ShowMessage('La collection '+namecollection+' est incomplte : il manque le dossier "molcules"') ; probleme :=true;   end
  // jfr modifi le 02/10/2003
   else CheminMolecules := CheminMolecules+'\';
   CheminAlign :=FIni.ReadString(section,'alignement',collection);
  if (CheminAlign ='') then CheminAlign:=CheminMolecules ;
 end;

 if (probleme = false ) then begin
  CheminArbres :=FIni.ReadString(section,'arbres','');
  if (CheminArbres ='') then CheminArbres:=searchdir(collection,'Arbres',collection)
  else CheminArbres:=searchdir(collection, CheminArbres,collection)  ;
if (CheminArbres = '') then begin ShowMessage('La collection '+namecollection+' est incomplte : il manque le dossier "Arbres"') ; probleme :=true;   end
else    CheminArbres := CheminArbres+'\';
 end;

 if (probleme = false ) then begin
  CheminImages :=FIni.ReadString(section,'images','');
  if (CheminImages ='') then CheminImages:=searchdir(collection,'Images',collection)
  else CheminImages:=searchdir(collection,CheminImages ,collection);
if (CheminImages = '') then begin ShowMessage('La collection '+namecollection+' est incomplte : il manque le dossier "Fichier-Images"') ; probleme :=true;   end
else    CheminImages :=CheminImages+'\';
 end;

 if (probleme = false ) then begin
  cheminCodage:=FIni.ReadString(section,'codage','');
  if  (cheminCodage='') then CheminCodage:=searchdir(collection,'Prog',collection)
  else CheminCodage:=searchdir(collection,CheminCodage,collection);
if (CheminCodage = '') then begin ShowMessage('La collection '+namecollection+' est incomplte : il manque le dossier "Utiles"') ; probleme :=true;   end
else  CheminCodage := CheminCodage+'\';
end;
   result:=probleme ;
end;



procedure TFormPrinc.Collectionslectionne1Click(Sender: TObject);
begin
exit;
end;

procedure TFormPrinc.chargerImageFond(fileName : String);
    var
Jpeg:TJpegImage;
erreur : boolean;
begin
    Jpeg:=TJpegImage.Create ;
    try
       filename := CheminCollSelect+'\'+filename ;
       Jpeg.LoadFromFile(filename);
       Image2.Picture.Bitmap.Assign(Jpeg);
       Image2.Visible := true ;
       Image1.Visible:=false;
     except  on EFOpenError    do
       begin
          Jpeg.Free; erreur:=false;
          Image1.Visible:=true;
          Image2.Visible := false ;
          end;
      end;

end;

end.
