unit PhylMain;
// DL 9/11/99 ajout fermeture FormMol dans ToutFermer
// DL 16/11/99 ajout appel FormPlche.CreeIcones ds Taxons1Click
// DL 28/11/99 modif EnregistrerMatrice1Click (TableauModifie:=false)
// DL 30/04/00 ajout d'une ligne ds EnregistrerMatrice1Click
//             Arbre1Click (2 espces ncessaires)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus,StdCtrls,ExtCtrls,listarray2,group2,typedef,Prtgrids, jpeg;

// jfr modifie le 10/04/00
// typedef rajout dans les uses

const
  MsgDonneeAbsente = 'Donne non disponible';
  DateLimite = '30/06/2002';
  //  DateLimite = '01/01/2001'  ou '' pour version illimite;

type
  TFormPrinc = class(TForm)
    MainMenu1: TMainMenu;
    Fichier1: TMenuItem;
    Ouvrir1: TMenuItem;
    Quitter1: TMenuItem;
    Observer1: TMenuItem;
    Comparer1: TMenuItem;
    Choisir1: TMenuItem;
    Aide1: TMenuItem;
    Apropos1: TMenuItem;
    OpenDialog1: TOpenDialog;
    Planche1: TMenuItem;
    Imprimer1: TMenuItem;
    EnregistrerMatrice1: TMenuItem;
    SaveDialog1: TSaveDialog;
    Arbre1: TMenuItem;
    Taxons1: TMenuItem;
    Tableaudecaractres1: TMenuItem;
    Tableaudemolcules1: TMenuItem;
    Classer1: TMenuItem;
    Glossaire1: TMenuItem;
    OuvrirArbre: TMenuItem;
    Enregistrerlarbre1: TMenuItem;
    Image1: TImage;
    LabelLimite: TLabel;
    LabelCopyright: TLabel;
    Toutfermer1: TMenuItem;
    procedure Quitter1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Observer1Click(Sender: TObject);
    procedure Apropos1Click(Sender: TObject);
    procedure Choisir1Click(Sender: TObject);
    procedure Planche1Click(Sender: TObject);
    procedure Comparer1Click(Sender: TObject);
    procedure Imprimer1Click(Sender: TObject);
    procedure EnregistrerMatrice1Click(Sender: TObject);
    procedure Taxons1Click(Sender: TObject);
    procedure Tableaudemolcules1Click(Sender: TObject);
    procedure Arbre1Click(Sender: TObject);
    procedure Tableaudecaractres1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Classer(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Glossaire1Click(Sender: TObject);
    procedure OuvrirArbreClick(Sender: TObject);
    procedure Enregistrerlarbre1Click(Sender: TObject);
    procedure Toutfermer1Click(Sender: TObject);
  private
    { Dclarations prives }
    function ToutFermer(Sender: TObject): boolean;
    function EnregOK(Sender: TObject): boolean;
    function LireNomFicRef(FTab: string): string;
    procedure InitVars;
//    procedure FermerFiches;
  public
    { Dclarations publiques }
    AData : TstrListArray;
    ATri :TTreeGroup;
    NomFicSansExt : string;
    FichierTableauCourant : string;
    TableauModifie : boolean;
    Activite : string;       // activit en cours : Observer,Comparer,Choisir
    procedure Fille(Sender: TForm);
  end;

var
  FormPrinc: TFormPrinc;

implementation

uses PhylAbout,Donnees, BarreCar, PhylObs, PhylChoi, PhylPlch, PhylComp,
     DataselMat, CustomGraph,arbre,fenarbre, PhylClade, PhylMol, TreeCLGR,
     PhylTrier, BarreIc, PhylGlo, Mynewgrid;


{$R *.DFM}

procedure ControleDate;
var
  NbJours: integer;
begin
  if (DateLimite = '') then
   begin
    // Version illimite
    FormPrinc.LabelLimite.Visible:=false;
   end
  else
    // Version limite
    begin
       NbJours:= Trunc(StrToDate(DateLimite)-Date);
       if (NbJours < 0) then
       begin
          ShowMessage('La dure d''utilisation est dpasse');
          Application.Terminate;
       end;
       FormPrinc.LabelLimite.Caption:='Version d''valuation, limite au '+DateLimite;
    end;
end;

procedure TFormPrinc.FormCreate(Sender: TObject);
begin
  Top:=0;
  Left:=0;
  if (Screen.Height<600) or (Screen.Width<800) then
  begin
    ShowMessage('Ce programme ne peut fonctionner qu''avec une rsolution'+
                ' minimum de 800x600.');
    Application.Terminate;
  end;               
  Height:=Screen.Height;
  Width:=Screen.Width;
  ControleDate;
  InitVars;
end;

procedure TFormPrinc.InitVars;
begin
  Adata:=TstrListArray.createListarray;
  ATri:=nil;
  TableauModifie:=false; // pour tester les modif de tableau ds PhylChoi
  Activite:='Observer';
end;

procedure LireTaxons(NomFic:string);
begin
     // Taxons
     Taxons.Free; // si une autre liste tait en mmoire on la libre
     Taxons:=TTaxons.Create;
     Taxons.LireFichier(NomFic);
end;

procedure LireCar(NomFic:string);
begin
     // Caractres
     Caracteres.Free;
     Caracteres:=TCaracteres.Create;
     Caracteres.LireCar(NomFic);
     Application.CreateForm(TBarreCaract, BarreCaract);
end;

function LireFicsPhylo(NomFic:string):boolean;
// lire les taxons et les caractres
var
  L:integer;
  NomFicCar:string;
begin
  if not FileExists(NomFic) then
  begin
     ShowMessage('Le fichier '+NomFic+' n''existe pas');
     LireFicsPhylo:=false;
     exit;
  end;
  L:=length(ExtractFileExt(NomFic));
  FormPrinc.NomFicSansExt:=copy(NomFic,1,length(NomFic)-L);
  NomFicCar:= FormPrinc.NomFicSansExt + ExtFicCar;
  if not FileExists(NomFicCar) then
  begin
     ShowMessage('Le fichier '+NomFicCar+' n''existe pas');
     LireFicsPhylo:=false;
     exit;
  end;

  LireTaxons(NomFic);
  LireCar(NomFicCar);

  with FormPrinc do begin
    Observer1.Enabled:=True;
    Comparer1.Enabled:=True;
    Choisir1.Enabled:=True;
    Planche1.Enabled:=True;
  end;
//  if not Assigned(FormChoisir) then
//     Application.CreateForm(TFormChoisir, FormChoisir);
  FormChoisir.Initialise;
  FormPlanche.CreeIcones;
  FormGlossaire.LireGlossaire;

  LireFicsPhylo:=true;
end;

function TFormPrinc.EnregOK(Sender: TObject): boolean;
// propose l'enregistrement du tableau en cours et
// renvoie false si la rponse est Annuler, true sinon
var
   Reponse: Word;
begin
   Reponse:=MessageDlg('Voulez-vous sauvegarder le tableau courant ?',mtCustom,
   [mbYes,mbNo,mbCancel],0);
   if Reponse = mrYes then EnregistrerMatrice1Click(Sender);
   EnregOK:=(Reponse <> mrCancel);
end;

function TFormPrinc.ToutFermer(Sender: TObject):boolean;
// videmment on doit pouvoir faire mieux ...
begin
   if TableauModifie then
        if EnregOK(Sender) then TableauModifie:=false
                           else begin
                                   ToutFermer:=false;
                                   exit;
                                end;
   if Assigned(FormPlanche) then FormPlanche.Close;
   if Assigned(FormObs) then FormObs.Close;
   if Assigned(FormComp) then FormComp.Close;
   if Assigned(FormChoisir) then FormChoisir.Close;
   if Assigned(BarreIcones) then BarreIcones.Close;
   if Assigned(BarreCaract) then BarreCaract.Close;
   if Assigned(FormTri) then FormTri.Close;
   if Assigned(FormArbre) then FormArbre.Close;
   if Assigned(FormMol) then FormMol.Close;
ToutFermer:=true;
end;


procedure TFormPrinc.Taxons1Click(Sender: TObject);
begin
  with OpenDialog1 do
  begin
     if not ToutFermer(Sender) then exit;
     Title:='Ouverture d''un fichier d''images';
     Filter:='Fichiers Phylogne (*'+ExtFicPhylo+')|*'+ExtFicPhylo;
     Filename:='';
     if Execute then
       if (ExtractFileExt(FileName)=ExtFicPhylo) then
       // Fichier phylo
          if LireFicsPhylo(FileName)then
          begin
             InitVars;
             FormPlanche.Show;
             Arbre1.enabled:=false;
             Classer1.Enabled:=false;
          end;
  end;
end;

function TFormPrinc.LireNomFicRef(FTab:string):string;
// Lit le nom du fichier de rfrence au dbut d'un fichier .tab
var
   f:TextFile;
   FRef:string;
begin
   if FileExists(FTab) then AssignFile(f,FTab)
                       else begin LireNomFicRef:=''; exit;end;
   Reset(f);
   if not eof(f) then readln(f,FRef);
   CloseFile(f);
   LireNomFicRef:=FRef;
end;

procedure TFormPrinc.Tableaudecaractres1Click(Sender: TObject);
var
  FicTab : string;
  FicRef : string;
  DataR,Data : TMemoryStream;
  strRef:string;
begin
  with OpenDialog1 do
  begin
    if not ToutFermer(Sender) then exit;
    Title:='Ouverture d''un tableau de caractres';
    Filter:='Tableaux de caractres (*'+ExtFicMat+')|*'+ExtFicMat;
    FileName:='';

    if Execute then
    begin
      FicTab:=FileName;
      if (ExtractFileExt(FicTab)=ExtFicMat) then
      begin
            FicRef:=LireNomFicRef(FicTab);
            if not FileExists(FicRef) then
            begin

               ShowMessage('Fichier de rfrence introuvable');
               with OpenDialog1 do
               begin
                 Title:='Fichier de rfrence';
                 Filter:='Fichier d''espces (*'+ExtFicPhylo+')|*'+ExtFicPhylo;
                 Filename:='';
                 if Execute then
                 begin
                    FicRef:=FileName;
                    // ajout de FicRef au dbut du fichier FicTab
                    // ncessaire pour compatibilit anciens fichiers
                    StrRef:=FicRef+#13+#10;
                    Data:=TMemoryStream.Create;
                    Data.Write(StrRef[1],length(StrRef));
                    DataR:=TMemoryStream.Create;
                    DataR.LoadFromFile(FicTab);
                    Data.CopyFrom(DataR,DataR.Size);
                    Data.Savetofile(FicTab);
                    Data.Free;
                    DataR.Free;
                 end;   
               end;
            end;
            if LireFicsPhylo(FicRef) then
            begin
               FichierTableauCourant:=FicTab;
               FormChoisir.ChargeTabGrid(FicTab);
               Choisir1.Click;
               Classer1.Enabled:=true;    // jfr modifie septembre 2001
               Arbre1.Enabled:=true;
            end;
      end;
    end;
  end;
end;

// jfr modifie le 10/04/00
procedure TFormPrinc.Tableaudemolcules1Click(Sender: TObject);
begin
   FormMol.ouvrirfichmolClick(Sender);
   if FormMol.Molgrid1.TypeMol<>nul then  FormMol.Show;
end;

procedure TFormPrinc.Planche1Click(Sender: TObject);
begin
  FormPlanche.Show;
end;

procedure TFormPrinc.Imprimer1Click(Sender: TObject);
begin
//   Prtgrid(FormChoisir.TabGrid1,'Titre','Text');
  Print;
end;

procedure TFormPrinc.EnregistrerMatrice1Click(Sender: TObject);
var
   Reponse: Word;
begin
   with SaveDialog1 do
   begin
      Title:='Enregistrement d''un tableau de caractres';
      Filter:='Tableaux de caractres (*'+ExtFicMat+')|*'+ExtFicMat;
// Dl 30/04/00
      FileName:=FichierTableauCourant;
      if Execute then
      begin
        if ExtractFileExt(FileName) <> ExtFicMat then
           FileName:=FileName+ExtFicMat;
        if FileExists(FileName) then
        begin
           Reponse:=MessageDlg('Remplacer le fichier ?',mtCustom,
                                 [mbYes,mbNo,mbCancel],0);
           if Reponse <> mrYes then  exit;
        end;
        FormChoisir.TabGrid1.FicRef:=ExtractFileName(NomFicSansExt)+ExtFicPhylo;
        FormChoisir.TabGrid1.SaveToFile(FileName);
        FichierTableauCourant:=FileName;
        TableauModifie:=false;
      end;
   end;
end;

procedure TFormPrinc.Quitter1Click(Sender: TObject);
{ Termine le programme }
begin
    Close;
end;

procedure TFormPrinc.Observer1Click(Sender: TObject);
var
activ:string;
begin
 { if ((Pos('Arbre',Activite)=0) and (Pos('Classer',Activite)=0)
      and (Activite<>'Classer') and (Activite<>'Arbre'))
  then Activite:='Observer';      }     // jfr modifie septembre 2001
  //Activite:='Observer';
  if(Pos('Arbre',Activite)<>0) or (Pos('Classer',Activite)<>0) then
  begin
   Activ:='';
   if(Pos('Arbre',Activite)<>0)then Activ :=Activ +'Arbre ';
   if(Pos('Classer',Activite)<>0)then Activ :=Activ +'Classer ';
   Activ :=Activ +'Observer' ;// jfr modifie 15 octobre 2001
   Activite:=activ;
  end
  else Activite:='Observer' ;
  {if(Pos('Arbre',Activite)<>0) then  Activite:=Arbre+'-'+'Observer'
  else if (Pos('Classer',Activite)<>0) then  Activite:=Classer+'-'+'Observer' 
  else  Activite:='Observer'; }


  FormObs.ImageCar.tag:=-1;             // jfr modifie 16 octobre 2001
  FormObs.ImageCar.Hide;                // pour cacher les fenetres d'image et de texte
  FormObs.texteCar.Visible:=false;
  FormObs.invalidate;  

  FormObs.Show;
  Choisir1.Enabled:=true;     // jfr modifie 12/12/01
  FormComp.Hide;
  FormChoisir.Hide;
end;

procedure TFormPrinc.Comparer1Click(Sender: TObject);
var
activ:string;
begin
 {if (Activite<>'Comparer-Arbre')    // jfr modifie septembre 2001
   then Activite:='Comparer';   }
  //Activite:='Comparer';
  {if(Pos('Arbre',Activite)<>0) or (Pos('Classer',Activite)<>0) then
    Activite:=Activite+'-'+'Comparer' // jfr modifie 15 octobre 2001    }
  if(Pos('Arbre',Activite)<>0) or (Pos('Classer',Activite)<>0) then
  begin
   Activ:='';
   if(Pos('Arbre',Activite)<>0)then Activ:=Activ+'Arbre ';
   if(Pos('Classer',Activite)<>0)then Activ:=Activ+'Classer ';
   Activ:=Activ+'Comparer'; ;// jfr modifie 15 octobre 2001
   Activite:=activ ;
  end
    else    Activite:='Comparer';
    Choisir1.Enabled:=true;     // jfr modifie 12/12/01
  FormComp.Show;
  FormChoisir.Hide;
  FormObs.Hide;
end;


procedure TFormPrinc.Choisir1Click(Sender: TObject);
begin
   ATri:=nil;
   Activite:='Choisir';
   FormChoisir.Show;
   FormComp.Hide;
   FormObs.Hide;

// sans doute mal plac : il faudrait s'assurer que des espces et des car ont
//   t choisis
   Choisir1.Enabled:=false;
   Classer1.Enabled:=false;    // jfr modifie septembre 2001
   Arbre1.Enabled:=false;
   EnregistrerMatrice1.Enabled:=true;
end;

procedure TFormPrinc.Classer(Sender: TObject);
begin
   if (FormChoisir.TabGrid1.ColCount > 1) and (FormChoisir.TabGrid1.RowCount > 1) then
     begin
     if ((pos('Classer',Activite)<>0)or (Activite='Classer')) then
       FormTri.Show                            // jfr modifie septembre 2001
     else
      begin
      FormTri.Close;
      Activite:='Classer';
   // ligne suivante ajoute par JFR et DL le 20/03/00   
      FormTri.TabGrid1.FFileName:=NomFicSansExt;
      FormTri.ChargeTabGrid(Sender);
      FormTri.Show;
      end
     end
   else
      Classer1.Enabled:=false;
      Choisir1.Enabled:=true;     // jfr modifie 12/12/01
  FormObs.Hide;        //jfr modifie 16 octobre 2001
  FormComp.Hide;     // Pour que les options du menu s'affichent si besoin
end;

procedure TFormPrinc.Arbre1Click(Sender: TObject);
begin
   if (FormChoisir.TabGrid1.ColCount > 1) and (FormChoisir.TabGrid1.RowCount > 2) then
     begin
      if((pos('Arbre',Activite)<>0)or (Activite='Arbre'))
      then  FormArbre.show        // jfr modifie septembre 2001
      else
      begin
        FormArbre.Close;
        if (Activite='Classer')
           then Activite:='Classer Arbre'
         else
         Activite:='Arbre';

         FormArbre.TabGrid1.FFileName:=NomFicSansExt;
         FormArbre.ChargeTabGrid(Sender);
         // jfr modifie le 10/04/00 (bug sinon)
          FormArbre.Optionslegendes.Enabled:=false;
          FormArbre.removelabel;
          FormArbre.Show;
          Enregistrerlarbre1.Enabled:=true;
          OuvrirArbre.Enabled:=true;  // provisoire pour LoadTree
          end
     end
   else
      Arbre1.Enabled:=false;
  Choisir1.Enabled:=true;     // jfr modifie 12/12/01    
  FormObs.Hide;        //jfr modifie 16 octobre 2001
  FormComp.Hide;     // Pour que les options du menu s'affichent si besoin
end;

procedure TFormPrinc.Apropos1Click(Sender: TObject);
begin
   AboutBox.ShowModal;
end;

procedure TFormPrinc.Fille(Sender: TForm);
// Sender devient "fille" de FormPrinc  et FicheActive
begin
   with Sender do
   begin
      Parent:=Self;
      BoundsRect:=Self.ClientRect;
      BorderStyle:=bsNone;
   end;
end;

procedure TFormPrinc.FormDestroy(Sender: TObject);
begin
   AData.free;
   if Atri<>nil then Atri.free;
end;

procedure TFormPrinc.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if not ToutFermer(Sender) then CanClose := False;
end;

procedure TFormPrinc.Glossaire1Click(Sender: TObject);
begin
  FormGlossaire.Show;
end;

// jfr modifie le 10/04/00
// toute la procdure est modifie
procedure TFormPrinc.OuvrirArbreClick(Sender: TObject);
var
  FicArb : string;
  ListArray: TStrListArray;
  strlist:TStringList;
  data:TFileStream;
  strTree,strTab,strRef :string;
  L:integer;

begin
  with OpenDialog1 do
  begin
    if not ToutFermer(Sender) then exit;
       Title:='Ouverture d''un arbre';
       Filter:='Arbres (*'+ExtFicArb+')|*'+ExtFicArb;
       FileName:='';

    if Execute then
    begin
      FicArb:=FileName;    // Fic Arb est un nom gnrique qui contient les noms
                           // du fichier arbre : strTree
                           // du fichier Tab : strTab
                           // et du fichier gnral : strRef
      if (ExtractFileExt(FicArb)=ExtFicArb) then
      begin
         try
            strlist:=TStringlist.Create;
            data:=TFileStream.Create(filename,fmOpenRead);
            ListArray:=TStrListArray.createlistArray;

             data.seek(0,0);
             strlist.loadfromstream(data);

             strtab:=StrList.strings[0];
             strRef:=StrList.strings[1];
             strtree:= StrList.strings[2];

            if LireFicsPhylo(strRef) then
              begin
               if FileExists(strtab)  then
                  begin
                    FichierTableauCourant:=strTab;
                    FormChoisir.ChargeTabGrid(strTab);
                    Choisir1.click;

                    FormChoisir.TabGrid1.CopyToAListArray(0,0,ListArray);
                   with FormArbre do
                    begin
                      Tabgrid1.RowCount:=FormChoisir.Tabgrid1.RowCount;
                      Tabgrid1.ColCount:=FormChoisir.Tabgrid1.ColCount;

                      TabGrid1.CopyFromAlistArray(0,0,ListArray);

                      L:=length(ExtractFileExt(strref));  // JFR modifie le 07/07/00  ligne ajoute
                      Tabgrid1.FFileName:=copy(strref,1,length(strref)-L) ; // JFR modifie le 07/07/00 :=strtab;

                      TabGrid1.SelectAllCol(true);
                      TabGrid1.SelectAllRow(true);

                       GCT1.InitTreeFile(TabGrid1,strtree);
                       LongTot.Text:=intToStr(GCT1.TreeTotalLength);
                       LongPart.Text:=intToStr(GCT1.TreeUnitLength);

                       FormArbre.Optionslegendes.Enabled:=false;
                       FormArbre.removelabel;
                       FormArbre.Show;
                       Enregistrerlarbre1.Enabled:=true;
                       OuvrirArbre.Enabled:=true;
                     end;
                    end
                 else
                  ShowMessage('Le fichier '+ strTab+' n''existe pas');
              end;
         finally
         strlist.free;
         data.free;
         ListArray.free;
         end;
   end;
end;
end;
end;

// jfr modifie le 10/04/00
// toute la procdure est modifie
procedure TFormPrinc.Enregistrerlarbre1Click(Sender: TObject);
var
   Reponse: Word;
   StrTab,StrTree,StrRef:String;
   Stream: TMemorystream;
begin
   if TableauModifie then
   begin
     ShowMessage('Vous devez enregistrer le tableau avant d''enregistrer l''arbre');
     exit;
   end;
   with SaveDialog1 do
   begin
      Title:='Enregistrement d''un arbre';
      Filter:='Arbre (*'+ExtFicArb+')|*'+ExtFicArb;
      if Execute then
      begin
       if  (ExtractFileExt(FileName) <> '') then
        begin
          if ExtractFileExt(FileName) <> ExtFicArb then
          begin
            FileName:=ChangeFileExt(FileName,'');
            FileName:=FileName+ExtFicArb;
           end;
         end else FileName:=FileName+ExtFicArb;

        if FileExists(FileName) then
        begin
           Reponse:=MessageDlg('Remplacer le fichier ?',mtCustom,
                                 [mbYes,mbNo,mbCancel],0);
           if Reponse <> mrYes then  exit;
        end;
        // jfr modifie le 10/04/00
        // remplace savetree dans TreeCLGR
         try
          Stream:=TMemorystream.Create;
          StrTab:=ExtractFilename(FichierTableauCourant)+#13+#10;
          StrRef:=NomFicSansExt+ExtFicPhylo;
          StrRef:=ExtractFilename(StrRef)+#13+#10;
          Stream.Write(StrTab[1],length(StrTab));
          Stream.Write(StrRef[1],length(StrRef));
          StrTree:=FormArbre.GCT1.GetStrTree+#13+#10;
          Stream.Write(Strtree[1],length(StrTree));
          Stream.savetofile(FileName);
         finally
            Stream.free;
         end;

      end;
   end;
end;

procedure TFormPrinc.Toutfermer1Click(Sender: TObject);
begin
ToutFermer(sender);

Observer1.Enabled:=false;
Comparer1.Enabled:=false;
Choisir1.Enabled:=false;
Classer1.Enabled:=false;    // jfr modifie septembre 2001
Arbre1.Enabled:=false;
end;

end.
