unit PhylPlch;

// 22/01/01 Modif CreeIcones pour position boutonOK si dernire ligne pleine
// 16/11/99 CreeIcones remplace AfficheIcones et devient publique (appele ds
//            PhylMain
//          Modif FormClose

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,StdCtrls,ExtCtrls,
   Forms, Dialogs,  jpeg, Buttons;

const
  EcartX = 10; // Ecart horizontal entre les icones
  EcartY = 10; // Ecart vertical entre les icones

type
  TFormPlanche = class(TForm)
    BoutonOK: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Clique(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BoutonOKClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Dclarations prives }
    ListeIcones:TList;
    FSelection:TStringList;         // liste des noms des espces slectionnes
    procedure AfficheSelection;

  public
    { Dclarations publiques }
     procedure CreeIcones;
     property Selection:TStringList read FSelection write FSelection;
  end;

var
  FormPlanche: TFormPlanche;
  PosX, PosY: Word;

implementation

uses Donnees, PhylObs, PhylMain, CompCadreIma2, BarreIc, PhylChoi, PhylComp;

{$R *.DFM}

procedure TFormPlanche.FormCreate(Sender: TObject);
begin
  FormPrinc.Fille(Self);
  PosX:=EcartX; // position de l'icone du 1er taxon
  PosY:=EcartY;
  ListeIcones:=TList.Create;
  FSelection:=TStringList.Create;
  BoutonOK.Visible:=false;
end;

procedure TFormPlanche.CreeIcones;
var
    Icone:TCadreImage2;
    i:integer;
begin
 for i:=0 to Taxons.NbTaxons - 1 do
 begin
  Icone:=TCadreImage2.Create(Self);// ici self est quivalent  FormPlanche
  ListeIcones.Add(Icone);
  With Icone do
  begin
    Parent:=Self;  //  la fiche
    BevelWidth:=2;
    OnClick:=Clique; // vnement on Click dclenchera la procdure Clique
    Height:=65; //
    Width:=80;  // 320/4
    Font.Name:='Arial';
    Font.Size:=7;
    Affiche(Taxons.GetIcone(i),Taxons.GetNom(i));
    Tag:=i;

    Left:=PosX; // Position en X de l'icone
    Top:=Posy;  // Position en Y de l'icone
    PosX:=PosX+Width+EcartX; // pour que la prochaine icone cre se mette plus  gauche
    If (PosX>Self.Width-Width) and (i <> Taxons.NbTaxons - 1) then
     // Si on dpasse la longueur de la fiche
    // on positionne la prochaine icone plus bas
    begin
      PosY:=PosY+Height+EcartY;
      if PosY>Self.Height then Self.Height:=PosY+Height;
      PosX:=EcartX;
    end;
    
  end; // with
 end; // for
 BoutonOK.Top:=PosY;
 BoutonOK.Left:=Self.Width-BoutonOK.Width-10;
 BoutonOK.Height:=65;
end;

procedure TFormPlanche.Clique (Sender:TObject);
begin
  with TCadreImage2(Sender) do
  begin
    // mise  jour de la Selection
     if (pos('Observer',FormPrinc.Activite)<>0) then
     // if (FormPrinc.Activite='Observer') then   // jfr modifie 15 octobre 2001
      begin
            FSelection.Clear;
            FSelection.Add(Taxons.GetNom(Tag));
      end
     else
      begin
         Selected:=not Selected;
         if Selected then
          if ((pos('Comparer',FormPrinc.Activite)<>0) and (FSelection.Count >= 4)) then
           //if ((FormPrinc.Activite='Comparer') and (FSelection.Count >= 4)) then  // jfr modifie 15 octobre 2001
             Selected:=false
           else
             FSelection.Add(Taxons.GetNom(Tag))
         else
           FSelection.Delete(FSelection.IndexOf(Taxons.GetNom(Tag)));
      end;
   // lancement ventuel de l'activit Observer (pour les autres voir BoutonOK)
    if (pos('Observer',FormPrinc.Activite)<>0) then
    // if (FormPrinc.Activite='Observer') then   // jfr modifie 15 octobre 2001
     begin
        BarreIcones.Premiere:= Tag;
        if (BarreIcones.Premiere > Taxons.NbTaxons-4) then
            BarreIcones.Premiere := Taxons.NbTaxons-4;
        Self.Hide;

        if (FormObs.ImageCar.tag=-1) then             // jfr modifie 16 octobre 2001
        FormObs.ImageCar.Hide;                // pour cacher les fenetres d'image et de texte
        if (FormObs.texteCar.Visible=false) then
        FormObs.invalidate;

        FormObs.Show;
        FormObs.AfficheEspece(Tag);
     
        FormObs.NomEsp.repaint;   // jfr modifie 16 octobre 2001


        BarreIcones.Selection:=Selection;
        BarreIcones.AfficheIcones;  // jfr modifie 16 octobre 2001


        
     end;
  end;
end;

procedure TFormPlanche.BoutonOKClick(Sender: TObject);
begin
   if (FormPrinc.Activite='Choisir')then
       FormChoisir.MajEspeces(Selection)
   else if (pos('Comparer',FormPrinc.Activite)<>0)then   // jfr modifie 16 octobre 2001
       FormComp.MajEspeces(Selection);
//   ModalResult:=mrOK;
   BarreIcones.Selection:=Selection;
   BarreIcones.AfficheIcones;    // jfr modifie 16 octobre 2001    rajoute
   Self.Hide;
end;

procedure TFormPlanche.FormClose(Sender: TObject;
  var Action: TCloseAction);
var
  i:integer;
begin
  PosX:=EcartX; // rinitialisation de la position de l'icone du 1er taxon
  PosY:=EcartY;
  if Assigned(ListeIcones) then
    for i:=0 to ListeIcones.Count-1 do TCadreImage2(ListeIcones.Items[i]).Free;
  ListeIcones.Clear;
  FSelection.Clear;
end;

procedure TFormPlanche.AfficheSelection;
var
   i: integer;
   NomTaxon: string;
begin
   if (FSelection.Count = 0) then
      for i:=0 to ListeIcones.Count-1 do
        TCadreImage2(ListeIcones[i]).Selected:=false
   else
      for i:=0 to ListeIcones.Count-1 do
      begin
         NomTaxon:=Taxons.GetNom(TCadreImage2(ListeIcones[i]).Tag);
         if (FSelection.IndexOf(NomTaxon) <> -1) then
           TCadreImage2(ListeIcones[i]).Selected:=true
         else
            TCadreImage2(ListeIcones[i]).Selected:=false;
      end;
end;

procedure TFormPlanche.FormShow(Sender: TObject);
begin
//jfr modifie 15 octobre 2001
 if (pos('Observer',FormPrinc.Activite)=0)then
   BoutonOK.Visible:=true else BoutonOK.Visible:=false;

   //BoutonOK.Visible:= not (FormPrinc.Activite='Observer');
   if (FormPrinc.Activite='Choisir')then
         Selection:=FormChoisir.Selection
  // else if (FormPrinc.Activite='Comparer')then
   else if (pos('Comparer',FormPrinc.Activite)<>0)then
         Selection:=FormComp.Selection
    else if (pos('Observer',FormPrinc.Activite)<>0) then
  // else if (FormPrinc.Activite='Observer')then
         Selection:=FormObs.Selection;
   AfficheSelection;
end;

end.
