unit TabGridMark;
// classe TTabGridMark :
// - surcharge les mthodes LoadFromFile et SaveToFile de TabGrid pour
//   ajouter le nom du fichier des espces correspondant
// - utilise un TStrListArray indiquant si le contenu des cellules est correct
// - encadre les cellules en consquence
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, MyNewgrid, listArray;

type
  TTabGridMark = class(TTabGrid)
  private
    { Dclarations prives }
    procedure FrameCell(color :TColor ; ARow, ACol : longint);
    protected
    procedure Paint; override;
  public
    { Dclarations publiques }
    FicRef : String;    // nom du fichier des espces
    MarkTab : TStrListArray;
    constructor Create(AOwner:TComponent);override;
    procedure LoadFromFile(const filename: string); override;
    procedure SaveToFile(const filename: string); override;
  published
    { Dclarations publies }
  end;

procedure Register;

implementation

 procedure TTabGridMark.FrameCell(color :TColor ; ARow, ACol : longint);
// devrait normalement tre ds TTabGrid (MyNewGrid)
// o une mthode analogue existe en priv (FillCell)
var
 OldPstyle: TPenStyle;
 OldBstyle :TBrushStyle;
 OldPenColor :TColor;
 OldBrushColor :TColor;
 Rect :TRect;
begin
 Rect:= CellRect(ACol,ARow);
 with  canvas do
  begin
    OldPstyle:=Pen.Style;
    OldBstyle:=Brush.style;
    OldPenColor:=Pen.color;
    OldBrushColor:=Brush.color;

    Pen.Style:=psclear;
    Brush.Style:=bssolid;

    brush.color:=Color;
    Font.color:=clred;
    FrameRect(Rect);

    Pen.Style:=OldPstyle;
    Brush.style:=OldBstyle;
    Pen.color:=OldPenColor;
    Brush.color:=OldBrushColor;
  end;
end;

constructor TTabGridMark.Create(AOwner:TComponent);
begin
inherited Create(AOwner);
 MarkTab:=TStrListArray.Create;

end;

procedure TTabGridMark.Paint;
var
i,j :integer;
begin
inherited Paint;
 for i:=TopRow to RowCount-1 do
     for j:=LeftCol to ColCount-1 do
     if MarkTab.StrItems[j,i]='F' then FrameCell(clRed,i,j)
                                  else FrameCell(clWhite,i,j) ;
 end;

procedure TTabGridMark.SaveToFile(const filename:string);
//  surcharge la mthode de TTabGrid pour crire le nom
//  du fichier des espces correspondant
//  on pourrait sans doute simplifier ...
var
  data: TMemoryStream;
  rect: TGridRect;
  StrRef:string;
begin
  data:=NIL;
  rect.left:=-1;
  rect.right:=-1;
  rect.top:=-1;
  rect.bottom:=-1;
  try
    StrRef:=FicRef+#13+#10;
    data:=TMemoryStream.Create;
    data.Write(StrRef[1],length(StrRef));
    data:=Contents2CSV(data,#7,rect);
    data.savetofile(filename);
  except
    on EFCreateError do
       ShowMessage('Erreur  la cration du fichier'+#13#10+
                    '(Si le fichier existe dj,'+
                    ' il est peut-tre en "lecture seule")');
  else
       data.free;
  end;
end;

procedure TTabGridMark.LoadFromFile(const filename:string);
//  surcharge la mthode de TTabGrid pour crire le nom
//  du fichier des espces correspondant
//  on pourrait sans doute simplifier ...
var
  AllData : TFileStream;
  data: TMemoryStream;
  rect: TGridRect;
  StrList:TStringList;

begin
  AllData:=NIL;
  rect.left:=-1;
  rect.right:=-1;
  rect.top:=-1;
  rect.bottom:=-1;
  try
    AllData:=TFileStream.Create(filename,fmOpenRead);
    StrList:=TStringList.Create;
    Strlist.LoadFromStream(AllData);
    FicRef:=StrList.Strings[0];
    AllData.Seek(length(FicRef)+2,0); // +2 pour CR LF
    data:=TMemoryStream.Create;
    data.CopyFrom(AllData,AllData.Size-length(FicRef)-2);
    data.seek(0,0);
    CSV2Contents(data,#7,rect);
  finally
    AllData.free;
    data.free;
    StrList.Free;
  end;
end;

procedure Register;
begin
  RegisterComponents('phylo', [TTabGridMark]);
end;
    
end.
