/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui;

import java.awt.Color;
import jcm.gui.complexity;
import jcm.gui.graph;
import jcm.gui.menu;
import jcm.gui.option;
import jcm.iob;
import jcm.mainapp;
import jcm.param;

public abstract class regionplot
extends graph {
    public param rate = new param("percent&per&yr", false);
    public param frac = new param("frac", false);
    public param varq;
    public param perq;
    public float[][] topdata = null;
    public float[][] perdata = null;
    public float[][][] datalist;
    public float[][][] perdatalist;
    public menu topmenu;
    public menu permenu;
    public option rateopt = new option(this.rate, this, "expert");
    public option fracopt = new option(this.frac, this);
    public option stackedopt = new option(this.stacked, this);
    public String[] toplist;
    public String[] unitlist;
    public String[] perlist;
    public String[] punitlist;
    public Color[] regcols;

    public void initsetup(mainapp mainapp2) {
        this.initsetup(mainapp2, new String[]{""});
    }

    public void initsetup(mainapp mainapp2, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            iob.debug(objectArray[n]);
            ++n;
        }
        if (objectArray.length < 4) {
            this.makelists(this.toplist[0], "");
        } else {
            this.makelists((String)objectArray[1], (String)objectArray[3]);
        }
        super.initsetup(mainapp2);
    }

    public abstract void makelists(String var1, String var2);

    public void setinteractions() {
        super.setinteractions();
        this.autofindinteractions(this.topdata);
        this.autofindinteractions(this.perdata);
        this.pansetup.setaffectedby(this.rate);
        this.pansetup.setaffectedby(this.perq);
        this.pansetup.setaffectedby(this.varq);
        this.pansetup.setaffectedby(this.stacked);
        this.bufi.setaffectedby(this.rate);
        this.bufi.setaffectedby(this.frac);
        this.bufi.setaffectedby(this.perq);
        this.bufi.setaffectedby(this.varq);
        this.stacked.flag = this.stacked.flag & complexity.complexity.chosen != "verysimple";
        this.stackedopt.output = this.stackedopt.output & (this.perdata == null && !this.rate.istrue());
        this.fracopt.output &= this.stackedopt.output;
    }

    public void preinterac(iob iob2) {
        super.preinterac(iob2);
        if (iob2 == this.varq || iob2 == this.perq || iob2 == this.rate || iob2 == this.frac) {
            this.makecurves();
            this.makecurvearrays();
        }
        if (iob2 == this.stacked) {
            this.legend.newcurves();
        }
    }

    public void reset() {
        this.makecurves();
        this.makecurvearrays();
    }

    public void makecurves() {
        this.topdata = this.datalist[this.varq.getchosenindex()];
        this.perdata = this.perdatalist[this.perq.getchosenindex()];
        this.stacked.flag = this.stacked.flag & (this.perdata == null && !this.rate.istrue());
        this.frac.flag = this.frac.flag & (this.perdata == null && !this.rate.istrue());
        this.yd = this.perdata == null && !this.rate.istrue() && !this.frac.istrue() ? this.topdata : new float[this.perdata == null || this.perdata.length > this.topdata.length ? this.topdata.length : this.perdata.length][this.xd.length];
        this.yscale.autoscale = true;
        this.setname();
    }

    public void makebuffer() {
        if (this.perdata != null) {
            this.ratio();
        }
        if (this.rate.istrue()) {
            this.rate();
            if (this.yscale.autoscale) {
                this.yscale.autoscale(-10.0, 10.0);
            }
        } else if (this.frac.istrue()) {
            this.frac();
            if (this.yscale.autoscale) {
                this.yscale.autoscale(0.0, 100.0);
            }
        } else if (this.yscale.autoscale) {
            this.yscale.autoscale();
        }
        super.makebuffer();
    }

    public void setvarper(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        this.varq = new param("varq", this.toplist, string);
        --this.varq.numitems;
        this.perq = new param("perq", this.perlist, string2);
        this.permenu = new menu(this.perq, this);
        this.topmenu = new menu(this.varq, this);
    }

    public void setname() {
        this.name2 = "";
        this.yscale.units = "";
        int n = 0;
        while (n < this.datalist.length - 1) {
            if (this.topdata == this.datalist[n]) {
                this.name2 = this.name2 + "&colon&" + this.toplist[n];
                this.yscale.units = this.yscale.units + this.unitlist[n];
            }
            ++n;
        }
        if (this.perdata != null) {
            int n2 = 0;
            while (n2 < this.perdatalist.length - 1) {
                if (this.perdata == this.perdatalist[n2]) {
                    this.name2 = this.name2 + "&per&" + this.perlist[n2];
                    this.yscale.units = this.yscale.units + "&/&" + this.punitlist[n2];
                }
                ++n2;
            }
        }
        if (this.rate.istrue()) {
            this.yscale.units = "percent&per&yr";
        }
        if (this.frac.istrue()) {
            this.yscale.units = "percent";
        }
        this.name3 = "&ob&" + this.yscale.units + "&cb";
    }

    public String docinfo(String string) {
        if (string.equals("curves")) {
            return "<hr>\u00b3\u00a3`curves \u00b3" + this.docwhatper() + "\u00a3\u00a7regintro " + this.doccurve();
        }
        if (string.equals("scales")) {
            return this.docscale() + " \u00a3\u00a7regscales ";
        }
        return super.docinfo(string);
    }

    public String docwhatper() {
        return "<br> \u00a3\u00a7whatper <br> \u00a3~" + this.varq.chosen + " \u00b2\u00a3\u00a7" + this.varq.chosen + " \u00b2 " + (this.perdata != null ? "<br>\u00a3`divby \u00a3~" + this.perq.chosen + " \u00b2\u00a3\u00a7" + this.perq.chosen : "");
    }

    void ratio() {
        int n = 0;
        while (n < this.yd.length) {
            int n2 = 0;
            while (n2 < this.xd.length) {
                this.yd[n][n2] = this.perdata[n][n2] > 0.0f && this.topdata[n][n2] > 0.0f ? this.topdata[n][n2] / this.perdata[n][n2] : -999.0f;
                ++n2;
            }
            ++n;
        }
    }

    void frac() {
        int n = 0;
        while (n < this.xd.length) {
            float f = 0.0f;
            int n2 = 0;
            while (n2 < this.ncurves) {
                if (this.curveoutput[n2]) {
                    f += this.topdata[n2][n];
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.ncurves) {
                this.yd[n3][n] = this.topdata[n3][n] * 100.0f / f;
                if (("" + this.yd[n3][n]).equals("NaN")) {
                    this.yd[n3][n] = -1.0E-8f;
                }
                ++n3;
            }
            ++n;
        }
    }

    void rate() {
        float[][] fArray = this.perdata == null ? this.topdata : this.yd;
        int n = 0;
        while (n < this.ncurves) {
            int n2 = this.xd.length - 1;
            while (n2 > 0) {
                this.yd[n][n2] = fArray[n][n2 - 1] > 0.0f ? 100.0f * (fArray[n][n2] - fArray[n][n2 - 1]) / fArray[n][n2 - 1] : -999.0f;
                --n2;
            }
            this.yd[n][0] = 0.0f;
            ++n;
        }
    }
}

