/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui;

import java.awt.Color;
import java.awt.Graphics;
import jcm.gui.colfont;
import jcm.gui.graph;
import jcm.gui.jcmpanel;
import jcm.gui.popob;
import jcm.iob;
import jcm.mod.time;
import jcm.pan.costsplot;
import jcm.pan.distribplot;
import jcm.param;
import jcm.tls.labinf;
import jcm.tls.txt;

public class scale
extends popob {
    public static int X = 0;
    public static int Y = 1;
    public static int Y2 = 2;
    int type = X;
    String[] ts = new String[]{"x", "y", "y2"};
    public String units;
    public static param linkx = new param("linkx", false);
    public static param showscales = new param("showscales", true);
    public param min;
    public param max;
    public double scales;
    public double scaleu;
    public double pmin;
    public double prange;
    public boolean autoscale = false;
    public boolean usebigfont = false;
    public double origin;
    public double dp;
    int ep;
    int op;
    boolean dragorigin = false;
    static String[] qs;
    static int[] qi;

    public scale(int n, jcmpanel jcmpanel2, String string, double d, double d2, double d3, double d4) {
        this.construct(n, jcmpanel2);
        this.setup(string, d, d2, d3, d4);
    }

    public scale(int n, jcmpanel jcmpanel2) {
        this.construct(n, jcmpanel2);
    }

    public scale() {
    }

    public void construct(int n, jcmpanel jcmpanel2) {
        this.type = n;
        this.owner = jcmpanel2;
        this.holder = jcmpanel2;
        this.min = new param(this.ts[n] + "min", "", 0.0, Double.MIN_VALUE, Double.MAX_VALUE);
        this.max = new param(this.ts[n] + "max", "", 0.0, Double.MIN_VALUE, Double.MAX_VALUE);
        this.min.owner = jcmpanel2;
        this.max.owner = jcmpanel2;
        this.min.holder = this;
        this.max.holder = this;
        this.name = this.ts[n] + "scale";
        this.color = colfont.black;
        this.register();
        this.min.register();
        this.max.register();
        this.level = "verysimple";
    }

    public String docinfo() {
        return this.getinfo() + "<br>" + this.min.docinfo() + "<br>" + this.max.docinfo();
    }

    public void setup(String string, double d, double d2, double d3, double d4) {
        this.scales = d3;
        this.scaleu = d4;
        this.units = string;
        this.min.units = string;
        this.max.units = string;
        this.labelkey = string;
        this.name2 = "&" + string;
        this.min.val = d;
        this.min.defval = d;
        this.max.val = d2;
        this.max.defval = d2;
        this.origin = this.type == X ? 2000.0 : 0.0;
        if (this.type == Y) {
            this.owner.name3 = "&ob&" + string + "&cb";
        }
    }

    public void setinteractions() {
        super.setinteractions();
        this.setaffectedby(((jcmpanel)this.owner).pansetup);
        this.setaffectedby(this.min);
        this.setaffectedby(this.max);
        this.min.setaffectedby(linkx);
        this.max.setaffectedby(linkx);
        this.min.setaffects(((graph)this.owner).bufi);
        this.max.setaffects(((graph)this.owner).bufi);
        this.output &= showscales.istrue() || this.holder == this.holder.holder.cpl.central || this.holder.holder != iob.applet;
    }

    public void resize(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
        if (this.type == X) {
            this.pmin = n;
            this.prange = n3;
        } else {
            this.pmin = n2 + n4;
            this.prange = -n4;
        }
    }

    double real(int n) {
        return this.min.val + ((double)n - this.pmin) * (this.max.val - this.min.val) / this.prange;
    }

    double pixel(double d) {
        return this.pmin + this.prange * (d - this.min.val) / (this.max.val - this.min.val);
    }

    public void postplot() {
        this.draw();
    }

    public void draw(Graphics graphics) {
        this.holder.clearRect(this.x, this.y, this.w, this.h);
        Graphics graphics2 = graphics.create();
        graphics2.clipRect(this.x, this.y, this.w, this.h);
        graphics2.setColor(Color.black);
        graphics2.setFont(this.usebigfont ? colfont.bigfont : colfont.scalefont);
        if (this.type == X) {
            graphics2.drawLine(this.x, this.y, this.x + this.w, this.y);
        }
        if (this.type == Y) {
            graphics2.drawLine(this.x + this.w - 1, this.y, this.x + this.w - 1, this.y + this.h);
        }
        if (this.type == Y2) {
            graphics2.drawLine(this.x, this.y, this.x, this.y + this.h);
        }
        if (this.scales != 0.0) {
            double d = this.scales * (double)((int)(0.8 + this.min.val / this.scales));
            while (d <= this.max.val) {
                int n = (int)this.pixel(d);
                String string = txt.round(d, this.scaleu);
                int n2 = this.sw(graphics2, string);
                if (this.type == X) {
                    graphics2.drawLine(n, this.y, n, this.y + 5);
                    if (this.h > 8) {
                        graphics2.drawString(string, n - n2 / 2, this.y + this.h - 4);
                    }
                }
                if (this.type == Y) {
                    graphics2.drawLine(this.x + this.w - 5, n, this.x + this.w, n);
                    if (this.w > 8) {
                        graphics2.drawString(string, this.x + this.w - (n2 + 5), n + 4);
                    }
                }
                if (this.type == Y2) {
                    graphics2.drawLine(this.x, n, this.x + 5, n);
                    if (this.w > 8) {
                        graphics2.drawString(string, this.x + 6, n + 4);
                    }
                }
                d += this.scales;
            }
        }
    }

    public String getinfo() {
        return this.ts[this.type] + ": " + txt.round(this.min.val, this.scaleu) + " - " + txt.round(this.max.val, this.scaleu) + " " + labinf.getshort(this.units) + " (" + labinf.getlabel(this.units) + ") ";
    }

    public void press(int n, int n2) {
        this.op = this.type == X ? n : n2;
        this.dragorigin = (double)this.op - this.pixel(this.origin) < 40.0 && (double)this.op - this.pixel(this.origin) > -40.0 && !((graph)this.holder).stacked.istrue();
        super.press(n, n2);
    }

    public void drag(int n, int n2) {
        if (popob.popup) {
            popob.removepopup();
        }
        int n3 = this.ep = this.type == X ? n : n2;
        if (this.dragorigin) {
            this.dp = (double)(this.ep - this.op) * (this.max.val - this.min.val) / (double)(this.type == X ? -this.w : this.h);
            this.max.val += this.dp;
            this.min.val += this.dp;
        } else {
            this.dp = ((double)this.op - this.pixel(this.origin)) / ((double)this.ep - this.pixel(this.origin));
            this.max.val = this.origin + (this.max.val - this.origin) * this.dp;
            this.min.val = this.origin + (this.min.val - this.origin) * this.dp;
        }
        this.op = this.ep;
        this.min.respond(false);
        this.max.respond(true);
        if (linkx.istrue() && this.type == X) {
            this.linkx();
        }
    }

    void linkx() {
        int n = 0;
        while (n < this.holder.holder.cpl.np) {
            graph graph2;
            if (this.holder.holder.cpl.pan[n] instanceof graph && (graph2 = (graph)this.holder.holder.cpl.pan[n]) != this.owner && graph2.output) {
                graph2.xscale.min.val = this.min.val;
                graph2.xscale.max.val = this.max.val;
                graph2.xscale.min.changed = true;
            }
            ++n;
        }
    }

    public void autoscale() {
        this.autoscale(0.0, this.getmax());
    }

    public void autoscale(double d, double d2) {
        this.setup(this.units, d, d2, 1.0, 1.0);
        this.checkunitfac();
        this.checkunitcancel();
        if (this.type == Y) {
            this.owner.name3 = "&ob&" + this.units + "&cb";
        }
        this.autoscale = false;
    }

    double getmax() {
        int n;
        int n2;
        double d = 0.0;
        if (this.holder instanceof distribplot || this.holder instanceof costsplot) {
            n2 = 90;
            n = 160;
        } else {
            n2 = 0;
            n = time.glos;
        }
        int n3 = n2;
        while (n3 < n) {
            int n4;
            if (((graph)this.holder).stacked.istrue()) {
                double d2 = 0.0;
                n4 = 0;
                while (n4 < ((graph)this.holder).yd.length) {
                    if (((graph)this.holder).curveoutput[n4]) {
                        d2 += (double)((graph)this.holder).yd[n4][n3];
                    }
                    ++n4;
                }
                if (d2 > d) {
                    d = d2;
                }
            } else {
                n4 = 0;
                while (n4 < ((graph)this.holder).yd.length) {
                    if ((double)((graph)this.holder).yd[n4][n3] > d && ((graph)this.holder).curveoutput[n4]) {
                        d = ((graph)this.holder).yd[n4][n3];
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        return d;
    }

    public void checkunitcancel() {
        int n;
        int n2;
        int n3 = this.units.indexOf("&per&yr");
        if (n3 > 0 && (n2 = this.units.indexOf("&per&yr", n3 + 1)) > 0) {
            this.units = this.units.substring(0, n3) + this.units.substring(n3 + 5, n2) + this.units.substring(n2 + 5);
        }
        int n4 = this.units.length();
        int n5 = -1;
        n2 = 0;
        while (n2 < qs.length) {
            n = this.units.indexOf(qs[n2]);
            if (n > -1 && n < n4) {
                n4 = n;
                n5 = n2;
            }
            ++n2;
        }
        if (n4 < this.units.length()) {
            int n6;
            int n7 = -1;
            int n8 = -1;
            n2 = 0;
            while (n2 < qs.length) {
                n = this.units.indexOf(qs[n2], n4 + 1);
                if (n > n7) {
                    n7 = n;
                    n8 = n2;
                }
                ++n2;
            }
            if (n7 > -1 && (n6 = 5 + n5 - n8) > -1 && n6 < qs.length) {
                String string = qs[n6] + "&";
                if (string.equals("###&")) {
                    string = "";
                }
                this.labelkey = this.units = this.units.substring(0, n4) + string + this.units.substring(n4 + qs[n5].length() + 1, n7) + this.units.substring(n7 + qs[n8].length() + 1);
            }
        }
    }

    public void checkunitfac() {
        this.scales = Math.pow(10.0, Math.floor(Math.log(this.max.val - this.min.val) / Math.log(10.0) - 0.4));
        int n = 5;
        int n2 = 5;
        int n3 = 0;
        while (n3 < qs.length) {
            if (this.units.startsWith(qs[n3])) {
                n = n3;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < qi.length) {
            if (this.scales >= Math.pow(10.0, qi[n4])) {
                n2 = n4;
            }
            ++n4;
        }
        this.scaleu = Math.pow(10.0, qi[n2]);
        int n5 = n + n2 - 5;
        this.labelkey = this.units = (n5 == 5 ? "" : qs[n5]) + this.units.substring(n == 5 ? 0 : qs[n].length());
    }

    static {
        scale.linkx.owner = new scale();
        scale.showscales.owner = new scale();
        qs = new String[]{"femto", "pico", "nano", "micro", "milli", "###", "kilo", "mega", "giga", "tera", "peta", "exa", "kiloexa"};
        qi = new int[]{-15, -12, -9, -6, -3, 0, 3, 6, 9, 12, 15, 18, 21};
    }
}

