/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod;

import jcm.iob;
import jcm.loop;
import jcm.mod.mathcurve;
import jcm.mod.modlist;
import jcm.mod.module;
import jcm.mod.time;
import jcm.param;

public class mitigation
extends module {
    String[] emitoptions = new String[]{"nopolicy", "stabemit", "stabconc", "stabrf&allghg", "stabrf&allghgaero", "stabtemp", "stabsea", "constant", "reduceintensity"};
    String[] concscenname = new String[]{"400ppm", "450ppm", "500ppm", "550ppm", "650ppm", "750ppm", "1000ppm"};
    int[] concscenlevel = new int[]{400, 450, 500, 550, 650, 750, 1000};
    public param scenario = new param("emitmenu", this.emitoptions, "stabconc");
    public param sygrowth = new param("initgrow", "percent&per&yr", 1.5, -3.5, 3.5);
    public param stabemityear = new param("stabemit&inyear", "", 2080.0, 2010.0, time.gey - 20);
    public param stabemitlevel = new param("stabemit&atlevel", "giga&ton&carbon&per&yr", 2000.0, 0.0, 12000.0, this.stabemityear);
    public param quartic = new param("integralopt", false);
    public param integralgt = new param("integral", "giga&ton&carbon", 650.0, 200.0, 2000.0);
    public param stabconcyear = new param("stabconc&inyear", "", 2125.0, 2005.0, 2400.0);
    public param stabconclevel = new param("stabconc&atlevel", "ppm", 500.0, 300.0, 1000.0, this.stabconcyear);
    public param wre = new param("wreopt", false);
    public param stabconcstartyear = new param("stabconcstartyear", "", 2030.0, 1990.0, 2050.0);
    public param concscen = new param("stabconcmenu", this.concscenname, "500ppm");
    public param stabrfyear = new param("stabrf&inyear", "", 2150.0, 2030.0, time.gey - 20);
    public param stabrflevel = new param("stabrf&atlevel", "w&per&m2", 3.1, 1.5, 8.0, this.stabrfyear);
    public param stabtempyear = new param("stabtemp&inyear", "", 2150.0, 2050.0, time.gey - 20);
    public param stabtemplevel = new param("stabtemp&atlevel", "degcbase", 2.0, 1.0, 7.0, this.stabtempyear);
    public param stfuzzy = new param("stfuzzyopt", false);
    public param damp = new param("dampopt", false);
    public param stabseayear = new param("stabsea&inyear", "", 2250.0, 2030.0, time.gey - 20);
    public param stabsealevel = new param("stabsea&atlevel", "metres", 0.75, 0.5, 3.0, this.stabseayear);
    public param reduceintensity = new param("reduceintensity", "percent&per&yr", -2.0, -6.0, 0.0);
    public float[] target = modlist.time.fyd();
    public float[] otarget = modlist.time.fyd();
    public float[] original = modlist.time.fyd();
    int intendy = 2200;
    int ge2000 = 6514;
    int integkyoto = 92870;
    int gesy = this.ge2000;
    int sy = time.fsy;
    int sty = this.sy + 5;
    int ssy = (int)this.stabconcstartyear.getval();
    int i;
    int j;
    int n;
    int ns;
    int nr;
    int year;
    int py;
    double targetlevel = 0.0;
    float[] curvetocheck;
    double co2stab = 0.0;
    double co2staborig = 0.0;
    double stabcor = 1.0;
    double oldstabcor = 1.0;
    double co2stabslope = 0.0;
    double co2stabslopeorig = 0.0;
    double stabslopecor = 1.0;
    double oldstabslopecor = 0.0;
    double co2end = 0.0;
    double co2endorig = 0.0;
    double endcor = 1.0;
    double oldendcor = 1.0;
    double co2endslope = 0.0;
    double co2endslopeorig = 0.0;
    double endslopecor = 1.0;
    double oldendslopecor = 0.0;
    int sys;
    int scy;
    public boolean goodenough = false;
    public int stit = 0;
    float fstx;
    float fsty;
    float dgt;
    float drf;
    float trf;
    float crf;
    float newtotemit;
    float ctarget;

    public void setinteractions() {
        this.setaffectedby(modlist.kyoto, modlist.kyoto.kyotop.istrue());
        this.setaffectedby(modlist.kyoto.kyotop);
        this.setaffectedby(modlist.carboncycle, this.scenario.chosen == "stabconc");
        this.setaffectedby(modlist.radfor, this.scenario.chosen == "stabrf&allghgaero" || this.scenario.chosen == "stabrf&allghg");
        this.setaffectedby(modlist.heatflux, this.scenario.chosen == "stabtemp");
        this.setaffectedby(modlist.heatflux.baseyear, this.scenario.chosen == "stabtemp");
        this.setaffectedby(modlist.sealevel, this.scenario.chosen == "stabsea");
        this.setaffectedby(modlist.people, this.scenario.chosen == "reduceintensity");
        this.affectsfutureonly = true;
    }

    public void precalc(iob iob2) {
        if (iob2 == this.scenario && this.scenario.chosen == "nopolicy") {
            modlist.regshares.distribution.chosen = "sresdist";
            modlist.sres.changed = true;
        }
        if (iob2 == this.concscen) {
            this.stabconclevel.setval(this.concscenlevel[this.concscen.getchosenindex()]);
            this.stabconcyear.setval(2100.0 + (double)(this.concscenlevel[this.concscen.getchosenindex()] - 450) / 2.0);
        }
        if (iob2 == this.scenario && this.scenario.chosen == "reduceintensity") {
            modlist.kyoto.kyotop.flag = false;
        }
        if (iob2 == this.scenario) {
            this.resetguess();
        }
    }

    public void precalc() {
        this.sty = this.sy = modlist.kyoto.kyotop.istrue() ? 2013 : time.fsy;
        int n = this.ssy = this.wre.istrue() && !modlist.kyoto.kyotop.istrue() ? 2002 + (int)((this.stabconclevel.getval() - 350.0) / 23.0) : this.sy;
        if (this.wre.istrue() && !modlist.kyoto.kyotop.istrue() && this.scenario.chosen == "stabconc") {
            int n2 = modlist.sres.sc;
            modlist.sres.sc = 6;
            int n3 = this.sy;
            while (n3 <= this.ssy) {
                modlist.carboncycle.fossil[n3 - time.gsy] = 1000.0f * modlist.sres.interp(modlist.sres.fosemit, n3) * 0.9436619f;
                ++n3;
            }
            modlist.sres.sc = n2;
        }
        if (this.scenario.chosen == "stabrf&allghgaero" || this.scenario.chosen == "stabrf&allghg" || this.scenario.chosen == "stabsea") {
            this.setupiteration();
        }
        if (this.scenario.chosen == "stabopt") {
            this.conctarget(this.scy, this.co2stab, this.co2stabslope, this.co2end, this.co2endslope);
        }
        if (this.scenario.chosen == "stabemit") {
            this.stabemit();
        }
    }

    public void calcstep(int n) {
        if (this.scenario.chosen == "stabconc") {
            if (n == this.ssy - time.gsy) {
                this.conctarget((int)this.stabconcyear.getval(), this.stabconclevel.getval());
            }
        }
        if (this.scenario.chosen == "stabtemp" && !this.stfuzzy.istrue()) {
            if ((double)n == modlist.heatflux.baseyear.val + 3.0 - (double)time.gsy) {
                this.setupiteration();
            }
        }
        if (this.scenario.chosen == "stabemit") {
            if (n > this.sy - time.gsy) {
                modlist.carboncycle.lucf[n] = modlist.carboncycle.lucf[this.sy - time.gsy] * modlist.carboncycle.fossil[n] / modlist.carboncycle.fossil[this.sy - time.gsy];
            }
        }
        if (this.scenario.chosen == "stabconc" || this.scenario.chosen == "stabrf&allghgaero" || this.scenario.chosen == "stabrf&allghg" || this.scenario.chosen == "stabtemp" && !this.stfuzzy.istrue() || this.scenario.chosen == "stabsea" || this.scenario.chosen == "stabopt") {
            if (n >= this.ssy - time.gsy) {
                modlist.carboncycle.totemit[n] = this.inverseco2(n, this.target[n]);
                this.lucfshare(n);
            }
        }
        if (this.scenario.chosen == "stabtemp" && this.stfuzzy.istrue()) {
            if (n == this.sty - time.gsy) {
                this.temptarget(n);
            }
            if (n >= this.sty - time.gsy) {
                this.inversetemp(n);
                this.lucfshare(n);
            } else {
                this.target[n] = 0.0f;
            }
        }
        if (this.scenario.chosen == "constant") {
            if (n >= this.sy - time.gsy) {
                modlist.carboncycle.totemit[n] = modlist.carboncycle.totemit[n - 1];
                this.lucfshare(n);
            }
        }
    }

    public void postcalc() {
        if (this.scenario.chosen == "stabrf&allghgaero" || this.scenario.chosen == "stabrf&allghg" || this.scenario.chosen == "stabtemp" && !this.stfuzzy.istrue() || this.scenario.chosen == "stabsea") {
            this.applycorrection();
        }
    }

    void setupiteration() {
        if (this.stit == 0) {
            if (this.scenario.chosen == "stabrf&allghgaero" || this.scenario.chosen == "stabrf&allghg") {
                this.curvetocheck = this.scenario.chosen == "stabrf&allghgaero" ? modlist.radfor.totanthrorf : modlist.radfor.totghgrf;
                this.targetlevel = this.stabrflevel.getval();
                this.setstabconcyear(this.stabrfyear.getval());
                this.guessconcfromrf(this.targetlevel * (double)modlist.radfor.totalrf[this.sys] / (double)(this.scenario.chosen == "stabrf&allghgaero" ? modlist.radfor.totanthrorf[this.sys] : modlist.radfor.totghgrf[this.sys]));
            }
            if (this.scenario.chosen == "stabtemp") {
                this.curvetocheck = modlist.heatflux.glotemp;
                this.targetlevel = this.stabtemplevel.getval() + modlist.heatflux.offset;
                this.setstabconcyear(this.stabtempyear.getval());
                this.guessconcfromrf(this.guessrffromtemp(this.targetlevel));
            }
            if (this.scenario.chosen == "stabsea") {
                this.curvetocheck = modlist.sealevel.total;
                this.targetlevel = this.stabsealevel.getval();
                this.setstabconcyear(this.stabseayear.getval());
                this.guessconcfromrf(this.guessrffromtemp(this.guesstempfromseal(this.targetlevel)));
            }
        }
        this.conctarget(this.scy, this.co2stab, this.co2stabslope, this.co2end, this.co2endslope);
    }

    public float inverseco2(int n, double d) {
        double d2 = 2.0 * (double)modlist.carboncycle.totsink[n - 1] - (double)modlist.carboncycle.totsink[n - 2];
        if (d2 / (double)modlist.carboncycle.totsink[n - 1] < 0.0) {
            d2 = 0.0;
        }
        return (float)((d - (double)modlist.carboncycle.atppm[n - 1]) / modlist.carboncycle.ppmpmtc + d2);
    }

    void lucfshare(int n) {
        if (modlist.carboncycle.totemit[n] > 0.0f) {
            modlist.carboncycle.lucf[n] = modlist.carboncycle.totemit[n] * modlist.carboncycle.lucf[this.ssy - time.gsy - 1] / modlist.carboncycle.totemit[this.ssy - time.gsy - 1];
            modlist.carboncycle.fossil[n] = modlist.carboncycle.totemit[n] - modlist.carboncycle.lucf[n];
        } else {
            modlist.carboncycle.lucf[n] = modlist.carboncycle.totemit[n];
            modlist.carboncycle.fossil[n] = 0.0f;
        }
    }

    void conctarget(int n, double d) {
        this.conctarget(n, d, 0.0, d, 0.0);
    }

    /*
     * Enabled aggressive block sorting
     */
    void conctarget(int n, double d, double d2, double d3, double d4) {
        int n2 = this.ssy - 1;
        int n3 = n2 - time.gsy;
        double d5 = n3 < 255 ? 0.016 : (double)modlist.carboncycle.atppm[n3] - 2.0 * (double)modlist.carboncycle.atppm[n3 - 1] + (double)modlist.carboncycle.atppm[n3 - 2];
        double d6 = d5 + (double)(modlist.carboncycle.atppm[n3] - modlist.carboncycle.atppm[n3 - 1]);
        double d7 = 0.0;
        mathcurve.padequintic(this.target, n2, n, modlist.carboncycle.atppm[n3], d6, d5, d, d2, d7);
        if (n >= time.gey) return;
        if (d2 != 0.0) {
            if (time.gey - n >= 20) {
                mathcurve.flatquadratic(this.target, n, time.gey, d, d2, d3);
                return;
            }
        }
        int n4 = n;
        while (n4 <= time.gey) {
            this.target[n4 - time.gsy] = (float)d3;
            ++n4;
        }
    }

    void setstabconcyear(double d) {
        this.sys = (int)d - time.gsy;
        this.scy = time.fsy + (int)(1.0 * (d - (double)time.fsy));
    }

    double guesstempfromseal(double d) {
        return modlist.sealevel.total[this.sys] > 0.0f ? (double)modlist.heatflux.glotemp[this.sys] * d / (double)modlist.sealevel.total[this.sys] : 2.0;
    }

    double guessrffromtemp(double d) {
        return d * (modlist.heatflux.glotemp[this.sys] > 0.0f ? (double)(modlist.radfor.totalrf[this.sys] / modlist.heatflux.glotemp[this.sys]) : modlist.heatflux.rfco2double.getval() / modlist.heatflux.climsens.getval());
    }

    void guessconcfromrf(double d) {
        double d2 = d * (modlist.radfor.totalrf[this.sys] > 0.0f ? (double)(modlist.radfor.co2rf[this.sys] / modlist.radfor.totalrf[this.sys]) : 0.85);
        this.co2staborig = modlist.carboncycle.atppmprein * Math.exp(Math.log(2.0) * d2 / modlist.heatflux.rfco2double.getval());
        this.co2stab = this.co2staborig * this.oldstabcor;
        this.co2stabslopeorig = 0.0;
        this.co2stabslope = this.oldstabslopecor;
        this.co2endorig = this.co2stab;
        this.co2end = this.co2endorig * this.oldendcor;
        this.co2endslopeorig = 0.0;
        this.co2endslope = this.oldendslopecor;
    }

    void applycorrection() {
        this.stabcor = this.targetlevel / (double)this.curvetocheck[this.sys];
        this.stabslopecor = -0.05 * (double)(this.curvetocheck[this.sys + 10] - this.curvetocheck[this.sys - 10]) / (double)this.curvetocheck[this.sys - 1];
        this.endcor = this.curvetocheck[this.sys] / this.curvetocheck[time.gey - time.gsy - 1];
        this.co2stab = 280.0 + (this.co2stab - 280.0) * this.stabcor;
        if (this.co2stab < 300.0) {
            this.co2stab = 300.0;
        }
        if (this.stit <= 6 || this.stabslopecor / this.oldstabslopecor < 1.0) {
            this.co2stabslope += this.stabslopecor * (this.co2stab - 280.0);
        }
        this.co2end = 280.0 + (this.co2end - 280.0) * this.endcor;
        if (this.co2end < 300.0) {
            this.co2end = 300.0;
        }
        this.goodenough = this.stabcor < 1.01 && this.stabcor > 0.99 && this.stabslopecor < 0.01 && this.stabslopecor > -0.01 && this.endcor < 1.01 && this.endcor > 0.99;
        boolean bl = Double.isInfinite(this.co2stab) || Double.isInfinite(this.co2end) || Double.isNaN(this.co2stab) || Double.isNaN(this.co2end) || this.co2stab < 300.0 || this.co2end < 300.0;
        ++this.stit;
        if (!this.goodenough && this.stit < 15 && !bl) {
            this.savecorrect();
            loop.itc = this;
            loop.itn = this;
            loop.repeat = true;
        } else if (loop.repeat) {
            loop.repeat = false;
            this.changed = true;
            loop.gowithin();
        } else {
            iob.debug("iteratated " + this.stit + " times");
            this.stit = 0;
            this.savecorrect();
        }
    }

    void savecorrect() {
        this.oldstabcor = this.co2stab / this.co2staborig;
        this.oldstabslopecor = (this.co2stabslope - this.co2stabslopeorig) / (this.co2stab - 280.0);
        this.oldendcor = this.co2end / this.co2endorig;
    }

    void resetcorrect() {
        this.oldstabcor = 1.0;
        this.oldstabslopecor = 0.0;
        this.oldendcor = 1.0;
        this.oldendslopecor = 0.0;
    }

    void resetguess() {
        this.resetcorrect();
        this.goodenough = false;
    }

    double aa(double d) {
        return (double)((int)(d * 10000.0)) / 10000.0;
    }

    /*
     * Enabled aggressive block sorting
     */
    void temptarget(int n) {
        int n2 = n - 1;
        int n3 = (int)this.stabtempyear.getval();
        double d = modlist.heatflux.glotemp[n2];
        double d2 = this.stabtemplevel.getval() + modlist.heatflux.offset;
        mathcurve.padequartic(this.target, n2 + time.gsy, n3, d, 0.0235, 4.0E-4, d2, 0.0);
        if (n3 < time.gey) {
            int n4 = n3;
            while (n4 <= time.gey) {
                this.target[n4 - time.gsy] = (float)d2;
                ++n4;
            }
        }
        int n5 = 0;
        while (n5 < n) {
            this.target[n5] = -999.0f;
            ++n5;
        }
    }

    void inversetemp(int n) {
        if (n > 250) {
            float f;
            this.fsty = (float)(modlist.heatflux.climsens.getval() / modlist.heatflux.rfco2double.getval());
            this.fstx = 0.0f;
            this.dgt = this.target[n] - this.target[n - 1] + 0.1f * (this.target[n - 1] - modlist.heatflux.glotemp[n - 1]);
            this.drf = (this.dgt - this.fstx) / this.fsty;
            this.trf = modlist.radfor.totalrf[n - 1] + this.drf;
            this.crf = this.trf * (modlist.radfor.co2rf[n - 1] / modlist.radfor.totalrf[n - 1]);
            this.ctarget = (float)(modlist.carboncycle.atppmprein * Math.pow(2.0, (double)this.crf / modlist.heatflux.rfco2double.getval()));
            this.newtotemit = this.inverseco2(n, this.ctarget);
            if (this.damp.istrue()) {
                f = (this.newtotemit - (2.0f * modlist.carboncycle.totemit[n - 1] - modlist.carboncycle.totemit[n - 2])) / modlist.carboncycle.totemit[n - 1];
                if ((double)f > 0.005) {
                    f = 0.005f;
                }
                if ((double)f < -0.005) {
                    f = -0.005f;
                }
                this.newtotemit = 2.0f * modlist.carboncycle.totemit[n - 1] - modlist.carboncycle.totemit[n - 2] + modlist.carboncycle.totemit[n - 1] * f;
            }
            if ((double)(f = this.newtotemit / modlist.carboncycle.totemit[n - 1]) > 1.1) {
                f = 1.1f;
            }
            if ((double)f < 0.9) {
                f = 0.9f;
            }
            modlist.carboncycle.totemit[n] = modlist.carboncycle.totemit[n - 1] * f;
            if ((double)modlist.carboncycle.totemit[n] < 0.1) {
                modlist.carboncycle.totemit[n] = 0.1f;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void stabemit() {
        double d;
        int n = (int)this.stabemityear.getval();
        int n2 = (int)(this.integralgt.getval() * 1000.0);
        int n3 = this.sy = modlist.kyoto.kyotop.istrue() ? 2012 : time.fsy;
        this.gesy = (int)(modlist.kyoto.kyotop.istrue() ? modlist.carboncycle.fossil[2012 - time.gsy] : (float)this.ge2000);
        double d2 = this.stabemitlevel.getval() / (double)this.gesy;
        double d3 = this.sygrowth.getval() / 100.0 * (double)(n - this.sy) / (1.0 - d2);
        if (this.quartic.istrue()) {
            d = 30.0 * (((double)((n2 - (modlist.kyoto.kyotop.istrue() ? this.integkyoto : 0)) / this.gesy) - (double)(this.intendy - this.sy) * d2) / ((1.0 - d2) * (double)(n - this.sy)) - 0.5 - d3 / 12.0);
        } else {
            d = 0.0;
            n2 = (int)((double)(modlist.kyoto.kyotop.istrue() ? this.integkyoto : 0) + (double)(n - this.sy) * (double)this.gesy * (d2 + (1.0 - d2) * (0.5 + d3 / 12.0)) + this.stabemitlevel.getval() * (double)(this.intendy - n));
            this.integralgt.setval(n2 / 1000);
        }
        if (!modlist.kyoto.kyotop.istrue()) {
            modlist.carboncycle.fossil[time.fsy - time.gsy] = this.ge2000;
        }
        this.year = this.sy + 1;
        while (this.year <= n) {
            double d4 = (double)(this.year - this.sy) / (double)(n - this.sy);
            modlist.carboncycle.fossil[this.year - time.gsy] = (float)((double)this.gesy * (d2 + (1.0 - d2) * ((1.0 + (2.0 + d3) * d4 + d * d4 * d4) * (1.0 - d4) * (1.0 - d4))));
            ++this.year;
        }
        this.year = n + 1;
        while (this.year <= time.gey) {
            modlist.carboncycle.fossil[this.year - time.gsy] = modlist.carboncycle.fossil[n - time.gsy];
            ++this.year;
        }
    }
}

