/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod;

import jcm.iob;
import jcm.mod.modlist;
import jcm.mod.module;
import jcm.mod.time;
import jcm.param;

public class radfor
extends module {
    public param sulfrf2000 = new param("sulfrf2000", "w&per&m2", -1.2, -2.4, 0.0);
    public param solarrf2000 = new param("solarrf2000", "w&per&m2", 0.3, 0.0, 0.6);
    public param volcfac = new param("volcfac", "", -1.5, -3.0, 0.0);
    public param futuresolar = new param("futsolopt", false);
    public param unifdist = new param("unif", false);
    public param only4gas = new param("4gas", false);
    public param includesv = new param("sv", true);
    public float[] co2rf = modlist.time.fyd();
    public float[] ch4rf = modlist.time.fyd();
    public float[] n2orf = modlist.time.fyd();
    public float[] cfcrf = modlist.time.fyd();
    public float[] hfcrf = modlist.time.fyd();
    public float[] strath2orf = modlist.time.fyd();
    public float[] tropo3rf = modlist.time.fyd();
    public float[] strato3rf = modlist.time.fyd();
    public float[] sulfdirrf = modlist.time.fyd();
    public float[] sulfindrf = modlist.time.fyd();
    public float[] bioburnrf = modlist.time.fyd();
    public float[] albedorf = modlist.time.fyd();
    public float[] dustrf = modlist.time.fyd();
    public float[] aircontrf = modlist.time.fyd();
    public float[] bcrf = modlist.time.fyd();
    public float[] ocrf = modlist.time.fyd();
    public float[] solarrf = modlist.time.fyd();
    public float[] totalrf = modlist.time.fyd();
    public float[] totanthrorf = modlist.time.fyd();
    public float[] totghgrf = modlist.time.fyd();
    public float[] totoghgrf = modlist.time.fyd();
    public float[] totaerorf = modlist.time.fyd();
    public float[] totnatvrf = modlist.time.fyd();
    public float[] solarrfdata = new float[time.hiss1];
    public float[] volcanorf = new float[time.hiss1];
    public float[] volcorig = new float[time.hiss1];
    public float[] co2eqghg = modlist.time.fyd();
    public float[] co2eqghgaero = modlist.time.fyd();
    public float[] co2eqkyoto = modlist.time.fyd();
    float[][] splitrf = new float[time.glos2][4];
    double[] frac;
    double[] splitnls = new double[4];
    double[] splitnlw = new double[4];
    double[] splitl = new double[4];
    double[] splitsl = new double[4];
    double[] splits = new double[4];

    public void setinteractions() {
        this.setaffectedby(modlist.loaddata);
        this.setaffectedby(modlist.carboncycle);
        this.setaffectedby(modlist.oghga);
        this.setaffectedby(modlist.heatflux.climod);
    }

    public void precalc(iob iob2) {
        if (iob2 == this.unifdist) {
            this.distribute();
        }
        if (iob2 == this.only4gas || iob2 == this.includesv || iob2 == this.volcfac) {
            this.makevolcanorf();
        }
        if (iob2 == this.solarrf2000 || iob2 == this.includesv) {
            this.solarrf();
        }
        if (iob2 == this.sulfrf2000) {
            modlist.oghga.changesulfrf();
        }
    }

    public void precalc() {
        if (modlist.loaddata.changed) {
            this.solarrf();
            this.makevolcanorf();
        }
    }

    public void calcstep(int n) {
        this.co2rf(n);
        this.only4gas(n);
        this.calctotals(n);
        this.calcsplit(n);
    }

    void co2rf(int n) {
        this.co2rf[n] = (float)(modlist.heatflux.rfco2double.getval() * Math.log((double)modlist.carboncycle.atppm[n] / modlist.carboncycle.atppmprein) / Math.log(2.0));
    }

    /*
     * Enabled aggressive block sorting
     */
    void makevolcanorf() {
        double d = 2.0;
        int n = 0;
        while (n < time.hiss1) {
            this.volcanorf[n] = this.volcorig[n];
            ++n;
        }
        int n2 = 1;
        while (n2 < time.hiss) {
            this.volcanorf[n2] = (float)(-this.volcfac.getval() * (double)this.volcanorf[n2] * (1.0 - Math.exp(-d)) / d + (double)this.volcanorf[n2 - 1] * Math.exp(-d));
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void solarrf() {
        double d = 0.5711986642890533;
        double d2 = 1.3962634015954636;
        int n = 0;
        while (n < time.hiss) {
            this.solarrf[n] = (float)(this.solarrf2000.getval() / 0.3) * this.solarrfdata[n];
            ++n;
        }
        int n2 = time.hiss;
        while (n2 <= time.glos) {
            this.solarrf[n2] = (float)(this.solarrf2000.getval() / 0.3 * (this.futuresolar.istrue() ? 0.3 + 0.06 * Math.sin(d * (double)(n2 + time.gsy - 2003)) : 0.3));
            ++n2;
        }
    }

    void distribute() {
        if (this.unifdist.istrue()) {
            int n = 0;
            while (n < 4) {
                this.splitnls[n] = 1.0;
                this.splitnlw[n] = 1.0;
                this.splitl[n] = 1.0;
                this.splitsl[n] = 1.0;
                this.splits[n] = 1.0;
                ++n;
            }
        } else {
            this.frac = modlist.heatflux.frac;
            this.splitnls[0] = 0.6000000000000001 / (0.75 * this.frac[0] + 0.25 * this.frac[1]);
            this.splitnls[1] = this.splitnls[0] / 3.0;
            this.splitnls[3] = 0.15000000000000002 / (0.75 * this.frac[3] + 0.25 * this.frac[2]);
            this.splitnls[2] = this.splitnls[3] / 3.0;
            this.splitnlw[0] = 0.44448888999999997 / (0.6667 * this.frac[0] + 0.3333 * this.frac[1]);
            this.splitnlw[1] = this.splitnlw[0] / 2.0;
            this.splitnlw[3] = 0.22221111 / (0.6667 * this.frac[3] + 0.3333 * this.frac[2]);
            this.splitnlw[2] = this.splitnlw[3] / 2.0;
            this.splitl[0] = 0.6667 / this.frac[0];
            this.splitl[1] = 0.0;
            this.splitl[3] = 0.3333 / this.frac[3];
            this.splitl[2] = 0.0;
            this.splitsl[0] = 0.249975 / (0.75 * this.frac[0] + 0.25 * this.frac[1]);
            this.splitsl[1] = this.splitsl[0] / 3.0;
            this.splitsl[3] = 0.5000249999999999 / (0.75 * this.frac[3] + 0.25 * this.frac[2]);
            this.splitsl[2] = this.splitnls[3] / 3.0;
            this.splits[0] = 0.5;
            this.splits[1] = 0.5;
            this.splits[2] = 1.5;
            this.splits[3] = 1.5;
        }
    }

    void only4gas(int n) {
        if (this.only4gas.istrue()) {
            this.cfcrf[n] = 0.0f;
            this.hfcrf[n] = 0.0f;
            this.tropo3rf[n] = 0.0f;
            this.strath2orf[n] = 0.0f;
            this.strato3rf[n] = 0.0f;
            this.solarrf[n] = 0.0f;
            if (n < time.hiss) {
                this.volcanorf[n] = 0.0f;
            }
            this.bcrf[n] = 0.0f;
            this.ocrf[n] = 0.0f;
            this.aircontrf[n] = 0.0f;
            this.albedorf[n] = 0.0f;
            this.bioburnrf[n] = 0.0f;
        }
        if (!this.includesv.istrue()) {
            this.solarrf[n] = 0.0f;
            if (n < time.hiss) {
                this.volcanorf[n] = 0.0f;
            }
        }
    }

    void calcsplit(int n) {
        int n2 = 0;
        while (n2 < 4) {
            this.splitrf[n][n2] = (float)((double)(this.co2rf[n] + this.ch4rf[n] + this.n2orf[n] + this.cfcrf[n] + this.hfcrf[n] + this.strath2orf[n] + this.solarrf[n] + (n < time.hiss ? this.volcanorf[n] : 0.0f)) + (double)(this.sulfdirrf[n] + this.bcrf[n] + this.ocrf[n] + this.aircontrf[n]) * this.splitnls[n2] + (double)(this.sulfindrf[n] + this.tropo3rf[n]) * this.splitnlw[n2] + (double)this.albedorf[n] * this.splitl[n2] + (double)this.bioburnrf[n] * this.splitsl[n2] + (double)this.strato3rf[n] * this.splits[n2]);
            ++n2;
        }
    }

    void calctotals(int n) {
        this.totoghgrf[n] = this.ch4rf[n] + this.n2orf[n] + this.cfcrf[n] + this.hfcrf[n] + this.tropo3rf[n] + this.strato3rf[n] + this.strath2orf[n];
        this.totnatvrf[n] = this.solarrf[n] + (n < time.hiss ? this.volcanorf[n] : 0.0f) + this.albedorf[n];
        this.totaerorf[n] = this.sulfdirrf[n] + this.sulfindrf[n] + this.bcrf[n] + this.ocrf[n] + this.aircontrf[n] + this.bioburnrf[n];
        this.totghgrf[n] = this.co2rf[n] + this.totoghgrf[n];
        this.totanthrorf[n] = this.totghgrf[n] + this.totaerorf[n];
        this.totalrf[n] = this.totanthrorf[n] + this.totnatvrf[n];
        this.co2eqkyoto[n] = (float)(modlist.carboncycle.atppmprein * Math.exp((double)(this.hfcrf[n] + this.ch4rf[n] + this.n2orf[n] + this.co2rf[n]) * Math.log(2.0) / modlist.heatflux.rfco2double.getval()));
        this.co2eqghg[n] = (float)(modlist.carboncycle.atppmprein * Math.exp((double)(this.totoghgrf[n] + this.co2rf[n]) * Math.log(2.0) / modlist.heatflux.rfco2double.getval()));
        this.co2eqghgaero[n] = (float)(modlist.carboncycle.atppmprein * Math.exp((double)(this.totoghgrf[n] + this.co2rf[n] + this.totaerorf[n]) * Math.log(2.0) / modlist.heatflux.rfco2double.getval()));
    }
}

