/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod;

import jcm.iob;
import jcm.loop;
import jcm.mod.modlist;
import jcm.mod.module;
import jcm.mod.region;
import jcm.mod.regionset;
import jcm.mod.time;
import jcm.param;

public class responsibility
extends module {
    public param differential = new param("differential", false);
    public param simplecarbon = new param("simplecarbon", false);
    public param startyear = new param("startyear", "", 1890.0, 1890.0, 2000.0);
    public param endyear = new param("endyear", "", 2100.0, 1990.0, 2100.0);
    public param regions = new param("regions", regionset.list, regionset.allreg.find("JCM12"));
    public int aesy = 1890;
    public int aeey = 2100;
    public int aiy = 2100;
    public int nay = 1 + this.aiy - this.aesy;
    public int ally = time.glos2;
    public int nreg;
    public int nemit;
    public int nrf;
    public int oth;
    int ncb;
    int nhb;
    public float[][] emitfos;
    public float[][] emitluc;
    public float[][] emitch4;
    public float[][] emitn2o;
    public float[][] atco2;
    public float[][] atch4;
    public float[][] atn2o;
    public float[][] rfco2;
    public float[][] rfch4;
    public float[][] rfn2o;
    public float[][] rftot;
    public float[][] surftemp;
    public float[][] sealevte;
    public float[][] pop;
    public float[][] gnp;
    float[] ls;
    float[] hs;
    float[] so;
    float[] hu;
    float[][] ciq;
    float[][][] hiq;
    public region regset;
    float[][] ehch4;
    float[][] ehn2o;
    float[][] regluc;
    float[][][] sresfos;
    float[][][] sresluc;
    float[][][] sresch4;
    float[][][] sresn2o;
    float[][][] srespop;
    float[][][] sresgnp;
    float zero;
    float fostot;
    float luctot;
    float ch4tot;
    float n2otot;
    float n2omod;
    float aviafrac;
    float shipfrac;
    float bunfrac;
    float extrach4;
    float extran2o;
    float fracn2o;
    String debug;
    float sink;
    float atinc;
    float lsinc;
    float hsinc;
    float fracat;
    float fracls;
    float frachs;
    float totls;
    float toths;
    float totat;
    float npinc;
    float dls;
    float dhs;
    float dnp;
    float dat;
    float totemit;
    float oldtotemit;
    float soinc;
    float huinc;
    float fracso;
    float frachu;
    float totso;
    float tothu;
    float dso;
    float dhu;
    float dc;
    float qin;
    float qinold;
    float dqin;
    float[] rff;
    float[] sf;
    float[] mlt;
    float[] boxtemp;

    public responsibility() {
        this.ncb = modlist.carboncycle.ncb;
        this.nhb = modlist.heatflux.nhb;
        this.ehch4 = new float[14][11];
        this.ehn2o = new float[14][11];
        this.regluc = new float[10][141];
        this.sresfos = new float[5][6][12];
        this.sresluc = new float[5][6][12];
        this.sresch4 = new float[5][6][12];
        this.sresn2o = new float[5][6][12];
        this.srespop = new float[5][6][12];
        this.sresgnp = new float[5][6][12];
        this.zero = 0.0f;
        this.debug = "";
        this.rff = new float[2];
        this.sf = new float[2];
        this.mlt = new float[2];
        this.boxtemp = new float[4];
    }

    public void setinteractions() {
        this.setaffectedby(modlist.loaddata);
        this.setaffectedby(modlist.regshares);
        this.setaffectedby(modlist.carboncycle);
        this.setaffectedby(modlist.oghga);
        this.setaffectedby(modlist.heatflux);
    }

    public void preinterac(iob iob2) {
        if (iob2 == this.regions) {
            this.makearrays();
        }
        super.precalc(iob2);
    }

    public void initsetup() {
        super.initsetup();
        this.makearrays();
    }

    public void makearrays() {
        this.regset = (region)this.regions.choseniob;
        if (this.regset.code.equals("JCM12") && this.startyear.val < 1900.0) {
            this.startyear.val = 1900.0;
        }
        this.nreg = this.regset.reg.size();
        this.nemit = this.nreg + 1;
        this.nrf = this.nreg + 4;
        this.oth = this.nreg;
        this.emitfos = new float[this.nemit][this.ally];
        this.emitluc = new float[this.nemit][this.ally];
        this.emitch4 = new float[this.nemit][this.ally];
        this.emitn2o = new float[this.nemit][this.ally];
        this.atco2 = new float[this.nemit][this.ally];
        this.atch4 = new float[this.nemit + 1][this.ally];
        this.atn2o = new float[this.nemit][this.ally];
        this.rfco2 = new float[this.nemit][this.ally];
        this.rfch4 = new float[this.nemit + 1][this.ally];
        this.rfn2o = new float[this.nemit][this.ally];
        this.rftot = new float[this.nrf][this.ally];
        this.surftemp = new float[this.nrf][this.ally];
        this.sealevte = new float[this.nrf][this.ally];
        this.pop = new float[this.nrf][this.ally];
        this.gnp = new float[this.nrf][this.ally];
        this.ciq = new float[this.nemit][this.ncb];
        this.ls = new float[this.nemit];
        this.hs = new float[this.nemit];
        this.so = new float[this.nemit];
        this.hu = new float[this.nemit];
        this.hiq = new float[this.nrf][2][this.nhb];
    }

    public void precalc() {
        if (this.changed && this.needed) {
            loop.calcfutureonly = false;
            modlist.carboncycle.changed = true;
            modlist.heatflux.changed = true;
        }
        if (this.startyear.getval() < 1890.0) {
            this.startyear.setval(1890.0);
        }
        if (this.endyear.getval() > 2100.0) {
            this.endyear.setval(2100.0);
        }
        this.debug = "";
    }

    public void calcstep(int n) {
        int n2 = n + time.gsy;
        int n3 = n;
        if (n3 >= 0 && n3 < this.ally) {
            this.emitstep(n3, n, n2);
            this.carbonstep(n3, n, n2);
            this.atchemstep(n3, n, n2);
            this.rfstep(n3, n, n2);
            this.heatfluxstep(n3, n, n2);
            this.popgnp(n3, n, n2);
        }
    }

    public void postcalc() {
        iob.debug(this.debug);
    }

    void emitstep(int n, int n2, int n3) {
        if ((double)n3 >= this.startyear.getval() && (double)n3 <= this.endyear.getval()) {
            int n4;
            if (this.regset.code.equals("SRES4")) {
                n4 = 0;
                while (n4 < this.nreg) {
                    if (n3 < 1990) {
                        this.emitfos[n4][n] = regionset.jcmtosres(modlist.regshares.emit, n4, n3);
                        this.emitluc[n4][n] = regionset.houghtontosres(this.regluc, n4, n3);
                        this.emitch4[n4][n] = regionset.ehtosresinterp(this.ehch4, n4, n3) * 16.0f / 12.0f;
                        this.emitn2o[n4][n] = regionset.ehtosresinterp(this.ehn2o, n4, n3);
                    } else {
                        this.emitfos[n4][n] = modlist.mitigation.scenario.chosen.equals("nopolicy") ? regionset.sresinterp(this.sresfos, n4, n3) * 1000.0f : regionset.jcmtosres(modlist.regshares.emit, n4, n3);
                        this.emitluc[n4][n] = regionset.sresinterp(this.sresluc, n4, n3) * 1000.0f;
                        this.emitch4[n4][n] = regionset.sresinterp(this.sresch4, n4, n3);
                        this.emitn2o[n4][n] = regionset.sresinterp(this.sresn2o, n4, n3);
                    }
                    ++n4;
                }
            } else if (this.regset.code.equals("JCM12")) {
                n4 = 0;
                while (n4 < this.nreg) {
                    float f = this.emitfos[n4][n] = n3 >= 1900 && n3 <= 2100 && n4 != 12 ? modlist.regshares.emit[n4][n3 - 1900] : 0.0f;
                    if (n3 < 1990) {
                        this.emitluc[n4][n] = regionset.houghtontojcm(this.regluc, n4, n3);
                        this.emitch4[n4][n] = regionset.ehtojcm(this.ehch4, n4, n3) * 16.0f / 12.0f;
                        this.emitn2o[n4][n] = regionset.ehtojcm(this.ehn2o, n4, n3);
                    } else {
                        this.emitluc[n4][n] = this.emitluc[n4][n - 1];
                        this.emitch4[n4][n] = this.emitch4[n4][n - 1];
                        this.emitn2o[n4][n] = this.emitn2o[n4][n - 1];
                    }
                    ++n4;
                }
            }
            this.emitfos[this.oth][n] = this.zero;
            this.emitluc[this.oth][n] = this.zero;
            this.emitch4[this.oth][n] = this.zero;
            this.emitn2o[this.oth][n] = this.zero;
            if (n3 > 2000 && this.regset.code.equals("SRES4") && !modlist.mitigation.scenario.chosen.equals("nopolicy") && modlist.regshares.distribution.chosen.equals("unspecified")) {
                this.emitfos[this.oth][n] = modlist.carboncycle.fossil[n2];
            }
            this.luctot = 0.0f;
            n4 = 0;
            while (n4 < this.nreg) {
                this.luctot += this.emitluc[n4][n];
                ++n4;
            }
            int n5 = 0;
            while (n5 < this.nreg) {
                float[] fArray = this.emitluc[n5];
                int n6 = n;
                fArray[n6] = fArray[n6] * (modlist.carboncycle.lucf[n2] / this.luctot);
                ++n5;
            }
            this.n2otot = 0.0f;
            int n7 = 0;
            while (n7 < this.nreg) {
                this.n2otot += this.emitn2o[n7][n];
                ++n7;
            }
            int n8 = 0;
            while (n8 < this.nreg) {
                float[] fArray = this.emitn2o[n8];
                int n9 = n;
                fArray[n9] = fArray[n9] * (modlist.oghga.n2oemit[n2] / this.n2otot);
                ++n8;
            }
            this.ch4tot = 0.0f;
            int n10 = 0;
            while (n10 < this.nreg) {
                this.ch4tot += this.emitch4[n10][n];
                ++n10;
            }
            int n11 = 0;
            while (n11 < this.nreg) {
                float[] fArray = this.emitch4[n11];
                int n12 = n;
                fArray[n12] = fArray[n12] * (modlist.oghga.ch4emit[n2] / this.ch4tot);
                ++n11;
            }
        } else {
            int n13 = 0;
            while (n13 < this.nreg) {
                this.emitfos[n13][n] = this.zero;
                this.emitluc[n13][n] = this.zero;
                this.emitch4[n13][n] = this.zero;
                this.emitn2o[n13][n] = this.zero;
                ++n13;
            }
            this.emitfos[this.oth][n] = modlist.carboncycle.fossil[n2];
            this.emitluc[this.oth][n] = modlist.carboncycle.lucf[n2];
            this.emitch4[this.oth][n] = modlist.oghga.ch4emit[n2];
            this.emitn2o[this.oth][n] = modlist.oghga.n2oemit[n2];
        }
    }

    void popgnp(int n, int n2, int n3) {
        float f = 0.0f;
        float f2 = 0.0f;
        n3 = n3 < 2100 ? n3 : 2100;
        int n4 = 0;
        while (n4 < this.nreg) {
            if (this.regset.code.equals("SRES4")) {
                if (n3 < 1990) {
                    this.pop[n4][n] = regionset.jcmtosres(modlist.people.pop, n4, n3);
                    this.gnp[n4][n] = regionset.jcmtosres(modlist.people.gdp, n4, n3);
                } else {
                    this.pop[n4][n] = regionset.sresinterp(this.srespop, n4, n3);
                    this.gnp[n4][n] = regionset.sresinterp(this.sresgnp, n4, n3) * 1000.0f;
                }
            } else if (this.regset.code.equals("JCM12")) {
                this.pop[n4][n] = n3 >= 1900 && n3 <= 2100 && n4 < 12 ? modlist.people.pop[n4][n3 - 1900] : 0.0f;
                this.gnp[n4][n] = n3 >= 1970 && n3 <= 2100 && n4 < 12 ? modlist.people.pop[n4][n3 - 1900] : 0.0f;
            }
            f += this.pop[n4][n];
            f2 += this.gnp[n4][n];
            ++n4;
        }
        int n5 = this.oth;
        while (n5 < this.nrf) {
            this.pop[n5][n] = f;
            this.gnp[n5][n] = f2;
            ++n5;
        }
    }

    void atchemstep(int n, int n2, int n3) {
        if (n == 0) {
            int n4 = 0;
            while (n4 < this.nreg) {
                this.atch4[n4][n] = 0.0f;
                this.atn2o[n4][n] = 0.0f;
                ++n4;
            }
            this.atch4[this.oth][n] = modlist.oghga.ch4conc[n2] - modlist.oghga.ch4prein;
            this.atch4[this.nemit][n] = 0.0f;
            this.atn2o[this.oth][n] = modlist.oghga.n2oconc[n2] - modlist.oghga.n2oprein;
        } else {
            int n5 = 0;
            while (n5 < this.nemit) {
                this.atch4[n5][n] = this.atch4[n5][n - 1] * (1.0f - 1.0f / modlist.oghga.ch4life(n2)) + modlist.oghga.ppbpmtch4 * this.emitch4[n5][n];
                this.atn2o[n5][n] = this.atn2o[n5][n - 1] * (1.0f - 1.0f / modlist.oghga.n2olife(n2)) + modlist.oghga.ppbpmtn * this.emitn2o[n5][n];
                ++n5;
            }
            this.extrach4 = modlist.oghga.ppbpmtch4 * modlist.oghga.ch4emitnat() - modlist.oghga.ch4prein / modlist.oghga.ch4life(n2);
            this.atch4[this.nemit][n] = this.atch4[this.nemit][n - 1] * (1.0f - 1.0f / modlist.oghga.ch4life(n2)) + this.extrach4;
            this.extran2o = modlist.oghga.ppbpmtn * modlist.oghga.n2oemitnat - modlist.oghga.n2oprein / modlist.oghga.n2olife(n2);
            this.fracn2o = modlist.oghga.n2oconc[n2] - modlist.oghga.n2oprein;
            if ((double)this.fracn2o > 0.1) {
                int n6 = 0;
                while (n6 < this.nemit) {
                    float[] fArray = this.atn2o[n6];
                    int n7 = n;
                    fArray[n7] = fArray[n7] + this.extran2o * this.atn2o[n6][n] / this.fracn2o;
                    ++n6;
                }
            }
        }
    }

    void carbonstep(int n, int n2, int n3) {
        if (this.simplecarbon.istrue()) {
            if (n == 0) {
                int n4 = 0;
                while (n4 < this.nreg) {
                    this.atco2[n4][n] = 0.0f;
                    ++n4;
                }
                this.atco2[this.oth][n] = modlist.carboncycle.atppm[n2] - (float)modlist.carboncycle.atppmprein;
            } else {
                int n5 = 0;
                while (n5 < this.nemit) {
                    this.atco2[n5][n] = this.atco2[n5][n - 1] * (1.0f - (float)modlist.carboncycle.ppmpmtc * modlist.carboncycle.totsink[n2] / (modlist.carboncycle.atppm[n2] - (float)modlist.carboncycle.atppmprein)) + (float)(modlist.carboncycle.ppmpmtc * (double)(this.emitfos[n5][n] + this.emitluc[n5][n]));
                    ++n5;
                }
            }
        } else {
            int n6;
            int n7;
            if (n == 0) {
                n7 = 0;
                while (n7 < this.ncb) {
                    n6 = 0;
                    while (n6 < this.nreg) {
                        this.ciq[n6][n7] = 0.0f;
                        ++n6;
                    }
                    this.ciq[this.oth][n7] = (float)modlist.carboncycle.ciq[n7];
                    ++n7;
                }
            }
            n7 = 0;
            while (n7 < this.nemit) {
                this.oldtotemit = n > 0 ? this.emitfos[n7][n - 1] + this.emitluc[n7][n - 1] : 0.0f;
                this.totemit = this.emitfos[n7][n] + this.emitluc[n7][n];
                this.fracat = n > 0 ? this.atco2[n7][n - 1] / (modlist.carboncycle.atppm[n2 - 1] - (float)modlist.carboncycle.atppmprein) : 0.0f;
                this.fracls = n > 0 ? this.ls[n7] / this.totls : 0.0f;
                this.frachs = n > 0 ? this.hs[n7] / this.toths : 0.0f;
                float f = this.fracso = n > 0 ? this.surftemp[n7][n - 1] / modlist.heatflux.glotemp[n2 - 1] : 0.0f;
                if (this.fracso > 0.0f && (double)this.fracso < 0.01 || this.fracso < 0.0f && (double)this.fracso > -0.01) {
                    this.fracso = 0.0f;
                }
                this.frachu = this.fracso;
                this.lsinc = (float)modlist.carboncycle.oldlsinc * this.fracls;
                this.hsinc = (float)modlist.carboncycle.oldhsinc * this.frachs;
                this.npinc = (float)modlist.carboncycle.oldnpinc * this.fracat;
                this.soinc = (float)modlist.carboncycle.oldsoinc * this.fracso;
                this.huinc = (float)modlist.carboncycle.oldhuinc * this.frachu;
                this.atinc = this.oldtotemit - (this.lsinc + this.hsinc + this.npinc + this.soinc + this.huinc);
                this.dls = (float)modlist.carboncycle.dls * this.fracls;
                this.dhs = (float)modlist.carboncycle.dhs * this.frachs;
                this.dnp = (float)modlist.carboncycle.dnp * this.fracat;
                this.dso = (float)modlist.carboncycle.dso * this.fracso;
                this.dhu = (float)modlist.carboncycle.dhu * this.frachu;
                this.dat = this.totemit - this.oldtotemit - (this.dls + this.dhs + this.dnp + this.dso + this.dhu);
                this.atco2[n7][n] = 0.0f;
                this.ls[n7] = 0.0f;
                this.hs[n7] = 0.0f;
                this.so[n7] = 0.0f;
                this.hu[n7] = 0.0f;
                n6 = 0;
                while (n6 < this.ncb) {
                    this.ciq[n7][n6] = (float)((double)this.ciq[n7][n6] * modlist.carboncycle.cpropf[n6] + modlist.carboncycle.scicAT[n6] * (double)this.atinc + modlist.carboncycle.scicLS[n6] * (double)this.lsinc + modlist.carboncycle.scicHS[n6] * (double)this.hsinc + modlist.carboncycle.scicNP[n6] * (double)this.npinc + modlist.carboncycle.rcicAT[n6] * (double)this.dat + modlist.carboncycle.rcicLS[n6] * (double)this.dls + modlist.carboncycle.rcicHS[n6] * (double)this.dhs + modlist.carboncycle.rcicNP[n6] * (double)this.dnp + modlist.carboncycle.scicSO[n6] * (double)this.soinc + modlist.carboncycle.rcicSO[n6] * (double)this.dso + modlist.carboncycle.scicHU[n6] * (double)this.huinc + modlist.carboncycle.rcicHU[n6] * (double)this.dhu);
                    float[] fArray = this.atco2[n7];
                    int n8 = n;
                    fArray[n8] = fArray[n8] + (float)modlist.carboncycle.crAT[n6] * this.ciq[n7][n6];
                    int n9 = n7;
                    this.ls[n9] = this.ls[n9] + (float)modlist.carboncycle.crLS[n6] * this.ciq[n7][n6];
                    int n10 = n7;
                    this.hs[n10] = this.hs[n10] + (float)modlist.carboncycle.crHS[n6] * this.ciq[n7][n6];
                    int n11 = n7;
                    this.so[n11] = this.so[n11] + (float)modlist.carboncycle.crSO[n6] * this.ciq[n7][n6];
                    int n12 = n7;
                    this.hu[n12] = this.hu[n12] + (float)modlist.carboncycle.crHU[n6] * this.ciq[n7][n6];
                    ++n6;
                }
                float[] fArray = this.atco2[n7];
                int n13 = n;
                fArray[n13] = fArray[n13] * (float)modlist.carboncycle.ppmpmtc;
                ++n7;
            }
            this.totls = 0.0f;
            this.toths = 0.0f;
            this.totat = 0.0f;
            this.totso = 0.0f;
            this.tothu = 0.0f;
            n6 = 0;
            while (n6 < this.nemit) {
                this.totls += this.ls[n6];
                this.toths += this.hs[n6];
                this.totat += this.atco2[n6][n];
                this.totso += this.so[n6];
                this.tothu += this.hu[n6];
                ++n6;
            }
        }
    }

    void rfstep(int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.nemit + 1) {
            if (this.differential.istrue() && (double)n3 > this.startyear.getval() + 1.0) {
                if (n4 < this.nemit) {
                    this.dc = modlist.carboncycle.atppm[n2] - modlist.carboncycle.atppm[n2 - 1];
                    this.rfco2[n4][n] = this.rfco2[n4][n - 1] + ((double)Math.abs(this.dc) > 1.0E-5 ? (modlist.radfor.co2rf[n2] - modlist.radfor.co2rf[n2 - 1]) * (this.atco2[n4][n] - this.atco2[n4][n - 1]) / this.dc : 0.0f);
                    this.dc = modlist.oghga.n2oconc[n2] - modlist.oghga.n2oconc[n2 - 1];
                    this.rfn2o[n4][n] = this.rfn2o[n4][n - 1] + ((double)Math.abs(this.dc) > 1.0E-5 ? (modlist.radfor.n2orf[n2] - modlist.radfor.n2orf[n2 - 1]) * (this.atn2o[n4][n] - this.atn2o[n4][n - 1]) / this.dc : 0.0f);
                }
                this.dc = modlist.oghga.ch4conc[n2] - modlist.oghga.ch4conc[n2 - 1];
                this.rfch4[n4][n] = this.rfch4[n4][n - 1] + ((double)Math.abs(this.dc) > 1.0E-5 ? (modlist.radfor.ch4rf[n2] - modlist.radfor.ch4rf[n2 - 1]) * (this.atch4[n4][n] - this.atch4[n4][n - 1]) / this.dc : 0.0f);
            } else {
                if (n4 < this.nemit) {
                    this.dc = modlist.carboncycle.atppm[n2] - (float)modlist.carboncycle.atppmprein;
                    this.rfco2[n4][n] = this.atco2[n4][n] * ((double)Math.abs(this.dc) > 1.0E-5 ? modlist.radfor.co2rf[n2] / this.dc : 0.0f);
                    this.dc = modlist.oghga.n2oconc[n2] - modlist.oghga.n2oprein;
                    this.rfn2o[n4][n] = this.atn2o[n4][n] * ((double)Math.abs(this.dc) > 1.0E-5 ? modlist.radfor.n2orf[n2] / this.dc : 0.0f);
                }
                this.dc = modlist.oghga.ch4conc[n2] - modlist.oghga.ch4prein;
                this.rfch4[n4][n] = this.atch4[n4][n] * ((double)Math.abs(this.dc) > 1.0E-5 ? modlist.radfor.ch4rf[n2] / this.dc : 0.0f);
            }
            ++n4;
        }
        float f = 0.0f;
        int n5 = 0;
        while (n5 < this.nemit) {
            this.rftot[n5][n] = this.rfco2[n5][n] + this.rfch4[n5][n] + this.rfn2o[n5][n];
            f += this.rftot[n5][n];
            ++n5;
        }
        this.rftot[this.nemit][n] = this.rfch4[this.nemit][n] + modlist.radfor.cfcrf[n2] + modlist.radfor.hfcrf[n2] + modlist.radfor.strath2orf[n2] + modlist.radfor.tropo3rf[n2] + modlist.radfor.strato3rf[n2];
        this.rftot[this.nemit + 1][n] = modlist.radfor.totaerorf[n2];
        this.rftot[this.nreg + 3][n] = modlist.radfor.totnatvrf[n2];
    }

    void heatfluxsetup() {
        int n = 0;
        while (n < 2) {
            this.rff[n] = (float)(1.0 + modlist.heatflux.frac[n * 3] / modlist.heatflux.frac[n + 1] * modlist.heatflux.klo / (modlist.heatflux.kls * modlist.heatflux.frac[n * 3] + modlist.heatflux.klo));
            this.sf[n] = (float)(modlist.heatflux.spaceflux[n] * modlist.heatflux.qpt * modlist.heatflux.tstart);
            int n2 = 0;
            while (n2 < this.nhb) {
                int n3 = 0;
                while (n3 < this.nrf) {
                    this.hiq[n3][n][n2] = (float)(n3 == this.oth ? modlist.heatflux.hiq[n][n2] : modlist.heatflux.hiqstart[n][n2]);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    void heatfluxstep(int n, int n2, int n3) {
        if (n == 0) {
            this.heatfluxsetup();
        }
        int n4 = 0;
        while (n4 < this.nrf) {
            int n5;
            this.surftemp[n4][n] = 0.0f;
            this.sealevte[n4][n] = 0.0f;
            int n6 = 0;
            while (n6 < 2) {
                this.mlt[n6] = 0.0f;
                this.qinold = this.sf[n6] + (n > 0 ? this.rftot[n4][n - 1] : 0.0f) * this.rff[n6];
                this.qin = this.sf[n6] + this.rftot[n4][n] * this.rff[n6];
                this.dqin = this.qin - this.qinold;
                n5 = 0;
                while (n5 < this.nhb) {
                    this.hiq[n4][n6][n5] = (float)(modlist.heatflux.hpropf[n6][n5] * (double)this.hiq[n4][n6][n5] + modlist.heatflux.shicML[n6][n5] * (double)this.qinold + modlist.heatflux.rhicML[n6][n5] * (double)this.dqin);
                    int n7 = n6;
                    this.mlt[n7] = this.mlt[n7] + (float)modlist.heatflux.hrML[n6][n5] * this.hiq[n4][n6][n5];
                    float[] fArray = this.sealevte[n4];
                    int n8 = n;
                    fArray[n8] = fArray[n8] + (float)modlist.heatflux.hrsl[n6][n5] * this.hiq[n4][n6][n5];
                    ++n5;
                }
                this.mlt[n6] = (float)((double)this.mlt[n6] / modlist.heatflux.qpt - modlist.heatflux.tstart);
                ++n6;
            }
            float[] fArray = this.sealevte[n4];
            int n9 = n;
            fArray[n9] = fArray[n9] - (float)modlist.heatflux.sealevteinit;
            this.boxtemp[0] = (float)(((double)this.mlt[0] * modlist.heatflux.cice * modlist.heatflux.klo + modlist.heatflux.frac[0] * (double)this.rftot[n4][n]) / (modlist.heatflux.kls * modlist.heatflux.frac[0] + modlist.heatflux.klo));
            this.boxtemp[3] = (float)(((double)this.mlt[1] * modlist.heatflux.cice * modlist.heatflux.klo + modlist.heatflux.frac[3] * (double)this.rftot[n4][n]) / (modlist.heatflux.kls * modlist.heatflux.frac[3] + modlist.heatflux.klo));
            this.boxtemp[1] = (float)((double)this.mlt[0] * modlist.heatflux.cice);
            this.boxtemp[2] = (float)((double)this.mlt[1] * modlist.heatflux.cice);
            n5 = 0;
            while (n5 < 4) {
                float[] fArray2 = this.surftemp[n4];
                int n10 = n;
                fArray2[n10] = fArray2[n10] + (float)((double)this.boxtemp[n5] * modlist.heatflux.frac[n5]);
                ++n5;
            }
            if (this.surftemp[n4][n] > 0.0f && (double)this.surftemp[n4][n] < 0.01 || this.surftemp[n4][n] < 0.0f && (double)this.surftemp[n4][n] > -0.01) {
                this.surftemp[n4][n] = 0.0f;
            }
            ++n4;
        }
    }
}

