/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod;

import jcm.mod.modlist;
import jcm.mod.module;

public class sealevel
extends module {
    public float[] glacier = modlist.time.fyd();
    public float[] longterm = modlist.time.fyd();
    public float[] antarctica = modlist.time.fyd();
    public float[] greenland = modlist.time.fyd();
    public float[] freshwater = modlist.time.fyd();
    public float[] other = modlist.time.fyd();
    public float[] total = modlist.time.fyd();
    double[] glsens = new double[]{0.12, 0.16, 0.09, 0.1, 0.03, 0.15, 0.14, 0.3};
    double[] ansens = new double[]{-0.18, -0.37, -0.35, -0.21, -0.48, -0.31, -0.48, -0.21};
    double glsensfac;
    double ansensfac;
    double totglac = 0.5;
    double taul = 70.0;
    double tauh = 130.0;
    double deltatl = 0.7;
    double deltath = 3.0;
    int ng = 10;
    int n;
    double eqglac;
    double[] glac = new double[this.ng];
    double[] glac99 = new double[this.ng];
    double[] tau = new double[this.ng];
    double[] deltat = new double[this.ng];

    public void setinteractions() {
        this.setaffectedby(modlist.heatflux);
    }

    public void precalc() {
        this.n = 0;
        while (this.n < this.ng) {
            this.tau[this.n] = this.taul + (this.tauh - this.taul) * (double)this.n / (double)(this.ng - 1);
            this.deltat[this.n] = this.deltatl + (this.deltath - this.deltatl) * (double)this.n / (double)(this.ng - 1);
            ++this.n;
        }
    }

    public void calcstep(int n) {
        if (n > 0) {
            this.longterm[n] = (float)((double)this.longterm[n - 1] + 2.5E-4);
            this.other[n] = (float)((double)this.other[n - 1] + (n < 240 ? 5.0E-5 : 1.7E-4));
            this.glacier[n] = (float)this.totglac;
            this.n = 0;
            while (this.n < this.ng) {
                this.eqglac = this.totglac / (double)this.ng * (1.0 - (double)modlist.heatflux.glotemp[n] / this.deltat[this.n]);
                if (this.eqglac < 0.0) {
                    this.eqglac = 0.0;
                }
                int n2 = this.n;
                this.glac[n2] = this.glac[n2] - 0.3 * (this.glac[this.n] - this.eqglac) / this.tau[this.n];
                int n3 = n;
                this.glacier[n3] = (float)((double)this.glacier[n3] - this.glac[this.n]);
                ++this.n;
            }
            this.glsensfac = 1.0 + ((double)modlist.heatflux.glotemp[n] - 1.5) * 0.3;
            this.ansensfac = (double)modlist.heatflux.glotemp[n] * 0.05;
            this.antarctica[n] = (float)((double)this.antarctica[n - 1] + ((n > 350 ? this.ansensfac : 0.0) + this.ansens[modlist.heatflux.model]) * (double)modlist.heatflux.glotemp[n] * 0.001);
            this.greenland[n] = (float)((double)this.greenland[n - 1] + (n > 350 ? this.glsensfac : 1.0) * this.glsens[modlist.heatflux.model] * (double)modlist.heatflux.glotemp[n] * 0.001);
            this.freshwater[n] = 0.0f;
        }
        this.total[n] = modlist.heatflux.sealevte[n] + this.glacier[n] + this.longterm[n] + this.antarctica[n] + this.greenland[n] + this.other[n];
    }

    public void save99() {
        this.n = 0;
        while (this.n < this.ng) {
            this.glac99[this.n] = this.glac[this.n];
            ++this.n;
        }
    }

    public void startstate(int n) {
        this.longterm[0] = 0.0f;
        this.antarctica[0] = 0.0f;
        this.greenland[0] = 0.0f;
        this.freshwater[0] = 0.0f;
        this.glacier[0] = 0.0f;
        this.other[0] = 0.0f;
        if (n == 2000) {
            this.n = 0;
            while (this.n < this.ng) {
                this.glac[this.n] = this.glac99[this.n];
                ++this.n;
            }
        } else {
            this.n = 0;
            while (this.n < this.ng) {
                this.glac[this.n] = this.totglac / (double)this.ng;
                ++this.n;
            }
        }
    }
}

