/*
 * Decompiled with CFR 0.152.
 */
package jcm.pan;

import java.awt.Color;
import jcm.gui.colfont;
import jcm.gui.control;
import jcm.gui.graph;
import jcm.gui.menu;
import jcm.gui.option;
import jcm.iob;
import jcm.mod.modlist;
import jcm.mod.time;

public class carbonstoreplot
extends graph {
    int nb;
    int nl;
    int cd;
    int cd2;
    Color[] boxcolor;
    String[] boxname;
    public menu carbchem;
    public option chemfeedback;
    public option stackedopt;
    public control fertbeta;
    public control respq10;
    public control diffufac;
    public control hlmix;
    public control sidemix;
    public control upwell;
    public control gasex;

    public carbonstoreplot() {
        this.nb = modlist.carboncycle.ncb;
        this.nl = modlist.carboncycle.ncl;
        this.cd = 75;
        this.boxcolor = new Color[this.nb];
        this.boxname = new String[this.nb];
        this.carbchem = new menu(modlist.carboncycle.carbchem, this, "expert");
        this.chemfeedback = new option(modlist.carboncycle.chemfeedback, this);
        this.stackedopt = new option(this.stacked, this);
        this.fertbeta = new control(modlist.carboncycle.beta, this, "ya", "ns", colfont.green, 30, 3);
        this.respq10 = new control(modlist.carboncycle.respq10, this, "ya", "ns", colfont.brown, 40, 2);
        this.diffufac = new control(modlist.carboncycle.diffufac, this, "ya", "ns", colfont.blue, 50, 2);
        this.hlmix = new control(modlist.carboncycle.hlmix, this, "ya", "ns", colfont.cyan, 60, 1, "expert");
        this.sidemix = new control(modlist.carboncycle.sidemix, this, "ya", "ns", colfont.yellow, 70, 4, "expert");
        this.upwell = new control(modlist.carboncycle.upwell, this, "ya", "ns", colfont.red, 80, 3, "expert");
        this.gasex = new control(modlist.carboncycle.gasex, this, "ya", "ns", colfont.orange, 90, 3, "expert");
    }

    public void setinteractions() {
        super.setinteractions();
        this.bufi.setaffectedby(modlist.carboncycle);
        this.bufi.setaffectedby(modlist.carboncycle.viewbox);
    }

    public void makecurves() {
        this.makeboxnamecol();
        this.makecurves(time.glx, modlist.carboncycle.cq, this.boxname, this.boxcolor);
        this.yscale.setup("giga&ton&carbon", 0.0, 2000000.0, 100000.0, 1000.0);
        this.stacked.flag = true;
        this.stacked.defflag = true;
        this.legw = 64;
    }

    public void makeboxnamecol() {
        int n = 0;
        while (n < this.nl) {
            int n2 = (int)(127.0 + 127.0 * Math.cos(Math.PI * 2 * (double)(n - this.nl / 3) / (double)this.nl));
            int n3 = (int)(127.0 + 127.0 * Math.cos(Math.PI * 2 * (double)(n - 2 * this.nl / 3) / (double)this.nl));
            this.boxcolor[n] = new Color(n3, 0, n2);
            this.cd2 = this.cd + (n < 20 ? 49 : 196);
            this.boxname[n] = "" + this.cd + "-" + this.cd2 + "m";
            this.cd = this.cd2;
            ++n;
        }
        this.boxcolor[this.nl] = colfont.ltblue;
        this.boxname[this.nl] = "lsurf";
        this.boxcolor[this.nl + 1] = colfont.blue;
        this.boxname[this.nl + 1] = "hsurf";
        this.boxcolor[this.nl + 2] = colfont.dkblue;
        this.boxname[this.nl + 2] = "hdeep";
        this.boxcolor[this.nl + 3] = colfont.ltgrey;
        this.boxname[this.nl + 3] = "atmosphere";
        this.boxcolor[this.nl + 4] = colfont.green;
        this.boxname[this.nl + 4] = "green";
        this.boxcolor[this.nl + 5] = colfont.dkgreen;
        this.boxname[this.nl + 5] = "wood";
        this.boxcolor[this.nl + 6] = colfont.brown;
        this.boxname[this.nl + 6] = "soil";
        this.boxcolor[this.nl + 7] = colfont.dkbrown;
        this.boxname[this.nl + 7] = "humus";
        this.boxcolor[this.nl + 8] = colfont.yellowgreen;
        this.boxname[this.nl + 8] = "newprod";
    }

    public void precalc(iob iob2) {
        super.precalc(iob2);
        if (iob2 == this.stacked) {
            this.yscale.max.val = this.stacked.istrue() ? 2000000.0 : 400000.0;
            this.yscale.scales = this.stacked.istrue() ? 100000.0 : 20000.0;
        }
    }
}

