/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui;

import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import jcm.gui.jcmpanel;
import jcm.gui.menu;
import jcm.iob;
import jcm.mod.region;
import jcm.mod.regionset;
import jcm.param;

public class mapplot
extends jcmpanel {
    public static String[] projections = new String[]{"grid", "coslat", "polar"};
    public param startlon = new param("mapstartlongitude", "degrees", 349.0, 0.0, 360.0);
    public param projection = new param("projection", projections, "coslat");
    public param regions = new param("regions", regionset.list, regionset.jcmreg);
    public menu projmenu = new menu(this.projection, this);
    public menu regmenu = new menu(this.regions, this);
    public double mx;
    public double oldmx;
    public double my;
    public int top;
    public int left;
    public int plotw;
    public int ploth;
    public int sl;
    public region regset;
    public region insidereg;
    public boolean needtoclear = true;
    public boolean addedyet = false;
    public boolean leftmap = false;
    public boolean gotevent = false;
    public boolean inside = false;
    public boolean newpolys = true;

    public void precalc(iob iob2) {
        super.precalc(iob2);
        if (iob2 == this.regions) {
            this.regset = (region)this.regions.choseniob;
        }
    }

    public void setinteractions() {
        super.setinteractions();
        this.bufi.setaffectedby(this.startlon);
        this.bufi.setaffectedby(this.projection);
        this.bufi.setaffectedby(this.regions);
    }

    public String docinfo(String string) {
        if (string.equals("mapstartlongitude")) {
            return this.startlon.docinfo();
        }
        return super.docinfo(string);
    }

    public void mainplot() {
        if (!this.bufi.changed) {
            this.bufi.draw();
        }
    }

    public void makebuffer() {
        this.setsize(0, 0, this.panw, this.panh - this.tmh, (int)this.startlon.val);
        this.bufi.newimage(0, this.tmh, this.panw, this.panh - this.tmh);
        this.paintreg(this.bufi.g);
        this.paintline(this.bufi.g);
        this.bufi.g.dispose();
    }

    public void setsize(int n, int n2, int n3, int n4, int n5) {
        this.left = n;
        this.top = n2;
        this.plotw = n3;
        this.ploth = n4;
        this.sl = n5;
    }

    public boolean handleEvent(Event event) {
        this.gotevent = true;
        if (event.id == 503 || event.id == 501 || event.id == 506) {
            this.findpos(event.x, event.y - this.tmh);
        }
        if (event.id == 501 && this.inside) {
            this.oldmx = this.mx;
        }
        if (event.id == 506 && this.inside) {
            this.dragplot();
        }
        if (event.id == 503) {
            this.mousemove();
        }
        super.handleEvent(event);
        this.gotevent = false;
        return false;
    }

    public region findreg(int n, int n2) {
        this.regset.start();
        while (this.regset.more()) {
            if (!this.regset.c.contains(this.translateback(n, n2))) continue;
            return this.regset.c;
        }
        return null;
    }

    public void paintline(Graphics graphics) {
        graphics.setColor(Color.black);
        this.regset.start();
        while (this.regset.more()) {
            this.regset.c.makepolys();
            int n = 0;
            while (n < this.regset.c.polyset.size()) {
                graphics.drawPolygon(this.translate(this.regset.c.poly(n)));
                ++n;
            }
        }
    }

    public Color regcol(region region2) {
        return region2.getcolor();
    }

    public void paintreg(Graphics graphics) {
        this.regset.start();
        while (this.regset.more()) {
            graphics.setColor(this.regcol(this.regset.c));
            this.regset.c.makepolys();
            int n = 0;
            while (n < this.regset.c.polyset.size()) {
                graphics.fillPolygon(this.translate(this.regset.c.poly(n)));
                ++n;
            }
        }
    }

    void dragplot() {
        this.startlon.val = (int)(((double)((int)this.startlon.val) + (this.mx - this.oldmx) + 360.0) % 360.0);
        this.newpolys = true;
        this.startlon.respond(true);
    }

    public void mousemove() {
        if (this.inside) {
            this.writepos();
            this.leftmap = false;
        } else {
            if (!this.leftmap) {
                this.cleartext();
            }
            this.leftmap = true;
        }
    }

    void cleartext() {
        Graphics graphics = this.getGraphics();
        graphics.clearRect(4, this.panh - 48, 35, 16);
        graphics.clearRect(4, this.panh - 32, 50, 16);
        graphics.clearRect(this.panw - 85, this.panh - 32, 60, 16);
        graphics.dispose();
    }

    public boolean notwrap(Point point, Point point2) {
        return this.notwrap(point.x, point.y, point2.x, point2.y);
    }

    public boolean notwrap(int n, int n2, int n3, int n4) {
        return this.projection.chosen.equals("polar") ? n2 * n4 > 0 : Math.abs(this.wrap(n + this.sl) - this.wrap(n3 + this.sl)) < 180;
    }

    int wrap(int n) {
        return (n + 540) % 360 - 180;
    }

    public Point translate(int n, int n2) {
        return this.translate((double)n, (double)n2);
    }

    public Point translate(double d, double d2) {
        int n;
        int n2 = this.projection.chosen.equals("coslat") || this.projection.chosen.equals("grid") ? this.top + (int)((double)this.ploth * (90.0 - d2) / 180.0) : (n = this.projection.chosen.equals("polar") ? this.top + (int)((double)this.ploth * (0.5 + 0.5 * Math.sin(Math.PI * (d + (double)this.sl) / 180.0) * (90.0 - Math.abs(d2)) / 90.0)) : (int)d2);
        int n3 = this.projection.chosen.equals("coslat") ? this.left + (int)((double)this.plotw * (0.5 + (double)this.wrap((int)(d + (double)this.sl)) / 360.0 * Math.cos(Math.PI * d2 / 180.0))) : (this.projection.chosen.equals("grid") ? this.left + this.plotw * (this.wrap((int)(d + (double)this.sl)) + 180) / 360 : (this.projection.chosen.equals("polar") ? this.left + (int)((double)this.plotw * ((d2 > 0.0 ? 0.25 : 0.75) - Math.cos(Math.PI * (d + (double)this.sl) / 180.0) * (Math.abs(d2) / d2) * 0.25 * (90.0 - Math.abs(d2)) / 90.0)) : (int)d));
        return new Point(n3, n);
    }

    public Point translateback(int n, int n2) {
        int n3;
        int n4;
        double d = (double)(n - this.left) / (double)this.plotw;
        double d2 = (double)(n2 - this.top) / (double)this.ploth;
        if (this.projection.chosen.equals("polar")) {
            int n5 = d > 0.5 ? -1 : 1;
            d = 4.0 * (d > 0.5 ? d - 0.75 : d - 0.25);
            d2 = 2.0 * (d2 - 0.5);
            n4 = (int)(90.0 * (double)n5 * (1.0 - Math.pow(d2 * d2 + d * d, 0.5)));
            n3 = this.wrap(-this.sl + (int)((double)(d * (double)n5 < 0.0 ? 360 : 180) - (double)n5 * Math.atan(d2 / d) * 180.0 / Math.PI));
        } else {
            int n6 = n4 = this.projection.chosen.equals("coslat") || this.projection.chosen.equals("grid") ? 90 - (int)(180.0 * d2) : n2;
            n3 = this.projection.chosen.equals("coslat") ? this.wrap((int)((d - 0.5) * 360.0 / Math.cos(Math.PI * (double)n4 / 180.0)) + 360 - this.sl) : (this.projection.chosen.equals("grid") ? this.wrap((int)(360.0 * d + 180.0 - (double)this.sl)) : n);
        }
        return new Point(n3, n4);
    }

    public Polygon translate(Polygon polygon) {
        Polygon polygon2 = new Polygon();
        int n = 0;
        while (n < polygon.npoints) {
            if (n == 0 || this.notwrap(polygon.xpoints[n], polygon.ypoints[n], polygon.xpoints[0], polygon.ypoints[0])) {
                Point point = this.translate(polygon.xpoints[n], polygon.ypoints[n]);
                polygon2.addPoint(point.x, point.y);
            }
            ++n;
        }
        return polygon2;
    }

    void findpos(int n, int n2) {
        Point point = this.translateback(n, n2);
        this.mx = point.x;
        this.my = point.y;
        this.insidereg = this.findreg(n, n2);
        this.inside = this.my < 90.0 && this.my > -90.0 && this.mx < 180.0 && this.mx > -180.0;
    }

    public void writepos() {
        this.writelatlon();
        this.writereg();
    }

    public void writelatlon() {
        this.drawString((int)Math.abs(this.my) + (this.my > 0.0 ? " N" : " S") + "   ", 4, this.panh - 32);
        this.drawString((int)Math.abs(this.mx) + (this.mx > 0.0 ? " E" : " W") + "   ", 4, this.panh - 16);
    }

    public void writereg() {
        if (this.insidereg != null) {
            this.drawString(this.insidereg.code + "   ", this.panw - 40, this.panh - 16);
        } else {
            this.drawString("        ", this.panw - 40, this.panh - 16);
        }
    }
}

