/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import jcm.iob;
import jcm.loop;
import jcm.mod.modlist;
import jcm.mod.module;
import jcm.mod.time;
import jcm.param;

public class carboncycle
extends module {
    public iob carbonsetup = new iob("carbonsetup", this);
    String[] chemoptions = new String[]{"realb", "realj", "hildaz0z1", "cubicfit", "linear"};
    public param beta = new param("fertbeta", "", 0.287, 0.0, 0.6);
    public param sidemix = new param("csidemix", "", 0.0018587360594795538, 0.0, 0.005);
    public param upwell = new param("cupwell", "m&per&yr", 0.44, 0.0, 1.0);
    public param hlmix = new param("chighlat", "m&per&yr", 38.0, 0.0, 70.0);
    public param diffufac = new param("ceddydiff", "", 1.0, 0.0, 2.0);
    public param gasex = new param("asgasex", "mol&per&m2&per&ppm&per&yr", 0.06, 0.0, 0.12);
    public param chemfeedback = new param("chemfbopt", true);
    public param carbchem = new param("carbchemmenu", this.chemoptions, "realj");
    public param histdeforbymassbal = new param("hdmbopt", false);
    public param fbchfut = new param("fbchfut", false);
    public param viewbox = new param("depth", false);
    public param landuseemit = new param("lucfemit1990", "mega&ton&carbon&per&yr", 1600.0, 0.0, 3000.0);
    public param respq10 = new param("resp_q10", "", 1.0, 0.5, 2.5);
    public boolean usehisttempdata = false;
    public int ncl = 34;
    public int ncb = this.ncl + 4 + 5;
    public float[] fossil = modlist.time.fyd();
    public float[] totemit = modlist.time.fyd();
    public float[] lucf = modlist.time.fyd();
    public float[] origlucf = modlist.time.fyd();
    public float[] ocsink = modlist.time.fyd();
    public float[] tbsink = modlist.time.fyd();
    public float[] totsink = modlist.time.fyd();
    public float[] atppm = modlist.time.fyd();
    public float[] atppmdata = new float[time.hiss1];
    public float[][] cq = new float[this.ncb][time.glos2];
    public double error;
    int steps;
    double dt;
    Matrix MV;
    double[] cpropf = this.cbox();
    double[] ciq = this.cbox();
    double[] ciqi = this.cbox();
    double[] ciq99 = this.cbox();
    double[] crBIO = this.cbox();
    double[] crOC = this.cbox();
    double[] crAT = this.cbox();
    double[] crLS = this.cbox();
    double[] crHS = this.cbox();
    double[] scicAT = this.cbox();
    double[] scicLS = this.cbox();
    double[] scicHS = this.cbox();
    double[] scicNP = this.cbox();
    double[] rcicAT = this.cbox();
    double[] rcicLS = this.cbox();
    double[] rcicHS = this.cbox();
    double[] rcicNP = this.cbox();
    double[] crSO = this.cbox();
    double[] scicSO = this.cbox();
    double[] rcicSO = this.cbox();
    double[] crHU = this.cbox();
    double[] scicHU = this.cbox();
    double[] rcicHU = this.cbox();
    double oceantemprise;
    double oldtotemit;
    double oldatinc;
    double atinc;
    double oldlsinc;
    double lsinc;
    double oldhsinc;
    double hsinc;
    double oldnpinc;
    double npinc;
    double at;
    double ls;
    double hs;
    double oldls;
    double oldhs;
    double tb;
    double oldtb;
    double oc;
    double oldoc;
    double dat;
    double dls;
    double dhs;
    double dnp;
    double atinc99;
    double lsinc99;
    double hsinc99;
    double npinc99;
    double totemit99;
    double dls99;
    double dhs99;
    double dnp99;
    int i;
    int j;
    int n;
    int o;
    int b;
    int ns;
    int nr;
    int year;
    int tstep;
    double guess;
    double nit;
    double ncit;
    double oldnit = 1.0;
    double ciqr;
    double diff;
    double wit;
    double check;
    String err = "";
    double landtemprise;
    double soinc;
    double huinc;
    double oldsoinc;
    double soinc99;
    double huinc99;
    double oldhuinc;
    double so;
    double hu;
    double oldso;
    double oldhu;
    double dso;
    double dhu;
    double dso99;
    double dhu99;
    double ppmpmtc = 4.71E-4;
    double atppmprein;
    double atppmy = this.atppmprein = 280.0;
    double ocdepth = 3725.0;
    double ocarea = 3.616E14;
    double askodml;
    double talk;
    double totb;
    double betab;
    double[] octemp;
    double[] saflin;
    double[] saflin0;
    double[] alpha;
    double[] gamma;
    double[] cubfitf;
    double[] oafdml;
    double[] askoaf;
    double[] totc0;
    double[] calk;
    double[] hyd;
    double[] k1;
    double[] k2;
    double[] kb;
    double[] kw;
    double[] k0;
    double nplin;

    public void setinteractions() {
        this.setaffectedby(modlist.loaddata);
        this.setaffectedby(modlist.sres, modlist.mitigation.scenario.chosen == "nopolicy");
        this.setaffectedby(modlist.mitigation, modlist.mitigation.scenario.chosen != "nopolicy");
        this.setaffectedby(modlist.heatflux, this.chemfeedback.istrue());
        this.setaffectedby(this.carbonsetup);
        this.carbonsetup.setaffectedby(this.beta);
        this.carbonsetup.setaffectedby(this.sidemix);
        this.carbonsetup.setaffectedby(this.upwell);
        this.carbonsetup.setaffectedby(this.hlmix);
        this.carbonsetup.setaffectedby(this.diffufac);
        this.carbonsetup.setaffectedby(this.gasex);
        this.carbonsetup.setaffectedby(this.chemfeedback);
        this.carbonsetup.setaffectedby(this.carbchem);
        this.carbonsetup.setaffectedby(this.viewbox);
    }

    public void precalc(iob iob2) {
        if (iob2 == this.carbonsetup) {
            this.setupfluxes();
        }
        if (iob2 == this.histdeforbymassbal && !this.histdeforbymassbal.flag) {
            int n = 0;
            while (n < 251) {
                this.lucf[n] = this.origlucf[n];
                ++n;
            }
        }
        if (iob2 == this.landuseemit) {
            this.scalelanduse();
        }
    }

    void scalelanduse() {
        int n = 0;
        while (n < 241) {
            this.lucf[n] = this.origlucf[n] * ((float)this.landuseemit.getval() / this.origlucf[240]);
            ++n;
        }
        int n2 = 241;
        while (n2 < 251) {
            this.lucf[n2] = (float)(this.landuseemit.getval() * (double)(250 - n2) + (double)(1070.0f * (float)(n2 - 240))) / 10.0f;
            ++n2;
        }
    }

    double[] cbox() {
        return new double[this.ncb];
    }

    public void calcstep(int n) {
        if (this.histdeforbymassbal.istrue()) {
            if (n < time.fsy - time.gsy && n > 5) {
                this.totemit[n] = modlist.mitigation.inverseco2(n, this.atppmdata[n]);
                this.lucf[n] = (float)((4.0 * (double)this.lucf[n - 1] + (double)(this.totemit[n] - this.fossil[n])) / 5.0);
            }
        }
        this.totemit[n] = this.fossil[n] + this.lucf[n];
        if (this.usehisttempdata && n < 252) {
            float f = 0.0f;
            int n2 = 98;
            while (n2 < 103) {
                f += modlist.heatflux.proxytemp[n2] / 5.0f;
                ++n2;
            }
            float f2 = (n < 110 ? modlist.heatflux.proxytemp[n] : modlist.heatflux.tempdata[n]) - f;
            this.oceantemprise = (double)f2 * 0.847;
            this.landtemprise = (double)f2 * 1.356;
        } else {
            double d = n > 0 ? (double)(modlist.heatflux.boxtemp[1][n - 1] + modlist.heatflux.boxtemp[2][n - 1] + (loop.calcfutureonly && n <= 250 ? modlist.heatflux.boxoffset[1] + modlist.heatflux.boxoffset[2] : 0.0f)) / 2.0 : (this.oceantemprise = 0.0);
            double d2 = n > 0 ? (double)(modlist.heatflux.boxtemp[0][n - 1] + modlist.heatflux.boxtemp[3][n - 1] + (loop.calcfutureonly && n <= 250 ? modlist.heatflux.boxoffset[0] + modlist.heatflux.boxoffset[3] : 0.0f)) / 2.0 : (this.landtemprise = 0.0);
        }
        if (this.chemfeedback.istrue()) {
            this.chemconsts(this.octemp[0] + this.oceantemprise, 0);
            this.chemconsts(this.octemp[1] + this.oceantemprise, 1);
        }
        int n3 = 0;
        while (n3 < this.steps) {
            this.n = 0;
            while (this.n < this.ncb) {
                this.ciq[this.n] = this.cpropf[this.n] * this.ciq[this.n] + this.scicAT[this.n] * this.atinc + this.scicLS[this.n] * this.lsinc + this.scicHS[this.n] * this.hsinc + this.scicNP[this.n] * this.npinc + this.scicSO[this.n] * this.soinc + this.scicHU[this.n] * this.huinc;
                ++this.n;
            }
            this.oldls = this.ls;
            this.oldhs = this.hs;
            this.oldso = this.so;
            this.oldhu = this.hu;
            this.nit = 0.0;
            do {
                this.dat = (double)this.totemit[n] - this.oldtotemit - (this.dls + this.dhs + this.dnp + this.dso + this.dhu);
                this.wit = this.nit == 0.0 ? 1.0 : 0.3;
                this.at = 0.0;
                this.ls = 0.0;
                this.hs = 0.0;
                this.so = 0.0;
                this.hu = 0.0;
                this.n = 0;
                while (this.n < this.ncb) {
                    this.ciqr = this.rcicAT[this.n] * this.dat + this.rcicLS[this.n] * this.dls + this.rcicHS[this.n] * this.dhs + this.rcicNP[this.n] * this.dnp + this.rcicSO[this.n] * this.dso + this.rcicHU[this.n] * this.dhu;
                    this.ciqi[this.n] = this.wit * (this.ciq[this.n] + this.ciqr) + (1.0 - this.wit) * this.ciqi[this.n];
                    this.at += this.crAT[this.n] * this.ciqi[this.n];
                    this.ls += this.crLS[this.n] * this.ciqi[this.n];
                    this.hs += this.crHS[this.n] * this.ciqi[this.n];
                    this.so += this.crSO[this.n] * this.ciqi[this.n];
                    this.hu += this.crHU[this.n] * this.ciqi[this.n];
                    ++this.n;
                }
                this.lsinc = -this.safnonlin(this.ls, 0);
                this.hsinc = -this.safnonlin(this.hs, 1);
                this.betab = this.fbchfut.istrue() && n < 250 ? this.beta.getdef() : this.beta.getval();
                this.npinc = 60000.0 * this.betab * Math.log(this.at * this.ppmpmtc / this.atppmprein + 1.0) - this.at * this.nplin;
                this.soinc = (this.so * 0.375 + 45000.0) * (1.0 - Math.pow(this.respq10.getval(), this.landtemprise / 10.0));
                this.huinc = (this.hu * 0.01 + 15000.0) * (1.0 - Math.pow(this.respq10.getval(), this.landtemprise / 10.0));
                this.atinc = (double)this.totemit[n] - (this.lsinc + this.hsinc + this.npinc + this.soinc + this.huinc);
                this.guess = this.dls + this.dhs + this.dnp + this.dso + this.dhu;
                this.dls = this.lsinc - this.oldlsinc;
                this.dhs = this.hsinc - this.oldhsinc;
                this.dnp = this.npinc - this.oldnpinc;
                this.dso = this.soinc - this.oldsoinc;
                this.dhu = this.huinc - this.oldhuinc;
                this.check = this.dls + this.dhs + this.dnp + this.dso + this.dhu;
                this.nit += 1.0;
            } while (Math.abs(this.guess - this.check) > 10.0 && this.nit < 10.0);
            this.n = 0;
            while (this.n < this.ncb) {
                this.ciq[this.n] = this.ciqi[this.n];
                ++this.n;
            }
            this.oldatinc = this.atinc;
            this.oldlsinc = this.lsinc;
            this.oldhsinc = this.hsinc;
            this.oldnpinc = this.npinc;
            this.oldsoinc = this.soinc;
            this.oldhuinc = this.huinc;
            this.oldtotemit = this.totemit[n];
            ++n3;
        }
        this.oldtb = this.tb;
        this.tb = 0.0;
        this.oldoc = this.oc;
        this.oc = 0.0;
        this.n = 0;
        while (this.n < this.ncb) {
            this.tb += this.ciq[this.n] * this.crBIO[this.n];
            this.oc += this.ciq[this.n] * this.crOC[this.n];
            ++this.n;
        }
        this.atppmy = this.atppmprein + this.ppmpmtc * this.at;
        if (n >= 0) {
            this.tbsink[n] = (short)(this.tb - this.oldtb);
            this.ocsink[n] = (short)(this.oc - this.oldoc);
            this.atppm[n] = (float)this.atppmy;
        }
        this.totsink[n] = this.ocsink[n] + this.tbsink[n];
        if (this.viewbox.needed) {
            this.n = 0;
            while (this.n < this.ncb) {
                this.cq[this.n][n] = 0.0f;
                int n4 = 0;
                while (n4 < this.ncb) {
                    float[] fArray = this.cq[this.n];
                    int n5 = n;
                    fArray[n5] = (float)((double)fArray[n5] + this.MV.getArray()[this.n][n4] * this.ciq[n4]);
                    ++n4;
                }
                ++this.n;
            }
        }
    }

    public void postcalc() {
        this.calcerror();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void calcerror() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n = 0;
        while (n < time.hiss1) {
            float f5 = this.atppm[n];
            float f6 = this.atppmdata[n];
            float f7 = n > 200 ? 0.1f : 0.5f;
            f += (f5 - f6) * (f5 - f6) / f7;
            f3 += f5 / f7;
            f2 += f6 / f7;
            f4 += 1.0f / f7;
            ++n;
        }
        this.error = Math.pow(f / f4 - (f3 / f4 - f2 / f4) * (f3 / f4 - f2 / f4), 0.5);
    }

    public void save99() {
        this.atinc99 = this.atinc;
        this.lsinc99 = this.lsinc;
        this.hsinc99 = this.hsinc;
        this.npinc99 = this.npinc;
        this.soinc99 = this.soinc;
        this.huinc99 = this.huinc;
        this.dso99 = this.dso;
        this.dhu99 = this.dhu;
        this.totemit99 = this.totemit[1999 - time.gsy];
        this.dls99 = this.dls;
        this.dhs99 = this.dhs;
        this.dnp99 = this.dnp;
        this.n = 0;
        while (this.n < this.ncb) {
            this.ciq99[this.n] = this.ciq[this.n];
            ++this.n;
        }
    }

    public void startstate(int n) {
        this.at = 0.0;
        this.ls = 0.0;
        this.hs = 0.0;
        this.oldls = 0.0;
        this.oldhs = 0.0;
        this.oc = 0.0;
        this.tb = 0.0;
        this.so = 0.0;
        this.hu = 0.0;
        if (n == 1750) {
            this.n = 0;
            while (this.n < this.ncb) {
                this.ciq[this.n] = 0.0;
                ++this.n;
            }
            this.atinc = 0.0;
            this.lsinc = 0.0;
            this.hsinc = 0.0;
            this.npinc = 0.0;
            this.oldtotemit = 0.0;
            this.dls = 0.0;
            this.dhs = 0.0;
            this.dnp = 0.0;
            this.soinc = 0.0;
            this.huinc = 0.0;
            this.dso = 0.0;
            this.dhu = 0.0;
        } else {
            this.n = 0;
            while (this.n < this.ncb) {
                this.ciq[this.n] = this.ciq99[this.n];
                ++this.n;
            }
            this.atinc = this.atinc99;
            this.lsinc = this.lsinc99;
            this.hsinc = this.hsinc99;
            this.npinc = this.npinc99;
            this.oldtotemit = this.totemit99;
            this.dls = this.dls99;
            this.dhs = this.dhs99;
            this.dnp = this.dnp99;
            this.soinc = this.soinc99;
            this.huinc = this.huinc99;
            this.dso = this.dso99;
            this.dhu = this.dhu99;
        }
        this.oldatinc = this.atinc;
        this.oldlsinc = this.lsinc;
        this.oldhsinc = this.hsinc;
        this.oldnpinc = this.npinc;
        this.oldsoinc = this.soinc;
        this.oldhuinc = this.huinc;
        this.n = 0;
        while (this.n < this.ncb) {
            this.ciqi[this.n] = this.ciq[this.n];
            ++this.n;
        }
        this.tb = 0.0;
        this.oc = 0.0;
        this.n = 0;
        while (this.n < this.ncb) {
            this.tb += this.ciq[this.n] * this.crBIO[this.n];
            this.oc += this.ciq[this.n] * this.crOC[this.n];
            ++this.n;
        }
    }

    public void setupfluxes() {
        double d;
        double d2;
        double d3;
        this.steps = 1;
        this.dt = 1.0 / (double)this.steps;
        this.nplin = 60000.0 * this.beta.getval() * this.ppmpmtc / this.atppmprein;
        double d4 = 75.0;
        double d5 = 0.0;
        double d6 = 0.16;
        double d7 = (1.0 - d6) / d6;
        double[] dArray = new double[this.ncl];
        double[] dArray2 = new double[this.ncl];
        double d8 = this.upwell.getval();
        double d9 = this.hlmix.getval();
        double d10 = this.sidemix.getval();
        this.n = 0;
        while (this.n < this.ncl) {
            double d11 = dArray[this.n] = this.n < 20 ? 49.0 : 196.0;
            if (this.n > 0) {
                d5 += dArray[this.n];
            }
            dArray2[this.n] = this.diffufac.getval() * (465.0 + 7096.0 * Math.exp(-d5 / 253.0));
            ++this.n;
        }
        double d12 = this.gasex.getval();
        this.askodml = 1000.0 * d12 / d4;
        this.oafdml = new double[2];
        this.oafdml[0] = 1.0E15 / (12.0 * this.ocarea * (1.0 - d6) * d4);
        this.oafdml[1] = 1.0E15 / (12.0 * this.ocarea * d6 * d4);
        this.askoaf = new double[2];
        this.askoaf[0] = 1.2E-11 * d12 * this.ocarea * (1.0 - d6);
        this.askoaf[1] = 1.2E-11 * d12 * this.ocarea * d6;
        this.alpha = new double[2];
        this.alpha[0] = this.ppmpmtc * this.askoaf[0];
        this.alpha[1] = this.ppmpmtc * this.askoaf[1];
        this.hyd = new double[2];
        this.hyd[0] = 1.0E-8;
        this.hyd[1] = 1.0E-8;
        this.calk = new double[2];
        this.calk[0] = this.talk - 0.001;
        this.calk[1] = this.talk - 0.001;
        this.saflin = new double[2];
        this.saflin0 = new double[2];
        this.gamma = new double[2];
        this.cubfitf = new double[2];
        this.k0 = new double[2];
        this.k1 = new double[2];
        this.k2 = new double[2];
        this.kb = new double[2];
        this.kw = new double[2];
        this.octemp = new double[2];
        this.octemp[0] = 21.37;
        this.octemp[1] = 1.38;
        this.talk = 0.0024;
        this.totb = 4.16E-4;
        this.totc0 = new double[2];
        this.totc0[0] = this.totc0(this.octemp[0]);
        this.totc0[1] = this.totc0(this.octemp[1]);
        this.saflin[0] = this.saflin(this.octemp[0]);
        this.saflin[1] = this.saflin(this.octemp[1]);
        this.saflin0[0] = this.saflin[0];
        this.saflin0[1] = this.saflin[1];
        if (this.carbchem.chosen == "realb" || this.carbchem.chosen == "realj") {
            this.saflin[0] = this.saflin[0] * 2.0;
            this.saflin[1] = this.saflin[1] * 2.0;
        }
        this.chemconsts(this.octemp[0], 0);
        this.chemconsts(this.octemp[1], 1);
        double[][] dArray3 = new double[this.ncb][this.ncb];
        this.i = 0;
        while (this.i < this.ncb) {
            this.j = 0;
            while (this.j < this.ncb) {
                dArray3[this.i][this.j] = 0.0;
                ++this.j;
            }
            ++this.i;
        }
        this.n = 1;
        while (this.n < this.ncl) {
            d3 = (2.0 * dArray2[this.n] - d8 * dArray[this.n]) / (dArray[this.n - 1] * (dArray[this.n - 1] + dArray[this.n]));
            d2 = (2.0 * dArray2[this.n] + d8 * dArray[this.n - 1]) / (dArray[this.n] * (dArray[this.n - 1] + dArray[this.n]));
            d = d10 * d7 * dArray[this.n] / this.ocdepth;
            double[] dArray4 = dArray3[this.n];
            int n = this.n - 1;
            dArray4[n] = dArray4[n] + d3;
            double[] dArray5 = dArray3[this.n - 1];
            int n2 = this.n - 1;
            dArray5[n2] = dArray5[n2] - d3;
            double[] dArray6 = dArray3[this.n - 1];
            int n3 = this.n;
            dArray6[n3] = dArray6[n3] + d2;
            double[] dArray7 = dArray3[this.n];
            int n4 = this.n;
            dArray7[n4] = dArray7[n4] - d2;
            double[] dArray8 = dArray3[this.n];
            int n5 = this.ncl + 2;
            dArray8[n5] = dArray8[n5] + d;
            double[] dArray9 = dArray3[this.ncl + 2];
            int n6 = this.ncl + 2;
            dArray9[n6] = dArray9[n6] - d;
            double[] dArray10 = dArray3[this.ncl + 2];
            int n7 = this.n;
            dArray10[n7] = dArray10[n7] + d10;
            double[] dArray11 = dArray3[this.n];
            int n8 = this.n++;
            dArray11[n8] = dArray11[n8] - d10;
        }
        d3 = 8.0 * dArray2[0] / (3.0 * dArray[0] * d4) - d8 / d4;
        d2 = 3.0 * dArray2[0] / (dArray[0] * dArray[0]);
        double d13 = dArray2[0] / (3.0 * dArray[0] * dArray[0]);
        double[] dArray12 = dArray3[0];
        int n = this.ncl;
        dArray12[n] = dArray12[n] + d3;
        double[] dArray13 = dArray3[this.ncl];
        int n9 = this.ncl;
        dArray13[n9] = dArray13[n9] - d3;
        double[] dArray14 = dArray3[this.ncl];
        dArray14[0] = dArray14[0] + d2;
        double[] dArray15 = dArray3[0];
        dArray15[0] = dArray15[0] - d2;
        double[] dArray16 = dArray3[0];
        dArray16[1] = dArray16[1] + d13;
        double[] dArray17 = dArray3[this.ncl];
        dArray17[1] = dArray17[1] - d13;
        d = d10 * d7 * dArray[0] / this.ocdepth;
        double[] dArray18 = dArray3[0];
        int n10 = this.ncl + 2;
        dArray18[n10] = dArray18[n10] + d;
        double[] dArray19 = dArray3[this.ncl + 2];
        int n11 = this.ncl + 2;
        dArray19[n11] = dArray19[n11] - d;
        double[] dArray20 = dArray3[this.ncl + 2];
        dArray20[0] = dArray20[0] + d10;
        double[] dArray21 = dArray3[0];
        dArray21[0] = dArray21[0] - d10;
        double[] dArray22 = dArray3[this.ncl];
        int n12 = this.ncl + 1;
        dArray22[n12] = dArray22[n12] + d10 * d7 * d4 / this.ocdepth;
        double[] dArray23 = dArray3[this.ncl + 1];
        int n13 = this.ncl + 1;
        dArray23[n13] = dArray23[n13] - d10 * d7 * d4 / this.ocdepth;
        double[] dArray24 = dArray3[this.ncl + 1];
        int n14 = this.ncl;
        dArray24[n14] = dArray24[n14] + (d10 + d8 / d4);
        double[] dArray25 = dArray3[this.ncl];
        int n15 = this.ncl;
        dArray25[n15] = dArray25[n15] - (d10 + d8 / d4);
        double[] dArray26 = dArray3[this.ncl - 1];
        int n16 = this.ncl + 2;
        dArray26[n16] = dArray26[n16] + d8 * d7 / this.ocdepth;
        double[] dArray27 = dArray3[this.ncl + 2];
        int n17 = this.ncl + 2;
        dArray27[n17] = dArray27[n17] - d8 * d7 / this.ocdepth;
        double[] dArray28 = dArray3[this.ncl + 1];
        int n18 = this.ncl + 2;
        dArray28[n18] = dArray28[n18] + d9 / this.ocdepth;
        double[] dArray29 = dArray3[this.ncl + 2];
        int n19 = this.ncl + 2;
        dArray29[n19] = dArray29[n19] - d9 / this.ocdepth;
        double[] dArray30 = dArray3[this.ncl + 2];
        int n20 = this.ncl + 1;
        dArray30[n20] = dArray30[n20] + (d9 + d8 / d7) / d4;
        double[] dArray31 = dArray3[this.ncl + 1];
        int n21 = this.ncl + 1;
        dArray31[n21] = dArray31[n21] - (d9 + d8 / d7) / d4;
        double[] dArray32 = dArray3[this.ncl + 3];
        int n22 = this.ncl;
        dArray32[n22] = dArray32[n22] + this.saflin[0];
        double[] dArray33 = dArray3[this.ncl];
        int n23 = this.ncl;
        dArray33[n23] = dArray33[n23] - this.saflin[0];
        double[] dArray34 = dArray3[this.ncl + 3];
        int n24 = this.ncl + 1;
        dArray34[n24] = dArray34[n24] + this.saflin[1];
        double[] dArray35 = dArray3[this.ncl + 1];
        int n25 = this.ncl + 1;
        dArray35[n25] = dArray35[n25] - this.saflin[1];
        double[] dArray36 = dArray3[this.ncl];
        int n26 = this.ncl + 3;
        dArray36[n26] = dArray36[n26] + this.alpha[0];
        double[] dArray37 = dArray3[this.ncl + 3];
        int n27 = this.ncl + 3;
        dArray37[n27] = dArray37[n27] - this.alpha[0];
        double[] dArray38 = dArray3[this.ncl + 1];
        int n28 = this.ncl + 3;
        dArray38[n28] = dArray38[n28] + this.alpha[1];
        double[] dArray39 = dArray3[this.ncl + 3];
        int n29 = this.ncl + 3;
        dArray39[n29] = dArray39[n29] - this.alpha[1];
        double[] dArray40 = dArray3[this.ncl + 7];
        int n30 = this.ncl + 5;
        dArray40[n30] = dArray40[n30] + 0.01;
        double[] dArray41 = dArray3[this.ncl + 5];
        int n31 = this.ncl + 5;
        dArray41[n31] = dArray41[n31] - 0.01;
        double[] dArray42 = dArray3[this.ncl + 7];
        int n32 = this.ncl + 6;
        dArray42[n32] = dArray42[n32] + 0.08333;
        double[] dArray43 = dArray3[this.ncl + 6];
        int n33 = this.ncl + 6;
        dArray43[n33] = dArray43[n33] - 0.08333;
        double[] dArray44 = dArray3[this.ncl + 6];
        int n34 = this.ncl + 5;
        dArray44[n34] = dArray44[n34] + 0.04;
        double[] dArray45 = dArray3[this.ncl + 5];
        int n35 = this.ncl + 5;
        dArray45[n35] = dArray45[n35] - 0.04;
        double[] dArray46 = dArray3[this.ncl + 6];
        int n36 = this.ncl + 4;
        dArray46[n36] = dArray46[n36] + 0.35;
        double[] dArray47 = dArray3[this.ncl + 4];
        int n37 = this.ncl + 4;
        dArray47[n37] = dArray47[n37] - 0.35;
        double[] dArray48 = dArray3[this.ncl + 5];
        int n38 = this.ncl + 8;
        dArray48[n38] = dArray48[n38] + 0.41667;
        double[] dArray49 = dArray3[this.ncl + 8];
        int n39 = this.ncl + 8;
        dArray49[n39] = dArray49[n39] - 0.41667;
        double[] dArray50 = dArray3[this.ncl + 4];
        int n40 = this.ncl + 8;
        dArray50[n40] = dArray50[n40] + 0.58333;
        double[] dArray51 = dArray3[this.ncl + 8];
        int n41 = this.ncl + 8;
        dArray51[n41] = dArray51[n41] - 0.58333;
        double[] dArray52 = dArray3[this.ncl + 3];
        int n42 = this.ncl + 6;
        dArray52[n42] = dArray52[n42] + 0.375;
        double[] dArray53 = dArray3[this.ncl + 6];
        int n43 = this.ncl + 6;
        dArray53[n43] = dArray53[n43] - 0.375;
        double[] dArray54 = dArray3[this.ncl + 3];
        int n44 = this.ncl + 7;
        dArray54[n44] = dArray54[n44] + 0.01;
        double[] dArray55 = dArray3[this.ncl + 7];
        int n45 = this.ncl + 7;
        dArray55[n45] = dArray55[n45] - 0.01;
        double[] dArray56 = dArray3[this.ncl + 8];
        int n46 = this.ncl + 3;
        dArray56[n46] = dArray56[n46] + this.nplin;
        double[] dArray57 = dArray3[this.ncl + 3];
        int n47 = this.ncl + 3;
        dArray57[n47] = dArray57[n47] - this.nplin;
        double[] dArray58 = this.cbox();
        double[] dArray59 = this.cbox();
        double[] dArray60 = this.cbox();
        double[] dArray61 = this.cbox();
        double[] dArray62 = this.cbox();
        double[] dArray63 = this.cbox();
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(new Matrix(dArray3, this.ncb, this.ncb));
        this.MV = eigenvalueDecomposition.getV();
        Matrix matrix = this.MV.inverse().transpose();
        this.crLS = this.MV.getArray()[this.ncl];
        this.crHS = this.MV.getArray()[this.ncl + 1];
        this.crAT = this.MV.getArray()[this.ncl + 3];
        this.crSO = this.MV.getArray()[this.ncl + 6];
        this.crHU = this.MV.getArray()[this.ncl + 7];
        this.crBIO = new double[this.ncb];
        this.crOC = new double[this.ncb];
        this.n = 0;
        while (this.n < this.ncb) {
            this.crBIO[this.n] = 0.0;
            this.i = 0;
            while (this.i < 5) {
                int n48 = this.n;
                this.crBIO[n48] = this.crBIO[n48] + this.MV.getArray()[this.ncl + 4 + this.i][this.n];
                ++this.i;
            }
            this.crOC[this.n] = 0.0;
            this.i = 0;
            while (this.i < this.ncl + 3) {
                int n49 = this.n;
                this.crOC[n49] = this.crOC[n49] + this.MV.getArray()[this.i][this.n];
                ++this.i;
            }
            ++this.n;
        }
        dArray59 = matrix.getArray()[this.ncl];
        dArray60 = matrix.getArray()[this.ncl + 1];
        dArray58 = matrix.getArray()[this.ncl + 3];
        dArray61 = matrix.getArray()[this.ncl + 8];
        dArray62 = matrix.getArray()[this.ncl + 6];
        dArray63 = matrix.getArray()[this.ncl + 7];
        double[] dArray64 = eigenvalueDecomposition.getRealEigenvalues();
        this.n = 0;
        while (this.n < this.ncb) {
            double d14;
            double d15;
            this.cpropf[this.n] = Math.exp(dArray64[this.n] * this.dt);
            if (Math.abs(dArray64[this.n]) < 1.0E-6) {
                d15 = this.dt;
                d14 = this.dt / 2.0;
            } else {
                d15 = (this.cpropf[this.n] - 1.0) / dArray64[this.n];
                d14 = (d15 - this.dt) / (dArray64[this.n] * this.dt);
            }
            String string = "ok here " + this.n;
            this.scicLS[this.n] = d15 * dArray59[this.n];
            this.scicHS[this.n] = d15 * dArray60[this.n];
            this.scicAT[this.n] = d15 * dArray58[this.n];
            this.scicNP[this.n] = d15 * dArray61[this.n];
            this.rcicLS[this.n] = d14 * dArray59[this.n];
            this.rcicHS[this.n] = d14 * dArray60[this.n];
            this.rcicAT[this.n] = d14 * dArray58[this.n];
            this.rcicNP[this.n] = d14 * dArray61[this.n];
            this.scicSO[this.n] = d15 * dArray62[this.n];
            this.scicHU[this.n] = d15 * dArray63[this.n];
            this.rcicSO[this.n] = d14 * dArray62[this.n];
            this.rcicHU[this.n] = d14 * dArray63[this.n];
            ++this.n;
        }
        if (!this.viewbox.needed) {
            this.MV = null;
        }
        eigenvalueDecomposition = null;
        matrix = null;
        dArray64 = null;
        dArray3 = null;
    }

    double z0(double d) {
        return 1.7561 - 0.031618 * d + 4.444E-4 * d * d;
    }

    double z1(double d) {
        return 0.004096 - 7.7086E-5 * d + 6.1E-7 * d * d;
    }

    double k0(double d) {
        return Math.exp(-60.2409 + 9345.17 / d + 23.3585 * Math.log(d / 100.0) + 35.0 * (0.023517 - 2.3656E-4 * d + 4.7036E-7 * d * d));
    }

    double kb(double d) {
        return Math.exp(-(28559.7 / d) + 1016.43 - 181.498 * Math.log(d) + 0.314173 * d);
    }

    double k1(double d) {
        return Math.exp(-(2331.08 / d) - 1.5529413 * Math.log(d) + 3.18181);
    }

    double k2(double d) {
        return Math.exp(-(3493.43 / d) - 0.2005743 * Math.log(d) - 7.69056);
    }

    double kw(double d) {
        return Math.exp(-(13145.2 / d) - 17.4432 * Math.log(d) + 113.0395);
    }

    double totc0(double d) {
        return 0.002225 - 9.5E-6 * d;
    }

    double saflin(double d) {
        return this.askodml * (1.68 - 0.036 * d + 6.0E-4 * d * d);
    }

    double cubfitf(double d) {
        return this.askodml * (80.0 - 3.5 * d + 0.05 * d * d) / 1000000.0;
    }

    void chemconsts(double d, int n) {
        if (this.carbchem.chosen == "hildaz0z1") {
            this.saflin[n] = this.z0(d) * this.askodml;
            this.gamma[n] = this.z1(d) * this.oafdml[n];
        }
        if (this.carbchem.chosen == "saflin") {
            this.saflin[n] = this.saflin(d);
        }
        if (this.carbchem.chosen == "cubicfit") {
            this.saflin[n] = this.saflin(d);
            this.cubfitf[n] = this.cubfitf(d) * this.oafdml[n] * this.oafdml[n];
        }
        if (this.carbchem.chosen == "realb" || this.carbchem.chosen == "realj") {
            double d2 = d + 273.15;
            this.k0[n] = this.k0(d2);
            this.k1[n] = this.k1(d2);
            this.k2[n] = this.k2(d2);
            this.kb[n] = this.kb(d2);
            this.kw[n] = this.kw(d2);
        }
    }

    double safnonlin(double d, int n) {
        if (this.carbchem.chosen == "hildaz0z1") {
            return this.saflin[n] * this.gamma[n] * d * d / (1.0 - this.gamma[n] * d) + (this.chemfeedback.istrue() ? d * (this.saflin[n] - this.saflin0[n]) : 0.0);
        }
        if (this.carbchem.chosen == "cubicfit") {
            return this.cubfitf[n] * d * d * d + (this.chemfeedback.istrue() ? d * (this.saflin[n] - this.saflin0[n]) : 0.0);
        }
        if (this.carbchem.chosen == "saflin" && this.chemfeedback.istrue()) {
            return d * (this.saflin[n] - this.saflin0[n]);
        }
        if (this.carbchem.chosen == "realb" || this.carbchem.chosen == "realj") {
            double d2;
            double d3 = this.totc0[n] + d * this.oafdml[n] / 1000000.0;
            this.ncit = 0.0;
            if (this.carbchem.chosen == "realb") {
                do {
                    this.ncit += 1.0;
                    d2 = this.hyd[n];
                    this.calk[n] = this.talk - this.totb * this.kb[n] / (this.hyd[n] + this.kb[n]) - this.kw[n] / this.hyd[n] + this.hyd[n];
                    double d4 = (d3 - this.calk[n]) * (d3 - this.calk[n]) - 4.0 * this.calk[n] * (this.calk[n] - 2.0 * d3) * this.k2[n] / this.k1[n];
                    this.hyd[n] = this.k1[n] / (2.0 * this.calk[n]) * (d3 - this.calk[n] + Math.pow(d4, 0.5));
                } while (Math.abs(1.0 - d2 / this.hyd[n]) > 1.0E-5 && this.ncit < 10.0);
            } else {
                d2 = 6.0;
                double d5 = -0.5;
                double d6 = 0.0;
                do {
                    this.ncit += 1.0;
                    this.hyd[n] = Math.pow(10.0, -d2);
                    double d7 = (this.k1[n] / this.hyd[n] + 2.0 * this.k1[n] * this.k2[n] / (this.hyd[n] * this.hyd[n])) / (1.0 + this.k1[n] / this.hyd[n] + this.k1[n] * this.k2[n] / (this.hyd[n] * this.hyd[n])) * d3;
                    double d8 = this.talk - d7 - this.kb[n] * this.totb / (this.hyd[n] + this.kb[n]) - this.kw[n] / this.hyd[n] + this.hyd[n];
                    d6 = d8;
                    d2 += (d5 *= d8 / (d6 - d8));
                } while (Math.abs(d5) > 1.0E-5 && this.ncit < 10.0);
            }
            d2 = d3 * (this.hyd[n] * this.hyd[n]) / (this.hyd[n] * this.hyd[n] + this.k1[n] * this.hyd[n] + this.k1[n] * this.k2[n]);
            return this.askoaf[n] * (1000000.0 * d2 / this.k0[n] - this.atppmprein) - this.saflin[n] * d;
        }
        return 0.0;
    }
}

