/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import jcm.iob;
import jcm.mod.modlist;
import jcm.mod.module;
import jcm.mod.time;
import jcm.param;

public class heatflux
extends module {
    public iob clifluxsetup = new iob("climatesetup", this);
    double[][] cmp = new double[][]{{3.71, 4.2, 8.0, 2.3, 1.2, 1.0, 1.0, 60.0, 0.2, 1.25}, {3.45, 3.7, 5.0, 1.6, 1.2, 1.0, 1.0, 60.0, 0.2, 1.25}, {3.74, 3.0, 25.0, 1.9, 1.4, 0.5, 0.5, 60.0, 0.2, 1.25}, {3.47, 2.5, 12.0, 1.7, 1.4, 0.5, 0.5, 60.0, 0.2, 1.25}, {3.8, 2.6, 20.0, 9.0, 1.4, 0.5, 0.5, 60.0, 0.2, 1.25}, {3.6, 1.9, 9999.0, 2.3, 1.4, 0.5, 0.5, 60.0, 0.2, 1.25}, {3.6, 1.7, 14.0, 2.3, 1.4, 0.5, 0.5, 60.0, 0.2, 1.25}, {4.37, 2.5, 7.0, 1.0, 1.3, 1.0, 1.0, 90.0, 0.2, 1.0}, {3.0, 1.5, 0.0, 0.05, 0.7, 0.0, 0.0, 1.0, 0.0, 0.8}, {5.0, 4.5, 30.0, 4.0, 1.5, 4.0, 2.0, 120.0, 1.0, 1.6}};
    int model = 2;
    String[] climodname = new String[]{"gfdl", "csiro", "hadcm3", "hadcm2", "echam4", "csm", "doe", "ipccsar"};
    public param climod = new param("climodmenu", this.climodname, "hadcm3");
    public param rfco2double = new param("rfco2d", "w&per&m2", this.cmp[this.model][0], this.cmp[8][0], this.cmp[9][0]);
    public param climsens = new param("climsens", "degc", this.cmp[this.model][1], this.cmp[8][1], this.cmp[9][1]);
    public param zeroupwelltemp = new param("tnoupwell", "degc", this.cmp[this.model][2], this.cmp[8][2], this.cmp[9][2]);
    public param heatdiffusivity = new param("teddydiff", "cm2&per&s", this.cmp[this.model][3], this.cmp[8][3], this.cmp[9][3]);
    public param landoceantempratio = new param("lotr", "", this.cmp[this.model][4], this.cmp[8][4], this.cmp[9][4]);
    public param knorthsouth = new param("kns", "", this.cmp[this.model][5], this.cmp[8][5], this.cmp[9][5]);
    public param klandocean = new param("klo", "", this.cmp[this.model][6], this.cmp[8][6], this.cmp[9][6]);
    public param mixlaydepth = new param("tmixlay", "metres", this.cmp[this.model][7], this.cmp[8][7], this.cmp[9][7]);
    public param polarsinktempratio = new param("psi", "", this.cmp[this.model][8], this.cmp[8][8], this.cmp[9][8]);
    public param seaice = new param("seaice", "", this.cmp[this.model][9], this.cmp[8][9], this.cmp[9][9]);
    public param varupwell = new param("tufbopt", true);
    public param upwellreducefrac = new param("uwredfrac", "", 0.3, 0.0, 1.0);
    public param upwellbaserate = new param("uwbaserate", "m&per&yr", 4.0, 0.0, 8.0);
    public param viewbox = new param("depth", false);
    public param baseyear = new param("baseyear", "", 1990.0, 1760.0, 1998.0);
    param[] climodparam = new param[]{this.rfco2double, this.climsens, this.zeroupwelltemp, this.heatdiffusivity, this.landoceantempratio, this.knorthsouth, this.klandocean, this.mixlaydepth, this.polarsinktempratio, this.seaice};
    public float[] glotemp = modlist.time.fyd();
    public float[] avtemp = modlist.time.fyd();
    public float[] tempdata = new float[time.hiss1 + 2];
    public float[] proxytemp = new float[time.hiss1 + 2];
    public float[] temptrend = new float[time.hiss1 + 2];
    public float[] sealevte = modlist.time.fyd();
    public float[][] boxtemp = new float[4][time.glos2];
    public int nhl = 34;
    public int nhb = this.nhl + 1;
    public float[][] hq = new float[2 * this.nhb][time.glos2];
    public double error = 0.0;
    double[][] hiq = this.hbox();
    double[][] hiqi = this.hbox();
    double[][] hiq99 = this.hbox();
    double[][] hpropf = this.hbox();
    double[][] hrML = this.hbox();
    double[][] shicML = this.hbox();
    double[][] rhicML = this.hbox();
    double[][] hrsl = this.hbox();
    double[] frac = new double[]{0.199, 0.301, 0.406, 0.094};
    double fracl = this.frac[0] + this.frac[3];
    double fraco = 1.0 - this.fracl;
    double[][] khi = new double[4][4];
    double[] khir = new double[4];
    double tstart = 18.17;
    double sealevteinit;
    double kls;
    double kos;
    double klo;
    double kns;
    double nstd;
    double nstdold;
    double dqin;
    double qpt;
    double sl;
    double cice;
    double[] qin = new double[2];
    double[] qinbase = new double[2];
    double[] qinold = new double[2];
    double[] qinold99 = new double[2];
    double[] mlt = new double[2];
    double[] spaceflux = new double[2];
    double totrf99;
    double nstd99;
    double nstdold99;
    double dt;
    double hu;
    double pi;
    double diffu;
    double dml;
    double rvu;
    double rv;
    double rjff;
    double polsink;
    double mlbaserate;
    double hiquc;
    double reftemp = 0.0;
    double[] dl;
    double[] vec;
    double[][] rate;
    double[][] hiqstart = new double[2][this.nhb];
    Matrix M;
    Matrix U;
    Matrix[] MV = new Matrix[2];
    Matrix[] MVI = new Matrix[2];
    double[][][] upwellstep = new double[2][this.nhb][this.nhb];
    int i;
    int j;
    int n;
    int m;
    int o;
    int b;
    int ns;
    int nr;
    int year;
    int startyear;
    int tstep;
    double guess;
    double nit;
    double ciqr;
    double diff;
    double offset = 0.0;
    double oldoffset = 1.0;
    float[] boxoffset = new float[4];

    public void setinteractions() {
        this.setaffectedby(modlist.loaddata);
        this.setaffectedby(modlist.radfor);
        this.setaffectedby(this.clifluxsetup);
        this.rfco2double.setaffects(modlist.radfor);
        int n = 0;
        while (n < this.climodparam.length) {
            this.climodparam[n].setaffectedby(this.climod);
            ++n;
        }
        this.clifluxsetup.setaffectedby(this.climod);
        this.clifluxsetup.setaffectedby(this.rfco2double);
        this.clifluxsetup.setaffectedby(this.climsens);
        this.clifluxsetup.setaffectedby(this.zeroupwelltemp);
        this.clifluxsetup.setaffectedby(this.heatdiffusivity);
        this.clifluxsetup.setaffectedby(this.mixlaydepth);
        this.clifluxsetup.setaffectedby(this.polarsinktempratio);
        this.clifluxsetup.setaffectedby(this.seaice);
        this.clifluxsetup.setaffectedby(this.landoceantempratio);
        this.clifluxsetup.setaffectedby(this.knorthsouth);
        this.clifluxsetup.setaffectedby(this.klandocean);
        this.clifluxsetup.setaffectedby(this.varupwell);
        this.clifluxsetup.setaffectedby(this.upwellreducefrac);
        this.clifluxsetup.setaffectedby(this.upwellbaserate);
    }

    void changeclimod(int n) {
        this.model = n;
        int n2 = 0;
        while (n2 < this.climodparam.length) {
            this.climodparam[n2].setval(this.cmp[n][n2]);
            ++n2;
        }
    }

    public void precalc(iob iob2) {
        if (iob2 == this.climod) {
            this.changeclimod(this.climod.getchosenindex());
        }
        if (iob2 == this.clifluxsetup) {
            this.setupfluxes();
        }
    }

    public void postcalc(iob iob2) {
        if (iob2 == this.baseyear) {
            this.histtemptrend();
        }
    }

    double[][] hbox() {
        return new double[2][this.nhb];
    }

    public void calcstep(int n) {
        double d;
        float[] fArray = modlist.radfor.splitrf[n];
        this.nstdold = this.nstd = (this.guess = this.nstd + (this.nstd - this.nstdold));
        this.o = 0;
        while (this.o < 2) {
            this.n = 0;
            while (this.n < this.nhb) {
                this.hiq[this.o][this.n] = this.hpropf[this.o][this.n] * this.hiq[this.o][this.n] + this.shicML[this.o][this.n] * this.qinold[this.o];
                ++this.n;
            }
            this.qinbase[this.o] = fArray[this.o + 1];
            int n2 = this.o;
            this.qinbase[n2] = this.qinbase[n2] + (double)fArray[this.o * 3] * (this.frac[this.o * 3] / this.frac[this.o + 1]) * this.klo / (this.kls * this.frac[this.o * 3] + this.klo);
            int n3 = this.o;
            this.qinbase[n3] = this.qinbase[n3] + this.spaceflux[this.o] * this.qpt * this.tstart;
            ++this.o;
        }
        this.nit = 0.0;
        do {
            this.o = 0;
            while (this.o < 2) {
                this.qin[this.o] = this.qinbase[this.o] + (this.o == 0 ? -1.0 : 1.0) * this.nstd * this.kns / this.frac[this.o + 1];
                this.dqin = this.qin[this.o] - this.qinold[this.o];
                this.mlt[this.o] = 0.0;
                this.n = 0;
                while (this.n < this.nhb) {
                    this.hiqi[this.o][this.n] = this.hiq[this.o][this.n] + this.rhicML[this.o][this.n] * this.dqin;
                    int n4 = this.o;
                    this.mlt[n4] = this.mlt[n4] + this.hrML[this.o][this.n] * this.hiqi[this.o][this.n];
                    ++this.n;
                }
                int n5 = this.o++;
                this.mlt[n5] = this.mlt[n5] / this.qpt;
            }
            this.diff = (this.mlt[0] - this.mlt[1]) * this.cice - this.nstd;
            this.nstd += this.diff;
            this.nit += 1.0;
        } while (Math.abs(this.diff) > 0.001 && this.nit < 10.0);
        this.hiq = this.hiqi;
        this.qinold = this.qin;
        this.o = 0;
        while (this.o < 2) {
            int n6 = this.o++;
            this.mlt[n6] = this.mlt[n6] - this.tstart;
        }
        this.sealevte[n] = 0.0f;
        this.o = 0;
        while (this.o < 2) {
            this.n = 0;
            while (this.n < this.nhb) {
                int n7 = n;
                this.sealevte[n7] = (float)((double)this.sealevte[n7] + this.hrsl[this.o][this.n] * this.hiq[this.o][this.n]);
                ++this.n;
            }
            ++this.o;
        }
        if (n == 0) {
            this.sealevteinit = this.sealevte[n];
        }
        int n8 = n;
        this.sealevte[n8] = (float)((double)this.sealevte[n8] - this.sealevteinit);
        this.boxtemp[0][n] = (float)((this.mlt[0] * this.cice * this.klo + this.frac[0] * (double)fArray[0]) / (this.kls * this.frac[0] + this.klo));
        this.boxtemp[3][n] = (float)((this.mlt[1] * this.cice * this.klo + this.frac[3] * (double)fArray[3]) / (this.kls * this.frac[3] + this.klo));
        this.boxtemp[1][n] = (float)(this.mlt[0] * this.cice);
        this.boxtemp[2][n] = (float)(this.mlt[1] * this.cice);
        this.glotemp[n] = 0.0f;
        this.i = 0;
        while (this.i < 4) {
            int n9 = n;
            this.glotemp[n9] = this.glotemp[n9] + (float)((double)this.boxtemp[this.i][n] * this.frac[this.i]);
            ++this.i;
        }
        if (this.viewbox.needed) {
            this.o = 0;
            while (this.o < 2) {
                this.n = 0;
                while (this.n < this.nhb) {
                    this.hq[this.n + this.o * this.nhb][n] = 0.0f;
                    int n10 = 0;
                    while (n10 < this.nhb) {
                        float[] fArray2 = this.hq[this.n + this.o * this.nhb];
                        int n11 = n;
                        fArray2[n11] = (float)((double)fArray2[n11] + this.MV[this.o].getArray()[this.n][n10] * this.hiq[this.o][n10]);
                        ++n10;
                    }
                    float[] fArray3 = this.hq[this.n + this.o * this.nhb];
                    int n12 = n;
                    fArray3[n12] = (float)((double)fArray3[n12] / (this.qpt * (this.n < this.nhb - 1 ? this.dl[this.n] / this.mixlaydepth.getval() : 1.0)));
                    ++this.n;
                }
                ++this.o;
            }
        }
        if ((d = (double)this.glotemp[n]) > this.zeroupwelltemp.getval()) {
            d = this.zeroupwelltemp.getval();
        }
        if (this.varupwell.istrue()) {
            this.o = 0;
            while (this.o < 2) {
                this.n = 0;
                while (this.n < this.nhb) {
                    this.hiquc = 0.0;
                    this.m = 0;
                    while (this.m < this.nhb) {
                        this.hiquc += this.hiq[this.o][this.m] * this.upwellstep[this.o][this.n][this.m];
                        ++this.m;
                    }
                    double[] dArray = this.hiq[this.o];
                    int n13 = this.n++;
                    dArray[n13] = dArray[n13] - this.hiquc * d * this.upwellreducefrac.getval();
                }
                ++this.o;
            }
        }
        if ((double)n == this.baseyear.val + 2.0 - (double)time.gsy) {
            this.calcoffset();
        }
    }

    public void postcalc() {
        this.applyoffset();
        this.calcerror();
    }

    public void calcerror() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        this.ns = 0;
        while (this.ns < 252) {
            float f5;
            float f6;
            float f7 = this.avtemp[this.ns];
            if (this.ns < 110) {
                f6 = this.proxytemp[this.ns];
                f5 = 0.5f;
            } else {
                f6 = this.tempdata[this.ns];
                f5 = 0.05f + 0.0015f * (float)(this.ns < 200 ? 200 - this.ns : 0);
            }
            f += (f7 - f6) * (f7 - f6) / f5;
            f3 += f7 / f5;
            f2 += f6 / f5;
            f4 += 1.0f / f5;
            ++this.ns;
        }
        this.error = Math.pow(f / f4 - (f3 / f4 - f2 / f4) * (f3 / f4 - f2 / f4), 0.5);
    }

    public void save99() {
        this.o = 0;
        while (this.o < 2) {
            this.nstd99 = this.nstd;
            this.nstdold99 = this.nstdold;
            this.qinold99[this.o] = this.qinold[this.o];
            this.n = 0;
            while (this.n < this.nhb) {
                this.hiq99[this.o][this.n] = this.hiq[this.o][this.n];
                ++this.n;
            }
            ++this.o;
        }
    }

    public void calcoffset() {
        this.oldoffset = this.offset;
        this.offset = 0.0;
        this.b = 0;
        while (this.b < 4) {
            this.boxoffset[this.b] = 0.0f;
            ++this.b;
        }
        int n = 0;
        while (n < 5) {
            int n2 = (int)this.baseyear.getval() - time.gsy + n - 2;
            if (n2 < 0) {
                n2 = 0;
            }
            this.offset += (double)((float)((double)this.glotemp[n2] / 5.0));
            this.b = 0;
            while (this.b < 4) {
                int n3 = this.b;
                this.boxoffset[n3] = this.boxoffset[n3] + (float)((double)this.boxtemp[this.b][n2] / 5.0);
                ++this.b;
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void applyoffset() {
        int n = 0;
        while (n <= time.glos) {
            this.b = 0;
            while (this.b < 4) {
                float[] fArray = this.boxtemp[this.b];
                int n2 = n;
                fArray[n2] = fArray[n2] - this.boxoffset[this.b];
                ++this.b;
            }
            this.avtemp[n] = (float)((double)this.glotemp[n] - this.offset);
            modlist.mitigation.otarget[n] = (float)(modlist.mitigation.target[n] != -999.0f ? (double)modlist.mitigation.target[n] - this.offset : -999.0);
            ++n;
        }
    }

    public void startstate(int n) {
        this.startyear = n;
        if (n == 1750) {
            this.nstd = 0.0;
            this.nstdold = 0.0;
            this.o = 0;
            while (this.o < 2) {
                this.qinold[this.o] = this.spaceflux[this.o] * this.qpt * this.tstart;
                this.n = 0;
                while (this.n < this.nhb) {
                    this.hiq[this.o][this.n] = this.hiqstart[this.o][this.n];
                    ++this.n;
                }
                ++this.o;
            }
        } else {
            n = 2000;
            this.nstd = this.nstd99;
            this.nstdold = this.nstdold99;
            this.qinold[0] = this.qinold99[0];
            this.qinold[1] = this.qinold99[1];
            this.o = 0;
            while (this.o < 2) {
                this.n = 0;
                while (this.n < this.nhb) {
                    this.hiq[this.o][this.n] = this.hiq99[this.o][this.n];
                    ++this.n;
                }
                ++this.o;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void histtemptrend() {
        this.ns = 0;
        while (this.ns <= 3) {
            this.temptrend[this.ns] = 0.0f;
            ++this.ns;
        }
        this.ns = 0;
        while (this.ns <= 6) {
            this.temptrend[3] = this.temptrend[3] + this.proxytemp[this.ns] / 7.0f;
            ++this.ns;
        }
        this.ns = 7;
        while (this.ns <= 1860 - time.gsy) {
            this.temptrend[this.ns - 3] = this.temptrend[this.ns - 4] + (this.proxytemp[this.ns] - this.proxytemp[this.ns - 7]) / 7.0f;
            ++this.ns;
        }
        this.ns = 1860 - time.gsy;
        while (this.ns <= 1867 - time.gsy) {
            this.temptrend[this.ns - 3] = this.temptrend[this.ns - 4] + (this.tempdata[this.ns] - this.proxytemp[this.ns - 7]) / 7.0f;
            ++this.ns;
        }
        this.ns = 1868 - time.gsy;
        while (this.ns <= time.hiss + 2) {
            this.temptrend[this.ns - 3] = this.temptrend[this.ns - 4] + (this.tempdata[this.ns] - this.tempdata[this.ns - 7]) / 7.0f;
            ++this.ns;
        }
        float f = 0.0f;
        int n = 0;
        while (n < 5) {
            int n2 = (int)this.baseyear.getval() - time.gsy + n - 2;
            if (n2 < 0) {
                n2 = 0;
            }
            f += (float)((double)(this.baseyear.getval() > 1862.0 ? this.tempdata[n2] : this.proxytemp[n2]) / 5.0);
            ++n;
        }
        this.ns = 0;
        while (this.ns <= time.hiss + 2) {
            int n3 = this.ns;
            this.proxytemp[n3] = this.proxytemp[n3] - f;
            int n4 = this.ns;
            this.tempdata[n4] = this.tempdata[n4] - f;
            int n5 = this.ns++;
            this.temptrend[n5] = this.temptrend[n5] - f;
        }
        this.ns = 0;
        while (this.ns < 3) {
            this.temptrend[this.ns] = -999.0f;
            ++this.ns;
        }
        this.ns = time.hiss;
        while (this.ns <= time.hiss + 2) {
            this.temptrend[this.ns] = -999.0f;
            ++this.ns;
        }
        this.ns = 0;
        while (this.ns < 1860 - time.gsy) {
            this.tempdata[this.ns] = -999.0f;
            ++this.ns;
        }
        this.ns = 1991 - time.gsy;
        while (this.ns <= time.hiss + 2) {
            this.proxytemp[this.ns] = -999.0f;
            ++this.ns;
        }
    }

    public void setupfluxes() {
        double d;
        this.dt = 1.0;
        this.dml = this.mixlaydepth.getval();
        this.dl = new double[this.nhl];
        this.n = 0;
        while (this.n < this.nhl) {
            this.dl[this.n] = (this.n < 20 ? 49.0 : 196.0) * (34.0 / (double)this.nhl);
            ++this.n;
        }
        this.diffu = this.heatdiffusivity.getval() * 3.1536E7 / 10000.0;
        this.hu = this.upwellbaserate.getval();
        this.pi = this.polarsinktempratio.getval();
        double d2 = 0.1300101471334348;
        this.qpt = d2 * this.dml;
        this.klo = this.klandocean.getval();
        this.kns = this.knorthsouth.getval();
        double d3 = this.landoceantempratio.getval();
        this.cice = this.seaice.getval();
        double d4 = 1.0;
        double d5 = -99.0;
        this.kos = 0.9;
        do {
            this.kls = this.rfco2double.getval() / this.climsens.getval() * (d3 * this.fracl + this.fraco) / (d3 * this.fracl) - this.kos * this.fraco / (d3 * this.fracl);
            this.khi = new Matrix(new double[][]{{this.frac[0] * this.kls + this.klo, -this.klo, 0.0, 0.0}, {-this.klo, this.frac[1] * this.kos + this.klo + this.kns, -this.kns, 0.0}, {0.0, -this.kns, this.frac[2] * this.kos + this.klo + this.kns, -this.klo}, {0.0, 0.0, -this.klo, this.frac[3] * this.kls + this.klo}}, 4, 4).inverse().getArray();
            this.i = 0;
            while (this.i < 4) {
                this.khir[this.i] = 0.0;
                this.j = 0;
                while (this.j < 4) {
                    double[] dArray = this.khi[this.i];
                    int n = this.j;
                    dArray[n] = dArray[n] * this.frac[this.j];
                    int n2 = this.i;
                    this.khir[n2] = this.khir[n2] + this.khi[this.i][this.j];
                    ++this.j;
                }
                ++this.i;
            }
            d = (this.frac[0] * this.khir[0] + this.frac[3] * this.khir[3]) / this.fracl / ((this.frac[1] * this.khir[1] + this.frac[2] * this.khir[2]) / this.fraco);
            double d6 = d5 == -99.0 ? 1.0 : this.kos + (d3 - d) * (this.kos - d5) / (d - d4);
            d5 = this.kos;
            this.kos = d6;
            d4 = d;
        } while (Math.abs(d3 - d) > 1.0E-4);
        this.rate = new double[this.nhb][this.nhb];
        this.i = 0;
        while (this.i < this.nhb) {
            this.j = 0;
            while (this.j < this.nhb) {
                this.rate[this.i][this.j] = 0.0;
                ++this.j;
            }
            ++this.i;
        }
        this.n = 1;
        while (this.n < this.nhl) {
            this.rvu = (2.0 * this.diffu - this.hu * this.dl[this.n]) / (this.dl[this.n - 1] * (this.dl[this.n - 1] + this.dl[this.n]));
            this.rv = (2.0 * this.diffu + this.hu * this.dl[this.n - 1]) / (this.dl[this.n] * (this.dl[this.n - 1] + this.dl[this.n]));
            double[] dArray = this.rate[this.n];
            int n = this.n - 1;
            dArray[n] = dArray[n] + this.rvu;
            double[] dArray2 = this.rate[this.n - 1];
            int n3 = this.n - 1;
            dArray2[n3] = dArray2[n3] - this.rvu;
            double[] dArray3 = this.rate[this.n - 1];
            int n4 = this.n;
            dArray3[n4] = dArray3[n4] + this.rv;
            double[] dArray4 = this.rate[this.n];
            int n5 = this.n++;
            dArray4[n5] = dArray4[n5] - this.rv;
        }
        this.rvu = 8.0 * this.diffu / (3.0 * this.dl[0] * this.dml) - this.hu / this.dml;
        this.rv = 3.0 * this.diffu / (this.dl[0] * this.dl[0]);
        this.rjff = this.diffu / (3.0 * this.dl[0] * this.dl[0]);
        double[] dArray = this.rate[0];
        int n = this.nhl;
        dArray[n] = dArray[n] + this.rvu;
        double[] dArray5 = this.rate[this.nhl];
        int n6 = this.nhl;
        dArray5[n6] = dArray5[n6] - this.rvu;
        double[] dArray6 = this.rate[this.nhl];
        dArray6[0] = dArray6[0] + this.rv;
        double[] dArray7 = this.rate[0];
        dArray7[0] = dArray7[0] - this.rv;
        double[] dArray8 = this.rate[0];
        dArray8[1] = dArray8[1] + this.rjff;
        double[] dArray9 = this.rate[this.nhl];
        dArray9[1] = dArray9[1] - this.rjff;
        this.polsink = this.pi * this.hu / this.dml;
        double[] dArray10 = this.rate[this.nhl - 1];
        int n7 = this.nhl;
        dArray10[n7] = dArray10[n7] + this.polsink;
        double[] dArray11 = this.rate[this.nhl];
        int n8 = this.nhl;
        dArray11[n8] = dArray11[n8] - this.polsink;
        this.mlbaserate = this.rate[this.nhl][this.nhl];
        this.M = new Matrix(this.rate, this.nhb, this.nhb);
        if (this.varupwell.istrue()) {
            double[][] dArray12 = new double[this.nhb][this.nhb];
            this.n = 0;
            while (this.n < this.nhb) {
                this.m = 0;
                while (this.m < this.nhb) {
                    dArray12[this.n][this.m] = 0.0;
                    ++this.m;
                }
                ++this.n;
            }
            this.n = 1;
            while (this.n < this.nhl) {
                this.rvu = -this.hu * this.dl[this.n] / (this.dl[this.n - 1] * (this.dl[this.n - 1] + this.dl[this.n]));
                this.rv = this.hu * this.dl[this.n - 1] / (this.dl[this.n] * (this.dl[this.n - 1] + this.dl[this.n]));
                double[] dArray13 = dArray12[this.n];
                int n9 = this.n - 1;
                dArray13[n9] = dArray13[n9] + this.rvu;
                double[] dArray14 = dArray12[this.n - 1];
                int n10 = this.n - 1;
                dArray14[n10] = dArray14[n10] - this.rvu;
                double[] dArray15 = dArray12[this.n - 1];
                int n11 = this.n;
                dArray15[n11] = dArray15[n11] + this.rv;
                double[] dArray16 = dArray12[this.n];
                int n12 = this.n++;
                dArray16[n12] = dArray16[n12] - this.rv;
            }
            this.rvu = -this.hu / this.dml;
            double[] dArray17 = dArray12[0];
            int n13 = this.nhl;
            dArray17[n13] = dArray17[n13] + this.rvu;
            double[] dArray18 = dArray12[this.nhl];
            int n14 = this.nhl;
            dArray18[n14] = dArray18[n14] - this.rvu;
            this.polsink = this.pi * this.hu / this.dml;
            double[] dArray19 = dArray12[this.nhl - 1];
            int n15 = this.nhl;
            dArray19[n15] = dArray19[n15] + this.polsink;
            double[] dArray20 = dArray12[this.nhl];
            int n16 = this.nhl;
            dArray20[n16] = dArray20[n16] - this.polsink;
            this.U = new Matrix(dArray12, this.nhb, this.nhb);
        }
        double d7 = this.tstart * this.qpt;
        Matrix matrix = this.M.getMatrix(0, this.nhl - 1, 0, this.nhl - 1).inverse().times(this.M.getMatrix(0, this.nhl - 1, this.nhl, this.nhl)).times(-d7);
        double[] dArray21 = matrix.transpose().getArray()[0];
        double[] dArray22 = new double[this.nhb];
        dArray22[this.nhl] = this.tstart;
        this.n = 0;
        while (this.n < this.nhl) {
            dArray22[this.n] = dArray21[this.n] / (d2 * this.dl[this.n]);
            ++this.n;
        }
        double[] dArray23 = new double[this.nhb];
        double d8 = 5071.5;
        dArray23[this.nhl] = 101325.0 + d8 * this.dml;
        dArray23[0] = dArray23[this.nhl] + d8 * (this.dml + this.dl[0]);
        this.n = 1;
        while (this.n < this.nhl) {
            dArray23[this.n] = dArray23[this.n - 1] + d8 * (this.dl[this.n - 1] + this.dl[this.n]);
            ++this.n;
        }
        this.vec = new double[this.nhb];
        this.n = 0;
        while (this.n < this.nhb) {
            this.vec[this.n] = 1.0 / d2 * (1.0E-4 * (0.5 + 0.12 * dArray22[this.n] - 8.0E-4 * dArray22[this.n] * dArray22[this.n] + 2.8 * (1.0 - 0.027 * dArray22[this.n]) * (dArray23[this.n] * 1.0E-8 - 0.24 * dArray23[this.n] * dArray23[this.n] * 1.0E-16)));
            ++this.n;
        }
        double[] dArray24 = new double[this.nhb];
        double[] dArray25 = new double[this.nhb];
        double[] dArray26 = new double[this.nhb];
        double[] dArray27 = new double[this.nhb];
        this.o = 0;
        while (this.o < 2) {
            this.spaceflux[this.o] = 1.0 / this.qpt * this.cice * (this.kos + this.klo / this.frac[this.o + 1] * (this.kls * this.frac[this.o * 3] / (this.kls * this.frac[this.o * 3] + this.klo)));
            this.M.set(this.nhl, this.nhl, this.mlbaserate - this.spaceflux[this.o]);
            EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(this.M);
            this.MV[this.o] = eigenvalueDecomposition.getV();
            this.MVI[this.o] = this.MV[this.o].inverse();
            this.n = 0;
            while (this.n < this.nhb) {
                this.hiqstart[this.o][this.n] = 0.0;
                this.m = 0;
                while (this.m < this.nhb) {
                    double[] dArray28 = this.hiqstart[this.o];
                    int n17 = this.n;
                    dArray28[n17] = dArray28[n17] + this.MVI[this.o].getArray()[this.n][this.m] * (this.m < this.nhb - 1 ? dArray21[this.m] : d7);
                    ++this.m;
                }
                ++this.n;
            }
            dArray24 = eigenvalueDecomposition.getRealEigenvalues();
            this.n = 0;
            while (this.n < this.nhb) {
                this.hpropf[this.o][this.n] = Math.exp(dArray24[this.n] * this.dt);
                if (Math.abs(dArray24[this.n]) < 1.0E-6) {
                    dArray25[this.n] = this.dt;
                    dArray26[this.n] = this.dt / 2.0;
                } else {
                    dArray25[this.n] = (this.hpropf[this.o][this.n] - 1.0) / dArray24[this.n];
                    dArray26[this.n] = (dArray25[this.n] - this.dt) / (dArray24[this.n] * this.dt);
                }
                ++this.n;
            }
            this.hrML[this.o] = this.MV[this.o].getArray()[this.nhl];
            dArray27 = this.MVI[this.o].transpose().getArray()[this.nhl];
            this.n = 0;
            while (this.n < this.nhb) {
                this.rhicML[this.o][this.n] = dArray26[this.n] * dArray27[this.n];
                this.shicML[this.o][this.n] = dArray25[this.n] * dArray27[this.n];
                ++this.n;
            }
            this.n = 0;
            while (this.n < this.nhb) {
                this.i = 1;
                while (this.i < this.nhb) {
                    double[] dArray29 = this.hrsl[this.o];
                    int n18 = this.n;
                    dArray29[n18] = dArray29[n18] + this.MV[this.o].getArray()[this.i][this.n];
                    ++this.i;
                }
                double[] dArray30 = this.hrsl[this.o];
                int n19 = this.n;
                dArray30[n19] = dArray30[n19] * this.vec[this.n];
                double[] dArray31 = this.hrsl[this.o];
                int n20 = this.n++;
                dArray31[n20] = dArray31[n20] * (this.frac[this.o + 1] / (this.frac[1] + this.frac[2]));
            }
            if (this.varupwell.istrue()) {
                this.upwellstep[this.o] = this.MVI[this.o].times(this.U.times(this.MV[this.o])).getArray();
                this.n = 0;
                while (this.n < this.nhb) {
                    this.m = 0;
                    while (this.m < this.nhb) {
                        double[] dArray32 = this.upwellstep[this.o][this.n];
                        int n21 = this.m;
                        dArray32[n21] = dArray32[n21] * (dArray25[this.m] / this.zeroupwelltemp.getval());
                        ++this.m;
                    }
                    ++this.n;
                }
            }
            ++this.o;
        }
        dArray24 = null;
        dArray26 = null;
        dArray25 = null;
        dArray27 = null;
    }
}

