package jcm.gui;
import jcm.*;
import jcm.tls.*;
import jcm.pan.panlist;

public class plotlayout extends iob implements panlist {
	//panlist stores the list of initial plotlayouts (pl array)
	//beware initialisation: some of the panels refer to cpl!
	//note any methods invoking "changed=true" etc. should be in preinterac!
	
	//********************************************
	
	public mainapp applet; 
	public param[] plotparam; 
	public menu[] plotmenu; 
	
	public jcmpanel[] pan; 
	public int np, nl; 
	int x,y,w,h; 
	public int[] px, py, pw, ph; //position and size as percentages
	public jcmpanel central; //panel in middle, has some special properties
	
	public plotlayout (int i, mainapp ma) {
		applet=ma; 
		name=pl[i]; nl=i; np=initplot[i].length+2; 
		px=layout[i][0]; py=layout[i][1]; pw=layout[i][2]; ph=layout[i][3]; 
		pan=new jcmpanel[np]; plotparam=new param[np]; plotmenu=new menu[np]; 
		for (int n=0; n<np-2; n++) pan[n]=makenewpanel(initplot[i][n], applet); 
		pan[np-2]=makenewpanel("mitigpanel",applet); 
		pan[np-1]=makenewpanel("layoutpanel",applet); 
		if ( np>8 ){	scale.showscales.flag=false; popob.showcontrols.flag=false; } 	else {	scale.showscales.flag=true; popob.showcontrols.flag=true; }
		initsetup(); 
	}
	
	public plotlayout(String name, mainapp ma) {
		applet=ma; 
		np=1; pan=new jcmpanel[] {	makenewpanel(name, ma) }; 
		register(); 
	}
	
	public void resetapplet(mainapp ma) {	applet=ma; for (int n=0; n<np; n++) pan[n].holder=ma; }
	
	jcmpanel makenewpanel(String name, mainapp a) {
		String[] args=txt.split(name, "&"); 
		jcmpanel j=(jcmpanel)ref.makeiob(args[0]); 
		j.initsetup(a, args); 
		return j; 
	}
	
	public void setinteractions() {
		for (int p=0; p<pan.length; p++) setaffects(pan[p].pansetup, this==applet.cpl); 
		output=(this==applet.cpl); 
	}
	
	public void preinterac(iob iob) {
		for (int i=0; i<np; i++) if (iob==plotparam[i]) 	{	swapplot(i, plotparam[i].chosen); }
	}
	
	public int findn(jcmpanel j) {	for (int i=0; i<np; i++) if (pan[i]==j) return i; return -1; }
	
	public void makeplotmenu(int n) {
		if	(plotparam[n]==null) {	plotparam[n]=new param("pan"+n, menulist, initplot[nl][n]); plotparam[n].owner=this; }
		if  (plotmenu[n]==null) {	plotmenu[n]=new menu(plotparam[n], pan[n], "verysimple"); plotmenu[n].name="plotmenu"; plotmenu[n].labelkey="plotmenu"; plotmenu[n].sml=1; }
		plotmenu[n].holder=pan[n]; plotmenu[n].owner=this; plotmenu[n].holder.titlepop.gotplotmenu=true; 
		plotmenu[n].clearinteractions(); 
	}
	public void makeplotmenu(jcmpanel j) {
		param pp=new param("pan-standalone", menulist, j.name); pp.owner=this; 
		menu pm=new menu(pp, j, "verysimple"); pm.name="plotmenu"; pm.labelkey="plotmenu"; pm.sml=0; 
		pm.holder=j; pm.owner=this; pm.holder.titlepop.gotplotmenu=true; 
		pm.clearinteractions(); 
	}
	
	public void resize(int x, int y, int w, int h) {	this.x=x; this.y=y; this.w=w; this.h=h; resizeall(); }
	
	public void resizeall() {
		for (int p=0; p<np; p++) 	pan[p].clear(); 
		if (np>1) {
			for (int p=0; p<np-2; p++) resize(p); 
			pan[np-1].resize(0,0, (int)(w*0.65), 40); pan[np-2].resize((int)(w*0.65),0, (int)(w*0.35), 40); 
		}
		else pan[0].resize(0,0,w,h); 
		for (int p=0; p<np; p++) pan[p].setchanged(); 
		iob.debug("resized"); 
	}
	
	
	public void resize (int n) {
		pan[n].resize(x+(px[n]*w)/100, 40+y+(py[n]*(h-40))/100, (pw[n]*w)/100, (ph[n]*(h-40))/100); 
		if (n==(np-1) && np>4) central=pan[n]; 
		makeplotmenu(n); 
	}
	
	public void hideawt() {	if (applet.allowpaint) for (int p=0; p<np; p++) pan[p].hide(); }
	
	public void dispose() {
		try {	hideawt(); applet.clearback(); }	catch (Exception e) {	debug(" pl disposing "+e); }
		for (int p=0; p<np; p++) pan[p].dispose(); 
		super.dispose(); 
		//could adapt this to keep plots that will still exist ?
	}
	
	public void swapplot(int i, String newname) {
		debug("swap "+pan[i].name+" => "+newname); 
		jcmpanel oldp=pan[i], newp; 
		oldp.hide(); oldp.dispose(); 
		newp=makenewpanel(newname,applet); //after dispose for param holder reset ok
		plotmenu[i].holder=newp; 
		pan[i]=newp; 
		if (this==applet.cpl) {	pan[i].clear(); resize(i); pan[i].setchanged(); } //this==cpl catches call during reset
	} //end swapplot
	
} //end class
	
	
	
