//Regionplot for comparing regional data 
//functions for ratio, rate, frac, autointeractions, changing name 

package jcm.gui;
import jcm.*;
import jcm.mod.*;
import java.awt.Color;

public abstract class regionplot extends graph  {
	
	public param
		rate=new param("percent&per&yr", false),
		frac=new param("frac", false), //maybe make "frac" just one option in "per" (i.e. percent)?
		varq, perq
		; 
	
	public float[][] topdata=null, perdata=null; 
	public float[][][] datalist, perdatalist; 
	public 	menu topmenu, permenu; 
	public option
		rateopt=new option(rate, this, "expert"),
		fracopt=new option(frac, this),
		stackedopt=new option(stacked, this); 
	
	public String[] toplist, unitlist, perlist, punitlist; 
	public Color[] regcols; 
	
	//*********************************
	public void initsetup(mainapp a) {	initsetup(a, new String[]{	""}); }
	public void initsetup(mainapp a, Object[] args) {
		for (int i=0; i<args.length; i++) debug (args[i]); 
		if (args.length<4) makelists(toplist[0], ""); 
		else makelists((String)args[1], (String)args[3]); 
		super.initsetup(a); 
	}
	public abstract void makelists(String what, String per); 
	
	//*********************************
	//INTERACTIONS
	public void setinteractions() {
		
		super.setinteractions(); 
		autofindinteractions(topdata); 
		autofindinteractions(perdata); 
		
		pansetup.setaffectedby(rate); 
		pansetup.setaffectedby(perq); 
		pansetup.setaffectedby(varq); 
		pansetup.setaffectedby(stacked); 
		
		bufi.setaffectedby(rate); 
		bufi.setaffectedby(frac); 
		bufi.setaffectedby(perq); 
		bufi.setaffectedby(varq); 
		
		stacked.flag &=complexity.complexity.chosen!="verysimple"; 
		stackedopt.output &= (perdata==null && !rate.istrue()); 
		fracopt.output &= stackedopt.output; 
	}
	
	
	//*********************************
	//LOOP / GRAPH methods
	
	public void preinterac(iob iob) {
		super.preinterac(iob); 
		if (iob==varq || iob==perq || iob==rate || iob==frac) {	makecurves(); makecurvearrays(); } //inefficient if several change!
		if (iob==stacked) legend.newcurves(); 
	}
	
	public void reset() {	makecurves(); makecurvearrays(); } //if pressed reset
	
	//makecurves called in initsetup & when change varq, perq rate or frac
	public void makecurves() {
		topdata=datalist[varq.getchosenindex()]; 
		perdata=perdatalist[perq.getchosenindex()]; 
		
		stacked.flag &= (perdata==null && !rate.istrue()); 
		frac.flag &= (perdata==null && !rate.istrue()); 
		
		if (perdata==null && !rate.istrue() && !frac.istrue()) yd=topdata; 
		else  yd=new float[perdata==null || perdata.length>topdata.length ? topdata.length : perdata.length][xd.length]; 
		
		yscale.autoscale=true; 
		setname(); 
	} //end makecurves
	
	public void makebuffer() {
		if (perdata!=null) ratio(); 
		if (rate.istrue()) {	rate(); if (yscale.autoscale) yscale.autoscale(-10.0, 10.0); }
		else {
			if (frac.istrue()) {	frac(); if (yscale.autoscale) yscale.autoscale(0, 100); }
			else if  (yscale.autoscale) yscale.autoscale(); 
		}
		super.makebuffer(); 
	}
	
	//*********************************
	//set var and per once toplist and perlist are defined: called by subclass constructors
	public void setvarper (String top, String per) {
		if (top==null) top=""; if (per==null) per=""; 
		varq=new param("varq", toplist, top); varq.numitems-=1; //remove the blank one
		perq=new param("perq", perlist, per); 
		permenu= new menu(perq, this); 
		topmenu=new menu(varq, this); 
	}
	
	//***************************************************
	//NAME
	public void setname() {
		name2=""; yscale.units=""; 
		for (int i=0; i<datalist.length-1; i++) if (topdata==datalist[i]) {	name2+="&colon&"+toplist[i]; yscale.units+=unitlist[i]; }
		if (perdata!=null) {
			for (int i=0; i<perdatalist.length-1; i++) if (perdata==perdatalist[i]) {	name2+="&per&"+perlist[i]; yscale.units+="&/&"+punitlist[i]; }
		}
		if (rate.istrue()) yscale.units="percent&per&yr"; 
		if (frac.istrue()) yscale.units="percent"; 
		name3= "&ob&"+yscale.units +"&cb"; 
	}
	
	public String docinfo(String what) {
		if (what.equals("curves")) return  "<hr>`curves "+docwhatper()+ "regintro "+doccurve(); 
		if (what.equals("scales")) return docscale()+" regscales "; 
		return super.docinfo(what); 
	}
	
	public String docwhatper() {	return "<br> whatper <br> ~"+varq.chosen+" "+varq.chosen+"  "+((perdata!=null) ? "<br>`divby ~"+ perq.chosen+" "+perq.chosen : ""); }
	
	//***************************************************
	//RATIO / FRAC / RATE
	
	void ratio(){
		for (int nr=0; nr<yd.length; nr++) {
			for (int rs=0; rs<xd.length; rs++) {
				if (perdata[nr][rs]>0 && topdata[nr][rs]>0) yd[nr][rs]=topdata[nr][rs]/perdata[nr][rs]; 
				else yd[nr][rs]=-999; 
			}}
	}
	
	void frac() {
		for (int rs=0; rs<xd.length; rs++) {
			float tot=0; for (int nr=0; nr<ncurves; nr++) if (curveoutput[nr]) tot+=topdata[nr][rs]; 
			for (int nr=0; nr<ncurves; nr++) { yd[nr][rs]=topdata[nr][rs]*100f/tot; if ((""+yd[nr][rs]).equals("NaN")) yd[nr][rs]=-0.00000001f; }
		}
	}
	
	void rate() {
		float[][] ydo=(perdata==null ? topdata : yd); 
		for (int nr=0; nr<ncurves; nr++) {
			for (int rs=xd.length-1; rs>0; rs--) {
				if (ydo[nr][rs-1]>0) yd[nr][rs]=100f*(ydo[nr][rs]-ydo[nr][rs-1])/ydo[nr][rs-1]; 
				else yd[nr][rs]=-999; 
			}
			yd[nr][0]=0; 
		}
	}
	
	
} //end regionplot
	
	//*********************************
	
	
	
