// mainapp contains methods specific to the holding applet, also triggering initiation

package jcm;
import jcm.gui.*;
import jcm.pan.*;
import jcm.mod.*;
import jcm.tls.*;

import java.awt.*;
import java.applet.Applet;

//import java.net.*;

public class mainapp extends Applet implements colfont {
	
	static {	System.out.println("\n**************************\nJCM mainapp starting"); }
	
	public boolean notapplet=false, allowpaint=true,   ready=false; 
	//set notapplet if started using startjcm, then also has access to save file tools and assume JDK1.4
	
	String pl, la, co; //applet parameters
	
	final mainapp ma=this; //just for ref from the inner class
	
	public plotlayout cpl; //current plotlayout
	
	public param
		backred=new param("backred","",221,0,255),
		backgreen=new param("backgreen","",221,0,255),
		backblue=new param("backblue","",255,0,255),
		reset=new param("reset") {	public void preinterac() {	changed=false; iob.resetall(); }}, //note, this will only catch preinterac methods of iobs registered after this one!!
	panlayout=	new param("layoutmenu", plotlayout.pl, plotlayout.pl[3]) {	public void preinterac() {	if (!chosen.equals(cpl.name)) {
				cpl.dispose(); cpl=new plotlayout( getchosenindex() , ma ); resize(); 
			}}}	; 
	
	//********** INIT ***************
	
	public void init() {
		//called either first time this class is loaded as an applet, or otherwise from startjcm (which sets notapplet)
		if (!notapplet && iob.codebase==null) iob.codebase=getCodeBase(); 
		if (!notapplet) 	getparameters(); //here for background before paint
		if (co==null) 	iob.applet=this; //master applet - used for applet-context to load data etc.
		//note if (iob.applet==null) doesn't work in NS4
		iob.debug("JCM mainapp initialised OK"); 
	}
	//note netscape 4.x jvm seems to be initialising everything before even running init method, i.e. any object referred in this code even in a method not yet reachable
	
	//netscape 4 will call stop and start every time you resize it
	//since stop disposes the cpl, we have to make another
	public void start() {	ready=false; }
	
	
	//************PAINT ***********************
	public void paint(Graphics g) {
		//main setup called from paint to ensure that applet is visible and has dimensions before make panels
		iob.debug("called paint "+allowpaint); 
		if (!ready && iob.applet!=null)  initialstart(); 
		if (ready) normalpaint(); 
		//		if (labinf.notgotdoc) labinf.getdoc();
	}
	public void update(Graphics g) {	iob.debug("called update "+allowpaint); normalpaint(); }
	
	
	public void initialstart() {
		iob.debug ("mainapp initialstart"); 
		if (!openapp.started) {	openapp.startup(); if (!notapplet) jcm.tls.showwebpage.webbrowser=true; } //for NS4.x and  appletviewer
		if (!notapplet) 	getparameters(); //here for restart
		setbackcol(); setFont(normalfont); 
		if (co==null)  	{
			cpl=new plotlayout(3, this); 
			reset.output=true; panlayout.output=true; //so always called if changed
		}
		else cpl=new plotlayout(co, this); 
		w=0; //force resize
		ready=true; 
		if (!showwebpage.oktoshow) {
			showwebpage.oktoshow=true; 
			showwebpage.showinfo(autodoc.makedoc(autodoc.current)); 
		}
	}
	
	public void normalpaint() {
		if (isShowing() && ready && allowpaint) {
			if (needtoresize()) resize(); //indiv plots set changed by resize
			else cpl.changed=true; 
			loop.go(); //loop runs model as needed then repaints panels
		}
	} //end paint
	
	
	//*******************
	//OVERIDE AWT methods
	//note paint or update also called if window moved, resized, uncovered etc.
	//(beware which and when called varies between browsers!)
	
	public boolean handleEvent(Event e) {	if (ready) {	jcmevent.handleEvent(e, this); return super.handleEvent(e); } else return false; }
	//overide for exporting image: note savefile contains java1.4 methods, so only refer to it if notapplet 	/*System.out.println("painting to image file"); */
	public Graphics getGraphics() {	if (notapplet && capimage.capturing) return capimage.getGraphics(); else return super.getGraphics(); }
	//JCM resizing, clearing methods etc.
	public int w=0, h=0; 
	public boolean needtoresize() {	return (w!=size().width || h!=size().height); }
	public void resize() {	w=size().width; h=size().height; cpl.resize(0,0,w, h); }
	public void clearback() {	setbackcol(); getGraphics().setColor(getBackground()); getGraphics().clearRect(0,0,w,h); }
	public void setbackcol() {	setBackground(new Color((int)backred.val,(int)backgreen.val, (int)backblue.val)); }
	public Color getBackground() {	return new Color((int)backred.val, (int)backgreen.val, (int)backblue.val); }
	public Dimension preferredSize() {	return new Dimension (1024,768); }
	
	//******** APPLET PARAMETERS *********************************
	
	void getparameters() {
		//don't put any ref to model/gui here -not yet initialised
		//message("Checking applet parameters...");
		
		pl=getParameter("layout"); 
		la=getParameter("language"); 
		co=getParameter("contents"); 
		String sp=getParameter("startpage"); if (sp!=null && !sp.equals("")) autodoc.current=sp; 
		iob.debug("startpage="+ sp); 
		String br=getParameter("backred"); if (br!=null) backred.doscript(br); 
		String bg=getParameter("backgreen"); if (bg!=null) backgreen.doscript(bg); 
		String bb=getParameter("backblue"); if (bb!=null) backblue.doscript(bb); 
		
	} //end parameters
	
	
	public String getParameter(String p) {
		if (notapplet) return null; 
		else return super.getParameter(p); 
	}
	
	//******** PUBLIC METHODS ****************
	//methods which may be called from javascript in webpage
	
	//public void setdevelop() {	iob.develop=true; }
	
	public String getinfo() {	return showwebpage.getinfo(); }
	public String getdoc(String name) {	return autodoc.makedoc(name); }
	public void autodoc(String name) {	showwebpage.showinfo(autodoc.makedoc(name)); }
	
	public String getoutput() {	String s=iob.accuminfo.toString(); iob.accuminfo=new StringBuffer(""); return s; }
	public String loadstring(String filename) {	return fileio.loadstring(filename); }
	public String getlabel(String key) {	return labinf.getlabel(key); }
	public String getshort(String key) {	return labinf.getshort(key); }
	
	public String autolink(String name) {	return autodoc.link(name); }
	public String autolink(String name, String text) {	return autodoc.link(name, text); }
	
	public void getcode(String name) {	showwebpage.showcode(ref.findclass(name)); }
	public void search(String s,  boolean anywords, boolean titlesonly) {	labinf.search(s, anywords, titlesonly); }
	
	public boolean isReady() {	return ready; }
	public String bounce(String in) {	return in; }
	
	//public void loadlabels(String lang) {	labinf.getlabels(lang); }
	
	public void playi(String instructions) {	player.playins(instructions); }
	public String playandrespond(String instructions) {	player.playins(instructions); return getoutput(); }
	public void setdebugtohtml() {	iob.debugiob=new showwebpage(); }
	
	//beware don't make method simply called play, which has another meaning to browser!
	public boolean playing() {	return player.running; }
	public void playfile(String filename) {	player.playins(fileio.loadstring(filename)); }
	public void playjsfile(String filename) {	showwebpage.javascript(fileio.loadstring(filename)); }
	public void stopplay() {	player.stop(); }
	public void stopplayjs() {	showwebpage.javascript("running=false;"); }
	public void set(String a, String b) {	iob.findiob(a).doscript(b); }
	public String val(String a) {	return iob.findiob(a).getstringval(); }
	public iob find(String a) {	return iob.findiob(a); }
	public void go() {	loop.go(); }
	public void sleep(long a) {	try {	Thread.sleep(a); } catch (InterruptedException e) {	}}
	//	public void setstartpage(String s) { autodoc.current=s; if (!labinf.notgotdoc) showwebpage.showinfo(autodoc.makedoc(autodoc.current));  }
	
	//*********************************************
	//called when applet is removed from view
	public void stop() {
		//	if (iob.applet==this){	 player.stop(); sysin.stop(); } 	//recorder.stop(); getinstruct.stop();}
		cpl.dispose(); 
	}
	
}//end mainapp
	
	
