//Carbon cycle
//including HILDA Diffusion-Advection ocean with 40 layers, and carbonate chemistry 
//also simple 4-box biosphere 
//solved using eigenvector method
//also stores global fossil and land-use change CO2 emissions 

//Developed in Copenhagen spring 2001 
//Soon to be updated Bern 2002 with Bern-CC biosphere, maybe split also


package jcm.mod;
import jcm.*;

import Jama.*; //this is the java matrix package for calculating eigenvectors, inverses etc.

public class carboncycle extends module {
	
	public iob carbonsetup=new iob("carbonsetup", this); 
	
	//*****************************************************
	//INTERACTIONS
	
	public void setinteractions() {
		setaffectedby(loaddata); 
		setaffectedby(sres, mitigation.scenario.chosen=="nopolicy"); 
		setaffectedby(mitigation, mitigation.scenario.chosen!="nopolicy"); 
		setaffectedby(heatflux, chemfeedback.istrue()); 
		setaffectedby(carbonsetup); 
		carbonsetup.setaffectedby(beta); carbonsetup.setaffectedby(sidemix); carbonsetup.setaffectedby(upwell); carbonsetup.setaffectedby(hlmix); carbonsetup.setaffectedby(diffufac); carbonsetup.setaffectedby(gasex); 
		carbonsetup.setaffectedby(chemfeedback); carbonsetup.setaffectedby(carbchem); //note although chemistry calc within loop it also affects the linear part of flux
		carbonsetup.setaffectedby(viewbox); 
	} //end interactions
	
	//*****************************************************
	//PARAMS
	
	String[] chemoptions={	"realb","realj","hildaz0z1","cubicfit","linear"}; 
	
	//adjustable parameters
	public param
		beta=new param("fertbeta", "", 0.287, 0, 0.6), 			//tb fertilisation
		sidemix=new param("csidemix", "", 1.0/538.0, 0, 0.005), 	//ocean sideways mixing
		upwell=new param("cupwell", "m&per&yr", 0.44, 0, 1), 		//ocean upwelling
		hlmix=new param("chighlat", "m&per&yr", 38, 0, 70), 		//ocean high-lat mixing
		diffufac=new param("ceddydiff", "", 1, 0, 2), 			//to multiply by vertical diffusivity
		gasex=new param("asgasex", "mol&per&m2&per&ppm&per&yr", 0.06, 0, 0.12), //gas exchange rate mol m-2 ppmv-1 yr-1
		chemfeedback=new param("chemfbopt", true), 			//recalculate chemistry "constants" for each new temp?
		carbchem=new param("carbchemmenu", chemoptions, "realj"),	//determines which carbon chemistry formula to use
		//stepsperyear=new param("stepsperyear", "steps", 1, 1, 20),	//!not currently used
	histdeforbymassbal=new param("hdmbopt", false),			//historical deforestation by mass balance
		fbchfut=new param("fbchfut", false), 		//change fertbeta only after 2000
		viewbox=new param("depth", false),		   //view depth profiles?
		landuseemit=new param("lucfemit1990", "mega&ton&carbon&per&yr",1600, 0, 3000), //land use emissions in 1990, MtCyr-1 Use 2103 for consistency with Houghton data (rather high)
		respq10=new param("resp_q10","",1.0, 0.5, 2.5) //respiration q10
		; 
	public boolean usehisttempdata=false; 
	
	public void precalc(iob iob) {
		if (iob==carbonsetup) setupfluxes(); 
		if (iob==histdeforbymassbal && histdeforbymassbal.flag==false) for (int ns=0; ns<251; ns++) lucf[ns]=origlucf[ns]; 
		if (iob==landuseemit) scalelanduse(); 
	}
	
	//******************************************************
	//scale land use emissions (note -this replaces the high-land-use option originally introduced for brazilian proposal exercise)
	void scalelanduse() {
		for (int ns=0; ns<241; ns++) lucf[ns]=origlucf[ns]*((float)landuseemit.getval()/origlucf[240]); 
		for (int ns=241; ns<251; ns++) lucf[ns]=(float)(landuseemit.getval()*(250-ns) + 1070f*(ns-240))/10f; 
	}
	
	//*******************************************************
	//PLOTARRAYS
	
	//ncl =num low-lat ocean layers (excluding surface) ncb=total num boxes
	public int ncl=34, ncb=ncl+4+5; 
	
	//arrays to store data for plotting
	public float[]
		fossil=time.fyd(), totemit=time.fyd(),
		lucf = time.fyd(), origlucf=time.fyd(),
		ocsink = time.fyd(), tbsink = time.fyd(), totsink =time.fyd(),
		atppm = time.fyd(), atppmdata =new float[time.hiss1]
		; 
	
	//"real" box contents for viewbox  -beware 550*43*4=94K memory!
	public float[][] cq=new float[ncb][time.glos2]; 
	
	
	//****************************************************
	//working variables
	//store cumulative error wrt measured concentration
	public double error; 
	
	//system boxes -filled in setupcarbon() but used in mainloop()
	
	//neb =total boxes with extra non-linear flux, nqb = total boxes we need to query
	//int neb=4, nqb=3;
	
	//make standard arrays
	double[] cbox(){	return new double[ncb]; }
	
	//inner loop timesteps (maybe remove later?)
	int steps; double dt; 
	
	//Matrix for converting back  to get real box contents if viewbox (see setup)
	Matrix MV; 
	
	double[]
		cpropf=cbox(), ciq=cbox(), ciqi=cbox(), ciq99=cbox(), //ciq stores the box contents, i for iteration, 99 for starting at 2000
		crBIO=cbox(), crOC=cbox() 	//for total tbio & ocean sinks
		; 
	
	double[]
		crAT=cbox(), crLS=cbox(), crHS=cbox(), //rows for querying boxes
		scicAT=cbox(), scicLS=cbox(), scicHS=cbox(), scicNP=cbox(),  //columns for adding to them, premultiplied by step function
		rcicAT=cbox(), rcicLS=cbox(), rcicHS=cbox(), rcicNP=cbox(),  //ditto for ramp function
		crSO=cbox(), scicSO=cbox(), rcicSO=cbox(), crHU=cbox(), scicHU=cbox(), rcicHU=cbox() 		//extra for soil respiration
		; 
	
	//crWO=cbox(), crHU=cbox(),
	//scicWO=cbox(), scicHU=cbox(),
	//rcicWO=cbox(), rcicHU=cbox(),
	//wo, hu, dwo, dhu
	
	//various working variables
	//could tidy up variables by making a nonlin-"box" class, and then just go through all of them.
	
	//note these may be accessed from other modules such as responsibility
	double oceantemprise,  oldtotemit, oldatinc, atinc, oldlsinc, lsinc, oldhsinc, hsinc, oldnpinc, npinc; 
	
	//box contents (of interest)
	double at, ls, hs,  oldls, oldhs, tb, oldtb, oc, oldoc; 
	double dat ,dls, dhs, dnp; 
	//double odls, odhs, odnp, ndls, ndhs, ndnp;
	//store box contents and non-linear fluxes for starting at 2000
	double atinc99, lsinc99, hsinc99, npinc99, totemit99, dls99, dhs99, dnp99; 
	
	int i, j, n, o, b, ns, nr, year, tstep; 
	double guess, nit, ncit, oldnit=1, ciqr, diff, wit, check; 
	String err=""; 
	//added for vary soil respiration
	double landtemprise, soinc, huinc, oldsoinc, soinc99, huinc99, oldhuinc, so, hu, oldso, oldhu, dso, dhu, dso99, dhu99; 
	
	//****************************************************
	//atmosphere constants
	//ppmptc= ppmv per megaton carbon in the atmosphere
	double ppmpmtc=0.000471, atppmprein=280f, atppmy=atppmprein; 
	//ocean constants
	double ocdepth=3725.0, ocarea=3.616e14; 
	
	//chemistry/gasexchange variables, the [] are for low-lat (=0) and high-lat (=1) boxes
	double askodml, talk, totb, betab; 
	double[] octemp, saflin, saflin0, alpha, gamma, cubfitf, oafdml, askoaf, totc0, calk, hyd, k1, k2, kb, kw, k0; 
	//calk and hyd change as go along. k's are to store constants if not changing
	double nplin; //linear part of terrestial fertilisation
	
	//************************ main calculation for one timestep ***************************
	//MAIN CALC ROUTINES
	//note setup and calcstart further down
	//no precalc() or postcalc()
	
	public void calcstep(int ns) {
		
		//hist landusechange by inverse from concentration (smoothed)
		if (histdeforbymassbal.istrue() && ns<(time.fsy-time.gsy) && ns>5) {
			totemit[ns]=mitigation.inverseco2(ns, atppmdata[ns]); 
			lucf[ns]=(float)((4.0*lucf[ns-1]+(totemit[ns]-fossil[ns]))/5.0); 
			//	lucf[ns]=(float)((7.0*lucf[ns-1]+(totemit[ns]-fossil[ns]))/8.0);
		}
		//else {
		//add up total emissions (fossil+lucf). note bunker now included in fossil
		totemit[ns]=(fossil[ns]+lucf[ns]); 
		//}
		
		//feedback from ocean temperature
		//beware temperature normalisation to baseyear which isn't done until heatflux.postcalc!
		//so if calcfutureonly boxtemp[0] and boxtemp[249] are still normalised (prev loop)
		//but boxtemp[250] isn't yet
		
		//for history use data normalised to 1850
		
		if (usehisttempdata && ns<252) {
			float nfac=0, temprise; 
			for (int s=98; s<103; s++) nfac+=heatflux.proxytemp[s]/5f; 
			temprise=(ns<110 ? heatflux.proxytemp[ns] : heatflux.tempdata[ns])-nfac; 
			oceantemprise=temprise*0.847 ; 
			landtemprise=temprise*1.356 ; 
		}
		else {
			//Actually this isn't correct - should weight by areas of box!
			oceantemprise=(ns>0? ((heatflux.boxtemp[1][ns-1]+heatflux.boxtemp[2][ns-1])
				+((loop.calcfutureonly && ns<=250) ? (heatflux.boxoffset[1]+heatflux.boxoffset[2]) : 0) )/2.0: 0); 
			landtemprise=(ns>0? ((heatflux.boxtemp[0][ns-1]+heatflux.boxtemp[3][ns-1])
				+((loop.calcfutureonly && ns<=250) ? (heatflux.boxoffset[0]+heatflux.boxoffset[3]) : 0) )/2.0: 0); 
		}
		
		//-(heatflux.boxtemp[1][0]+heatflux.boxtemp[2][0]))/2.0: 0);
		
		//re-calculate "constants" for carbonate chemistry if considering feedback from temp change
		if (chemfeedback.istrue()) {	chemconsts(octemp[0]+oceantemprise, 0); chemconsts(octemp[1]+oceantemprise, 1); }
		
		//********inner steps loop**********
		//usually steps=1, use more only to test the rampfunction assumption works ok
		for (int step=0; step<steps; step++) {
			
			//first apply the prop & step functions to calculate base change (using data for beginning of year)
			for (n=0; n<ncb; n++) {	ciq[n]= cpropf[n]*ciq[n] +scicAT[n]*atinc + scicLS[n]*lsinc + scicHS[n]*hsinc +scicNP[n]*npinc +scicSO[n]*soinc + scicHU[n]*huinc; }
			
			//first guess assumes dls, dhs, dnp same as last time
			//or enable 2 lines below for changed by same as last time -but encourages minor oscillations!
			//ndls=2*dls-odls; ndhs=2*dhs-odhs; ndnp= 2*dnp-odnp;
			//odls=dls; odhs=dhs; odnp=dnp; dls=ndls; dhs=ndhs; dnp=ndnp;
			
			//store for use in attribution scaling
			oldls=ls; oldhs=hs; oldso=so; oldhu=hu; 
			
			//******** start of iteration loop ********
			nit=0; do {
				
				dat= (totemit[ns]-oldtotemit) -(dls+dhs+dnp+dso+dhu); 
				
				//apply ramp function and work out new contents of at, ls and hs
				if (nit==0) wit=1.0; else wit=0.3; //arbitrary iteration parameter
				
				at=0; ls=0; hs=0; so=0; hu=0; 
				for (n=0; n<ncb; n++) {
					ciqr=rcicAT[n]*dat + rcicLS[n]*dls + rcicHS[n]*dhs +rcicNP[n]*dnp  +rcicSO[n]*dso +rcicHU[n]*dhu; 
					ciqi[n]=wit*(ciq[n]+ciqr)+(1.0-wit)*ciqi[n]; 
					at+=crAT[n]*ciqi[n]; ls+=crLS[n]*ciqi[n]; hs+=crHS[n]*ciqi[n]; so+=crSO[n]*ciqi[n]; hu+=crHU[n]*ciqi[n]; 
				}
				
				//work out non-linear part of sea-air fluxes, 0 for low-lat box, 1 for high-lat box
				lsinc=-safnonlin(ls, 0); hsinc=-safnonlin(hs, 1); 
				
				//terrestrial biosphere fertilisation
				betab= (fbchfut.istrue() && ns<250 ? beta.getdef() : beta.getval() ); 
				npinc=60000*betab*Math.log((at*ppmpmtc/atppmprein)+1.0)-at*nplin; 
				
				//vary soil respiration
				//note 45000 and 15000 are the pre-ind steady-state fluxes, which depend on the inter-box rate constants (see setup below)
				soinc= (so*0.375+45000)*(1.0-Math.pow(respq10.getval(), landtemprise/10.0)); 
				huinc= (hu*0.01 +15000)*(1.0-Math.pow(respq10.getval(), landtemprise/10.0)); 
				
				//effect of nonlin fluexes on atmosphere
				atinc= totemit[ns]-(lsinc+hsinc+npinc+soinc+huinc); 
				
				guess=dls+ dhs+ dnp +dso +dhu; 
				dls=lsinc-oldlsinc; dhs=hsinc-oldhsinc; dnp=npinc-oldnpinc; dso=soinc-oldsoinc; dhu=huinc-oldhuinc; 
				check=dls+ dhs+ dnp +dso + dhu; 
				
				nit++; 
			} while (Math.abs(guess-check)>10 && nit<10); 
			//if difference >10MtC and no more than 10 iterations
			//********* end of iteration loop *********
			
			//{modloop.debug.write(""+(ns+1750)+"  lsinc="+(int)lsinc+" lin="+(int)(saflin[0]*ls)+" hsinc="+(int)hsinc+" lin="+(int)(saflin[1]*hs)+"\n");}
			//modloop.debug.write(""+(ns+time.gsy)+" "+nit+" "+ncit+"\n");
			//if (nit==10 && oldnit==0) {err+=(ns+time.gsy)+"-"; oldnit=10;}
			//if (nit!=10 && oldnit==10) {err+=(ns+time.gsy-1)+" "; oldnit=0;}
			//if (ns==550) {if (err!="") modloop.debug.write(err+"\n"); err=""; oldnit=0; }
			
			//permanently update ciq and record old values
			for (n=0; n<ncb; n++) {	ciq[n]=ciqi[n]; }
			oldatinc=atinc; oldlsinc=lsinc; oldhsinc=hsinc; oldnpinc=npinc; oldsoinc=soinc; oldhuinc=huinc; 
			oldtotemit=totemit[ns]; 
			
		}  //********** end inner steps loop ***********
		
		//work out new total biosphere and ocean contents
		oldtb=tb; tb=0; oldoc=oc; oc=0; 
		for (n=0; n<ncb; n++) {	tb+=ciq[n]*crBIO[n]; oc+=ciq[n]*crOC[n]; }
		
		//if ((ns==250) || (ns==350) || (ns==450)) System.out.println(""+(1750+ns)+" tot="+oc);
		
		//store arrays of "output" data for plotting and further calculations
		atppmy=atppmprein+(ppmpmtc*at); 
		if (ns>=0) {	tbsink[ns]=(short)(tb-oldtb); ocsink[ns]=(short)(oc-oldoc); atppm[ns]=(float)atppmy; }
		totsink[ns]=ocsink[ns]+tbsink[ns]; 
		
		//#############VIEW-BOX################
		//below is whole matrix multiplication for view box only
		//beware will be slow, this is not yet optimised
		
		if (viewbox.needed) {
			for (n=0; n<ncb; n++) {	cq[n][ns]=0; for (int m=0; m<ncb; m++) cq[n][ns]+=MV.getArray()[n][m]*ciq[m]; }
		}
		
		//#############END VIEW-BOX################
		
		//checking calcfutureonly start
		//if (ns>247 & ns<253) {
		//notepad.write("ns="+ns+" totemit="+totemit[ns]+" ocsink="+ocsink[ns]+" biosink="+tbsink[ns]+" atppm="+atppm[ns]+" oceantemprise="+oceantemprise+"\n");
		//notepad.write("2xot(ns-1)="+(heatflux.boxtemp[1][ns-1]+heatflux.boxtemp[2][ns-1])+" 2xot(0)="+(heatflux.boxtemp[1][0]+heatflux.boxtemp[2][0])+"\n");
		//}
		
	} //end calcstep()
	
	public void postcalc() {	calcerror(); }
	
	public void calcerror() {
		float sumdiff=0, sumdata=0, sumcalc=0, n=0, c, m, e; 
		for (int ns=0; ns<time.hiss1; ns++) {
			c=atppm[ns]; 
			m=atppmdata[ns]; 
			e=(ns>200 ? 0.1f : 0.5f); //assume bigger uncertainty pre 1950
			sumdiff+=(c-m)*(c-m)/e; 
			sumcalc+=c/e; 
			sumdata+=m/e; 
			n+=1f/e; 
		}
		error= Math.pow(sumdiff/n - (sumcalc/n - sumdata/n)* (sumcalc/n - sumdata/n), 0.5); 
	}
	
	//***********************************************
	//save 1999 state for adjusting future only -called from modloop mainloop
	
	public void save99() {
		atinc99=atinc; lsinc99=lsinc; hsinc99=hsinc; npinc99=npinc; 
		soinc99=soinc; huinc99=huinc; dso99=dso; dhu99=dhu; 
		totemit99=totemit[1999-time.gsy]; dls99=dls; dhs99=dhs; dnp99=dnp; 
		for (n=0; n<ncb; n++) {	ciq99[n]=ciq[n]; }
	}
	
	//**************************************
	//reset the boxes according to startyear
	//Note the 1999 data is set by running it from 1750 initially
	
	public void startstate(int startyear) {
		at=0; ls=0; hs=0; oldls=0; oldhs=0; oc=0; tb=0; 
		so=0; hu=0; 
		if (startyear==1750) {
			for (n=0; n<ncb; n++) ciq[n]=0; 
			atinc=0; lsinc=0; hsinc=0; npinc=0; oldtotemit=0; 
			dls=0; dhs=0; dnp=0; 
			//added for soil respiration
			soinc=0; huinc=0; dso=0; dhu=0; 
		} //end 1750
		
		else {	//assume startyear is 2000
			//not yet fixed fror soil respiration!
			for (n=0; n<ncb; n++) {	ciq[n]=ciq99[n]; }
			atinc=atinc99; lsinc=lsinc99; hsinc=hsinc99; npinc=npinc99; oldtotemit=totemit99; 
			dls=dls99; dhs=dhs99; dnp=dnp99; 
			//added for soil respiration
			soinc=soinc99; huinc=huinc99; dso=dso99; dhu=dhu99; 
		} //end 2000
		
		oldatinc=atinc; oldlsinc=lsinc; oldhsinc=hsinc; oldnpinc=npinc; 
		oldsoinc=soinc; oldhuinc=huinc; 
		//odls=dls; odhs=dhs; odnp=dnp;
		for (n=0; n<ncb; n++) ciqi[n]=ciq[n]; 
		tb=0; oc=0; for (n=0; n<ncb; n++) {	tb+=ciq[n]*crBIO[n]; oc+=ciq[n]*crOC[n]; }
		
		//temp fix: force run history even if start 2000
		//if (startyear==2000) for (int ns=0; ns<time.hiss; ns++) calcstep(ns);
		
	} //end startstate
	
	
	//**************************************************************
	//ocean-atmosphere-biosphere carbon cycle system setup
	//note units: rates per year, boxes contain Mt C, distances in m
	
	public void setupfluxes() {
		
		//**********************
		//setup various constants, for carbon chemistry and gas-exchange etc.
		
		steps=1; //(int)stepsperyear.getval();
		dt=1.0/steps; //timestep
		
		//saflin part of new production due to fertilisation
		nplin=60000*beta.getval()*ppmpmtc/atppmprein; 
		
		double dml=75.0, dtot=0.0; //dml =mixed layer depth
		double hfrac=0.16, lhf=(1.0-hfrac)/hfrac; //hfrac= fraction of area in high-lat b
		double[] dl=new double[ncl]; // depth of layer
		double[] diffu=new double[ncl]; // diffusivity for top of layer
		double ocu=upwell.getval(), ocw=hlmix.getval(), srate=sidemix.getval(); 
		
		for (n=0; n<ncl; n++) {
			dl[n]=(n<20 ? 49.0 : 196.0); if (n>0) dtot+=dl[n]; 
			diffu[n]=diffufac.getval()*(465.0+7096.0*Math.exp(-dtot/253.0)); 
		}
		
		//gas exchange rate in mol m-2 uatm-1 yr-1 from 14C budget, almost independent of temp, but note not exactly same as in Joos value!
		double airseak= gasex.getval(); 
		
		//useful combinations of constants
		//note the [] are for low-lat (=0) and high-lat (=1) boxes
		
		askodml=1000.0*airseak/dml; 
		oafdml=new double[2]; oafdml[0]=1.0e15 /(12*ocarea*(1.0-hfrac)*dml); oafdml[1]=1.0e15 /(12*ocarea*hfrac*dml); 
		//param to get flux in MtC when multiplied by ppm gradient
		askoaf=new double[2]; askoaf[0]= 1.2e-11 * airseak * ocarea* (1.0-hfrac); askoaf[1]= 1.2e-11 * airseak * ocarea * hfrac; 
		//air-sea exchange rate
		alpha=new double[2]; alpha[0]= ppmpmtc*askoaf[0]; alpha[1] = ppmpmtc*askoaf[1]; 
		
		hyd=new double[2]; hyd[0] = 1e-8; hyd[1] = 1e-8; 
		calk=new double[2]; calk[0] = talk-0.001; calk[1] = talk-0.001; 
		//calk and hyd are just starting values: will adjust as you go round the main loop
		//actually only need one of them -at the moment use hyd
		
		//temperature-dependent constants
		saflin=new double[2]; saflin0=new double[2]; gamma=new double[2]; cubfitf=new double[2]; 
		k0=new double[2]; k1=new double[2]; k2=new double[2]; kb=new double[2]; kw=new double[2]; 
		
		//ocean temperature
		octemp=new double[2]; octemp[0]=21.37; octemp[1]=1.38; //from original hilda?
		
		//for "real" chemistry calculations -need to know initial setup:
		talk = 0.0024; totb = 0.000416; // from dickson handbook
		totc0 = new double[2]; 
		totc0[0] = totc0(octemp[0]); totc0[1] = totc0(octemp[1]); 
		//based on above, and same constants, with pCO2=280, and T for each box. overall uptake is very sensitive to this setting!
		//note totc0 is not same for hd and ld, but can't really assume eqm either -will be a steady state flow round loop due to temp gradient.
		
		//linear part of sea-air flux to include in matrix
		saflin[0] = saflin(octemp[0]) ; saflin[1] = saflin(octemp[1]); 
		//also must remember original if saflin changes with temp!
		saflin0[0]= saflin[0]; saflin0[1]=saflin[1]; 
		//line below makes better linear part for high emissions scenarios (but not so efficient at beginning)
		if (carbchem.chosen=="realb" || carbchem.chosen=="realj"){	saflin[0] *= 2.0; saflin[1]*=2.0; }
		
		//work out chemistry constants for low and high lat boxes, depending on which formula you chose
		chemconsts(octemp[0], 0); chemconsts(octemp[1], 1); 
		
		
		//*********************************
		//make rates for exchange between boxes (gross rates per year)
		//rate[i][j] is the amount by which you have multiply box j to get the change in box i
		
		//ocean system: 0 to ncl-1 are LD layers, ncl is LS, ncl+1 is HS, ncl+2 is HD,
		//ncl+3 is atmosphere
		//biosphere system: ncl+4 is green, ncl+5 is wood, ncl+6 is soil, ncl+7 is humus, ncl+8 is new-production (temporary box)
		
		double[][] rate=new double[ncb][ncb]; for (i=0; i<ncb; i++) {	for (j=0; j<ncb; j++) {	rate[i][j]=0; }}
		
		//go through layers
		double rvu, rv, rh, rjff; 
		for (n=1; n<ncl; n++) {
			rvu=(2.0*diffu[n]-ocu*dl[n])/(dl[n-1]*(dl[n-1]+dl[n])); 
			rv =(2.0*diffu[n]+ocu*dl[n-1])/(dl[n]*(dl[n-1]+dl[n])); 
			rh = srate*lhf*dl[n]/ocdepth; 
			rate[n][n-1]+=rvu; rate[n-1][n-1]-=rvu; 
			rate[n-1][n]+=rv; rate[n][n]-=rv; 
			rate[n][ncl+2]+=rh; rate[ncl+2][ncl+2]-=rh; 
			rate[ncl+2][n]+=srate; rate[n][n]-=srate; 
		}
		
		//top layer and ls exchange:
		rvu=(8.0*diffu[0]/(3.0*dl[0]*dml))-ocu/dml; 
		rv =3.0*diffu[0]/(dl[0]*dl[0]); 
		rjff=diffu[0]/(3.0*dl[0]*dl[0]); 
		rate[0][ncl]+=rvu; rate[ncl][ncl]-=rvu; 
		rate[ncl][0]+=rv; rate[0][0]-=rv; 
		rate[0][1]+=rjff; rate[ncl][1]-=rjff; 
		//rjff is joos funny flux. To make like other layers, remove and replace with below:
		//rvu=(2.0*diffu[0]-ocu*dl[0])/(dml*(dml+dl[0]));
		//rv =(2.0*diffu[0]+ocu*dml)/(dl[0]*(dml+dl[0]));
		//rate[0][ncl]+=rvu; rate[ncl][ncl]-=rvu;
		//rate[ncl][0]+=rv; rate[0][0]-=rv;
		
		rh = srate*lhf*dl[0]/ocdepth; 
		rate[0][ncl+2]+=rh; rate[ncl+2][ncl+2]-=rh; 
		rate[ncl+2][0]+=srate; rate[0][0]-=srate; 
		
		//ls and hs exchange:
		rate[ncl][ncl+1]+=srate*lhf*dml/ocdepth; rate[ncl+1][ncl+1]-=srate*lhf*dml/ocdepth; 
		rate[ncl+1][ncl]+=srate+ocu/dml; rate[ncl][ncl]-=srate+ocu/dml; 
		//bottom u-flow:
		rate[ncl-1][ncl+2]+=ocu*lhf/ocdepth; rate[ncl+2][ncl+2]-=ocu*lhf/ocdepth; 
		//hs surf <=> deep
		rate[ncl+1][ncl+2]+= ocw/ocdepth; rate[ncl+2][ncl+2]-=ocw/ocdepth; 
		rate[ncl+2][ncl+1]+=(ocw+ocu/lhf)/dml; rate[ncl+1][ncl+1]-=(ocw+ocu/lhf)/dml; 
		
		//sea-air flux, saflin component only
		rate[ncl+3][ncl]+=saflin[0]; rate[ncl][ncl]-=saflin[0]; 
		rate[ncl+3][ncl+1]+=saflin[1]; rate[ncl+1][ncl+1]-=saflin[1]; 
		
		//air-sea flux
		rate[ncl][ncl+3]+=alpha[0]; rate[ncl+3][ncl+3]-=alpha[0]; 
		rate[ncl+1][ncl+3]+=alpha[1]; rate[ncl+3][ncl+3]-=alpha[1]; 
		
		//terrestrial biosphere fluxes
		rate[ncl+7][ncl+5]+=0.01; rate[ncl+5][ncl+5]-=0.01; //wood-humus
		rate[ncl+7][ncl+6]+=0.08333; rate[ncl+6][ncl+6]-=0.08333; //soil-humus
		rate[ncl+6][ncl+5]+=0.04; rate[ncl+5][ncl+5]-=0.04; //wood-soil
		rate[ncl+6][ncl+4]+=0.35; rate [ncl+4][ncl+4]-=0.35; //green-soil
		rate[ncl+5][ncl+8]+=0.41667; rate [ncl+8][ncl+8]-=0.41667; //newprodn-wood
		rate[ncl+4][ncl+8]+=0.58333; rate [ncl+8][ncl+8]-=0.58333; //newprodn-green
		rate[ncl+3][ncl+6]+=0.375; rate[ncl+6][ncl+6]-=0.375; //soil-atmosphere
		rate[ncl+3][ncl+7]+=0.01; rate[ncl+7][ncl+7]-=0.01; //humus-atmosphere
		rate[ncl+8][ncl+3]+=nplin; rate[ncl+3][ncl+3]-=nplin; //linear part of atmosphere-newprodn
		
		//*******************************
		
		double[] cicAT=cbox(), cicLS=cbox(), cicHS=cbox(), cicNP=cbox(); 
		double[] cicSO=cbox(), cicHU=cbox(); //extra for varying soil respiration
		
		// now put this into a jama Matrix
		EigenvalueDecomposition ED=new EigenvalueDecomposition (new Matrix(rate,ncb,ncb)); 
		MV=ED.getV(); 
		Matrix MVI=MV.inverse().transpose(); 
		
		//I need the rows of S for the 3 boxes LS,HS,AT, and the equiv columns of S-1
		//also need S-1 for terrestrial newproduction, and S for sum of all bio sink
		crLS=MV.getArray()[ncl]; 
		crHS=MV.getArray()[ncl+1]; 
		crAT=MV.getArray()[ncl+3]; 
		//added for soil respiration
		crSO=MV.getArray()[ncl+6]; 
		crHU=MV.getArray()[ncl+7]; 
		
		crBIO=new double[ncb]; crOC=new double[ncb]; 
		for (n=0; n<ncb; n++){
			crBIO[n]=0; for (i=0; i<5; i++) crBIO[n]+=MV.getArray()[ncl+4+i][n]; 
			crOC[n]=0; for (i=0; i<ncl+3; i++) crOC[n]+=MV.getArray()[i][n]; 
		}
		cicLS=MVI.getArray()[ncl]; 
		cicHS=MVI.getArray()[ncl+1]; 
		cicAT=MVI.getArray()[ncl+3]; 
		cicNP=MVI.getArray()[ncl+8]; 
		//added for soil respiration
		cicSO=MVI.getArray()[ncl+6]; 
		cicHU=MVI.getArray()[ncl+7]; 
		
		//checked diagonalization works OK!
		//R.eig().getV().print(10,6);
		//MV.times(ED.getD().times(MV.inverse())).print(10,6);
		//R.eig().getV().times(R.eig().getV().inverse()).print(10,6);
		//MV.print(10,6);
		
		//make cpropf, cstepf, crampf functions
		double[] Eig= ED.getRealEigenvalues(); double stepf,rampf; 
		for (n=0; n<ncb; n++) {
			cpropf[n]=Math.exp(Eig[n]*dt); 
			if (Math.abs(Eig[n])<0.000001) {	stepf=dt; rampf=dt/2.0; }
			else {	stepf=(cpropf[n]-1.0)/Eig[n]; rampf=(stepf-dt)/(Eig[n]*dt); }
			
			String dummy="ok here "+n; 
			
			scicLS[n]=stepf*cicLS[n]; 
			scicHS[n]=stepf*cicHS[n]; 
			scicAT[n]=stepf*cicAT[n]; 
			scicNP[n]=stepf*cicNP[n]; 
			rcicLS[n]=rampf*cicLS[n]; 
			rcicHS[n]=rampf*cicHS[n]; 
			rcicAT[n]=rampf*cicAT[n]; 
			rcicNP[n]=rampf*cicNP[n]; 
			//added for soil respiration
			scicSO[n]=stepf*cicSO[n]; 
			scicHU[n]=stepf*cicHU[n]; 
			rcicSO[n]=rampf*cicSO[n]; 
			rcicHU[n]=rampf*cicHU[n]; 
		}
		
		if (!viewbox.needed) MV=null; 
		ED=null; MVI=null; Eig=null; rate=null; //don't need these any more -save memory
	} //end setup ocean
	
	
	//*************************************************************
	//temperature dependent constants:
	
	//hilda z0z1 carbonate chemistry: excess pco2 (ppmv) = z0dc/(1-z1dc) where dc =excess tco2 (micro-mol/kg) , note t in C
	double z0(double t) {	return 1.7561-0.031618*t+0.0004444*t*t; }
	double z1(double t) {	return 0.004096-7.7086e-5*t+6.1e-7*t*t; }
	
	//solubility Weiss 74, t in K! assume s=35
	double k0(double t) {	return Math.exp(-60.2409 + 9345.17/t + 23.3585*Math.log(t/100) + 35*(0.023517 - 0.00023656*t + 0.00000047036*t*t )); }
	
	//borate dissociation constant, Dickson 1990, t in K, assume s=35
	double kb(double t) {	return Math.exp(-(28559.7/t) + 1016.43 - 181.498*Math.log(t) +0.314173*t); }
	
	//carbonic acid k1, k2 Roy 1993, t in K, assume s=35
	double k1(double t) {	return Math.exp(-(2331.08/t) -1.5529413*Math.log(t) + 3.18181); }
	double k2(double t) {	return Math.exp(-(3493.43/t) -0.2005743*Math.log(t) -7.69056); }
	
	//kw water dissociation, Millero 95, t in  K, assume s=35
	double kw(double t) {	return Math.exp(-(13145.2/t) -17.4432*Math.log(t) +113.0395); }
	
	//preindustrial total carbon (mol/l), for pco2=280, talk=0.0024
	double totc0(double t) {	return (0.002225-0.0000095*t); }
	
	//saflin factor dpco2/dTCO2 at c0 ppm/micromolar
	double saflin(double t) {	return askodml*(1.68 -0.036*t +0.0006*t*t); }
	
	//cubic-fit formula factor
	double cubfitf(double t) {	return askodml*(80.0 -3.5*t +0.05*t*t)/1e6; }
	
	
	
	//************************************************
	//routine to change chemistry "constants": (called within mainloop if temperature feedback)
	
	void chemconsts(double t, int b) {
		if (carbchem.chosen=="hildaz0z1") {	saflin[b] = z0(t)*askodml; gamma[b]= z1(t)*oafdml[b]; }
		if (carbchem.chosen=="saflin") {	saflin[b] = saflin(t); }
		if (carbchem.chosen=="cubicfit") {	saflin[b] = saflin(t); cubfitf[b] = cubfitf(t)*oafdml[b]*oafdml[b]; }
		if (carbchem.chosen=="realb" || carbchem.chosen=="realj") {	double tk=t+273.15; k0[b]=k0(tk); k1[b]=k1(tk); k2[b]=k2(tk); kb[b]=kb(tk); kw[b]=kw(tk); }
	} //end chemconsts
	//check constants OK: System.out.println(b+" "+t+" "+k0[b]+" "+k1[b]+" "+k2[b]+" "+kb[b]+" "+kw[b]);
	
	
	
	//************************************************
	//functions for nonlinear components of fluxes from sea to air, depending on carbchem.chosen
	
	double safnonlin(double xsc, int b){
		if (carbchem.chosen=="hildaz0z1") return (saflin[b]*gamma[b]*xsc*xsc)/(1.0-(gamma[b]*xsc)) + (chemfeedback.istrue()? xsc*(saflin[b]-saflin0[b]) : 0); 
		else if (carbchem.chosen=="cubicfit") return (cubfitf[b]*xsc*xsc*xsc)+ (chemfeedback.istrue()? xsc*(saflin[b]-saflin0[b]) : 0); 
		else if (carbchem.chosen=="saflin" && chemfeedback.istrue()) return xsc*(saflin[b]-saflin0[b]) ; 
		
		else if (carbchem.chosen=="realb" || carbchem.chosen=="realj") {
			double totc = totc0[b] + xsc * oafdml[b] /1.0e6 ; 
			
			ncit=0; 
			
			if (carbchem.chosen=="realb") {	//ben's iteration method -use old h to calculate calk from talk, solve quadratic for new h
				double hydold; 
				do {
					ncit++; 
					hydold=hyd[b]; 
					calk[b]= talk - (totb*kb[b]/(hyd[b]+kb[b])) - (kw[b]/hyd[b]) +hyd[b]; 
					double root=((totc-calk[b])*(totc-calk[b]))-(4*calk[b]*(calk[b]-2*totc)*k2[b]/k1[b]); 
					hyd[b] = (k1[b]/(2*calk[b]))*((totc-calk[b])+Math.pow(root,0.5)); 
				} while (Math.abs(1-hydold/hyd[b])>0.00001 && ncit<10); 
			}
			
			else {	//jesper's iteration method from basic program
				double ph=6.0, dph=-0.5, yold=0.0, a, y; 
				do {
					ncit++; 
					hyd[b]=Math.pow(10.0,-ph); 
					a=((k1[b]/hyd[b]+2.0*k1[b]*k2[b]/(hyd[b]*hyd[b]))/(1.0+k1[b]/hyd[b]+k1[b]*k2[b]/(hyd[b]*hyd[b])))*totc; 
					y= talk -a -kb[b]*totb/(hyd[b]+kb[b]) - kw[b]/hyd[b] + hyd[b]; 
					dph*=y/(yold-y); yold=y; ph+=dph; 
				} while (Math.abs(dph)>0.00001 && ncit<10); 
			}
			
			double co2= totc * (hyd[b]*hyd[b])/(hyd[b]*hyd[b] + k1[b]*hyd[b] + k1[b]*k2[b]); 
			return (askoaf[b] * ((1e6 * co2 / k0[b])-atppmprein))- saflin[b]*xsc ; 
			
			//note: saflin linear flux was included in matrix to help smooth the response, so subtract it here
		} //end real
		
		else return 0; //saflin and no chemfeedback from temp
	}
	
	//********************************************************
	
} //end carbon

//prob with adding extra bio-feedbacks is
//1: need total carbon
//2: inefficiencies as start to query many rows etc.
//3: wd be better to seperate ocean and tbio 2 systems
