
//Abatement (mitigation) and damage (Adaptation?) costs 
//Experimental!  May be developed further with clim-neg project Louvain
//Please note, the author of JCM does not trust these simple formulae!

//Developed January 2002 Louvain-la-neuve


package jcm.mod;
import jcm.*;

public class costs extends module  {
	
	//*****************************
	//standard module bits
	
	public void setinteractions() {
		setaffectedby(regshares); 
		setaffectedby(heatflux); 
		setaffectedby(people); 
	}
	
	
	int nregs=14; 
	
	
	//***************************************************
	//beware world av not correct in data below, put it in to stop exceptions but need to calculate!
	//nordhaus abate cost b1 b1*GDP*frac abatement^b2
	double[] b1={	0.07, 0.07, 0.05, 0.05, 0.10, 0.15, 0.10, 0.15, 0.10, 0.10, 0.10, 0.10, 0.10, 0.05}; 
	double[] b2={	2.887, 2.887, 2.887, 2.887, 2.887, 2.887, 2.887, 2.887, 2.887, 2.887, 2.887, 2.887, 2.887, 2.887}; 
	//nordhaus damage cost a1*GDP*DT^a2
	double[] a1={	0.01102, 0.01102, 0.01174, 0.01174, 0.01000, 0.00857, 0.02093, 0.01523, 0.02903, 0.02903, 0.02903, 0.02903, 0.015, 0.01174}; 
	double[] a2={	1.5,1.5,1.5,1.5,1.5,1.5,1.5,1.5,1.5,1.5,1.5,1.5,1.5,1.5}; 
	//johan paper abatement cost G$ =a*R^b R in GtC
	double[] macgema={	373.612, 337, 290.224, 241.278, 694.559, 694.559, 269.217, 199.020, 523.793, 496.158, 500, 235.499, 1, 1}; 
	double[] macgemb={	1.220, 1.372, 1.251, 1.426, 1.100, 1.100, 1.279, 1.634, 1.209, 1.180, 1.2, 1.846, 1, 1}; 
	//note some interpolations between regions
	
	//****************************
	
	public float[][]
		abate=new float[nregs][time.regs2],
		damage=new float[nregs][time.regs2],
		total=new float[nregs][time.regs2],
		discounted=new float[nregs][time.regs2]
		; 
	
	public param
		discountrate=new param("discountrate", "", 0.02, 0, 0.1),
		macgem=new param("macgem", false), //use mac-gem abatement cost functions
		abatepow=new param("abatepow", "", b2[0], 0, 6),
		abatelin=new param("abatelin", "", 1, 0, 3),
		damagepow=new param("damagepow", "", a2[0], 0, 6),
		damagelin=new param("damagelin", "", 1, 0, 3),
		popweight=new param("popweight", false)
		; 
	
	public float totdam=0, totab=0, totcost=0, totgdp=0; 
	double mu; 
	
	//***********************************************************
	
	public void calcstep(int ns) {
		int rs=ns-(time.rsy-time.gsy); 
		if (rs>=0 && rs<=(time.rey-time.rsy)) {
			for (int nr=0; nr<12 ; nr++) {
				if (rs>70 && rs<=(time.rey-time.rsy)){	//gdp data starts 1970
					
					//damage cost
					damage[nr][rs]=(float)(damagelin.getval()*a1[nr]*Math.pow(heatflux.glotemp[ns]/2.5,damagepow.getval())*people.gdp[nr][rs]); 
					
					if (rs>=100){	//abatement starts 2001
						
						//abatement cost
						if (macgem.istrue()) {
							mu=regshares.abate[nr][rs]/1000f; if (mu<0) mu=0; 
							abate[nr][rs]=(float)(abatelin.getval()*macgema[nr]*Math.pow(mu, macgemb[nr])); 
						}
						else {
							mu=regshares.abate[nr][rs]/regshares.baseemit[nr][rs]; if (mu<0) mu=0; if (mu>1) mu=1; 
							abate[nr][rs]=(float)(abatelin.getval()*b1[nr]*people.gdp[nr][rs]*Math.pow(mu, abatepow.getval())); 
						}
						//total cost
						total[nr][rs]=abate[nr][rs]+damage[nr][rs]; 
						
					} //if
					else {	abate[nr][rs]=-999; total[nr][rs]=damage[nr][rs]; }
				} //if
				else {	damage[nr][rs]=-999; total[nr][rs]=-999; }
			} //nr
		} //rs
		
	} //end calcstep
	
	public void postcalc() {
		for (int nr=0; nr<12 ; nr++) {
			for (int rs=(time.rey-time.rsy); rs>=0; rs--) {
				if (rs==(time.rey-time.rsy)) discounted[nr][rs]=0; 
				else {
					if (rs>70) discounted[nr][rs]=total[nr][rs]+discounted[nr][rs+1]*(1f-(float)discountrate.getval()); 
					else discounted[nr][rs]=-999; 
				}
			} //rs
		} //nr
		
		totdam=0; totab=0; totgdp=0; totcost=0; 
		
		for (int rs=200; rs>=100; rs--) {
			totdam=totdam*(1f-(float)discountrate.getval()); 
			totab=totab*(1f-(float)discountrate.getval()); 
			totgdp=people.gdp[12][rs] + totgdp*(1f-(float)discountrate.getval()); 
			for (int nr=0; nr<12 ; nr++) {
				totab+=abate[nr][rs]*(popweight.istrue() ? (people.pop[nr][rs]/people.gdp[nr][rs]) * (people.gdp[12][rs]/people.pop[12][rs]) : 1.0); 
				totdam+=damage[nr][rs]*(popweight.istrue() ? (people.pop[nr][rs]/people.gdp[nr][rs]) * (people.gdp[12][rs]/people.pop[12][rs]) : 1.0); 
			}
		}
		totcost=totdam+totab; 
	} //postcalc
	
} //end costs
	
/*popweighting:
orig is impact*gdp/pop*pop (ie impact*gdp)
we want to assume global av gdp/cap =>mult by av gdp/cap, and local pop/gdp
*/
