//loads historical and sres data

package jcm.mod;
import java.io.*;
import java.net.*;
import jcm.*;

public class loaddata extends module {
	
	static DataInputStream datain; 
	int i,j; 
	
	//public void initsetup() {  super.initsetup(); getdata();}
	
	public void precalc() {	getdata(); }
	public void getdata()  {	try {
			
			URL datafile=new URL(iob.codebase, "data/data.dat"); 
			datain = new DataInputStream(new BufferedInputStream(datafile.openStream())); 
			
			//historical global
			loadarray(carboncycle.fossil,110); 
			loadarray(carboncycle.lucf,100); //1850-1990
			loadarray(oghga.ch4emit,110); 
			loadarray(oghga.soxemit,100); 
			loadarray(oghga.coemit,15); 
			
			loadarray(carboncycle.atppmdata,110); 
			loadarray(oghga.ch4conc); 
			loadarray(oghga.n2oconc); 
			loadarray(oghga.tropo3du,100); 
			
			loadarray(oghga.hfchistconc); 
			loadarray(oghga.fgconc,12,0); //startyr 1930=0 cfcs 12-26
			
			loadarray(radfor.solarrfdata); 
			loadarray(radfor.volcorig); 
			
			loadarray(heatflux.tempdata,110); //1860 up to 2002 !
			loadarray(heatflux.proxytemp); //up to 1991
			
			System.out.println("loaded hist-glob-data-ok"); 
			
			//historical regional
			loadarray(regshares.emit); 
			loadarray(people.pop); 
			loadarray(people.gdp, 70); 
			loadarray(people.en, 71); 
			
			System.out.println("loaded hist-reg-data-ok"); 
			
			//sres global
			loadarray(sres.fosemit); 
			loadarray(sres.lucemit); 
			loadarray(sres.soxemit); 
			loadarray(sres.ch4emit); 
			loadarray(sres.n2oemit); 
			loadarray(sres.noxemit); 
			loadarray(sres.coemit); 
			loadarray(sres.vocemit); 
			loadarrayset(sres.hfcemit); 
			
			System.out.println("loaded sres-glob-data-ok"); 
			
			//sres regional
			loadarray(sres.regemit); 
			loadarray(sres.pop); 
			loadarray(sres.gdppc); 
			loadarray(sres.enpc); 
			
			System.out.println("loaded sres-reg-data-ok"); 
			
			//sres calculated for comparison only
			loadarray(sres.bernmid); 
			for (int i=0; i<6; i++) loadarray(sres.rfdata[i]); 
			loadarray(sres.rfdata[6][0]); for (int j=1; j<7; j++) sres.rfdata[6][j]=sres.rfdata[6][0]; //cfc same for all
			for (int i=7; i<10; i++) loadarray(sres.rfdata[i]); 
			loadarray(sres.tempchange); 
			for (int i=0; i<7; i++) loadarray(sres.sldata[i]); 
			
			System.out.println("loaded sres-calc-data-ok"); 
			
			//historical responsibility data - for brazilian proposal exercise
			loadarray(responsibility.ehch4); 
			loadarray(responsibility.ehn2o); 
			loadarray(responsibility.regluc); 
			loadarray(responsibility.sresfos); 
			loadarray(responsibility.sresluc); 
			loadarray(responsibility.sresch4); 
			loadarray(responsibility.sresn2o); 
			loadarray(responsibility.srespop); 
			loadarray(responsibility.sresgnp); 
			
			System.out.println("loaded responsibility-data-ok"); 
			
			datain.close(); 
		} catch (IOException e) {	System.err.println("loaded Caught IOException: " + e); }//.getMessage()); }
		
		atco2data(); 
		makebunker(); 
		adjustments(); 
		
	} //end getdata
	
	//***********************
	void adjustments() {
		
		//temp fix for fossil co2 - cdiac 98
		for (int i=0; i<253; i++) carboncycle.fossil[i]=(float)fossil[i]; 
		
		//scale houghton landuseco2 down
		//note SRES 1990 is only 1.1Gt whilst houghton is 2.103!
		//note TAR says 1980s central estimate 1.7Gt, houghton 1980s av is 2.017
		//but where did 5.5/7.0 come from?
		float haf=(float)(5.5/7.0); for (i=110; i<241; i++) carboncycle.lucf[i]*=haf; 
		//fill in last 10 years and join to sres start
		for (i=241; i<251; i++) carboncycle.lucf[i]=(carboncycle.lucf[240]*(250-i)+1070f*(i-240))/10f; 
		
		//adjust methane to match sres at 2000
		for (i=0; i<251; i++) oghga.ch4emit[i]*=323f/380f; 
		
		//adjust soxemit to match sres at 1990 (70.9) and connect linearly to 2000 (69.0)
		for (i=0; i<241; i++) oghga.soxemit[i]*=70.9f/oghga.soxemit[240]; 
		for (i=241; i<251; i++) oghga.soxemit[i]=((i-240)*69.0f+(250-i)*oghga.soxemit[240])/10f; 
		
		//solarrf *1.5 to make 0.3 increase 1750 to 2000 as per IPCC TAR!
		for (i=0; i<251; i++) radfor.solarrfdata[i]*=1.5f; 
		
		//volcano numbers were x10
		for (i=0; i<251; i++) radfor.volcorig[i]*=-0.1f; 
		
		//normalise tempdata and proxytemp to 1960-90
		for (i=110; i<253; i++) heatflux.tempdata[i]-=0.42; 
		for (i=0; i<242; i++) heatflux.proxytemp[i]+=0.04; 
		
		//remove pop/gdp data for denmark (this region is now bunker!}
		for (i=0; i<=100; i++) {	people.pop[13][i]=0; people.gdp[13][i]=0; }
		
		
		//multiply gdp and en by population (original from image was per-capita)
		for (i=0; i<13; i++) {
			for (j=70; j<101; j++) people.gdp[i][j]*=0.001f*people.pop[i][j]; 
			for (j=71; j<101; j++) people.en[i][j]*=people.pop[i][j]; 
		}
		
		//temp fix for recent reduction in china emissions (china is region 7)
		//according to cdiac and iea, 6% reduction 1996-8, assume constant thereafter
		float cb=regshares.emit[7][96]; 
		regshares.emit[7][97]=cb*0.97f; //carboncycle.fossil[247]-=cb*0.03f;
		regshares.emit[7][98]=cb*0.94f; //carboncycle.fossil[248]-=cb*0.06f;
		regshares.emit[7][99]=cb*0.94f; //carboncycle.fossil[249]-=cb*0.06f;
		regshares.emit[7][100]=cb*0.94f; //carboncycle.fossil[250]-=cb*0.06f;
		
		//since we now assume fossil is correct (CDIAC 98), scale regional emissions (+bunker) accordingly.
		for (int i=0; i<101; i++) {
			float total=regshares.bunker[i+150]; 
			for (int r=0; r<12; r++)  total+=regshares.emit[r][i]; 
			regshares.bunker[i+150]*=carboncycle.fossil[i+150]/total; 
			for (int r=0; r<14; r++) regshares.emit[r][i]*=carboncycle.fossil[i+150]/total; 
			regshares.emit[12][i]=carboncycle.fossil[i+150]; 
		}
		
		//***********************
		//fill in gaps in data
		
		for (j=0; j<110; j++) {
			carboncycle.atppmdata[j]=(float)(280.0+(double)j*8.0/110.0); 
			//carboncycle.fossil[j]=(int)(carboncycle.fossil[110]*j/110.0);
			carboncycle.lucf[j]=(short)(carboncycle.lucf[110]*j/110.0); 
			oghga.ch4emit[j]=(float)(oghga.ch4emit[110]*j/110.0); 
			if (j<100) oghga.tropo3du[j]=25; 
			//radfor.solarrfdata[j]=0;
			heatflux.tempdata[j]=0; 
		}
		
		//store origlucf in case change with histdeforbymassbal
		for (int j=0; j<251; j++) carboncycle.origlucf[j]=carboncycle.lucf[j]; 
		
	} //end adjustments
	
	//***********************
	void atco2data() {
		//need more precision in atCO2 if calc deforestn by mass bal,
		//standard method saving data one byte per number not good enough
		double[] atco2= //from 1860 to 2000
		{	288,288.1,288.2,288.2,288.3,288.4,288.5,288.6,288.7,288.7,288.8,288.9,289,289.1,289.3,289.4,289.5,289.6,289.7,289.8,290,290.1,290.2,290.4,290.5,290.7,290.8,291,291.2,291.3,291.5,291.7,291.8,292,292.2,292.4,292.6,292.7,292.9,293.1,293.3,293.5,293.8,294,294.3,294.6,294.9,295.2,295.5,295.8,296.1,296.4,296.7,297,297.4,297.6,297.9,298.2,298.5,298.8,299.1,299.4,299.6,299.9,300.3,300.6,300.9,301.2,301.6,301.9,302.3,302.6,302.9,303.1,303.4,303.6,303.9,304.3,304.6,304.9,305.3,305.7,306.1,306.4,306.8,307.2,307.5,307.9,308.2,308.7,309,309.5,310.1,310.6,311.2,311.8,312.5,313.2,313.9,314.6,315.4,316.2,317,317.9,318.8,319.7,320.8,321.8,322.8,323.9,325.1,326.3,327.5,328.7,330.1,331.3,332.6,334,335.4,336.9,338.4,339.9,341.3,342.7,344.1,345.6,347.2,348.8,350.5,352.2,353.9,355.6,357.3,358.9,360.5,362.2,363.9,365.5,367.2,368.9,370.6}; 
		
		//mauna loa from 1960 to 2000 real data shows 1998 effect
		double[] atco2ml= {	316.91, 317.63, 318.47, 319.02, 319.52, 320.09, 321.34, 322.12, 323.11, 324.60, 325.65, 326.32, 327.51, 329.61, 330.29, 331.16, 332.18, 333.88, 335.52, 336.89, 338.67, 339.95, 341.09, 342.75, 344.44, 345.87, 347.14, 348.99, 351.44, 352.94, 354.19, 355.62, 356.36, 357.10, 358.86, 360.90, 362.58, 363.84, 366.58, 368.28, 369.40}; 
		//note older data above says 315.4 in 1960, new says 316.9
		//so multiply new data-288 by 28.5/27
		
		for (j=110; j<210; j++) carboncycle.atppmdata[j]=(float)(288f+(atco2[j-110]-288f)*(28.5f/27f)); 
		for (j=210; j<251; j++) carboncycle.atppmdata[j]=(float)atco2ml[j-210]; 
		
		//ditto ch4 and n2o if marginal d(rf)/d(conc) in responsibility
		double[] ch4conc = //ppb 1750-2000
{732.46, 733.18, 733.89, 734.59, 735.29, 735.97, 736.65, 737.31, 737.96, 738.60, 739.23, 739.85, 740.46, 741.05, 741.64, 742.22, 742.78, 743.34, 743.90, 744.44, 744.97, 745.50, 746.02, 746.54, 747.05, 747.56, 748.06, 748.56, 749.05, 749.54, 750.03, 750.51, 751, 751.49, 751.99, 752.49, 753, 753.51, 754.03, 754.57, 755.11, 755.67, 756.25, 756.84, 757.44, 758.07, 758.71, 759.38, 760.07, 760.78, 761.51, 762.28, 763.08, 763.90, 764.76, 765.65, 766.57, 767.51, 768.48, 769.48, 770.49, 771.53, 772.58, 773.65, 774.74, 775.84, 776.95, 778.08, 779.21, 780.36, 781.51, 782.68, 783.85, 785.02, 786.20, 787.38, 788.57, 789.75, 790.93, 792.12, 793.29, 794.47, 795.63, 796.79, 797.94, 799.07, 800.20, 801.31, 802.40, 803.47, 804.53, 805.56, 806.59, 807.59, 808.59, 809.59, 810.58, 811.58, 812.59, 813.60, 814.63, 815.68, 816.74, 817.82, 818.93, 820.06, 821.20, 822.36, 823.54, 824.74, 825.95, 827.18, 828.43, 829.70, 830.98, 832.27, 833.59, 834.91, 836.26, 837.62, 839, 840.39, 841.80, 843.24, 844.69, 846.17, 847.66, 849.19, 850.73, 852.31, 853.91, 855.55, 857.21, 858.92, 860.66, 862.44, 864.27, 866.14, 868.06, 870.04, 872.07, 874.15, 876.30, 878.51, 880.78, 883.12, 885.53, 888, 890.55, 893.16, 895.85, 898.61, 901.44, 904.35, 907.33, 910.39, 913.53, 916.75, 920.04, 923.42, 926.87, 930.41, 934.03, 937.74, 941.53, 945.41, 949.38, 953.43, 957.58, 961.82, 966.15, 970.59, 975.12, 979.75, 984.49, 989.34, 994.30, 999.39, 1004.59, 1009.93, 1015.41, 1021.03, 1026.81, 1032.75, 1038.85, 1045.13, 1051.59, 1058.24, 1065.08, 1072.13, 1079.39, 1086.87, 1094.58, 1102.53, 1110.72, 1119.17, 1127.88, 1136.86, 1146.11, 1155.65, 1165.48, 1175.60, 1186.03, 1196.76, 1207.79, 1219.13, 1230.77, 1242.71, 1254.94, 1267.47, 1280.29, 1293.39, 1306.75, 1320.37, 1334.24, 1348.35, 1362.70, 1377.27, 1392.05, 1407.03, 1422.20, 1437.53, 1452.99, 1468.57, 1484.22, 1499.92, 1515.60, 1531.23, 1546.76, 1562.13, 1577.29, 1592.20, 1606.79, 1621.02, 1634.83, 1648.17, 1661.02, 1673.37, 1685.24, 1696.69, 1707.78, 1718.63, 1729.34, 1723.5, 1728.7, 1733.9, 1739.1, 1744.3, 1749.6, 1754.8, 1760.0};
				double[] n2oconc= //ppb 1750-2000 (data to 1998, added last 2 by extrapolate)
{271.68, 271.70, 271.72, 271.74, 271.77, 271.79, 271.81, 271.84, 271.86, 271.88, 271.91, 271.93, 271.95, 271.98, 272, 272.02, 272.05, 272.07, 272.09, 272.12, 272.14, 272.17, 272.19, 272.21, 272.24, 272.26, 272.29, 272.31, 272.34, 272.36, 272.38, 272.41, 272.44, 272.46, 272.49, 272.51, 272.54, 272.56, 272.59, 272.62, 272.64, 272.67, 272.70, 272.72, 272.75, 272.78, 272.81, 272.83, 272.86, 272.89, 272.92, 272.95, 272.98, 273.01, 273.04, 273.07, 273.10, 273.13, 273.16, 273.19, 273.22, 273.26, 273.29, 273.32, 273.36, 273.39, 273.43, 273.46, 273.50, 273.53, 273.57, 273.61, 273.64, 273.68, 273.72, 273.76, 273.80, 273.84, 273.88, 273.92, 273.96, 274.01, 274.05, 274.09, 274.14, 274.19, 274.23, 274.28, 274.33, 274.37, 274.42, 274.47, 274.52, 274.57, 274.63, 274.68, 274.73, 274.79, 274.84, 274.90, 274.96, 275.01, 275.07, 275.13, 275.19, 275.25, 275.32, 275.38, 275.44, 275.51, 275.57, 275.64, 275.71, 275.78, 275.85, 275.92, 275.99, 276.07, 276.14, 276.22, 276.29, 276.37, 276.45, 276.53, 276.61, 276.69, 276.78, 276.86, 276.95, 277.03, 277.12, 277.21, 277.30, 277.39, 277.49, 277.58, 277.68, 277.77, 277.87, 277.97, 278.07, 278.18, 278.28, 278.38, 278.49, 278.60, 278.71, 278.82, 278.93, 279.05, 279.16, 279.28, 279.40, 279.52, 279.64, 279.76, 279.88, 280.01, 280.14, 280.27, 280.39, 280.53, 280.66, 280.79, 280.93, 281.07, 281.20, 281.34, 281.48, 281.63, 281.77, 281.91, 282.05, 282.20, 282.34, 282.48, 282.63, 282.77, 282.92, 283.07, 283.21, 283.36, 283.51, 283.66, 283.81, 283.97, 284.13, 284.28, 284.45, 284.61, 284.78, 284.95, 285.13, 285.32, 285.51, 285.70, 285.90, 286.11, 286.33, 286.55, 286.78, 287.02, 287.28, 287.54, 287.81, 288.09, 288.38, 288.69, 289.01, 289.34, 289.68, 290.04, 290.42, 290.80, 291.21, 291.63, 292.07, 292.52, 292.99, 293.48, 293.99, 294.52, 295.06, 295.63, 296.21, 296.82, 297.45, 298.10, 298.77, 299.47, 300.18, 300.92, 301.68, 302.45, 303.24, 304.03, 304.82, 305.61, 306.39, 307.16, 307.93, 308.69, 309.44, 310.19, 310.92, 311.65, 312.38, 313.11, 313.83, 314.55, 315.27}; //last 2 added
				
				for (j=0; j<251; j++) oghga.ch4conc[j]=(float)ch4conc[j]; 
				for (j=0; j<251; j++) oghga.n2oconc[j]=(float)n2oconc[j]; 
			}
			
			//temporary replacement by CDIAC global98 data (1751-1998, 1750, 1999, 2000 added)
			//later will move to savedata
			//added also continuation for 2001, 2002 to help stabilisation start smoothly
double[] fossil= {3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 7, 8, 8, 10, 9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 12, 13, 14, 14, 14, 14, 14, 15, 16, 16, 17, 17, 18, 18, 18, 24, 23, 23, 24, 24, 25, 29, 29, 30, 31, 33, 34, 36, 37, 39, 43, 43, 46, 47, 50, 54, 54, 57, 59, 69, 71, 76, 77, 78, 83, 91, 95, 97, 104, 112, 119, 122, 130, 135, 142, 147, 156, 173, 184, 174, 188, 191, 194, 196, 210, 236, 243, 256, 272, 275, 277, 281, 295, 327, 327, 356, 372, 374, 370, 383, 406, 419, 440, 465, 507, 534, 552, 566, 617, 624, 663, 707, 784, 750, 785, 819, 836, 879, 943, 850, 838, 901, 955, 936, 806, 932, 803, 845, 970, 963, 975, 983, 1062, 1065, 1145, 1053, 940, 847, 893, 973, 1027, 1130, 1209, 1142, 1192, 1299, 1334, 1342, 1391, 1383, 1160, 1238, 1392, 1469, 1419, 1630, 1767, 1795, 1841, 1865, 2043, 2177, 2270, 2330, 2463, 2578, 2595, 2701, 2848, 3009, 3146, 3306, 3412, 3588, 3802, 4075, 4227, 4394, 4633, 4641, 4613, 4879, 5018, 5078, 5368, 5297, 5125, 5080, 5067, 5241, 5405, 5573, 5701, 5926, 6035, 6096, 6186, 6089, 6090, 6236, 6378, 6530, 6628, 6608, 6650, 6700, 6750, 6800};
				
				//note this is *not* consistent with CDIAC nation96 data used to make JCM regional emissions
				//so scale them down accordingly
				
				
				//*****************************
				void makebunker() {
					//past bunker fuel emissions
					
					//original formulae just aircraft!
					//for (j=0; j<170; j++) regshares.bunker[j]=(short)0;
					//for (j=170; j<200; j++) regshares.bunker[j]=(short)(j-170);
					//for (j=200; j<=250; j++) regshares.bunker[j]=(short)(regshares.bunker[j-1]*1.05);
					
					for (j=0; j<150; j++) regshares.bunker[j]=(short)0; 
					for (j=150; j<200; j++) regshares.bunker[j]=(short)(j-150); 
					for (j=200; j<251; j++) regshares.bunker[j]=(short)(regshares.bunker[j-1]*1.04); 
					
					//temporarily add bunker into fossil for history
					//(looks better on carbon cycle plot)
					//and remove references to it in carbon module
					
					//for (j=0; j<251; j++) carboncycle.fossil[j]+=regshares.bunker[j];
					
					//now assume cdiac97 totals included bunker
				}
				
				
				//********************************
				//general methods to load an array:
				
				static int getlen() {	int l=0; try {	l=datain.readShort(); } catch (IOException e) {	System.out.println(e); } return l; }
				
				//simplest 1D array
				static void loadarray(float[] id) {	loadarray(id,0); }
				
				//1D with offset start
				static void loadarray(float[] id, int s) {	int l=getlen(); loadarray(id, s, l); }
				
				//1D array, start and length
				static void loadarray(float[] id, int s, int l) {
					try {
						float min=datain.readFloat(), max=datain.readFloat(), rf=(max-min)/255f; 
						for (int i=0; i<l; i++) id[i+s]=min+rf*datain.readUnsignedByte(); 
					} catch (IOException e) {	System.out.println(e); }
				} //end load
				
				
				//2D array
				static void loadarray(float[][] id) {	loadarray(id,0); }
				
				//2D array, starting id[][] at s
				static void loadarray(float[][] id, int s) {	loadarray(id, 0, s); }
				
				//2D array, starting id[] at si, id[][] at sj
				static void loadarray(float[][] id, int si, int sj) {
					int li=getlen(); int lj=getlen(); 
					for (int i=si; i<(si+li); i++) loadarray(id[i], sj, lj); 
				}
				
				//3D array regular
				static void loadarray(float[][][] id) {
					int li=getlen(); int lj=getlen(); int lk=getlen(); 
					for (int i=0; i<li; i++) for (int j=0; j<lj; j++) loadarray(id[i][j], 0, lk); 
				}
				
				//3D array, set of irregular 2D
				static void loadarrayset(float[][][] id) {
					int li=getlen(); 
					for (int i=0; i<li; i++) {
						int lj=getlen(); int lk=getlen(); 
						for (int j=0; j<lj; j++) loadarray(id[i][j], 0, lk); 
					}
				}
				
				
			} //end class histdata
			
			
			
			