//Mitigation -routines to fix global emissions 
//in order to stabilise emissions, concentration or temperature 
//by inverse/fuzzy-control/iteration feedback methods 
//Stabilise concentration can generate IPCC "S"/"WRE" scenarios

//stabilise concentration developed Arendal autumn 2001 to match IPCC synthesis report, 
//stabilise temperature from fuzzy-control experiments Copenhagen 2001, iteration method improved Bern March 2002, extended LLN March 2003
//stabilise emissions originally developed spring 2000 based on GCI-C&C
//stabilise forcing and sealevel added spring 2003

package jcm.mod;
import jcm.*;

public class mitigation extends module {
	
	//*****************************************************
	//INTERACTIONS
	
	public void setinteractions() {
		setaffectedby(kyoto, kyoto.kyotop.istrue()); 
		setaffectedby(kyoto.kyotop); 
		setaffectedby(carboncycle, scenario.chosen=="stabconc"); 
		setaffectedby(radfor, scenario.chosen=="stabrf&allghgaero" || scenario.chosen=="stabrf&allghg"); 
		setaffectedby(heatflux, scenario.chosen=="stabtemp"); 
		setaffectedby(heatflux.baseyear, scenario.chosen=="stabtemp"); 
		setaffectedby(sealevel, scenario.chosen=="stabsea"); 
		setaffectedby(people, scenario.chosen=="reduceintensity"); 
		affectsfutureonly=true; 
	}
	
	
	//**************************************************
	//ADJUSTABLE PARAMETERS
	
	String[] emitoptions={	"nopolicy", "stabemit", "stabconc",  "stabrf&allghg", "stabrf&allghgaero",  "stabtemp", "stabsea", "constant", "reduceintensity" }; //, "stabopt"};
	String[] concscenname={	"400ppm", "450ppm", "500ppm", "550ppm", "650ppm", "750ppm", "1000ppm"}; 
	int[] concscenlevel={	400, 450, 500, 550, 650, 750, 1000}; 
	
	public param
	
	scenario=new param("emitmenu", emitoptions, "stabconc"),	//general menu
	
	//for stabilise emissions
	sygrowth=new param("initgrow", "percent&per&yr", 1.5, -3.5, 3.5), 		//initial growth rate
		stabemityear=new param("stabemit&inyear", "", 2080, 2010, (time.gey)-20), 	//stabilisation year
		stabemitlevel=new param("stabemit&atlevel", "giga&ton&carbon&per&yr", 2000, 0, 12000, stabemityear), 		//final emissions
		quartic=new param("integralopt", false),				//control integral (quartic curve)
		integralgt=new param("integral", "giga&ton&carbon", 650, 200, 2000),		//total emissions 2000-2200 in GtC
	
	//for stabilise concentration
	stabconcyear=new param("stabconc&inyear", "", 2125, 2005, 2400), 	//stabilisation year
		stabconclevel=new param("stabconc&atlevel", "ppm", 500, 300, 1000, stabconcyear), 	//final concentration
		wre=new param("wreopt", false), 					//delay start year as Wigley-Richels-Edmonds proposal
		stabconcstartyear=new param("stabconcstartyear", "", 2030, 1990, 2050), 					//startyear fixed by WRE
		concscen=new param("stabconcmenu", concscenname, "500ppm"),	//conc menu
	
	//for stabilise rad-for
	stabrfyear=new param("stabrf&inyear", "", 2150, 2030, (time.gey)-20), //stabilisation year
		stabrflevel=new param("stabrf&atlevel", "w&per&m2", 3.1, 1.5, 8.0, stabrfyear), 	//final total rf
	
	//for stabilise temperature
	stabtempyear=new param("stabtemp&inyear", "", 2150, 2050, (time.gey)-20),//stabilisation year
		//note stabtemplevel mix/min changed by heatflux.baseyear!
	stabtemplevel=new param("stabtemp&atlevel", "degcbase", 2.0, 1.0, 7.0, stabtempyear), 	//final temperature
		stfuzzy=new param("stfuzzyopt", false), 				//use fuzzy-control method
		damp=new param("dampopt", false), 						//use damping in fuzzy control
	
	//for stabilise sealevel
	stabseayear=new param("stabsea&inyear", "", 2250, 2030, (time.gey)-20), //stabilisation year
		stabsealevel=new param("stabsea&atlevel", "metres", 0.75, 0.5, 3.0, stabseayear), 	//final total rf
	
	//for reduceintensity proposal, reduction in energy reduceintensity, % per year
	reduceintensity=new param("reduceintensity", "percent&per&yr", -2, -6, 0)
		; 
	
	//*****************************************************
	//ARRAYS
	
	//arrays for stabilisation calculations
	public float[] target=time.fyd(), otarget=time.fyd(), original=time.fyd(); 
	
	//other variables
	//constants (maybe not all needed now check stabemit and kyoto)
	int intendy=2200, ge2000=6514, integkyoto=92870,  gesy=ge2000; 
	
	//startyear varies depending on kyoto.kyotop
	int sy=time.fsy, sty=sy+5, ssy=(int)stabconcstartyear.getval(); 
	
	//general working
	int i, j, n, ns, nr, year, py; 
	
	
	//######################################
	//MAIN LOOP CALCULATIONS
	
	public 	void precalc(iob p) {
		if (p==scenario && scenario.chosen=="nopolicy") {	regshares.distribution.chosen="sresdist"; sres.changed=true; } //eventually shouldn't be necessary if modules call sres data when needed
		if (p==concscen) {
			stabconclevel.setval(concscenlevel[concscen.getchosenindex()]); 
			stabconcyear.setval(2100+(concscenlevel[concscen.getchosenindex()] -450)/2.0); //set endyear as a func of endlevel as per IPCC S/WRE
		}
		if (p==scenario && scenario.chosen=="reduceintensity") kyoto.kyotop.flag=false; 
		if (p==scenario) {	resetguess(); }
	}
	
	//******************************
	public void precalc() {
		
		//set startyear for stabilisation curve, 2000 or after kyoto
		sy=(kyoto.kyotop.istrue() ? 2013 : time.fsy); 
		//stabilise temp starts later to avoid effect of kinks in radiative forcing at 2000
		sty=sy; //+2
		//wre option delays the start
		ssy=(wre.istrue() && !kyoto.kyotop.istrue() ? 2002+(int)((stabconclevel.getval()-350.0)/23.0) :  sy); 
		
		//note WRE starts by following IS92a *(6.7/7.1) to connect with 2000 historical data
		if (wre.istrue() && !kyoto.kyotop.istrue() && scenario.chosen=="stabconc") {
			int oldsc=sres.sc; sres.sc=6; 
			for (int year=sy; year<=ssy; year++) carboncycle.fossil[year-time.gsy]=1000f*sres.interp(sres.fosemit, year)*(6.7f/7.1f); 
			sres.sc=oldsc; 
		}
		
		if (scenario.chosen=="stabrf&allghgaero" ||  scenario.chosen=="stabrf&allghg" || scenario.chosen=="stabsea") setupiteration(); 
		
		if (scenario.chosen=="stabopt") conctarget( scy, co2stab, co2stabslope, co2end, co2endslope); //this will only work AFTER another stabilisation scenario has set initial guess!
		
		if (scenario.chosen=="stabemit") stabemit(); 
		
	} //precalc
	
	//******************************
	public void calcstep(int ns) {
		
		//set target stabilisation curves if start year
		//note need to call this in calcstep loop as kyoto affects atppm[ns-1] etc.
		//what was this for? if (!carboncycle.histdeforbymassbal.istrue()) enclosing all conctarget method
		if (scenario.chosen=="stabconc" && ns==(ssy-time.gsy) ) conctarget((int)stabconcyear.getval(), stabconclevel.getval()); 
		
		//need to setup stabtemp iteration from within loop, *after* heatflux.baseyear+3, to get baseyear offset correction right (done in climate module at baseyear+2)
		if  (scenario.chosen=="stabtemp" && !stfuzzy.istrue() && (ns==heatflux.baseyear.val+3 - time.gsy) )   setupiteration(); 
		
		if (scenario.chosen=="stabemit" && ns>(sy-time.gsy)) {
			//stabemit doesn't fix lucf (or bunker!) so do it here
			carboncycle.lucf[ns]=carboncycle.lucf[sy-time.gsy]*carboncycle.fossil[ns]/carboncycle.fossil[sy-time.gsy]; 
		}
		
		if ((scenario.chosen=="stabconc" || scenario.chosen=="stabrf&allghgaero" ||  scenario.chosen=="stabrf&allghg" || (scenario.chosen=="stabtemp" && !stfuzzy.istrue()) || scenario.chosen=="stabsea"  || scenario.chosen=="stabopt") && ns>=(ssy-time.gsy)) {
			carboncycle.totemit[ns]=inverseco2(ns, target[ns]); lucfshare(ns); 
		}
		
		if (scenario.chosen=="stabtemp" && stfuzzy.istrue()) {
			if (ns==(sty-time.gsy)) temptarget(ns); 
			if (ns>=(sty-time.gsy)) {	inversetemp(ns); lucfshare(ns); }
			else 	 target[ns]=0; //remove target temp curve before start (as it's plotted)
		}
		
		if  (scenario.chosen=="constant" && ns>=(sy-time.gsy)) {	carboncycle.totemit[ns] =carboncycle.totemit[ns-1]; lucfshare(ns); }
		
	} //end calcstep
	
	//**************************
	public void postcalc() {
		//correct for stabtemp or stabrf, if not good enough calls modloop again
		if (scenario.chosen=="stabrf&allghgaero" ||  scenario.chosen=="stabrf&allghg" || (scenario.chosen=="stabtemp" && !stfuzzy.istrue()) || scenario.chosen=="stabsea") applycorrection(); 
		//if (scenario.chosen=="stabopt") optcorrection();
	}
	
	
	
	//**************************
	
	//initial guesses for CO2 concentration target curve for stabilise radfor or temp iterations
	//if first step of iteration set co2stab, scy, co2end, co2slope (otherwise these reset in correct method called from postcalc)
	//then make new target co2 curve (- maybe move into correct for stit > 0?)
	void setupiteration() {
		if (stit==0) {
			if (scenario.chosen=="stabrf&allghgaero" || scenario.chosen=="stabrf&allghg") {
				curvetocheck= scenario.chosen=="stabrf&allghgaero" ? radfor.totanthrorf : radfor.totghgrf; 
				targetlevel=stabrflevel.getval(); 
				setstabconcyear(stabrfyear.getval()); 
				guessconcfromrf( targetlevel *  radfor.totalrf[sys] /  (scenario.chosen=="stabrf&allghgaero" ? radfor.totanthrorf[sys] : radfor.totghgrf[sys])); 
			}
			if (scenario.chosen=="stabtemp") {
				curvetocheck=heatflux.glotemp; 
				targetlevel=stabtemplevel.getval()+heatflux.offset; //offset because model temperature relative to 1750 but parameter relative to baseyear!
				setstabconcyear(stabtempyear.getval()); 
				guessconcfromrf(guessrffromtemp(targetlevel)); 
			}
			if (scenario.chosen=="stabsea") {
				curvetocheck=sealevel.total; 
				targetlevel=stabsealevel.getval(); 
				setstabconcyear(stabseayear.getval()); 
				guessconcfromrf(guessrffromtemp(guesstempfromseal(targetlevel))); 
			}
		} //stit=0
		conctarget( scy, co2stab, co2stabslope, co2end, co2endslope); 
		//		stabtemplevel.min=1.0-heatflux.offset; stabtemplevel.max=7.0-heatflux.offset; //set permitted range relative to 1750
	}
	
	//####################################################
	
	//STABILISE CO2 CONCENTRATION
	
	//inverse formula: emissions from concentration
	public float inverseco2(int ns, double ctarget) {
		//project total sinks
		double projsink=	2.0*carboncycle.totsink[ns-1]-carboncycle.totsink[ns-2] ; 
		if ((projsink / carboncycle.totsink[ns-1])<0) projsink= 0; 
		//+carboncycle.totsink[ns-1]+(carboncycle.totsink[ns-1]-carboncycle.totsink[ns-5])/4.0
		return (float)(	( (ctarget - carboncycle.atppm[ns-1]) / carboncycle.ppmpmtc) + projsink); 
		//emissions = total co2 needed to add to atmosphere in this step , plus total sinks
		// ?(target is ppmv normalised to startyear-1)
		//-(target[(ssy-1)-time.gsy]-carboncycle.atppm[(ssy-1)-time.gsy])
	}
	
	//************************************************
	//LUCFSHARE - constant fraction for land use change
	
	void lucfshare(int ns) {
		//carboncycle.lucf is constant fraction of total if positive, or all of total if negative (can't have negative fossil emissions)
		if (carboncycle.totemit[ns]>0) {
			carboncycle.lucf[ns]=(carboncycle.totemit[ns]*carboncycle.lucf[ssy-time.gsy-1]/carboncycle.totemit[ssy-time.gsy-1]); 
			carboncycle.fossil[ns]=carboncycle.totemit[ns]-(carboncycle.lucf[ns]); //+regshares.bunker[ns]);
		}
		else {
			carboncycle.lucf[ns]=carboncycle.totemit[ns]; carboncycle.fossil[ns]=0; 
		}
	}
	
	//**************************
	//make target curve for stabilise co2 concn
	//note ye and dye used for cubic at end if stabtemp by iterate
	
	void conctarget(int xs, double ys) {	conctarget(xs, ys, 0, ys, 0); }
	
	void conctarget(int xs, double ys,  double dys, double ye, double dye) {
		
		//work out initial gradient and d2y/dx2, or if start before 2005 fix start d2y0 to avoid effect of kinks in historical data
		//growth 2000 = (7.77-4.20)*.471 =1.68 (emit-sink)*(ppmpgtc) ,	growth 1990 = (7.75-3.84)*.471 =1.84 ,	so d2y0 =  (1.68-1.84)/10 = -0.016
		int x0=ssy-1, x0s=x0 - time.gsy; 
		double d2y0= (x0s<255) ?  0.016 : (carboncycle.atppm[x0s]-2.0*carboncycle.atppm[x0s-1]+carboncycle.atppm[x0s-2])  ; 
		double dy0=d2y0+(carboncycle.atppm[x0s]-carboncycle.atppm[x0s-1]); //could also fix dy0 =d2y0+1.65;
		
		//make the pade curve
		double d2ys=0; mathcurve.padequintic( target, x0,  xs, carboncycle.atppm[x0s],  dy0, d2y0,ys, dys, d2ys); 
		//double d2ys = padequartic( target, x0, xs, carboncycle.atppm[x0s],  dy0, d2y0, ys, dys);
		
		//after CO2 stabilisation point
		if (xs<time.gey) {
			if (dys==0 || (time.gey-xs<20)) for (int x=xs; x<=time.gey; x++) target[x-time.gsy]=(float)ye; //flat
			else mathcurve.flatquadratic (target, xs, time.gey, ys, dys, ye); 
			//mathcurve.expdecay(target, xs, ys, dys, d2ys);
			//mathcurve.simplepade (target, xs,  time.gey, ys, dys, d2ys, ye);
		}
	} //end conctarget
	
	
	//##################################################
	//STABILISE RADFOR or TEMPERATURE by ITERATE CO2: guess CO2 stabilisation
	
	//iteration variables to be remembered between calls
	double targetlevel=0; float[] curvetocheck; 
	double co2stab=0, co2staborig=0, stabcor=1.0, oldstabcor=1.0; 
	double co2stabslope=0, co2stabslopeorig=0, stabslopecor=1.0, oldstabslopecor=0; 
	//double co2mid=0, co2midorig=0, midcor=1.0, oldmidcor=1.0;
	double co2end=0, co2endorig=0, endcor=1.0, oldendcor=1.0; 
	double co2endslope=0, co2endslopeorig=0, endslopecor=1.0, oldendslopecor=0; 
	int sys, scy; //number of iterations, year steps
	public boolean goodenough=false; 
	public int stit=0; 
	
	
	//**************************
	
	void setstabconcyear(double stabconcyear) {
		sys=(int)stabconcyear-time.gsy; 
		scy=time.fsy+(int)(1.0*(stabconcyear-time.fsy)); //note here can experiment setting co2 stab earlier than temp stab year
	}
	
	double guesstempfromseal(double sealeveltarget) {
		return (sealevel.total[sys]>0 ?  heatflux.glotemp[sys] * sealeveltarget / sealevel.total[sys] : 2.0); //first guess - assume sealevel proportional to temperature (in same year) - if sealevel not yet calculated guess 2
	}
	double guessrffromtemp(double stabtemplevel) {	//called from precalc() -before steps
		//first guess - use ratio temp/radfor if already calculated once, else use climate sensitivity assuming equilibrium
		return stabtemplevel*(heatflux.glotemp[sys]>0 ? radfor.totalrf[sys]  / heatflux.glotemp[sys] : heatflux.rfco2double.getval()/heatflux.climsens.getval() ); 
	}
	
	void guessconcfromrf(double guesstotrf) {
		double co2rf = guesstotrf * (radfor.totalrf[sys]>0 ?  radfor.co2rf[sys] / radfor.totalrf[sys]  : 0.85); //guess CO2 rf is same frac as current, or 85% if first time
		
		co2staborig= carboncycle.atppmprein * Math.exp (Math.log(2.0) * co2rf /heatflux.rfco2double.getval() ); //find corresponding co2 concentration
		
		//note: old corrections remembered from previous solution -faster when dragging control
		co2stab=co2staborig*oldstabcor; 
		//if (co2stab<stabconclevel.min) {	co2stab=stabconclevel.min; debug("can't drop CO2 below "+stabconclevel.min); } 	//catch impossible target
		co2stabslopeorig=0; 
		co2stabslope=oldstabslopecor; 
		//co2midorig=co2stab;
		//co2mid=co2midorig*oldmidcor;
		co2endorig=co2stab; 
		co2end=co2endorig*oldendcor; 
		co2endslopeorig=0; 
		co2endslope=oldendslopecor; 
	}
	
	//**************************
	//for iteration: correct according to calculated rf or temp, called from postcalc()
	void applycorrection() {
		
		//correct level in stabilisation year
		stabcor=targetlevel / curvetocheck[sys]; 
		
		//gradient should be flat at stabilisation point (check twenty years gradient)
		stabslopecor= -0.05*(curvetocheck[sys+10]-curvetocheck[sys-10])  / curvetocheck[sys-1]; 
		
		//end level should be same as stab level: (check penultimate step - note use actual stab level rather than target level)
		endcor=curvetocheck[sys] / curvetocheck[(time.gey-time.gsy)-1]; 
		
		//end gradient should be flat (check last twenty years gradient)
		//endslopecor = -0.05*(curvetocheck[(time.gey-time.gsy)-1]-curvetocheck[(time.gey-time.gsy)-21]) / curvetocheck[sys-1];
		
		
		co2stab=280.0+(co2stab-280.0)*stabcor; if (co2stab<300) co2stab=300; 
		if (stit<=6 || stabslopecor/oldstabslopecor <1.0)  	co2stabslope+=stabslopecor * (co2stab-280.0); //only use if iteration 0 - 6 or correction is getting smaller - avoid instability
		co2end=280.0+(co2end-280.0)*endcor; if (co2end<300) co2end=300; 
		//if (stit<=4 || endslopecor/oldendslopecor <1.0)  co2endslope+=endslopecor * (co2stab-280.0);
		
		goodenough=(
			(stabcor<1.01) && (stabcor>0.99) 	&& (stabslopecor<0.01) && (stabslopecor>-0.01)
			&& (endcor<1.01) && (endcor>0.99)  //&& (endslopecor<0.05) && (endslopecor>-0.05)
			//			(stabcor<1.005) && (stabcor>0.995) 	&& (stabslopecor<0.02) && (stabslopecor>-0.02)
		//			&& (endcor<1.005) && (endcor>0.995) // && (endslopecor<0.01) && (endslopecor>-0.01)
		) 	; 
		boolean impossible=(Double.isInfinite(co2stab) || Double.isInfinite(co2end) || Double.isNaN(co2stab) || Double.isNaN(co2end) || co2stab<300 || co2end<300) ; //stop iteration if impossible targets
		
		/*
		+ " STAB= " + aa(co2stab) 	+" corr= " + aa(stabcor) + " slope= " + aa(co2stabslope) +" corr= "+aa(stabslopecor) 	//+ "MID= " + aa(co2mid) +" corr= "+ aa(midcor)
		+ " END= " + aa(co2end) +" corr= "+ aa(endcor) 	+ " slope= " + aa(co2endslope) +" corr= "+aa(endslopecor)
		+" ok? "+goodenough+"\n" );
		*/
		
		stit++; 
		
		if (!goodenough && stit<15 &&!impossible ) {
			savecorrect(); 
			loop.itc=this; loop.itn=this; loop.repeat=true; //set loop to repeat (when done) with only itc changed and itn output
			//note due to finishing first loop, result of first guess will be plotted, but this is safer than discarding needeed and changed info too soon, in case other responses required (not just this mitigation control)
		}
		
		else {	//good enough so now run whole loop again (inside current loop) with normal interactions for final gui output
			if (loop.repeat) {	loop.repeat=false; changed=true; loop.gowithin(); }
			else {	//and now this is the final time so reset for next guess
				debug(	"iteratated "+stit+" times"); 
				stit=0; 
				/*if (scenario.chosen=="stabsea") resetcorrect(); else */ savecorrect(); 
			}
		}
	} //end applycorrection
	
	void savecorrect() {	//saving oldcorrect  makes iteration faster if dragging arrow
		oldstabcor=co2stab/co2staborig; oldstabslopecor=(co2stabslope-co2stabslopeorig) /  (co2stab-280.0); 
		//oldmidcor=co2mid/co2midorig;
		oldendcor=co2end/co2endorig; //oldendslopecor=(co2endslope-co2endslopeorig) /   (co2stab-280.0);
	}
	void resetcorrect() {	oldstabcor=1.0; oldstabslopecor=0; /*oldmidcor=1.0;*/ oldendcor=1.0; oldendslopecor=0; }
	void resetguess() {	resetcorrect(); goodenough=false; } //see climate module
	
	double aa(double d) {	return ((int) (d*10000.0))/10000.0; }
	
	//##############################################
	//STABILISE TEMPERATURE by TARGET CURVE
	// EXPERIMENTAL!!! (i.e. it doesn't really work -causes oscillations)
	
	float fstx, fsty, dgt, drf,  trf, crf, newtotemit, ctarget; 
	
	//make target curve for stabilise temperature by fuzzy control (experimental)
	void temptarget(int startns) {
		int x0s=startns-1, xs=(int)stabtempyear.getval(); 
		double y0=heatflux.glotemp[x0s], ys=stabtemplevel.getval()+heatflux.offset; //beware must have set offset before
		
		mathcurve.padequartic(target, x0s + time.gsy, xs, y0, 0.0235, 0.0004 , ys, 0); //pade curve, flat at end, fixed straight start slope
		//variant: d2y0=heatflux.glotemp[x0s]-2.0*heatflux.glotemp[x0s-1]+heatflux.glotemp[x0s-2]; dy0= d2y0+heatflux.glotemp[x0s]-heatflux.glotemp[x0s-1];
		
		if (xs<time.gey) for (int x=xs; x<=time.gey; x++) target[x-time.gsy]=(float)ys; //flat after stabilisation point
		for (int ns=0; ns<startns; ns++) target[ns]=-999f; //null before start
	} //end temptarget
	
	//************************************************
	void inversetemp(int ns) {	if (ns>250) {
			//assumes dT/dt= fstx + fsty*dRF/dt
			//set fstx & fsty
			fsty=(float)(heatflux.climsens.getval()/heatflux.rfco2double.getval()); 
			fstx=0; 
			
			//aim mainly to correct slope, plus a little to get back to target curve
			dgt=(target[ns]-target[ns-1])+0.1f*(target[ns-1]-heatflux.glotemp[ns-1]); 
			
			//work out required total radiative forcing
			drf=(dgt-fstx)/fsty; 
			trf=radfor.totalrf[ns-1]+drf; 
			
			//co2rf same proportion as last step
			crf=trf*(radfor.co2rf[ns-1]/radfor.totalrf[ns-1]); 
			
			//work out co2 target
			ctarget= (float)(carboncycle.atppmprein * Math.pow(2.0, crf / heatflux.rfco2double.getval())); 
			//apply inverse co2 formula
			newtotemit=inverseco2(ns, ctarget); 
			
			if (damp.istrue()) {
				//limit d2e/dt to 0.5%/yr
				float d2e=(newtotemit-(2f*carboncycle.totemit[ns-1]-carboncycle.totemit[ns-2]))/carboncycle.totemit[ns-1]; 
				if (d2e>0.005) d2e=0.005f; if (d2e<-0.005) d2e=-0.005f; 
				newtotemit=2f*carboncycle.totemit[ns-1]-carboncycle.totemit[ns-2]+carboncycle.totemit[ns-1]*d2e; 
			}
			
			//limit de/dt to 10%/yr
			float de=newtotemit/carboncycle.totemit[ns-1]; 
			if (de>1.1) de=1.1f; if (de<0.9) de=0.9f; 
			carboncycle.totemit[ns]=carboncycle.totemit[ns-1]*de; 
			
			//else carboncycle.totemit[ns]=newtotemit;
			
			//prevent negative emissions
			if (carboncycle.totemit[ns]<0.1) carboncycle.totemit[ns]=0.1f; 
			
		} //if>255
	}
	
	//###################################################
	//STABILISE EMISSIONS
	//this is  old code (should be adapted to use general methods in curves)
	
	void stabemit() {
		
		double k,delta,ctf,tc; 
		int cty=(int)stabemityear.getval(), integral=(int)(integralgt.getval()*1000); 
		sy=(kyoto.kyoto.kyotop.istrue() ? 2012 : time.fsy); 
		gesy=(int)(kyoto.kyotop.istrue() ? carboncycle.fossil[2012-time.gsy]: ge2000); 
		
		//calculate constants
		ctf=(double)stabemitlevel.getval()/(double)gesy; 
		delta=(double)((sygrowth.getval()/100)*(cty-sy)/(1-ctf)); 
		if (quartic.istrue()) {	k=(double)(30*(((((integral-(kyoto.kyotop.istrue() ? integkyoto : 0))/gesy)-(intendy-sy)*ctf)/((1-ctf)*(cty-sy)))-0.5-delta/12)); }
		else {	k=0; integral=(int)((kyoto.kyotop.istrue() ? integkyoto : 0)+((cty-sy)*(double)gesy*(double)(ctf+(1-ctf)*(0.5+(delta/12))))+stabemitlevel.getval()*(intendy-cty)); integralgt.setval(integral/1000); }
		
		if (!kyoto.kyotop.istrue()) carboncycle.fossil[time.fsy-time.gsy]=(float)ge2000; 
		
		//apply quartic formula (or cubic if k=0)
		for (year=sy+1; year<=cty; year++) {
			tc=(double)(year-sy)/(cty-sy); 
			carboncycle.fossil[year-time.gsy]=(float)(gesy*(ctf+(1-ctf)*((1+(2+delta)*tc+k*tc*tc)*(1-tc)*(1-tc)))); 
		}
		//constant after stabemityearear
		for (year=cty+1; year<=time.gey; year++) carboncycle.fossil[year-time.gsy]=carboncycle.fossil[cty-time.gsy]; 
		
	} //end stabemit
	
	
	
	//************************************************
} //end mitigation class.
	
	
	
	
	
