package jcm.mod;

import jcm.*;
import java.util.*;
import java.awt.*;
import java.io.*;
import java.net.*;

public class regionset implements jcm.gui.colfont, modlist {
	
	
	public static region allreg=new region("ALL"); 
	public static region jcmreg=new region(); 
	public static region[] list; 
	
	public static Color[] jcmcols=new Color[]{	red, purple, lilac, yellow, dkorange, brown , cyan, blue, dkgreen, ltblue, green, dkcyan, black, dkblue, grey}; 
	
	static {
		loaddata(); iob.debug("loaded region data ok"); 
		jcmreg= allreg.find("JCM12"); 
		jcmreg.setcols(jcmcols); 
		iob.debug("made jcmreg ok"); 
		allreg.find("SRES4").setcols(new Color[]{	yellow, brown, blue, green }); 
		region mainlist=allreg.find("MAINLIST"); 
		list=new region[mainlist.reg.size()]; 
		for (mainlist.start(); mainlist.more(); ) list[mainlist.i]=mainlist.c; 
		iob.debug("made main reg list ok"); 
	}
	
	//*****************************************************
	
	public static void loaddata() {
		//			if (standalone)	try{	iob.codebase=new URL("file:///java/jcm/jcm"); } catch (MalformedURLException e) {	System.out.println(e); }
		String poly=jcm.tls.fileio.loadstring("data/regions.txt").trim(); 
		String[] line=jcm.tls.txt.split(poly, "\n", true), item; 
		for (int i=0; i<line.length-1; i++) {
			item=jcm.tls.txt.split(line[i], " ", true); 
			try {
				if (region.nsew(item[0])==0) {	//not nsew
					region r=allreg.find(item[0]); 
					if (item[1].equals("+")) r.addsub(item); //consists of following subregions
					else if (item[1].equals("-")) r.subtract(item); //remove following subregions
					else if (item[1].equals("&")) r.addset(item); //add set (expanding not recursive). repeating an entry is OK
					else if (item[1].equals("L")) {	r.defbox(item); r.land=true; } //tgcia box ocean
					else if (item[1].equals("O")) {	r.defbox(item); r.land=false; } //tgcia box ocean
					else r.addedge(item); //add adge (with, from, to, corners)
				}
			} catch (Exception e) {	iob.debug(line[i]+" regload "+e); }
		}
	} //end loaddata
	
	/*
	region converters
	
	JCM regions
	"usa", "can", "jap", "weu", "eeu", "rub", "mec", "chi", "sca", "oas", "afr", "ind", "worldav"
	
	Edgar Hyde regions (RIVM v2)
	Canada, USA, Latin America, Africa, OECD EU, E EU, CIS, Mid east, "India", "China", East asia, Oceania, Japan,  world
	
	Houghton regions (CDIAC)
	Nth America, Sth/C America, Europe, Nth Af/MidE, TropAf, FSU, China, S/SE Asia, PacificDev, Total
	
	IPCC SRES REGIONS (as sum of JCM regions) :
	0 OECD90 = WEU, CAN, USA, JAP, Turkey part of MEC
	1 REF	= EEU + RUB + FSU part of MEC
	2 ASIA = IND + CHIN + OA + Pakistan, Afghanistan part of MEC
	3 ALM = AFR + SCA + rest of MEC
	4 for bunker fuel (but note NOT specified in SRES!)
	*/
	
	//fractions of JCM MEC region based on 1998 emissions from CDIAC
	static 	float mecfsu=0.192f, mecoth=0.627f, mecpaf=0.059f, mecturk=0.122f; 
	
	static 	float ehtojcm(float[][] data, int reg, int year) {
		int rs=(year-1890)/10; 
		if (reg==0) return data[1][rs]; 
		if (reg==1) return data[0][rs]+data[11][rs]; 
		if (reg==2) return data[12][rs]; 
		if (reg==3) return data[4][rs]; 
		if (reg==4) return data[5][rs]; 
		if (reg==5) return data[6][rs]; //assume RUB=CIS  
		if (reg==6) return data[7][rs]; //asume MEC=Mid East
		if (reg==7) return data[9][rs]; //assume China="China" (CPA)
		if (reg==8) return data[2][rs]; 
		if (reg==9) return data[10][rs]; //assume OAS="East Asia" (SEA)
		if (reg==10) return data[3][rs]; 
		if (reg==11) return data[8][rs]; //assume India="India" (SAS)
		return 0; 
	}
	
	
	static 	float houghtontojcm(float[][] data, int reg, int year) {
		//landusechange - temporary approximations:
		int rs=year-1850; 
		float euw=people.pop[3][100]/(people.pop[3][100]+people.pop[4][100]); 
		if (reg==0) return data[0][rs]*0.8f; //us is 80% of NA
		if (reg==1) return data[0][rs]*0.2f+data[8][rs]*0.6f; //can is 20% of NA, anz is 60% of pac-dev
		if (reg==2) return data[8][rs]*0.4f; //jap is 40% of pac-dev
		if (reg==3) return data[2][rs]*euw; 
		if (reg==4) return data[2][rs]*(1.0f-euw); 
		if (reg==5) return data[5][rs]; //rus is all of fsu, ignoring stans
		if (reg==6) return data[3][rs]*0.5f; //mec has half of NAf/ME
		if (reg==7) return data[6][rs]; 
		if (reg==8) return data[1][rs]; 
		if (reg==9) return data[7][rs]*0.7f; //oth-asia has 0.7 of S/SE asia 
		if (reg==10) return data[3][rs]*0.5f+data[4][rs];
		if (reg==11) return data[7][rs]*0.3f; 
		return 0; 
	}
	
	static 	float jcmtosres(float[][] data, int reg, int year){
		int rs=year-time.rsy; 
		if (rs<0) rs=0; //note jcm regional data starts only in 1900 not 1890! will update later
		if (reg==0) return data[0][rs]+data[1][rs]+data[2][rs]+data[3][rs]+data[6][rs]*mecturk; 
		if (reg==1) return data[4][rs]+data[5][rs]+data[6][rs]*mecfsu; 
		if (reg==2) return data[7][rs]+data[9][rs]+data[11][rs]+data[6][rs]*mecpaf; 
		if (reg==3) return data[8][rs]+data[10][rs]+data[6][rs]*mecoth; 
		return 0; 
	}
	

	static 	float ehtosres(float[][] data, int reg, int year) {
		int rs=(year-1890)/10; 
		if (reg==0) return data[0][rs]+data[1][rs]+data[4][rs]+data[11][rs]+data[12][rs]; 
		if (reg==1) return data[5][rs]+data[6][rs]; 
		if (reg==2) return data[8][rs]+data[9][rs]+data[10][rs]; 
		if (reg==3) return data[2][rs]+data[3][rs]+data[7][rs]; 
		return 0; 
	}
	
	static 	float houghtontosres(float[][] data, int reg, int year) {
		float euw=people.pop[3][100]/(people.pop[3][100]+people.pop[4][100]); 
		float eue=people.pop[4][100]/(people.pop[3][100]+people.pop[4][100]); 
		int rs=year-1850; 
		if (reg==0) return data[0][rs]+data[8][rs]+data[2][rs]*euw; 
		if (reg==1) return data[5][rs]+data[2][rs]*eue; 
		if (reg==2) return data[1][rs]+data[3][rs]+data[4][rs]; 
		if (reg==3) return data[6][rs]+data[7][rs]; 
		return 0; 
	}
	
	static 	float ehtosresinterp(float[][] data, int reg, int year) {
		int bk=year/10, by=year % 10; 
		return (1f-(float)by/10f)*ehtosres(data, reg, 10*bk) + (by>0 ? ((float)by/10f)*ehtosres(data, reg, 10*(bk+1)) : 0); 
	}
	
	static 	float sresinterp(float[][][] data, int reg, int year) {
		int bk=year/10, by=year % 10; 
		int scen=sres.scenario.getchosenindex(); 
		if (reg<4) {
			return (1f-(float)by/10f)*data[reg+1][scen][bk-199] + (by>0 ? ((float)by/10f)*data[reg+1][scen][bk-198] : 0); 
		} else return 0; 
	}
	
	
	
} //end regionset
	
	
	
