//Regional Shares of emissions
//This implements the options in the "Distribution" menu
//per-capita convergence, brazilian proposal, SRES distn, per-dollar, grandfathering
//Also adjusts regional emissions while the global cap is adjusted by mitigation module
//and calculates abatement (sres minus mitigation)
//note interface "reg" contains the basic region data

//convergence formula developed with GCI summer 1996, spring 2000
//other options added in Arendal autumn 2001, and in Louvain-la-neuve spring 2002
//updated july 2003

package jcm.mod;
import jcm.*;

public class regshares extends module  {
	
	//*****************************
	//INTERACTIONS
	
	public void setinteractions() {
		setaffectedby(loaddata); 
		
		setaffectedby(sres, distribution.chosen=="sresdist"); 
		setaffectedby(people, distribution.chosen=="percapita" || distribution.chosen=="convpergdp" || distribution.chosen=="percapgdp"); //indirect effect via people
		setaffectedby(responsibility, distribution.chosen=="brazil"); 
		setaffectedby(costs, distribution.chosen=="cheapest"); 
		setaffectedby(kyoto, kyoto.kyotop.istrue()); 
		setaffectedby(kyoto.kyotop, distribution.chosen!="unspecified"); 
		setaffectedby(mitigation, mitigation.scenario.chosen!="nopolicy"); //this only applies to the emit/percap steps!
		affectsfutureonly=true; 
		distribution.setaffectedby(mitigation.scenario); 
	}
	
	/*
	public void precalc(iob p) {
	if (p==distribution && distribution.chosen=="sresdist") sres.changed(); //eventually shouldn't be necessary if modules call sres data when needed
	}
	*/
	
	int nregs=14; 
	
	//*******************************
	//PARAMETERS
	
	String[] distriboptions={	"unspecified", "percapita",  /*"brazil",*/ "sresdist", "convpergdp",  "grandfather", "cheapest"}; 
	
	//convergence and popu cutoff years and conv factor
	public param
		distribution=new param("distribmenu", distriboptions, "unspecified"),
		convergey=new param("convyear", "", 2040, 2010, 2100),
		popcoy=new param("popcoy", "", 2030, 1990, 2100),
		cvf=new param("convfac", "", 6, 1, 13),
		exponential=new param("expconvopt", false),
		popcoyoption=new param("popcoyopt", false)
		; 
	//****************************
	//PLOTARRAYS
	
	//arrays for region data
	public float[][]
		share=new float[nregs][time.regs2],
		emit=new float[nregs+1][time.regs2], //last region is "remainder" for unknown future
		abate=new float[nregs][time.regs2],
		//		emitforplot=new float[region.nregs][time.regs2],
	baseemit=new float[nregs][time.regs2]; //sres baseline for abatement
	
	public float[] bunker=time.fyd(); 
	
	// note emissions data in MtC
	// region segments now all start from time.rsy (now 1900), even though shares only used in future
	
	//****************************
	
	//working variables
	int nr, ns, rs, ss, sy, py, year; 
	double bunkd; //remembers in double for precision
	boolean[] participate=new boolean[12]; //for brazil proposal threshold
	
	//***************************************************
	//MAIN CALC LOOP
	
	public 	void precalc() {
		sy=(kyoto.kyotop.istrue() ? 2012 : time.fsy); ss=sy-time.rsy; 
		shares(); 
		if (distribution.chosen=="brazil") for (int nr=0; nr<12; nr++) participate[nr]=false; //initialise brazil
	}
	
	public 	void calcstep(int ns) {
		int rs=ns-(time.rsy-time.gsy); 
		
		//put bunker in reg13
		if (rs>0 && rs<=100) emit[13][rs]=bunker[ns]; 
		
		if  (ns>(sy-time.gsy) && mitigation.scenario.chosen=="reduceintensity") reduceintensity(ns, rs); 
		
		else if (ns>(sy-time.gsy) && ns<=(time.rey-time.gsy) ) {
			if (distribution.chosen=="brazil") brazil(ns,rs); 
			else if (distribution.chosen=="cheapest") leastcost(ns,rs); 
			else for (int nr=0; nr<nregs; nr++) emit[nr][rs]=share[nr][rs]*carboncycle.fossil[ns]; 
			if (rs>100 && rs<time.regs2 && (distribution.chosen=="unspecified" || distribution.chosen=="sresdist")) emit[13][rs]=0; 
		}
		
		if (ns>(time.fsy-time.gsy) && ns<=(time.rey-time.gsy) ) 	for (int nr=0; nr<nregs; nr++) abate[nr][rs]=baseemit[nr][rs]-emit[nr][rs]; 
		
		if (rs>=0 && rs<=200) {
			//fill emit[14] - total or remainder in future
			emit[14][rs]=(emit[0][rs]==0 ? emit[12][rs] : 0); 
			//grey developing if kyoto
			if (kyoto.kyotop.istrue() && rs<(2013-time.rsy) && rs>(2000-time.rsy) && distribution.chosen=="unspecified") {
				for (nr=6; nr<12; nr++) {	emit[14][rs]+=emit[nr][rs]; emit[nr][rs]= 0; }
			}
		}
		
		
	} //end calcstep
	
	
	//************************************************
	//methods below distribute the emissions
	
	void shares() {
		//repeat startyear here because shares may be called directly (by kyoto?)
		sy=(kyoto.kyotop.istrue() ? 2012 : time.fsy); ss=sy-time.rsy; 
		
		if (distribution.chosen=="percapita") converge("pop"); 
		if (distribution.chosen=="convpergdp") converge("gdp"); 
		
		//if (distribution.chosen=="percapgdp") converge("popgdp");
		//if (distribution.chosen=="sresdist") sres.emitshare();
		
		for (int rs=sy-time.rsy; rs<=(time.rey-time.rsy); rs++) {
			for (nr=0; nr<nregs; nr++) {
				if (distribution.chosen=="grandfather") share[nr][rs]=(float)(kyoto.kyotop.istrue() ? share[nr][sy-time.rsy] : ef(nr)  ); 
				if (distribution.chosen=="unspecified" && nr!=12) share[nr][rs]=0; 
			}
			//if sres scale denmark to EU
			//if (distribution.chosen=="sresdist") share[13][rs]=share[3][rs]*(float)ef[13]/(float)ef[3]; //0.01f*
			share[12][rs]=1f; //world always 1!
		}
	} //end shares
	
	//*************************************
	float ef(int nr) {	return (float)emit[nr][100]/emit[12][100]; }
	void converge(String cw) {
		//remember regions are 0-11, 12 is world average, 13 is denmark!
		
		int cvy=(int)convergey.getval(); 
		double f, cr=1, cf=cvf.getval()/(double)(cvy-sy); int pops=ss+1; 
		
		if (!kyoto.kyotop.istrue()) {
			for (nr=0; nr<14; nr+=1) {	share[nr][ss]=ef(nr); }
			share[12][ss]=1f; //share[13][ss]=(float)ef[13];
		}
		
		for (year=sy+1; year<=time.rey; year++) {
			ns=year-time.rsy; 
			if (year<=popcoy.getval() || !popcoyoption.istrue()) pops=ns; 
			
			//calc factor f
			if (year<cvy) {
				if(exponential.istrue()) {	f=(double)Math.exp(cf*(year-cvy-1)); }
				else {	f=(double)1.0/(cvy-year); }
			} else f=1; 
			
			//main convergence formula
			for (nr=0; nr<14; nr+=1) {
				if (nr!=12) {
					if (cw=="pop") cr =(float)people.pop[nr][pops]/(float)people.pop[12][pops]; 
					if (cw=="gdp") cr =(float)people.gdp[nr][pops]/(float)people.gdp[12][pops]; 
					//if (cw=="popgdp") cr = (float)Math.sqrt(people.gdp[nr][pops]/people.gdp[12][pops]);
					share[nr][ns]=(float)(share[nr][ns-1]-f*(share[nr][ns-1]-cr)); 
				}
				else share[12][ns]=1f; //world average
			} //end nr
		} //end yearloop
	} //end convergence
	
	//*************************************
	void reduceintensity(int ns, int rs) {
		//reduce energy intensity by 2% per year, apply to all regions
		if (ns<=(time.rey-time.gsy)) {
			carboncycle.fossil[ns]=0; 
			for (nr=0; nr<12; nr++) {
				emit[nr][rs]=(float)(1.0+mitigation.reduceintensity.getval()/100)*emit[nr][rs-1]*people.gdp[nr][rs]/people.gdp[nr][rs-1]; 
				carboncycle.fossil[ns]+=emit[nr][rs]; 
			}
			for (nr=0; nr<nregs; nr++) share[nr][rs]=emit[nr][rs]/carboncycle.fossil[ns]; 
			emit[12][rs]=carboncycle.fossil[ns]; 
		}
		else {
			carboncycle.fossil[ns]=(float)(1.0+mitigation.reduceintensity.getval()/100)*carboncycle.fossil[ns-1]*people.gdp[12][time.regs]/people.gdp[12][time.regs-1]; 
			carboncycle.totemit[ns]=carboncycle.fossil[ns]+carboncycle.lucf[ns]+bunker[ns]; 
		}
	} //end intensity
	
	
	double[] alpha=new double[nregs]; 
	double sumboa=0, sumbase=0; float mu; 
	void leastcost(int ns, int rs) {
		//note below doesn't work with macgem formula!
		sumboa=0; sumbase=0; 
		for (nr=0; nr<12; nr++) 	{
			alpha[nr]=Math.pow(people.gdp[nr][rs]*costs.abatelin.getval()*costs.b1[nr]/baseemit[nr][rs], 1.0/(costs.abatepow.getval()-1.0)); 
			sumbase+=baseemit[nr][rs]; 
			sumboa+=baseemit[nr][rs]/alpha[nr]; 
		}
		for (nr=0; nr<12; nr++)  {
			mu=(float)((sumbase-carboncycle.fossil[ns])/(sumboa*alpha[nr])); 
			emit[nr][rs]=baseemit[nr][rs]*(1f-mu); 
		}
			emit[12][rs]=carboncycle.fossil[ns]; 
			emit[13][rs]=0; 
	}
	
	//not currently used
	void brazil(int ns, int rs) {
		if (!kyoto.kyotop.istrue() || rs>2012-time.rsy){
			float npemit=0, pemit=0, tfr=0; float[] fr=new float[12], fp=new float[12], fe=new float[12]; //totals for non-participants and participants
			for (int nr=0; nr<12; nr++) {
				fr[nr]=responsibility.atco2[nr][rs-1]/responsibility.atco2[12][rs-1]; //fraction responsibility
				fp[nr]=people.pop[nr][rs]/people.pop[12][rs]; //fraction population
				fe[nr]=emit[nr][rs-1]/carboncycle.fossil[ns-1]; //fraction emissions
				//if (fr[nr]>fp[nr]) participate[nr]=true;
				if (fe[nr]>fp[nr]) participate[nr]=true; 
				if (participate[nr]) {	pemit+=emit[nr][rs-1]; tfr+=fr[nr]; }
				else {	emit[nr][rs]=baseemit[nr][rs]; npemit+=emit[nr][rs]; }
			}
			float rpr=((npemit+pemit)-carboncycle.fossil[ns])/tfr; //reduction needed per share responsibility
			for (int nr=0; nr<12; nr++) if (participate[nr]) emit[nr][rs]=emit[nr][rs-1]-rpr*fr[nr]; 
			emit[12][rs]=0; for (int nr=0; nr<12; nr++) emit[12][rs]+=emit[nr][rs]; 
		}
	} //end brazil
	
	//************************************************
	
} //end regshares
	
	