//Sea-level rise
//adds ice-melt (glaciers and icecaps) 
//to the thermal expansion calculated in heatflux module 

//Developed Edinburgh June 2001

//import Jama.*; //this is the java matrix package for calculating eigenvectors, inverses etc.

package jcm.mod;
import jcm.*;

public class sealevel extends module {
	
	//*****************************************************
	//adjustable parameters -may be changed by controls on the graphs
	
	//*****************************************************
	//standard module bits
	
	public void setinteractions() {
		setaffectedby(heatflux); 
	} //end interactions
	
	
	//*******************************************************
	//arrays to store data for plotting
	public float[]
		glacier=time.fyd(), longterm=time.fyd(),
		antarctica=time.fyd(), greenland=time.fyd(),
		freshwater=time.fyd(),  other=time.fyd(),
		total=time.fyd()
		; 
	
	//icecap sensitivities from IPCCTAR chap6 table 11.12
	//climodname={"GFDL_R15_a","CSIRO Mk2","HadCM3","HadCM2", "ECHAM4/OPYC", "CSM 1.0", "DOE PCM", "IPCC SAR"};
	double[] glsens={	0.12,0.16,0.09,0.10,0.03,0.15,0.14,0.3}; 
	double[] ansens={	-0.18,-0.37,-0.35,-0.21,-0.48,-0.31,-0.48,-0.21}; 
	double glsensfac, ansensfac; 
	
	//glacier groups as per jesper interpretation of SAR method
	double totglac=0.5; //total glacier ice as m sea-level
	double taul=70, tauh=130, deltatl=0.7, deltath=3.0; //tau is lifetime, deltat is temp for melting
	
	int ng=10, n; double eqglac; 
	double[] glac=new double[ng], glac99=new double[ng], tau=new double [ng], deltat=new double[ng]; 
	
	//*******************************************************
	
	public void precalc() {
		//set up glacier groups
		for (n=0; n<ng; n++) {
			tau[n]=taul+(tauh-taul)*(double)n/(double)(ng-1); 
			deltat[n]=deltatl+(deltath-deltatl)*(double)n/(double)(ng-1); 
		}
	}

	public void calcstep(int ns) {
		
		//note thermal expansion calculated in the heatflux module
		
		if (ns>0) {
			//recovery from ice age
			longterm[ns]=(float)(longterm[ns-1]+0.00025); 
			
			//other factors: sedimentation and permafrost about 0.0002/yr
			//permafrost see tar11.2.6 0-0.23 mm/yr 1990-2100 and 0-0.05 1900-1990, +sedimentation 0-0.05 (constant?)
			
			other[ns]=(float)(other[ns-1]+(ns<240 ? 0.00005 : 0.00017 ) ); 
			
			//small glaciers
			glacier[ns]=(float)totglac; 
			for (n=0; n<ng; n++) {
				//calc equilibrium left at this temperature
				eqglac=(totglac/ng)*(1.0-heatflux.glotemp[ns]/deltat[n]); 
				if (eqglac<0) eqglac=0; 
				//then slow melting towards equilibrium
				//the 0.3 is a factor to match rates of melting in TAR -won't affect final melt (used to be 0.4)
				glac[n]-=0.3*(glac[n]-eqglac)/tau[n]; 
				glacier[ns]-=glac[n]; 
			}
			
			//polar ice-caps
			
			//need greenland and antarctica responding to longer term warming -see TARWG1 sec11.5.4.3
			//from TAR fig 11.16 greenland melt mm/yr in 3000: 3C: 0.5 = 0.17/C, 5.5C: 1.8 =0.33/C , 8C: 2.4 = 0.3 /C
			//text mentions 1mm/yr for 3C =0.33/C and 7 for 12C! = 0.57/C not inc precipitation
			//av sensitivity from models 1990-2090 is 0.13/C (for about 1.5C avg rise)
			
			glsensfac=1.0+(heatflux.glotemp[ns]-1.5)*0.3; //to be multiplied, i.e. sens up by 25% per degree
			
			//antarctica av sensitivity from models 1990-2090 is about -0.3C! (for about 1.5C avg rise)
			//max loss total antarctic 2.5mm/yr for 8C = +0.32/C
			//so sens increase could be about 0.6/6.5C ? but be conservative, use half this
			
			ansensfac=heatflux.glotemp[ns]*0.05; //to be added not multiplied!
			
			//apply sensfacs only after 2100 to aim for consistency with tar!
			
			antarctica[ns]=(float)(antarctica[ns-1] + ((ns>350 ? ansensfac : 0) + ansens[heatflux.model]) * heatflux.glotemp[ns] * 0.001); 
			greenland[ns]=(float)(greenland[ns-1] + (ns>350 ? glsensfac : 1) * glsens[heatflux.model] * heatflux.glotemp[ns] * 0.001); 
			
			//could use boxtemp[ns][2] and [1] i.e. south or north ocean temp rather than the global average, since this will determine precipitation or ice-edge melting better,
			//but TAR parameters already adjust global to local temps
			
			freshwater[ns]=0; //0.001f*ns;
		}
		
		//add up total
		total[ns]=
			heatflux.sealevte[ns]
			+glacier[ns]+longterm[ns]
			+antarctica[ns]+greenland[ns]
			//+freshwater[ns]
		+other[ns]
			; 
		
	} //********* end calcstep **************
	
	public void save99() {	for (n=0; n<ng; n++) glac99[n]=glac[n]; }
	
	public void startstate(int startyear) {
		longterm[0]=0; antarctica[0]=0; greenland[0]=0; freshwater[0]=0; glacier[0]=0; other[0]=0; 
		if (startyear==2000) for (n=0; n<ng; n++) glac[n]=glac99[n]; 
		else for (n=0; n<ng; n++) glac[n]=totglac/ng; 
	}
	
} //end sealevel class
//************** end *******************

//need to add freshwater and historical data 
//maybe show effect of WAIS? 
//and maybe storm surges?

