//Contains IPCC-SRES data 
//for no-climate-policy baseline scenarios
//also interpolation routines

//March 2002: this module is in transition:

//Originally developed spring 2001,
//Regional emissions population and gdp data from RIVM-IMAGE added in Arendal Summer 2001
//restructured Bern spring 2002

package jcm.mod;
import jcm.*;

public class sres extends module  {
	
	//***************************
	//INTERACTIONS
	//no interactions: just fixed data!
	
	public void setinteractions() {
		setaffectedby(loaddata); 
		
		affectsfutureonly=true; 
		setaffectedby(kyoto.kyotop); 
		setaffectedby(regshares.distribution); 
		setaffectedby(mitigation.scenario); 
	}
	
	//***************************
	//PARAMETERS
	String[] scenname={	"A1B","A1T","A1F","A2","B1", "B2", "IS92a", "TGCIA450"}; 
	
	public param scenario=new param("sresmenu", scenname, "A1B"); 
	
	//****************************
	//ARRAYS FOR INTERP, FILLED BY LOADDATA
	//item, (region,) scenario, year
	//6 SRES scenarios +IS92a
	//12 regions + world + extra
	//11 year blocks (2000-2100 in 10yr intervals)
	
	//later maybe combine similar types?
	
	//global data
	float[][]
		fosemit=new float[8][11],
		lucemit=new float[8][11],
		soxemit=new float[8][11],
		ch4emit=new float[8][11],
		n2oemit=new float[8][11],
		noxemit=new float[8][11],
		coemit=new float[8][11],
		vocemit=new float[8][11]
		; 
	float[][][] hfcemit=new float[12][7][11]; 
	
	//regional data
	float[][][]
		regemit=new float[13][6][11], //note only up to 12 filled by loaddata
		pop=new float[13][6][11],
		gdppc=new float[13][6][11],
		enpc=new float[13][6][11]
		; 
	
	//calculated data for superimposing circles
	//rf: co2bern, co2isam ch4, n2o, tropo3, hfc, cfc, sa, bcoc(isam), total
	public float[][][]
		rfdata=new float[10][7][11],
		sldata=new float[7][6][11]
		; 
	public float[][]
		bernmid=new float[7][11],
		tempchange=new float[7][11]
		; 
	
	
	//**************************************************
	//working variables
	public int datayear[]={	2000,2010,2020,2030,2040,2050,2060,2070,2080,2090,2100}; 
	
	int year, bk, by, ns, i, ns2100, nr, rs, rs0=time.fsy-time.rsy; 
	public int sc; //store index of scenario as seperate int for speed
	
	float[] rsnf=new float[12], rpnf=new float[13]; 
	
	
	public void initsetup() {
		//TGCIA450
		fosemit[7]=new float[]{	7.97f, 8.78f, 8.89f, 7.97f, 6.70f, 5.69f, 4.64f, 3.19f, 2.74f, 2.25f, 1.77f, 1.49f, 1.55f, 1.81f, 2.13f, 2.38f, 2.48f, 2.42f, 2.27f, 2.07f, 1.86f, 1.70f, 1.57f, 1.48f, 1.41f, 1.36f, 1.33f, 1.29f, 1.26f, 1.21f, 1.15f}; 
		//split fos and lucf using fracs from B1, and then constant ratio from 2100
		lucemit[7]=new float[31]; 
		for(int i=0; i<11; i++) {	lucemit[7][i]=fosemit[7][i]*lucemit[4][i]/(lucemit[4][i]+fosemit[4][i]); fosemit[7][i]=fosemit[7][i]-lucemit[7][i]; }
		for(int i=11; i<31; i++) {	lucemit[7][i]=  fosemit[7][i]*lucemit[7][10]/(lucemit[7][10]+fosemit[7][10]); fosemit[7][i]=fosemit[7][i]-lucemit[7][i]; }
		
		soxemit[7]=new float[]{	66.0f, 60.7f, 54.5f, 47.9f, 33.9f, 24.6f, 18.9f, 14.7f, 11.8f, 9.2f, 7.5f, 7.1f, 6.6f, 6.1f, 5.6f, 5.1f, 4.8f, 4.6f, 4.5f, 4.4f, 4.4f, 4.3f, 4.2f, 4.1f, 4.0f, 3.9f, 3.8f, 3.7f, 3.6f, 3.5f, 3.4f}; 
		ch4emit[7]=new float[]{	323f, 358f, 397f, 433f, 436f, 436f, 423f, 393f, 357f, 310f, 266f, 263f, 254f, 242f, 229f, 217f, 210f, 206f, 204f, 188f, 171f, 157f, 146f, 138f, 132f, 127f, 124f, 121f, 117f, 113f, 108f}; 
		n2oemit[7]=new float[]{	6.80f, 6.90f, 7.00f, 7.10f, 7.20f, 7.26f, 7.09f, 6.88f, 6.67f, 6.38f, 6.09f, 6.06f, 5.88f, 5.64f, 5.39f, 5.17f, 5.03f, 4.95f, 4.91f, 4.49f, 4.03f, 3.66f, 3.38f, 3.17f, 3.02f, 2.92f, 2.84f, 2.77f, 2.70f, 2.60f, 2.47f}; 
		noxemit[7]=new float[]{	32.0f, 33.6f, 35.0f, 36.2f, 34.8f, 33.9f, 32.6f, 28.5f, 24.7f, 21.5f, 20.1f, 19.7f, 18.7f, 17.3f, 15.9f, 14.7f, 13.9f, 13.4f, 13.2f, 12.5f, 11.8f, 11.2f, 10.7f, 10.3f, 9.9f, 9.6f, 9.4f, 9.1f, 8.8f, 8.5f, 8.2f}; 
		coemit[7]=new float[]{	877f, 872f,  851f, 823f, 800f, 779f, 756f, 740f, 722f, 698f, 674f, 667f, 643f, 610f, 576f, 546f, 526f, 515f, 511f, 471f, 430f, 395f, 369f, 349f, 334f, 323f, 314f, 306f, 298f, 288f, 274f}; 
		vocemit[7]=new float[]{	141f, 156f, 160f, 154f, 134f, 116f, 96f, 78f, 68f, 58f, 50f, 49f, 47f, 44f, 40f, 37f, 35f, 34f, 34f, 32f, 30f, 28f, 27f, 26f, 25f, 24f, 23f, 23f, 22f, 21f, 21f}; 
	
		super.initsetup(); 
	}
	//**************************************************
	
	//****************************
	//MAIN CALCULATIONS
	
	
	public void precalc() {
		
		sc=scenario.getchosenindex(); 
		
		pop(); gdp(); energy(); //must do pop first!
		
		for (ns=time.fsy-time.gsy; ns<time.gey-time.gsy; ns++) {
			
			if (mitigation.scenario.chosen=="nopolicy" || kyoto.kyotop.istrue()) carboncycle.fossil[ns]=1000f*interpns(fosemit,ns); 
			
			if (mitigation.scenario.chosen=="nopolicy") 	carboncycle.lucf[ns]=1000f*interpns(lucemit,ns); 
			
		} //end timeloop
		
		//if (regshares.distribution=="sresdist" || mitigation.scenario.chosen=="nopolicy" || kyoto.kyotop)
		//always do this to calculate baseline
		emitshare(); 
		
	} //end precalc
	
	
	//****************************
	//INTERPOLATION ROUTINES
	//linear interpolation between 10-year data
	
	void getbkby(int year) {	bk=(year-2000) / 10; by=(year-2000) % 10; }
	
	//for global data float[sc][bk]
	float interp(float[][] data, int year) {
		try {
			getbkby(year); 
			return (float)((bk<10 || (sc==7 && bk<30)) ? ((double)(10-by)*data[sc][bk]+ (double)by*data[sc][bk+1]) /10f : sc==7 ? data[sc][30]  : data[sc][10] ); 
		} catch (Exception e) {	iob.debug("sres interp error: "+data+" in "+year+" "+data[7].length) ; return 0; }
	}
	
	//using ns not year
	float interpns(float[][] data, int ns) {	return interp(data, ns+time.gsy); }
	
	//for regional data float[reg][sc][bk]
	float interp(float[][][] data, int reg, int sc, int year) {
		getbkby(year); 
		int sc2= (sc<7 ? sc : 4); //use B1 for TGCIA450 regional
		return (float)((bk<10) ? ((double)(10-by)*data[reg][sc2][bk]+ (double)by*data[reg][sc2][bk+1]) /10f : data[reg][sc2][10] ); 
	}
	
	//for hfc data -unnecessarily complicated as only use in 5-yr intervals!
	float interphfc(int which, int year) {
		int schfc=(sc<3 ? 0 : sc<7 ? sc-2 : 2); //all A1 same, for TGCIA450 use B1
		if (sc==6 && (which<4 || which>6)) return 0; //is92a only has data for 3 gases
		else {
			getbkby(year); 
			return (float)((bk<10) ? ((double)(10-by)*hfcemit[which][schfc][bk]+ (double)by*hfcemit[which][schfc][bk+1]) /10f : hfcemit[which][schfc][10] ); 
		}
	}
	
	//****************************
	//FILLING ARRAYS IN OTHER MODULES
	
	void pop() {	if (sc<8) {
			int scp=(sc==3 ? 1 : sc==5 ? 2 : 0); //pop is same for all A1+B1 (and TGCIA450)
			//normalising factor to join on to hist data
			for (nr=0; nr<13; nr++) rpnf[nr]=people.pop[nr][rs0]/(float)pop[nr][scp][0]; 
			
			for (year=2000; year<=time.rey; year++) {
				rs=year-time.rsy; 
				for (nr=0; nr<13; nr++) people.pop[nr][rs]= rpnf[nr]*interp(pop, nr, scp, year); 
				//and renormalise so total must be pop[12]
				float rpnf2=0; 
				for (nr=0; nr<12; nr++) rpnf2+=people.pop[nr][rs]; 
				for (nr=0; nr<12; nr++) people.pop[nr][rs]*=(people.pop[12][rs]/rpnf2); 
			}
		}} //end pop
	
	//****************************
	
	void gdp() {	if (sc<8) {
			int scg=(sc==7 ? 2 : sc==6 ? 0  : sc>2 ? sc-2 : 0); //gdp is same for all A1T,F,B, IS92A, for TCGIA450 use B1
			for (year=2000; year<=time.rey; year++) {	rs=year-time.rsy; 
				for (nr=0; nr<13; nr++) people.gdp[nr][rs]= interp(gdppc, nr, scg, year)*people.pop[nr][rs]/1000f; 
			}}} //end gdp
	
	void energy() {	if (sc<8) {
			int sce=(sc==7 ? 4 : sc==6 ? 0  : sc); //energy use A1B for IS92A, B1 for TCGIA450
			for (year=2000; year<=time.rey; year++) {	rs=year-time.rsy; 
				for (nr=0; nr<13; nr++) people.en[nr][rs]= interp(enpc, nr, sce, year)*people.pop[nr][rs]; 
			}}} //end energy
	
	
	//****************************
	void emitshare() {	if (sc<8) {
			
			int sce=(sc==7 ? 4 : sc==6 ? 0  : sc); //energy use A1B for IS92A, B1 for TCGIA450
			//normalising factor to join on to hist data
			for (nr=0; nr<12; nr++) rsnf[nr]=1000f*(regshares.emit[nr][rs0]/(float)mitigation.ge2000) /(float)regemit[nr][sce][0]; 
			
			for (year=2000; year<=time.rey; year++) {
				
				rs=year-time.rsy; ns=year-time.gsy; 
				for (nr=0; nr<12; nr++) regshares.share[nr][rs]= rsnf[nr]*interp(regemit, nr, sce, year)/1000f; 
				//and renormalise so total must be one
				float rsnf2=0; 
				for (nr=0; nr<12; nr++) rsnf2+=regshares.share[nr][rs]; 
				for (nr=0; nr<12; nr++) regshares.share[nr][rs]/=rsnf2; 
				regshares.share[nr][12]=1f; regshares.share[nr][13]=0f; 
				for (nr=0; nr<14; nr++) regshares.baseemit[nr][rs]=regshares.share[nr][rs]*1000f*interpns(fosemit,ns); 
			}
		}} //end emitshare
	
	//****************************
	
	
	
	
	
} //end class

