//For preliminary experiments with cost functions,
//created Louvain-la-neuve, January 2002, separated from regionplot July 2002

package jcm.pan;
import jcm.*;
import jcm.mod.*;
import jcm.gui.*; 
import java.awt.Color;

public class costsplot extends regionplot {
	
	public costsplot() {
		toplist=  new String[] {	"abcost", "damcost", "totcost", "disccost", "popn", "energy", "gdp", "co2emit", "abate", ""}; 
		unitlist= new String[] {	"giga&dollar&per&yr","giga&dollar&per&yr","giga&dollar&per&yr", "giga&dollar&per&yr", "mega&person", "tera&joule&per&yr", "giga&dollar&per&yr", "mega&ton&carbon&per&yr", "mega&ton&carbon&per&yr", ""}; 
		perlist=toplist; 
		punitlist=unitlist	; 
		datalist=new float[][][] {	costs.abate, costs.damage, costs.total, costs.discounted, people.pop, people.en, people.gdp, regshares.emit, regshares.abate, null}; 
		perdatalist=datalist; 
		regcols=regionset.jcmreg.getcols();
	}
	
	//********************************
	//constructors
	
	public void makelists(String top, String per) {
		xd=time.rgx; 
		xscale.setup("yr", time.rsy, time.rey, 20, 1.0); 
		curvename = regionset.jcmreg.getnames(); 
		curvecolor=regionset.jcmreg.getcols(); 
		setvarper(top, per); 
	}
	
	public option macgem=new option(costs.macgem, this); 
	public option popweight=new option(costs.popweight, this); 
	
	public control
		damagelin=new control(costs.damagelin, this, "ya", "ns", cyan, 60, 2),
		damagepow=new control(costs.damagepow, this, "ya", "ns", blue, 70, 2),
		abatelin=new control(costs.abatelin, this, "ya", "ns", orange, 30, 2),
		abatepow=new control(costs.abatepow, this, "ya", "ns", red, 40, 2),
		discountrate=new control(costs.discountrate, this, "xa", "ew", red, 50, 2); 
	
	public void setinteractions() {
		super.setinteractions(); 
		boolean
			disc = topdata==costs.discounted || perdata==costs.discounted,
			totc=  topdata==costs.total || perdata==costs.total,
			abac= disc || totc || topdata==costs.abate ||  perdata==costs.abate,
			damc= disc || totc || topdata==costs.damage || perdata==costs.damage; 
		discountrate.output &=disc; 
		damagelin.output &=damc; damagepow.output &=damc; 
		macgem.output &=abac; abatelin.output &=abac; abatepow.output &=abac && !costs.macgem.istrue(); 
	}
	
	//***************************************************
	
	
} //end costsplot

