//Distribution plot:
//shows regional distribution options and socioeconomic data

package jcm.pan;
import jcm.*;
import jcm.mod.*;
import jcm.gui.*; 
import java.awt.Color;

public class distribplot extends regionplot {
	
	public distribplot (){
		toplist= new String[] {	"co2emit", "abate","popn", "energy", "gdp",  ""}; 
		perlist=toplist; 
		unitlist= new String[]{	"mega&ton&carbon&per&yr", "mega&ton&carbon&per&yr", 	"mega&person", "peta&joule&per&yr", "giga&dollar&per&yr", ""}; 
		punitlist=unitlist; 
		datalist=new float[][][] {	regshares.emit, regshares.abate, people.pop, people.en, people.gdp, null}; 
		perdatalist= datalist; 
		regcols= regionset.jcmreg.getcols(); 
	}
	//note: now scale works out unit scalars, so here just use put the units of the original data
	//energy ends up in kilo-exa joules!
	
	//controls for kyoto, stabemit, convergence
	public option
		kyotoopt=new option(kyoto.kyotop, this),
		incusa=new option(kyoto.incusa, this),
		quartic=new option(mitigation.quartic, this, "expert"),
		exponential=new option(regshares.exponential, this, "expert"),
		popcoyoption=new option(regshares.popcoyoption, this, "expert"); 
	
	public control
		convergey=new control(regshares.convergey, this, "x", "downarrow", Color.blue, 15, 0),
		convergef=new control(regshares.cvf, this, "xa", "ew", Color.cyan, 50, 1),
		popcoy=new control(regshares.popcoy, this, "x", "downarrow", Color.green, 15, 0),
		integral=new control(mitigation.integralgt, this, "ya", "ns", Color.red, 70, 0, "expert"),
		initialgrowth=new control(mitigation.sygrowth, this, "ya", "uptriangle", Color.orange, 50, 2, "expert"),
		reduceintensity=new control(mitigation.reduceintensity, this, "ya", "ns", pink, 70, 1),
		stabemit=new control(mitigation.stabemityear, this, "xy", "nsew", Color.yellow, 0, 2, "verysimple"); 
	
	public static int counter=0; //because initially three of these distribplots!
	
	//********************************
	
	public void makelists(String top, String per) {
		stacked.flag=true; stacked.defflag=true; 
		xd=time.rgx; 
		xscale.setup("yr", time.rsy, time.rey, 20, 1.0); 
		curvename = regionset.jcmreg.getnames(); 
		curvecolor= regcols; 
		setvarper(top, per); 
		counter++; //name+="&"+counter; remove this because problem with showhelppage!
	}
	
	public void setup() {
		if (complexity.complexity.chosen=="verysimple") xscale.setup("yr", time.gsy,time.gey,50, 1.0); else xscale.setup("yr", time.rsy, time.rey, 20, 1.0); 
		super.setup(); 
	}
	
	//***************************************************
	
	public void setinteractions() {
		curvelevel[12]="verysimple"; //if verysimple just show world total or average
		if (complexity.complexity.changed || perq.changed) {
			stacked.flag = (perdata==null && !rate.istrue()) && !(complexity.complexity.chosen=="verysimple"); 
		}
		
		super.setinteractions(); 
		curveoutput[12] &=(!curveoutput[0] || (!stacked.istrue() && !frac.istrue())); //world total/average only if not stacked or verysimple
		curveoutput[13] &=(perdata==null); //bunker emissions only if not divided by anything
		if (yd.length>14) curveoutput[14] &=(stacked.istrue()); //remainder only if stacked
		
		boolean
			emitcontrol=(topdata==regshares.emit && perdata==null && mitigation.scenario.chosen=="stabemit"),
			convergence=(topdata==regshares.emit && ((perdata==people.pop && regshares.distribution.chosen=="percapita") || (perdata==people.gdp && regshares.distribution.chosen=="convpergdp"))) ; 
		//for brazil add (...) || topdata==responsibility.atc && perdata==people.pop && regshares.distribution.chosen=="convresp"
		
		reduceintensity.output &= mitigation.scenario.chosen=="reduceintensity"; 
		stabemit.output &=emitcontrol; quartic.output &=emitcontrol; initialgrowth.output &=emitcontrol; 
		integral.output &= emitcontrol && mitigation.quartic.istrue(); 
		
		kyotoopt.output &= bufi.affectedby(regshares) && mitigation.scenario.chosen!="bush"; 
		incusa.output &=kyotoopt.output && kyoto.kyotop.istrue(); 
		
		convergey.output &= convergence; 
		exponential.output &=convergence; 
		popcoyoption.output &=convergence; 
		popcoy.output &= regshares.popcoyoption.istrue() && convergence; 
		convergef.output &= regshares.exponential.istrue() && convergence; 
	}
	
	//***************************************************
	
} //end distribplot

