//jcmpanel which plots the regional climate maps

//note calculations now moved into regcli module

package jcm.pan;

import jcm.gui.*; 
import jcm.*;
import jcm.mod.*;

import java.awt.*;
import java.util.*;

public class regclimap extends mapplot implements Runnable {
	
	public void setinteractions() {
		super.setinteractions(); 
		bufi.setaffectedby(regcli); 
		bufi.setaffectedby(usereg); 
		bufi.setaffectedby(landonly); 
		bufi.setaffectedby(rescale); 
		pansetup.setaffectedby(projection); 
		rescale.setaffectedby(regcli.quantity); 
		ylopt.output &=regcli.scale.istrue(); 
	}
	
	public void reset() {	rescale.changed=true; }
	
	
	//*************************************
	
	//link to mapdata
	mapdata d=regcli.d, d2=regcli.d2, d3=regcli.d3; 
	
	
	//general working variables
	Thread th; //for auto-cycle, and to wait for regcli ready
	
	Polygon[] poly; 
	Polygon yc=new Polygon(), rc=new Polygon(); 
	colorscale cols=new colorscale(); 
	
	int m,s,ss, i,j,k,x,y,z; 
	int xx, xw, yh, bw=0, bh=0; 
	
	public param
		rotating=new param("rotateopt", false),
		monthloop=new param("monthcycopt", false),
		yearloop=new param("yearcycopt", false),
		usereg=new param("usereg", false),
		landonly=new param("land", false),
		rescale=new param("rescale")
		; 
	
	public menu
		monthmenu=new menu(regcli.month, this),
		quantitymenu=new menu(regcli.quantity, this),
		datasetmenu=new menu(regcli.dataset, this); 
	
	public option
		scaleopt=new option(regcli.scale, this),
		rotopt=new option(rotating, this),
		mlopt=new option(monthloop, this),
		ylopt=new option(yearloop, this, "expert"),
		regopt=new option(usereg, this),
		rescaleopt=new option(rescale, this),
		landopt=new option(landonly, this); 
	
	String oq="", od=""; boolean ob=false; 
	
	
	//*************************************
	//SETUP
	
	public void initsetup() {
		cols.makecolours(); 
		cols.setminandrange(d.fac*(d.av-3.0*d.sd), d.fac*(6.0*d.sd)); 
		super.initsetup(); 
	}
	
	//setup called after resizing for example
	public void setup() {
		super.setup(); 
		//		makepolys();
		newpolys=true; 
	} //end setup
	
	
	//makepolys done on resizing the plot or changing dataset
	//the polys are not rotated when startlon is changed, they are just swapped
	//this is faster but may be misalignment with coastlines by up to one gridcell
	//this does not affect averaging calculations which are done with (fixed) polygons of region
	void makepolys() {
		sl=0; 
		poly=new Polygon[d.tot+1]; 
		Point[][] p=new Point[d.nlon+1][d.nlat+1]; 
		double lat, lon; 
		boolean ok; 
		for (y=0; y<=d.nlat; y++) for (x=0; x<=d.nlon; x++) p[x][y]=translate(lon(x), lat(y)); 
		for (y=0; y<d.nlat; y++) for (x=0; x<d.nlon; x++) {
			i=y*d.nlon+x; 
			poly[i]=new Polygon(); 
			ok =  notwrap((int)lon(x), (int)lat(y), (int)lon(x+1), (int)lat(y+1)); 
			if (ok) {
				poly[i].addPoint(p[x][y].x, 		 p[x][y].y); 
				poly[i].addPoint(p[x+1][y].x, 		p[x+1][y].y); 
				poly[i].addPoint(p[x+1][y+1].x,   p[x+1][y+1].y); 
				poly[i].addPoint(p[x][y+1].x, 		p[x][y+1].y); 
			}
		}
		sl=(int)startlon.val; 
	} //end makepolys
	
	double lon(int x) {	return 360.0*x/d.nlon-180.0; }
	double lat(int y) {	return 90.0 - 180.0*y/d.nlat; }
	
	//fillpolys is called from paint-routine
	void fillpolys(Graphics g) {
		for (y=0; y<d.nlat; y++) for (x=0; x<d.nlon; x++) {
			i=y*d.nlon+x; 
			int xx=(x+(int)(startlon.val*d.nlon/360.0) +d.nlon/2 )%d.nlon; 
			if (!(landonly.istrue() && regcli.dataset.chosen.startsWith("h") && regcli.land[i]==-1)   && d.r[i]>-999 ) {
				g.setColor(cols.getcolor(i)); g.fillPolygon(poly[y*d.nlon+xx]); 
			}
		}
	} //end fillpolys
	
	
	//*************************
	//MAIN PAINT ROUTINE
	
	public void makebuffer() {
		try {
			if (output && !painting) {	//don't operate loops if not visible! don't paint if already painting
				if (regcli.ready && regcli.gotdata) {
					//debug ("rcm buf");
					painting=true; 
					if (!(regcli.dataset.chosen.equals(od)) || !(regcli.quantity.chosen.equals(oq)) ) {
						newpolys=true; 
						if (!(regcli.quantity.chosen.equals(oq)) || ( (regcli.dataset.chosen.startsWith("b"))!=ob) ) cols.setminandrange(d.fac*(d.av-3.0*d.sd), d.fac*(6.0*d.sd)); 
						oq=regcli.quantity.chosen; od=regcli.dataset.chosen; ob=od.startsWith("b"); 
					}
					if (newpolys) {
						setsize(0,0,panw,panh-tmh, (int)startlon.val);
						bufi.newimage(0, tmh, panw, panh-tmh); 
						makepolys(); 
						newpolys=false; 
					}
					if (usereg.istrue()) {	bufi.clear(); paintreg(bufi.g); }
					else fillpolys(bufi.g); 
					paintline(bufi.g); 
					
					drawString(bufi.g, (jcm.tls.labinf.getlabel(regcli.month.chosen)+"          ").substring(0,12),4,2); 
					if (regcli.scale.istrue()) drawString(bufi.g,  String.valueOf(regcli.year.val)+"  ",4,20); 
					
				painting=false; 
				} else  {	debug("regcli not ready"); tryagain(); }
			}
		} catch (ArrayIndexOutOfBoundsException e) {	debug("regclimap "+e); tryagain(); }
	}
	
	public void tryagain() {	painting=false; regcli.settrigger(this); debug("regclimap tryagain"); }
	public void trigger() {	bufi.changed=true; debug("trigger called loop"); loop.go(); }
	
	public Color regcol(region r) {
		return ( regcli.quantity.chosen.equals("mix&tmx&tmn&pre") ? cols.mixregcolor(r) : cols.getcolor(r.avg(d)) ); 
	}
	
	//********************
	//THREAD TO CONTROL AUTO-CYCLE
	public void run() {
		try {
			while (Thread.currentThread()==th && (rotating.istrue() || monthloop.istrue() || yearloop.istrue())) {
				th.sleep(50); 
				if (!gotevent && !painting && !bufi.painting && !loop.inmainloop) {
					//change data if loops running
					if (rotating.istrue()) {	startlon.val=(int)((int)startlon.val+5 /*1.0*(360.0/d.nlon)*/ ) %360; startlon.respond(false); }
					if (monthloop.istrue()) {	regcli.month.chosen=regcli.months[(regcli.month.getchosenindex()+1)%d.nmon]; regcli.month.respond(false); }
					if (yearloop.istrue() && (!monthloop.istrue() || regcli.month.chosen=="jan")) {	regcli.year.val=1750+(regcli.year.val-1749)%time.glos; regcli.year.respond(false); }
					if (rotating.istrue() || monthloop.istrue() || yearloop.istrue()) loop.go(); 
					//note doesn't move arrow on glotemplot!
				}
			}
		} catch (InterruptedException e) {	}
	} //end run
	
	//****************************
	//EFFECTS OF BUTTONS/MENUS
	
	public void postcalc(iob iob) {
		super.postcalc(iob); 
		if (iob==rescale) 	cols.setminandrange(d.fac*(d.av-3.0*d.sd), d.fac*(6.0*d.sd)); 
		
		//start or stop auto-cycle
		if (rotating.istrue() || monthloop.istrue() || yearloop.istrue()) {	th=new Thread(this); th.setPriority(th.MIN_PRIORITY); th.start(); }
		else th=null; 
		
	} //end effects
	
	//***********************************
	//EVENTS
	
	public boolean handleEvent(Event e) {
		//note most events now handled by mapplot
		//key press to control loops
		if (e.id==Event.KEY_ACTION_RELEASE) {
			if (e.key==(int)"R".charAt(0) || e.key==(int)"r".charAt(0)) {	rotating.flag=!rotating.istrue(); rotating.respond(true); }
			if (e.key==Event.ESCAPE) {	rotating.flag=false; monthloop.flag=false; yearloop.flag=false; }
		}
		return 	super.handleEvent(e); 
	}  //end handlevent
	
	
	//*********************************************
	
	public void writepos() {	writelatlon(); writetemp(); }
	public void writetemp() {
		y=(int)((90-my)*d.nlat/180); x=(int) (d.nlon*(mx)/360)%d.nlon; i=d.nlon*y+x; 
		double ti=( (int)(100.0* d.r[i]  ) ) /100.0; 
		// -regcli.tempbase()
		drawString(""+ti /*+" C   "*/+"    " , panw-35,panh-32); //delta "\u0394: "
		if (insidereg!=null) drawString(insidereg.code+" "+( (int)(100.0*insidereg.avg(d)))/100.0+"    ", panw-55,panh-16); 
		else  drawString("             ", panw-55,panh-16); 
	}
	
	
} //end class
	
	
	
