//class param holds user-adjustable parameters

package jcm;
import jcm.mod.module;
import jcm.tls.*;
import java.util.Vector;

public class param extends iob {
	
	//*****************************
	//VARIABLES
	
	public int type; 
	public static final int iobmenu=0, menu=1, option=2, value=3, trigger=4; 
	
	public static param scriptmode=new param("scriptmode", (new String[] {	"demo", "direct", "delay"}), "direct"); 
	public static boolean reportchange=true; 
	
	public Vector holders=new Vector(); 
	
	//specific to types of param
	public iob[] ioblist; public iob choseniob, defchoseniob; //for iob menus
	public String[] menulist; public String chosen, defchosen; //for string menus
	public int numitems; 
	public boolean flag, defflag; //for options
	public double val, defval, max, min; public int dp; public String units; public param pair; public boolean pairof=false; //for values
	
	public void setinteractions() {	setaffects(owner); }
	//public boolean indoc() {	return holder.output || owner instanceof module; }
	
	//need to know about multiple holders in case first plot disposed, want to move to second
	public void setholder(iob i) {	holders.addElement(i); }
	public iob getholder() {	for (int i=0; i<holders.size(); i++) {	iob iob=(iob)holders.elementAt(i); if (!iob.disposed) holder=iob; return iob; }	return this; }
	
	
	//***************************
	//CONSTRUCTORS
	
	public param() {	register(); }
	
	//menu - string
	public param(String iname, String[] imenulist, String ichosen) {
		name=iname; menulist=imenulist; chosen=ichosen; defchosen=chosen; type=menu; numitems=menulist.length; register(); 
	}
	
	//menu -iob
	public param(String iname, iob[] ioblist, iob choseniob) {
		name=iname; this.ioblist=ioblist; this.choseniob=choseniob; defchoseniob=choseniob; type=iobmenu; numitems=ioblist.length; register(); 
	}
	//do i still need this type? or could use findiob(name)
	
	//controls
	public param(String name, String units, double val, double min, double max) {	this(name, units, val, min, max, null); }
	
	public param(String name, String units, double val, double min, double max, param pairof) {
		String[] ss=txt.split(name,"&"); this.name=ss[0]; if (ss.length>1) this.name2= "&"+ss[1]; 
		this.units=units; this.val=val; defval=val; this.min=min; this.max=max; type=value; register(); 
		if (pairof!=null) {	pairof.pair=this; this.pairof=true; }
	}
	
	//options
	public param(String name, boolean flag) {
		this.name=name; this.flag=flag; defflag=flag; type=option; register(); 
	}
	
	//trigger
	public param(String name) {	this.name=name; type=trigger; this.flag=false; this.defflag=false; changed=false; register(); } //note changed=false here!
	
	//**************************
	//QUERY/CHANGE
	
	public void reset() {
		if (type==menu && chosen!=defchosen) {	chosen=defchosen; changed=true; }
		if (type==iobmenu && choseniob!=defchoseniob) {	choseniob=defchoseniob; changed=true; }
		if (type==option && flag!=defflag) {	flag=defflag; changed=true; }
		if (type==value && val!=defval) {	val=defval; changed=true; }
		if (type==trigger) flag=defflag; 
	}
	
	public void choose(String c) {
		if (c.equals("next")) {	choose( (getchosenindex()+1) % numitems); return; }
		if (c.equals("prev")) {	choose( (numitems +getchosenindex()-1) % numitems); return; }
		if (type==menu) {	for (int i=0; i<menulist.length; i++) if (c.equals(menulist[i])) chosen=menulist[i]; return; }
		if (type==iobmenu)	{	for (int i=0; i<ioblist.length; i++) if (c.equals(ioblist[i].name)) 	choseniob=ioblist[i]; chosen=choseniob.name; }
	}
	//this search is necessary even for string lists because == checks ref of string not its contents, and code elsewhere doesn't always use .equals() method
	public void choose(int i) {
		if (type==menu)	chosen=menulist[i]; 
		if (type==iobmenu) {	choseniob=ioblist[i]; chosen=choseniob.name; }
	}
	
	public String name (int i) {	if (type==menu) return menulist[i]; else return ioblist[i].getname(); }
	public String longname (int i) {	if (type==menu) return menulist[i]; else return ioblist[i].getname()+ioblist[i].name2; }
	public void iobtostring()	{	menulist=new String[ioblist.length]; for (int i=0; i<ioblist.length; i++) menulist[i]=ioblist[i].name; chosen=choseniob.name; }
	
	public void demo() {	getholder().demo(); }
	public void doscript(String s) {	//for scripting
		if (type==option) {	if (s.equals("false") || s.equals("f") || s.equals("F") || s.equals("off") || s.equals("dis") || s.equals("disabled")) flag=false; else flag=true; }
		if (type==menu || type==iobmenu) choose(s); 
		if (type==value) setval(Double.valueOf(s).doubleValue()); 
		doscript(); 
	}
	
	public void setval(double val) {	this.val=val; }
	public void setflag(boolean b) {	flag=b; }
	
	//called from mod.script
	public void set(double d) {	val=d; doscript(); }
	public void set(boolean b) {	flag=b; doscript(); }
	public void set(String s) {	choose(s); doscript(); }
	public void set(int i) {	if (type==value) set((double)i); else {	choose(i); doscript(); }}
	
	public void doscript() {
		//trigger types set nothing
		if (scriptmode.chosen.equals("demo")) getholder().demopreloop(); 
		respond(!scriptmode.chosen.equals("delay")); 
		if (scriptmode.chosen.equals("demo")) getholder().demopostloop(); 
	}
	
	public String getstringval() {	return ""+((type==option) ? ""+flag : (type==menu) ? chosen :  (type==iobmenu) ? choseniob.name : (type==value) ? ""+val : ""); }
	
	public double getval() {	return val; }
	public double getdef() {	return defval; }
	public double getfrac() {	return val/defval; }
	public boolean istrue() {	return flag; }
	public String getname(int i) {	return ((type==iobmenu) ? ioblist[i].name : menulist[i]); }
	
	public boolean isnotdefault() {
		if (type==menu) return chosen!=defchosen; 
		if (type==iobmenu) return choseniob!=defchoseniob; 
		if (type==value) return val!=defval; 
		if (type==option) return flag!=defflag; 
		return false; 
	}
	
	public String getinfo() {
		String ena=labinf.getlabel("ena"), dis=labinf.getlabel("dis"); 
		String info=labinf.getlabel(name); 
		if (type==menu) info+=(" \t\t"+labinf.getlabel(chosen)+(isnotdefault() ? " ("+labinf.getlabel(defchosen)+")" : "")+" \n"); 
		if (type==iobmenu) try {	info+=(" \t\t"+labinf.getlabel(choseniob.name)+(isnotdefault() ? " ("+labinf.getlabel(defchoseniob.name)+")"  : "")+"\n"); } catch (NullPointerException e) {	info+=("\t\t null \n"); }
		if (type==option) info+=(" \t\t: "+(flag ? ena : dis )+(isnotdefault() ? " ("+(defflag ? ena : dis )+")"  : "")+" \n"); 
		if (type==value) info+=(" \t\t"+ txt.dp(val, dp)+(isnotdefault() ? " ("+ txt.dp(defval, dp)+") "  : "")+((units!="" && units!=null)? labinf.getshort(units) : "")+" \n")	; 
		return info; 
	}
	
	
	public String docinfo() {
		String label=(pairof? labinf.getlabel(name2) : labinf.getlabel(name+name2)); 
		if	(type==option) return " <input type=checkbox "+(flag ? "checked" : "" )+" onclick=\"jcm.playi('"+name+" : '+checked); \"> "+label; 
		if   (type==value) return
			label+" <input type=text size=6 style='font:75%' value="+ txt.dp(val, dp)
			+" onchange=\"jcm.playi('"+name +name2+" : '+value); \" >"+ ((units!="" && units!=null)? labinf.getshort(units) : "")
			+(isnotdefault() ? " (<i>`default : "+ txt.dp(defval, dp)+"</i>) "  : "")+" <br>"
			+(pair!=null ? pair.docinfo() : "") ; 
		
		if  (type==menu || type==iobmenu)  {
			String	info=label+" <select style='font:75%' onchange=  \"jcm.playi('"+name +" : '+item(selectedIndex).value); \" >"; 
			for (int i=0; i<numitems; i++) info+="<option value="+getname(i)+(i==getchosenindex() ? " selected" : "")+" >"+ labinf.getlabel(getname(i)); 
			info+="</select>"; 
			String info2=""; for (int i=0; i<numitems; i++)  /*if (labinf.getdocnosplit(getname(i)).length()>1)*/  info2+="<li>"+ autodoc.link(getname(i)); 
			//note: check of getdocnosplit forces all the doc to load when (for example) you open any plot menu
			if (info2.length()>2)  info+="<br> `moreinfo"; 
			return info+""+info2+"<br>"; 
		}
		if (type==trigger) return  " <input type=button style='font:75%' value='"+labinf.getshort(name)+"' onclick=\"jcm.playi('"+name+" : true'); \"> "+label; 
		return ""; 
	}
	
	public int getchosenindex() {
		int i=0; 
		if (type==iobmenu)  for (int j=0; j<ioblist.length; j++) if (choseniob==ioblist[j]) i=j; 
		if (type==menu) 	for (int j=0; j<menulist.length; j++) if (chosen.equals(menulist[j])) i=j; 
		return i; 
	}
	
	//************************************
	
	public void respond(boolean domodloop) {
		if (reportchange) debug(getfullname()+" "+getstringval()); 
		changed=true; 
		if (domodloop) loop.go(); 
	}
}//end param
	
	
	
	
