//PLAYER - plays a scripted sequence of events


package jcm.tls;
import jcm.*;

public class player extends iob implements Runnable {
	
	public static boolean running=false; 
	static Thread pth; //playthread
	
	//**********************************
	//INPUT INSTRUCTIONS
	
	public static void playins(String script) {	newins(script); start(); }
	public static void newins(String script) {	allins=txt.split(script); }
	public static void addnewins(String  script) {	allins=txt.add(allins, txt.split(script)); }
	
	//**********************************
	//START, RUN, STOP
	
	public static void start() {	if (!running) {	pth=new Thread(new player()); running=true; pth.start(); } } //if running, just keep going
	public static void stop() {	running=false; pth=null; } //popob.popup=false; menu.currentlistup=null; } -need to do another way because don't know about gui!
	public static boolean ok() {	return (pth==Thread.currentThread() && running); }
	public void run() {	sec baseloop=new sec(-1); baseloop.inbracket=true; baseloop.donext(); stop(); }
	//note it gives you the opening bracket! use a closing bracket to force end
	
	//************************************
	//LOCATE
	static String getnextins(sec sec) {
		if (sec.loc<(allins.length-1)) {	sec.loc++; return allins[sec.loc]; }
		else  return ")"; 
	}
	
	static int  findloc(String label) {
		int i=0; 
		while (i<allins.length) {
			if (allins[i].equals(label)) return i; 
			if (allins[i].equals("sub")) i++; 
			i++; 
		}
		return 0; 
	}
	
	//************************************
	//TIMING
	
	static long t, dt=500, newt; //int maxwait=10000;  this was for remotecontrol
	public static void wait(int gap) {	if (gap>0) dt=gap; waitgap(); }
	public static void waitgap() {	t=System.currentTimeMillis(); while (System.currentTimeMillis()<t+dt && pth==Thread.currentThread() && running) 	pause(); }
	public static void pause() {	try {	pth.sleep(20); } catch (InterruptedException e) {	debug("interrupted!"); }  }
	public static void waitready() {	while (loop.inmainloop) pause(); }
	
	
	//************************************
	//VARIABLES
	
	static String[] allins=new String[0]; //instions (split)
	static String[] v = new String[100], vn = new String[100]; static int nv=0; //variables - content, name, total,
	
	static int find(String f) {	int n=0; while (n < nv && !(vn[n].equals(f)) ) n++; return n; }
	static int findorcreate(String f) {	int n=find(f); if (n==nv) {	vn[n]=f; v[n]=""; nv++; } return n; }  //if don't find, add new blank $name to list;
	static String finds(String f) {	int n=find(f); if (n==nv) return null; else return v[n]; }
	static void setv(String f, String s) {	v[findorcreate(f)]=s; }
	//************************
	
} //end player
	
	
	//************************
	// CURRENT ITEM IN SCRIPT 

class sec {
	
	int loc; String val, prev, next; 
	boolean inbracket=false, skip=false, inquote=false; 
	
	sec(int l) {	this(l, false); }
	sec(int l, boolean bracket) {	loc=l; val=null; prev=null; inbracket=bracket; } //constructor
	
	// return result from a new sec loop immediately following sec position, move on to end of it
	sec newsec() {	sec c = new sec(loc); c.donext(); loc=c.loc; return c; }
	sec newbsec() {	sec c = new sec(loc, true); c.donext(); loc=c.loc; return c; }
	sec subsec() {	sec c = new sec(player.findloc(newco())); c.donext(); return c; }
	void skip() {	sec c = new sec(loc); c.skip=true; c.donext(); loc=c.loc; }
	
	String newco() {	return newsec().getco(); }
	String subco() {	return subsec().getco(); }
	
	sec donext() {
		try {
			
			do {
				player.waitready(); 
				next= player.getnextins(this); 
				//iob.debug("*"+next);
				
				//quotes and brackets
				if (inquote && next.equals("'")) {	inquote=false; continue; }
				if (next.equals("'")) {	val = ""; inquote=true; continue; } //now it will keep going until encountering another '
				if (next.equals("(")) {
					val=null; 
					if (inbracket) setco(newbsec().getco()); 
					else inbracket=true; 
					continue; 
				} //now it will keep going until encountering ")"
				
				if (next.equals(")")) {	inbracket=false; continue; }
				if (skip) continue; // if skip ( following an "if" that was false or an else that was true) ignore everything except brackets and quotes
				
				if (inquote) {	val+=(val=="" ? "" : " ")+ next; continue; }
				
				if (next.length() < 7) 	{
					//***********************
					//set val functions
					
					if (next.equals(";")) {	val=null; continue; } // set val to null because finished with it (not required, but useful to force script mistakes to show up in debug)
					if (next.equals(":")) {  val=prev; setco(newco()); continue; }//set prev  to contents of parameter  (if its an iob, pass the parameter to its doscript method)
					if (next.startsWith(":")) { val=prev; next=next.substring(1); }  //next is what's left, so can do :+ (+=) :/ (/=) :~ (append to self) etc.
					if (next.equals("_")) {	val=prev; setco(newsec().prev); continue; } // use parameter as string, don't interpret it
					if (next.equals("var")) {	val=newsec().prev; continue; } //convert value of parameter into name of val - could use to make arrays, for recursion etc.
					if (next.equals("put")) {	newsec().setco(getco()); continue; } //the opposite of : set value of parameter to val (this is useful at the beginning of a function which inherits sec)
					
					//************************
					//loop functions - one parameter
					
					if (next.equals("sub")) {	val=null; setco(subco()); continue; } 	//  jump to label, set to result returned  (return at end of bracket or quote)
					if (next.equals("goto")) {	loc=player.findloc(newco()); continue; } 	//  jump to label, never come back
					
					//************************
					// if X then do Y (and set val to the boolean condition, which could then be the input condition of else)
					if (next.equals("if")) {	val=newco(); if (istrue()) newsec(); else skip(); continue; } //two parameters
					if (next.equals("else")) {	if (!istrue()) newsec(); else skip(); continue; } //one parameter
					
					//***********************
					//boolean - return true or false:
					if (next.equals("!")) {	setco(""+ (!txt.bv(newco()))); continue; } // not
					if (next.equals(">")) {	setco(""+(txt.dv(getco()) > txt.dv(newco()))); continue; }
					if (next.equals("<")) {	setco(""+(txt.dv(getco()) < txt.dv(newco()))); continue; }
					if (next.equals("&")) {	setco(""+(txt.bv(getco()) & txt.bv(newco()))); continue; }
					if (next.equals("|")) {	setco(""+(txt.bv(getco()) | txt.bv(newco()))); continue; }
					if (next.equals("==") || next.equals("eq")) {	//numeric or string equals
						String d=newco(); setco(""+  ( Double.isNaN(txt.dv(d)) ?  getco().equals(d) :  (txt.dv(getco()) == txt.dv(d)) ) ); continue; 
					}
					if (next.equals("!=") || next.equals("ne")) {	//notequal
						String d=newco(); setco(""+  ( Double.isNaN(txt.dv(d)) ?  !getco().equals(d) :  (txt.dv(getco()) != txt.dv(d)) ) ); continue; 
					}
					//***********************
					//mathematical
					if (next.equals("rnd")) {	setco(""+Math.random()); continue; } //random number 0 to 1
					if (next.equals("int")) {	setco(""+ (int)(txt.dv(newco())+0.5)); continue; } //round to nearest integer
					if (next.equals("exp")) {	setco(""+Math.exp(txt.dv(newco()))); continue; } //exponential
					if (next.equals("log")) {	setco(""+Math.log(txt.dv(newco()))); continue; } //logarithm
					
					//arithmetic - return floating point number as string
					if (next.equals("+")) {	setco(""+(txt.dv(getco()) + txt.dv(newco()))); continue; }
					if (next.equals("-")) {	setco(""+(txt.dv(getco()) - txt.dv(newco()))); continue; }
					if (next.equals("-")) {	setco(""+(txt.dv(getco()) - txt.dv(newco()))); continue; }
					if (next.equals("/")) {	setco(""+(txt.dv(getco()) / txt.dv(newco()))); continue; }
					if (next.equals("*")) {	setco(""+(txt.dv(getco()) * txt.dv(newco()))); continue; }
					if (next.equals("%")) {	setco(""+(txt.dv(getco()) % txt.dv(newco()))); continue; }
					if (next.equals("^")) {	setco(""+Math.pow(txt.dv(getco()),  txt.dv(newco()))); continue; }
					
					//append string
					if (next.equals("~")) {	setco(getco()+newco()); continue; } //append string
					
					//***********************
					//timing
					if (next.equals("p")) {	player.waitgap(); continue; } //pause (gap as last specified with wait)
					if (next.equals("w")) {	player.wait(txt.iv(newco())); continue; } //wait x milliseconds
					//loop, end
					if (next.equals("go")) {	loop.go(); continue; } //run model mainloop (use after stack up parameter changes in delay mode)
					if (next.equals("end")) {	player.running=false; continue; } //stop thread suddenly (breaking out from all brackets)
					//debug
					if (next.equals("?")) {	report(); continue; }
					if (next.equals("c")) {	iob.debug(newco()); continue; } //write comment to debug
					
					if (next.equals("show")) {	demo(newsec().prev); continue; }
					
					//************************
					//showwebpage
					if (next.equals("swp")) {	showwebpage.swp(); continue; } //show web page (as specified by funcs below)
					if (next.equals("html")) {	showwebpage.setinfo(newco()); continue; } //set htmlinfo
					if (next.equals("page")) {	showwebpage.setpage(newco()); continue; } //set page to show
					if (next.equals("frame")) {	showwebpage.setframe(newco()); continue; } //set frame to show (default is "info")
					if (next.equals("jvs")) {	showwebpage.javascript(newco()); continue; } //javascript nexttion (sent to page with main applet)
					
					
				} //<7
				
				//*****************************
				//if none of above
				val=getco(next); //set val = contents of next (don't change contents of old val)
				prev = next; // store next in prev in case we need it for set val=prev in assignment in next step
				continue; 
				
			} while (player.ok() && (inquote || inbracket)  ); //close bracket returns control to underlying loop
			return this; 
			
		} catch (Exception e) {	debugscript ("caused java exception  \n"+e.toString()); e.printStackTrace(); donext(); return this; }
	} //end donext
	
	
	boolean istrue() {	return getco().equals("true"); }
	
	void demo(String w) {	iob i=iob.findiob(w); if (i!=null) i.demo(); else debugscript(w+" not iob"); }
	
	void debugscript(String s) {	iob.debug(	"mistake in jcmscript at "+" #"+loc+" "+next+ " "+(val==null ? "" : "val="+val)+" " +s ) ; }
	
	void report() {	iob.debug(getco(val, true)); }
	
	String getco() {	return getco(val, false); }
	
	String getco(String val) {	return getco(val, false); }
	
	String getco(String val, boolean fullinfo) {
		if (val==null)  return ""; 
		// if starts with $ it's a variable
		if (val.startsWith("$")) {	String s = player.finds(val); if (s!=null) return (fullinfo ? val+"="+ s : s); /*else debugscript("-no such variable");*/ return ""; }
		//look for iob
		iob i=iob.findiob(val); if (i!=null) return (fullinfo ? i.getstate() : i.getstringval() ); 
		//look for field of an iob
		String s=ref.readval(val, fullinfo); if (s!=null) return s; 
		//just return val as a string
		return val; 
	} //getco
	
	//set contents of  val to contents of parameter a
	void setco(String a) {
		if (val==null) {	val=a; return; }
		// if starts with $ it's a variable
		if (val.startsWith("$")) {	player.setv(val, a); return; }
		//look for iob
		iob i=iob.findiob(val); if (i!=null) {	i.doscript(a); return; }
		//look for field of an iob
		if (ref.writeval(val, a)) return; 
		// just set val as string
		val = a ; return; 
	}
	
} //end sec

			/* 
				    No longer used - to keep description simpler
					if (next.equals("@")) 	continue; //does nothing, must use to indicate subroutine labels
					if (next.equals("")) {	setco(null); continue; } // (same as : ;) set value of sec val to nothing (could also be used to call iob doscript without any parameter)
					if (next.equals("close")) {	System.exit(0); continue; } //close JVM! -drastic
					if (next.equals("goto")) {	loc=player.findloc(newco()); continue; } // jump to label passing current val, never return
					if (next.equals("this")) 	continue; //does nothing, indicates sec value should be parameter of what preceded  (e.g. after int or not)
					//if X then do Y else do Z :  (and return the result of Y or Z) - this isn't working!
					if (next.equals("ifelse")) {	if (newsec().istrue()) {	setco(newco()); skip(); } else {	skip(); setco(newco()); } continue; } //three parameters
			*/
		
			/*
			wishlist for interpreter:
			split by quote & bracket & mathsigns not space
			math precedence
			passing to subs
			load another script
			save data
			get regcli region data
			*/			
			
	
	
	
	
	
	
	
	
	
	
