import java.io.*;

public interface histdata {

//#########################################
//HISTORICAL DATA
//EMISSIONS

double[] fosemit= //from 1860
{90, 95, 97, 103, 111, 118, 122, 130, 134, 142, 145, 155, 171, 182, 170, 184, 187, 191, 192, 206, 233, 241, 254, 271, 274, 276, 280, 294, 326, 325, 355, 371, 374, 370, 383, 406, 419, 439, 463, 505, 533, 551, 565, 616, 622, 662, 696, 787, 757, 787, 826, 840, 879, 949, 861, 850, 917, 956, 942, 813, 934, 814, 853, 975, 978, 988, 974, 1067, 1067, 1151, 1059, 947, 851, 896, 975, 1025, 1125, 1203, 1133, 1199, 1319, 1355, 1361, 1410, 1391, 1148, 1259, 1394, 1463, 1414, 1583, 1699, 1723, 1771, 1814, 1984, 2110, 2177, 2245, 2373, 2497, 2502, 2592, 2747, 2885, 3018, 3157, 3262, 3440, 3671, 3845, 3995, 4178, 4394, 4375, 4391, 4655, 4769, 4939, 5056, 5042, 4933, 4911, 4958, 5099, 5300, 5395, 5558, 5757, 5842, 5774, 5920, 5805, 5860, 5926, 6088, 6140, 6233, 6327, 6420, 6513};

double[] lucemit= //houghton99 TgC from 1850-1990
{397, 397, 400, 404, 407, 410, 413, 416, 419, 422, 423, 427, 421, 423, 424, 426, 427, 427, 428, 429, 433, 461, 471, 479, 483, 488, 491, 493, 495, 496, 497, 535, 546, 556, 564, 572, 577, 579, 581, 583, 584, 584, 583, 581, 579, 577, 578, 579, 580, 582, 583, 655, 678, 697, 713, 728, 741, 748, 753, 757, 760, 704, 687, 658, 648, 636, 640, 639, 639, 639, 637, 682, 695, 706, 715, 723, 730, 733, 736, 711, 707, 723, 723, 722, 722, 719, 730, 728, 725, 721, 714, 720, 719, 717, 719, 720, 793, 811, 825, 834, 846, 1064, 1125, 1128, 1161, 1214, 1246, 1275, 1297, 1232, 1241, 1387, 1431, 1476, 1512, 1542, 1551, 1559, 1570, 1582, 1564, 1438, 1394, 1416, 1406, 1394, 1497, 1519, 1533, 1577, 1595, 1870, 1929, 1973, 2041, 2079, 2150, 2163, 2185, 2187, 2103};
//old deforest from 1860 {542, 534, 539, 544, 549, 554, 557, 560, 564, 569, 572, 582, 588, 592, 596, 600, 605, 607, 609, 610, 611, 642, 656, 663, 668, 673, 677, 678, 679, 679, 687, 684, 685, 684, 683, 682, 680, 680, 681, 683, 686, 749, 767, 782, 795, 806, 817, 822, 825, 827, 828, 773, 757, 746, 743, 734, 737, 736, 736, 736, 736, 785, 799, 811, 817, 827, 825, 824, 805, 780, 775, 783, 779, 774, 768, 762, 767, 765, 762, 757, 751, 730, 723, 716, 712, 709, 758, 768, 774, 776, 782, 946, 987, 992, 1089, 1126, 1155, 1091, 1083, 1087, 1085, 1232, 1271, 1309, 1339, 1363, 1333, 1332, 1345, 1350, 1297, 1277, 1246, 1279, 1259, 1255, 1339, 1363, 1363, 1404, 1415, 1435, 1479, 1510, 1567, 1596, 1661, 1694, 1711, 1705, 1713, 1672, 1630, 1589, 1548, 1506, 1465, 1424, 1383, 1341, 1300};

double[] ch4emit= //from 1860 to 2000
//note sres 310 1990 and 323 2000 mt ch4!, also last 6 points 1995-2000 just added +1.5/yr
{79.3, 79.97, 80.39, 80.99, 81.63, 82.22, 82.73, 83.31, 83.64, 84.13, 84.6, 85.51, 86.28, 87.01, 87.24, 87.79, 88.54, 89.31, 90, 90.92, 92.01, 93.74, 95, 96.2, 97.04, 97.65, 98.45, 99.61, 100.87, 101.72, 102.86, 103.99, 104.79, 105.34, 106.42, 107.62, 108.64, 109.81, 111.07, 112.78, 114.18, 116.52, 117.79, 119.92, 120.95, 122.56, 124.52, 126.9, 126.82, 128.23, 129.7, 129.52, 130.8, 132.31, 130.78, 131.05, 133.2, 134.97, 135.39, 133.78, 137.27, 136.13, 138.48, 141.9, 142.71, 143.77, 144.73, 147.51, 148.19, 150.2, 148.93, 147.65, 146.47, 148.14, 150.6, 152.02, 155.41, 157.76, 157.17, 159.45, 161.63, 163.31, 164.13, 165.39, 165.8, 163.39, 166.77, 171.06, 173.97, 174.07, 177.51, 186.07, 189.87, 192.64, 195.28, 201.26, 205.72, 210.4, 214.2, 216.75, 221.07, 226.33, 230.69, 236.32, 242.06, 247.39, 252.62, 257.04, 262.88, 269.61, 275.82, 277.47, 282.2, 290.61, 292.93, 294.32, 304.48, 307.78, 312.92, 317.48, 318.94, 319.34, 323.86, 326.46, 332.06, 339.63, 344.34, 349.42, 355.32, 357.8, 362.26, 366.52, 367.37, 367.23, 371.02, 372.5, 374.0, 375.5, 377.0, 378.5, 380.0};

double[] soxemit= //from cicero MtS, 1850 to 1990
{0, 0.25, 0.50, 0.75, 1, 1.25, 1.50, 1.75, 2, 2.25, 2.50, 2.64, 2.78, 2.92, 3.06, 3.20, 3.34, 3.48, 3.62, 3.76, 3.90, 4.12, 4.34, 4.56, 4.78, 5, 5.22, 5.44, 5.66, 5.88, 6.10, 6.42, 6.74, 7.06, 7.38, 7.70, 8.02, 8.34, 8.66, 8.98, 9.30, 9.78, 10.26, 10.74, 11.22, 11.70, 12.18, 12.66, 13.14, 13.62, 14.10, 14.82, 15.54, 16.26, 16.98, 17.70, 18.42, 19.14, 19.86, 20.58, 21.30, 21.48, 21.66, 21.84, 22.02, 22.20, 22.76, 23.32, 23.88, 24.44, 25, 25.02, 25.04, 25.06, 25.08, 25.10, 25.50, 25.90, 26.30, 26.70, 27.10, 26.60, 26.10, 25.60, 25.10, 24.60, 26.22, 27.84, 29.46, 31.08, 32.70, 31.72, 30.74, 29.76, 28.78, 27.80, 29.60, 31.40, 33.20, 35, 36.80, 37.42, 38.04, 38.66, 39.28, 39.90, 41.90, 43.90, 45.95, 48, 48.60, 49.20, 50.90, 52.60, 53.95, 55.30, 55.90, 56.50, 58, 59.50, 62, 64.50, 65.75, 67, 68, 69, 70.50, 72, 71, 73, 72, 70, 71, 71, 74, 76, 78, 79, 81, 83, 85}; 
//removed this! plus added last 10 years to join to sres 69 at 2000!
//83.4, 81.8, 80.2, 78.6, 77.0, 75.4, 73.8, 72.2, 70.6, 69.0};

double[] coemit= //Mt-CO/y 1765-2000 
//note 1990-2000 seems to be simply -0.2!
{9.8, 10.0, 10.2, 10.4, 10.6, 10.8, 11.0, 11.2, 11.5, 11.7, 11.9, 12.2, 12.4, 12.7, 12.9, 13.2, 13.4, 13.7, 14.0, 14.3, 14.6, 14.9, 15.2, 15.5, 15.8, 16.1, 16.4, 16.8, 17.1, 17.4, 17.8, 18.2, 18.5, 18.9, 19.3, 19.7, 20.1, 20.5, 20.9, 21.3, 21.7, 22.2, 22.6, 23.1, 23.5, 24.0, 24.5, 25.0, 25.5, 26.0, 26.5, 27.1, 27.6, 28.2, 28.8, 29.3, 29.9, 30.5, 31.1, 31.8, 32.4, 33.1, 33.7, 34.4, 35.1, 35.8, 36.6, 37.3, 38.0, 38.8, 39.6, 40.4, 41.2, 42.0, 42.9, 43.8, 44.6, 45.5, 46.5, 47.4, 48.4, 49.3, 50.3, 51.4, 52.4, 53.5, 54.5, 55.6, 56.8, 57.9, 59.1, 60.3, 61.5, 62.7, 64.0, 65.3, 66.6, 68.0, 69.3, 70.7, 72.2, 73.6, 75.1, 76.6, 78.2, 79.7, 81.4, 83.0, 84.7, 86.4, 88.1, 89.9, 91.7, 93.6, 95.5, 97.4, 99.4, 101.4, 103.4, 105.5, 107.6, 109.8, 112.0, 114.3, 116.6, 119.0, 121.4, 123.8, 126.3, 128.9, 131.5, 134.1, 136.8, 139.6, 142.4, 145.3, 148.2, 151.2, 154.3, 157.4, 160.6, 163.8, 167.1, 170.5, 174.0, 177.5, 181.1, 184.7, 188.4, 192.2, 196.1, 200.1, 204.1, 208.3, 212.5, 216.8, 221.1, 225.6, 230.2, 234.8, 239.6, 244.4, 249.3, 254.4, 259.5, 264.7, 270.1, 275.6, 281.1, 286.8, 292.6, 298.5, 304.5, 310.7, 317.0, 323.4, 329.9, 336.6, 343.4, 350.3, 357.4, 364.6, 372.0, 379.5, 387.1, 395.0, 402.9, 411.1, 419.4, 427.9, 436.5, 445.3, 454.3, 463.5, 472.9, 482.4, 492.2, 502.1, 512.2, 522.6, 533.1, 543.9, 554.9, 566.1, 577.5, 589.2, 601.1, 613.3, 625.6, 638.3, 651.2, 664.3, 677.8, 691.4, 705.4, 719.7, 734.2, 749.0, 764.2, 779.6, 795.4, 811.4, 827.8, 844.5, 861.6, 879.0, 878.8, 878.6, 878.4, 878.2, 878.0, 877.8, 877.6, 877.4, 877.2, 877.0}; 
//scaled CO emission 1770-2000 /10 yr intervals
//{10.4, 12.7, 15.5, 19.0, 23.2, 28.3, 34.6, 42.2, 51.6, 63.0, 76.9, 94.0, 114.8, 140.2, 171.2, 209.2, 255.5, 312.0, 381.1, 465.5, 568.6, 694.5, 848.2, 1036.0};

//*******************************
//CONCENTRATIONS

//note atco2 below not used as need more precision, input direct into datall
double[] co2conc= //from 1860
{288, 288.1, 288.2, 288.2, 288.3, 288.4, 288.5, 288.6, 288.7, 288.7, 288.8, 288.9, 289, 289.1, 289.3, 289.4, 289.5, 289.6, 289.7, 289.8, 290, 290.1, 290.2, 290.4, 290.5, 290.7, 290.8, 291, 291.2, 291.3, 291.5, 291.7, 291.8, 292, 292.2, 292.4, 292.6, 292.7, 292.9, 293.1, 293.3, 293.5, 293.8, 294, 294.3, 294.6, 294.9, 295.2, 295.5, 295.8, 296.1, 296.4, 296.7, 297, 297.4, 297.6, 297.9, 298.2, 298.5, 298.8, 299.1, 299.4, 299.6, 299.9, 300.3, 300.6, 300.9, 301.2, 301.6, 301.9, 302.3, 302.6, 302.9, 303.1, 303.4, 303.6, 303.9, 304.3, 304.6, 304.9, 305.3, 305.7, 306.1, 306.4, 306.8, 307.2, 307.5, 307.9, 308.2, 308.7, 309, 309.5, 310.1, 310.6, 311.2, 311.8, 312.5, 313.2, 313.9, 314.6, 315.4, 316.2, 317, 317.9, 318.8, 319.7, 320.8, 321.8, 322.8, 323.9, 325.1, 326.3, 327.5, 328.7, 330.1, 331.3, 332.6, 334, 335.4, 336.9, 338.4, 339.9, 341.3, 342.7, 344.1, 345.6, 347.2, 348.8, 350.5, 352.2, 353.9, 355.6, 357.3, 358.9, 360.5, 362.2, 363.9, 365.5, 367.2, 368.9, 370.6};

double[] ch4conc = //ppb 1750-2000 
{732.46, 733.18, 733.89, 734.59, 735.29, 735.97, 736.65, 737.31, 737.96, 738.60, 739.23, 739.85, 740.46, 741.05, 741.64, 742.22, 742.78, 743.34, 743.90, 744.44, 744.97, 745.50, 746.02, 746.54, 747.05, 747.56, 748.06, 748.56, 749.05, 749.54, 750.03, 750.51, 751, 751.49, 751.99, 752.49, 753, 753.51, 754.03, 754.57, 755.11, 755.67, 756.25, 756.84, 757.44, 758.07, 758.71, 759.38, 760.07, 760.78, 761.51, 762.28, 763.08, 763.90, 764.76, 765.65, 766.57, 767.51, 768.48, 769.48, 770.49, 771.53, 772.58, 773.65, 774.74, 775.84, 776.95, 778.08, 779.21, 780.36, 781.51, 782.68, 783.85, 785.02, 786.20, 787.38, 788.57, 789.75, 790.93, 792.12, 793.29, 794.47, 795.63, 796.79, 797.94, 799.07, 800.20, 801.31, 802.40, 803.47, 804.53, 805.56, 806.59, 807.59, 808.59, 809.59, 810.58, 811.58, 812.59, 813.60, 814.63, 815.68, 816.74, 817.82, 818.93, 820.06, 821.20, 822.36, 823.54, 824.74, 825.95, 827.18, 828.43, 829.70, 830.98, 832.27, 833.59, 834.91, 836.26, 837.62, 839, 840.39, 841.80, 843.24, 844.69, 846.17, 847.66, 849.19, 850.73, 852.31, 853.91, 855.55, 857.21, 858.92, 860.66, 862.44, 864.27, 866.14, 868.06, 870.04, 872.07, 874.15, 876.30, 878.51, 880.78, 883.12, 885.53, 888, 890.55, 893.16, 895.85, 898.61, 901.44, 904.35, 907.33, 910.39, 913.53, 916.75, 920.04, 923.42, 926.87, 930.41, 934.03, 937.74, 941.53, 945.41, 949.38, 953.43, 957.58, 961.82, 966.15, 970.59, 975.12, 979.75, 984.49, 989.34, 994.30, 999.39, 1004.59, 1009.93, 1015.41, 1021.03, 1026.81, 1032.75, 1038.85, 1045.13, 1051.59, 1058.24, 1065.08, 1072.13, 1079.39, 1086.87, 1094.58, 1102.53, 1110.72, 1119.17, 1127.88, 1136.86, 1146.11, 1155.65, 1165.48, 1175.60, 1186.03, 1196.76, 1207.79, 1219.13, 1230.77, 1242.71, 1254.94, 1267.47, 1280.29, 1293.39, 1306.75, 1320.37, 1334.24, 1348.35, 1362.70, 1377.27, 1392.05, 1407.03, 1422.20, 1437.53, 1452.99, 1468.57, 1484.22, 1499.92, 1515.60, 1531.23, 1546.76, 1562.13, 1577.29, 1592.20, 1606.79, 1621.02, 1634.83, 1648.17, 1661.02, 1673.37, 1685.24, 1696.69, 1707.78, 1718.63, 1729.34, 1723.5, 1728.7, 1733.9, 1739.1, 1744.3, 1749.6, 1754.8, 1760.0};

double[] n2oconc= //ppb 1750-2000 (data to 1998, added last 2 by extrapolate)
{271.68, 271.70, 271.72, 271.74, 271.77, 271.79, 271.81, 271.84, 271.86, 271.88, 271.91, 271.93, 271.95, 271.98, 272, 272.02, 272.05, 272.07, 272.09, 272.12, 272.14, 272.17, 272.19, 272.21, 272.24, 272.26, 272.29, 272.31, 272.34, 272.36, 272.38, 272.41, 272.44, 272.46, 272.49, 272.51, 272.54, 272.56, 272.59, 272.62, 272.64, 272.67, 272.70, 272.72, 272.75, 272.78, 272.81, 272.83, 272.86, 272.89, 272.92, 272.95, 272.98, 273.01, 273.04, 273.07, 273.10, 273.13, 273.16, 273.19, 273.22, 273.26, 273.29, 273.32, 273.36, 273.39, 273.43, 273.46, 273.50, 273.53, 273.57, 273.61, 273.64, 273.68, 273.72, 273.76, 273.80, 273.84, 273.88, 273.92, 273.96, 274.01, 274.05, 274.09, 274.14, 274.19, 274.23, 274.28, 274.33, 274.37, 274.42, 274.47, 274.52, 274.57, 274.63, 274.68, 274.73, 274.79, 274.84, 274.90, 274.96, 275.01, 275.07, 275.13, 275.19, 275.25, 275.32, 275.38, 275.44, 275.51, 275.57, 275.64, 275.71, 275.78, 275.85, 275.92, 275.99, 276.07, 276.14, 276.22, 276.29, 276.37, 276.45, 276.53, 276.61, 276.69, 276.78, 276.86, 276.95, 277.03, 277.12, 277.21, 277.30, 277.39, 277.49, 277.58, 277.68, 277.77, 277.87, 277.97, 278.07, 278.18, 278.28, 278.38, 278.49, 278.60, 278.71, 278.82, 278.93, 279.05, 279.16, 279.28, 279.40, 279.52, 279.64, 279.76, 279.88, 280.01, 280.14, 280.27, 280.39, 280.53, 280.66, 280.79, 280.93, 281.07, 281.20, 281.34, 281.48, 281.63, 281.77, 281.91, 282.05, 282.20, 282.34, 282.48, 282.63, 282.77, 282.92, 283.07, 283.21, 283.36, 283.51, 283.66, 283.81, 283.97, 284.13, 284.28, 284.45, 284.61, 284.78, 284.95, 285.13, 285.32, 285.51, 285.70, 285.90, 286.11, 286.33, 286.55, 286.78, 287.02, 287.28, 287.54, 287.81, 288.09, 288.38, 288.69, 289.01, 289.34, 289.68, 290.04, 290.42, 290.80, 291.21, 291.63, 292.07, 292.52, 292.99, 293.48, 293.99, 294.52, 295.06, 295.63, 296.21, 296.82, 297.45, 298.10, 298.77, 299.47, 300.18, 300.92, 301.68, 302.45, 303.24, 304.03, 304.82, 305.61, 306.39, 307.16, 307.93, 308.69, 309.44, 310.19, 310.92, 311.65, 312.38, 313.11, 313.83, 314.55, 315.27}; //last 2 added

double[] tropo3du= //1850-2000 dobson units (constant 25 b4 1850)
{25.0, 25.0, 25.0, 25.1, 25.1, 25.1, 25.1, 25.1, 25.2, 25.2, 25.2, 25.2, 25.3, 25.3, 25.3, 25.3, 25.3, 25.4, 25.4, 25.4, 25.4, 25.5, 25.5, 25.5, 25.5, 25.5, 25.5, 25.6, 25.6, 25.6, 25.6, 25.7, 25.7, 25.7, 25.7, 25.7, 25.8, 25.8, 25.8, 25.8, 25.9, 25.9, 25.9, 25.9, 25.9, 26.0, 26.0, 26.0, 26.0, 26.0, 26.1, 26.1, 26.1, 26.2, 26.2, 26.2, 26.3, 26.3, 26.3, 26.4, 26.4, 26.4, 26.5, 26.5, 26.5, 26.6, 26.6, 26.6, 26.7, 26.7, 26.7, 26.8, 26.8, 26.8, 26.9, 26.9, 26.9, 27.0, 27.0, 27.0, 27.1, 27.1, 27.1, 27.2, 27.2, 27.2, 27.3, 27.3, 27.3, 27.4, 27.4, 27.4, 27.5, 27.5, 27.5, 27.6, 27.6, 27.6, 27.7, 27.7, 27.7, 27.8, 27.9, 28.0, 28.1, 28.2, 28.3, 28.4, 28.5, 28.6, 28.7, 28.9, 29.0, 29.1, 29.2, 29.4, 29.5, 29.6, 29.7, 29.9, 30.0, 30.1, 30.2, 30.3, 30.5, 30.6, 30.7, 30.8, 30.9, 31.0, 31.2, 31.3, 31.5, 31.6, 31.7, 31.9, 32.0, 32.2, 32.3, 32.5, 32.6, 32.7, 32.9, 33.0, 33.2, 33.3, 33.4, 33.6, 33.7, 33.9, 34.0};

//4 F gases below are from cicero 1960 to 1989 ppt
//note cf4 was 44 in preindustrial, also CH3Br constant 9.06 (??). Other F gases assumed to be zero pre 1960. 
double[] sf6conc= {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.04, 0.08, 0.12, 0.16, 0.20, 0.32, 0.44, 0.56, 0.68, 0.80, 0.92, 1.04, 1.16, 1.28, 1.40, 1.55, 1.70, 1.85, 2};
double[] cf4conc= {44, 44, 44, 44, 44, 44, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68};
double[] c2f6conc= {0, 0, 0, 0, 0, 0, 0, 0.10, 0.20, 0.30, 0.40, 0.50, 0.58, 0.66, 0.74, 0.82, 0.90, 0.98, 1.06, 1.14, 1.22, 1.30, 1.38, 1.46, 1.54, 1.62, 1.70, 1.78, 1.86, 1.94, 2.02};
double[] hfc23conc= {0, 0, 0.17, 0.34, 0.51, 0.68, 0.85, 1.02, 1.19, 1.36, 1.53, 1.70, 1.87, 2.04, 2.21, 2.38, 2.55, 2.72, 2.89, 3.06, 3.23, 3.40, 3.76, 4.12, 4.48, 4.84, 5.20, 5.68, 6.16, 6.64, 7.12};
double[][] hfcconc= {sf6conc, cf4conc, c2f6conc, hfc23conc};

//Montreal gases: CFCs, HCFCs, CCl4, Br gases, EESCL (effective stratospheric Cl =>Ozone loss)
//In 5 year intervals (as orig WMO data) from 1930 to 2300 
//note data stops at 2100 for Br gases and EESCL! but only 120byte extra, leave in for simple array

double[] HCFC22={0, 0, 0, 0, 0, 0, 0, 0.8, 13.2, 24.7, 41.3, 63.7, 90.1, 112.5, 144.9, 212.5, 256.9, 263.6, 228.9, 178.9, 137, 107.7, 88, 67.1, 45.8, 30.3, 19.9, 13.1, 8.6, 5.6, 3.7, 2.4, 1.6, 1, 0.6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
double[] HCFC141b={0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.6, 13.2, 20.2, 22.1, 20.5, 16.5, 12, 8.8, 6.7, 5.5, 4, 2.4, 1.4, 0.8, 0.5, 0.3, 0.2, 0.1, 0.1, 0, 0, 0, 0.54, 0.41, 0.32, 0.24, 0.19, 0.14, 0.11, 0.08, 0.06, 0.05, 0.04, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
double[] HCFC142b={0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.3, 1.3, 7, 14.9, 26, 33, 34.9, 32.2, 27.5, 23.3, 19.9, 17.2, 14.1, 10.8, 8.3, 6.3, 4.8, 3.7, 2.8, 2.1, 1.6, 1.2, 1, 0.7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
double[] HCFC123={0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.3, 1.6, 2.5, 2.8, 2.6, 2.3, 2, 1.7, 1.5, 1.2, 1, 0.8, 0.6, 0.4, 0.4, 0.3, 0.2, 0.2, 0.1, 0.1, 0.1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
double[] CH3CCl3={0, 0, 0, 0, 0, 0, 0, 1.2, 13.4, 36.4, 75, 101.8, 124.8, 110, 43.5, 16, 6.1, 2.3, 0.8, 0.3, 0.1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.39, 0.26, 0.17, 0.11, 0.07, 0.05, 0.03, 0.02, 0.01, 0.01, 0.01, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

double[] CFC11={0, 0, 0, 0, 0.4, 2.9, 8.8, 22.3, 50.5, 106, 164.5, 206.8, 257.7, 270.9, 266.7, 257.9, 245.8, 230.6, 213.8, 196.6, 179.9, 164, 149.2, 135.5, 122.9, 111.4, 100.9, 91.4, 82.7, 74.9, 67.8, 61.3, 55.5, 50.2, 45, 40.27, 36.03, 32.24, 28.85, 25.82, 23.1, 20.67, 18.5, 16.55, 14.81, 13.26, 11.86, 10.61, 9.5, 8.5, 7.61, 6.81, 6.09, 5.45, 4.88, 4.36, 3.9, 3.49, 3.13, 2.8, 2.5, 2.24, 2, 1.79, 1.61, 1.44, 1.29, 1.15, 1.03, 0.92, 0.82, 0.74, 0.66, 0.59, 0.53};
double[] CFC12={0, 0, 0.2, 1.2, 5.7, 13.9, 28.1, 55.3, 108.9, 198.6, 289.9, 373.4, 467.4, 520.4, 535, 535.4, 527.3, 508.5, 485.7, 462.8, 440.8, 419.7, 399.6, 380.5, 362.3, 345, 328.5, 312.8, 297.8, 283.6, 270, 257.1, 244.8, 233.1, 222, 211.17, 200.87, 191.08, 181.76, 172.89, 164.46, 156.44, 148.81, 141.55, 134.65, 128.08, 121.84, 115.89, 110.24, 104.87, 99.75, 94.89, 90.26, 85.86, 81.67, 77.69, 73.9, 70.29, 66.87, 63.6, 60.5, 57.55, 54.74, 52.07, 49.53, 47.12, 44.82, 42.64, 40.56, 38.58, 36.7, 34.91, 33.2, 31.58, 30.04};
double[] CFC113={0, 0, 0, 0, 0.2, 0.4, 1, 2.1, 4.3, 9, 18.5, 34.1, 67.4, 85.9, 85.2, 84.1, 81.2, 76.8, 72.4, 68.3, 64.4, 60.7, 57.2, 54, 50.9, 48, 45.2, 42.6, 40.2, 37.9, 35.8, 33.7, 31.8, 30, 28, 26.4, 24.89, 23.47, 22.13, 20.87, 19.67, 18.55, 17.49, 16.49, 15.55, 14.66, 13.82, 13.03, 12.29, 11.59, 10.92, 10.3, 9.71, 9.16, 8.63, 8.14, 7.68, 7.24, 6.82, 6.43, 6.07, 5.72, 5.39, 5.09, 4.79, 4.52, 4.26, 4.02, 3.79, 3.57, 3.37, 3.18, 2.99, 2.82, 2.66};
double[] CFC114={0, 0, 0, 0.2, 1, 2.2, 3.4, 4.6, 6.1, 7.8, 9.8, 12.1, 14.7, 15.5, 15.8, 15.8, 15.7, 15.5, 15.2, 15, 14.8, 14.5, 14.3, 14, 13.8, 13.6, 13.4, 13.2, 12.9, 12.7, 12.5, 12.3, 12.1, 11.9, 11.7, 11.51, 11.32, 11.13, 10.95, 10.76, 10.59, 10.41, 10.24, 10.07, 9.9, 9.74, 9.58, 9.42, 9.27, 9.11, 8.96, 8.81, 8.67, 8.52, 8.38, 8.24, 8.11, 7.97, 7.84, 7.71, 7.59, 7.46, 7.34, 7.22, 7.1, 6.98, 6.86, 6.75, 6.64, 6.53, 6.42, 6.31, 6.21, 6.11, 6.01};
double[] CFC115={0, 0, 0, 0, 0, 0, 0, 0, 0, 0.6, 1.3, 2.8, 5, 7.3, 8.6, 8.8, 8.9, 8.8, 8.8, 8.8, 8.8, 8.7, 8.7, 8.7, 8.7, 8.6, 8.6, 8.6, 8.6, 8.5, 8.5, 8.5, 8.5, 8.4, 8.4, 8.38, 8.35, 8.33, 8.3, 8.28, 8.25, 8.23, 8.2, 8.18, 8.16, 8.13, 8.11, 8.08, 8.06, 8.04, 8.01, 7.99, 7.97, 7.94, 7.92, 7.9, 7.87, 7.85, 7.83, 7.8, 7.78, 7.76, 7.74, 7.71, 7.69, 7.67, 7.65, 7.62, 7.6, 7.58, 7.56, 7.53, 7.51, 7.49, 7.47};
double[] CCl4={3.1, 5.8, 10.9, 20.4, 29.1, 34.1, 38.3, 45.7, 55.9, 77, 92.4, 99.8, 102.2, 99.8, 91.7, 83.6, 75, 66.6, 59.1, 52.5, 46.6, 41.4, 36.7, 32.6, 28.9, 25.7, 22.8, 20.2, 18, 16, 14.2, 12.6, 11.2, 9.9, 9, 7.8, 6.76, 5.86, 5.08, 4.41, 3.82, 3.31, 2.87, 2.49, 2.16, 1.87, 1.62, 1.41, 1.22, 1.06, 0.92, 0.79, 0.69, 0.6, 0.52, 0.45, 0.39, 0.34, 0.29, 0.25, 0.22, 0.19, 0.16, 0.14, 0.12, 0.11, 0.09, 0.08, 0.07, 0.06, 0.05, 0.05, 0.04, 0.03, 0.03};

double[] CF2BrCl={0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 4, 4, 4, 4, 3, 3, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
double[] CF3Br={0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

//multiplied below by 1000 to make in ppt like the rest!
double[] EESCL={910, 910, 930, 950, 990, 1030, 1060, 1120, 1250, 1540, 1990, 2440, 2870, 3300, 3280, 3140, 3030, 2920, 2740, 2580, 2420, 2280, 2160, 2040, 1940, 1850, 1760, 1690, 1620, 1560, 1510, 1460, 1410, 1370, 1330, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

double[][] cfcconc={ HCFC22, HCFC141b, HCFC142b, HCFC123, CH3CCl3, CFC11, CFC12, CFC113, CFC114, CFC115, CCl4, CF2BrCl, CF3Br, EESCL};

//********************************
//RADIATIVE FORCING 

//old solar data
//double[] oldsolrf= //from 1860 to 2000
//{-0.018, -0.026, -0.044, -0.066, -0.084, -0.094, -0.088, -0.074, -0.056, -0.041, -0.031, -0.033, -0.04, -0.05, -0.058, -0.063, -0.06, -0.054, -0.046, -0.042, -0.048, -0.07, -0.102, -0.138, -0.169, -0.189, -0.189, -0.178, -0.162, -0.147, -0.133, -0.123, -0.114, -0.106, -0.098, -0.089, -0.08, -0.07, -0.06, -0.049, -0.035, -0.017, 0.004, 0.026, 0.045, 0.06, 0.063, 0.062, 0.058, 0.058, 0.065, 0.088, 0.118, 0.152, 0.182, 0.205, 0.212, 0.212, 0.208, 0.206, 0.209, 0.22, 0.236, 0.254, 0.269, 0.279, 0.277, 0.27, 0.26, 0.253, 0.253, 0.265, 0.284, 0.306, 0.325, 0.338, 0.339, 0.334, 0.325, 0.321, 0.324, 0.341, 0.365, 0.394, 0.413, 0.414, 0.379, 0.326, 0.264, 0.21, 0.173, 0.168, 0.18, 0.2, 0.214, 0.214, 0.19, 0.152, 0.108, 0.072, 0.051, 0.062, 0.088, 0.122, 0.152, 0.174, 0.18, 0.178, 0.172, 0.17, 0.174, 0.194, 0.22, 0.25, 0.282, 0.318, 0.359, 0.39, 0.397, 0.371, 0.336, 0.302, 0.279, 0.271, 0.287, 0.318, 0.352, 0.37, 0.349, 0.315, 0.283, 0.285, 0.302, 0.328, 0.344, 0.349, 0.328, 0.317, 0.31, 0.31, 0.31};

double[] solrf = // from 1750 to 1994 guestimate extension to 2000
{-0.05, -0.035, -0.02, -0.005, 0.01, 0.025, 0.04, 0.055, 0.07, 0.08, 0.09, 0.054, 0.069, 0.084, 0.094, 0.16, 0.16, 0.16, 0.183, 0.207, 0.23, 0.22, 0.21, 0.2, 0.173, 0.145, 0.118, 0.09, 0.135, 0.18, 0.11, 0.033, -0.045, -0.122, -0.2, -0.19, -0.18, -0.185, -0.19, -0.22, -0.25, -0.28, -0.293, -0.306, -0.319, -0.331, -0.344, -0.357, -0.37, -0.37, -0.37, -0.362, -0.354, -0.346, -0.338, -0.33, -0.34, -0.35, -0.328, -0.306, -0.284, -0.262, -0.241, -0.219, -0.197, -0.175, -0.153, -0.131, -0.109, -0.087, -0.066, -0.044, -0.022, 0, 0.018, 0.035, 0.053, 0.07, 0.073, 0.077, 0.08, 0.05, 0.02, -0.01, 0.015, 0.04, 0.065, 0.09, 0.08, 0.07, 0.06, 0.05, 0.003, -0.045, -0.092, -0.14, -0.122, -0.105, -0.087, -0.07, -0.11, -0.15, -0.157, -0.165, -0.172, -0.18, -0.175, -0.17, -0.137, -0.103, -0.07, -0.082, -0.095, -0.107, -0.12, -0.155, -0.19, -0.19, -0.19, -0.135, -0.08, -0.094, -0.108, -0.122, -0.136, -0.15, -0.148, -0.146, -0.144, -0.142, -0.14, -0.127, -0.113, -0.1, -0.17, -0.195, -0.22, -0.245, -0.27, -0.27, -0.27, -0.247, -0.223, -0.2, -0.207, -0.213, -0.22, -0.208, -0.197, -0.185, -0.173, -0.162, -0.15, -0.12, -0.09, -0.06, -0.05, -0.04, -0.042, -0.044, -0.046, -0.048, -0.05, -0.025, 0, 0.025, 0.05, 0.075, 0.1, 0.088, 0.075, 0.063, 0.05, 0.072, 0.094, 0.116, 0.138, 0.16, 0.148, 0.136, 0.124, 0.112, 0.1, 0.12, 0.14, 0.16, 0.18, 0.2, 0.21, 0.198, 0.185, 0.173, 0.16, 0.165, 0.17, 0.235, 0.3, 0.283, 0.267, 0.25, 0.188, 0.125, 0.063, 0, 0.023, 0.047, 0.07, 0.046, 0.022, -0.002, -0.026, -0.05, -0.06, -0.07, -0.065, -0.06, -0.02, 0.02, 0.06, 0.065, 0.07, 0.04, 0.01, 0.04, 0.03, 0.02, 0.07, 0.12, 0.17, 0.22, 0.27, 0.273, 0.277, 0.28, 0.235, 0.19, 0.145, 0.1, 0.195, 0.29, 0.28, 0.24, 0.2, 0.16, 0.12, 0.10, 0.09, 0.09, 0.1, 0.12, 0.15};

double[] volcano= //from 1750 to 2000, all negative forcings *10 (i.e. 22=-2.2)
{0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 23, 0, 0, 0, 9, 0, 0, 0, 0, 5, 0, 4, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 4, 0, 0, 0, 0, 1, 0, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0};

//****************************
//TEMPERATURE

double[] measuretemp= //from 1860 to 2002 !!! cf preindustrial, subtract 0.42 to get figures wrt 1960-90 average
{0.04, 0.03, -0.09, 0.18, -0.02, 0.19, 0.24, 0.13, 0.24, 0.15, 0.12, 0.08, 0.23, 0.16, 0.04, 0.01, 0.03, 0.31, 0.43, 0.15, 0.16, 0.2, 0.21, 0.13, 0.08, 0.1, 0.18, 0.07, 0.13, 0.27, 0.05, 0.11, 0.03, -0.01, 0.05, 0.08, 0.27, 0.29, 0.1, 0.21, 0.3, 0.21, 0.08, -0.01, -0.05, 0.06, 0.13, -0.06, -0.09, -0.05, -0.02, -0.04, 0.03, 0.03, 0.2, 0.3, 0.08, -0.04, 0.06, 0.17, 0.21, 0.24, 0.14, 0.16, 0.1, 0.2, 0.35, 0.24, 0.21, 0.06, 0.29, 0.37, 0.32, 0.2, 0.32, 0.27, 0.32, 0.41, 0.5, 0.42, 0.42, 0.51, 0.48, 0.48, 0.64, 0.51, 0.32, 0.34, 0.34, 0.33, 0.24, 0.37, 0.45, 0.51, 0.27, 0.26, 0.18, 0.48, 0.54, 0.48, 0.43, 0.47, 0.47, 0.49, 0.21, 0.29, 0.37, 0.37, 0.34, 0.48, 0.41, 0.25, 0.4, 0.53, 0.27, 0.32, 0.23, 0.5, 0.4, 0.51, 0.54, 0.57, 0.5, 0.68, 0.46, 0.45, 0.54, 0.67, 0.68, 0.61, 0.78, 0.73, 0.59, 0.63, 0.7, 0.82, 0.66, 0.85, 1.01, 0.76, 0.71, 0.85, 0.91};

double[] proxytemp = //from 1750 to 1991
{-0.5707, -0.47775, -0.42825, -0.2025, -0.40045, -0.3814, -0.46865, -0.1951, -0.16555, -0.2003, -0.13645, -0.16595, -0.12905, -0.1807, -0.2641, -0.1395, -0.0991, -0.14555, -0.1529, -0.4026, -0.26625, -0.1538, 0.01125, -0.0253, -0.1295, -0.03915, -0.05395, -0.41305, -0.3275, -0.278, -0.36055, -0.4821, -0.3974, -0.2797, -0.6002, -0.4517, -0.08865, -0.48555, -0.28145, -0.0748, -0.1746, -0.05045, -0.07435, -0.192, -0.18555, -0.27405, -0.25455, -0.40565, 0.0568, -0.1182, -0.25025, -0.29235, -0.3379, -0.2077, -0.30065, -0.3284, -0.33875, -0.0348, -0.24675, -0.37485, -0.4447, -0.3505, -0.38175, -0.6145, -0.5238, -0.4456, -0.65925, -0.44385, -0.35305, -0.2037, -0.3579, -0.5103, -0.22805, -0.2962, -0.268, -0.16205, -0.18335, -0.4886, -0.20335, -0.5099, -0.19805, -0.2641, -0.4165, -0.31135, -0.51595, -0.77645, -0.78605, -0.5993, -0.6162, -0.37175, -0.30055, -0.3266, -0.2059, -0.4651, -0.7027, -0.62015, -0.12215, -0.09865, -0.58365, -0.81775, -0.4812, 0.0829, 0.0825, -0.2745, -0.35135, -0.45905, -0.50295, -0.48775, -0.26845, -0.1503, -0.34045, -0.2815, -0.33395, -0.1694, -0.2506, -0.1021, -0.48115, -0.28275, -0.30405, -0.3431, -0.34875, -0.15075, -0.35525, -0.23325, -0.3123, -0.2233, -0.26885, 0.00125, -0.14855, -0.57585, -0.54065, -0.3279, -0.4547, -0.31965, -0.4443, -0.22845, -0.14205, -0.1651, -0.2059, -0.06475, -0.182, -0.4582, -0.42995, -0.08695, -0.04825, -0.17895, -0.4052, -0.4087, -0.3158, -0.8625, -0.31015, -0.21375, -0.23715, -0.403, -0.3931, -0.1912, -0.3757, -0.63145, -0.11255, -0.46345, -0.3375, -0.10435, -0.29795, -0.3006, -0.3479, -0.21895, -0.22635, -0.3045, -0.2389, 0.17625, -0.08305, -0.1938, -0.2055, -0.21335, -0.28065, -0.1651, -0.1408, -0.1881, -0.15035, -0.22725, -0.0518, -0.1356, -0.21595, -0.1486, -0.1187, -0.1252, 0.1432, -0.0101, -0.12215, 0.0242, -0.1165, -0.12775, -0.0453, -0.05005, -0.0027, 0.0242, -0.19295, -0.0648, -0.23805, -0.0496, -0.11395, -0.04175, -0.04655, 0.1306, -0.21935, 0.04245, 0.0251, 0.13015, -0.0622, 0.0242, 0.2461, 0.10585, -0.2589, -0.11515, -0.2459, -0.0882, -0.2181, -0.03095, -0.14205, 0.14365, -0.0179, 0.0438, -0.06825, 0.18535, 0.1228, 0.02205, 0.1028, -0.1217, -0.1464, 0.0169, -0.2029, -0.09565, -0.0244, 0.24485, 0.07675, -0.0635, -0.03175, -0.0639, 0.23005, 0.35035, 0.17925, 0.12495}; 


//*******************************
//REGIONAL DATA 1900-2000

double[][] regfosemit={
{181, 197, 209, 244, 240, 269, 282, 328, 287, 318, 346, 343, 366, 393, 359, 373, 414, 455, 476, 403, 467, 382, 385, 510, 454, 466, 505, 491, 486, 524, 466, 398, 338, 362, 385, 401, 461, 481, 404, 446, 507, 553, 592, 612, 653, 631, 609, 671, 700, 589, 692, 713, 695, 711, 678, 743, 779, 772, 748, 779, 797, 799, 829, 873, 910, 945, 996, 1036, 1079, 1131, 1155, 1163, 1215, 1263, 1218, 1167, 1248, 1253, 1275, 1278, 1253, 1208, 1148, 1151, 1190, 1210, 1233, 1266, 1338, 1345, 1319, 1313, 1328, 1374, 1406, 1412, 1450, 1473, 1495, 1517, 1539} 
, {9, 10, 11, 12, 13, 14, 15, 18, 19, 18, 20, 23, 25, 29, 27, 24, 28, 30, 32, 28, 31, 29, 27, 33, 30, 30, 32, 35, 35, 36, 34, 28, 26, 27, 30, 31, 33, 36, 34, 38, 41, 45, 49, 51, 52, 49, 52, 54, 58, 55, 59, 63, 62, 62, 65, 68, 74, 73, 74, 76, 80, 81, 85, 88, 98, 105, 107, 116, 122, 126, 132, 136, 146, 149, 151, 155, 157, 164, 165, 171, 175, 174, 172, 167, 174, 174, 172, 179, 187, 196, 191, 186, 188, 194, 201, 204, 204, 210, 216, 222, 228} 
, {5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 14, 15, 16, 15, 16, 18, 20, 22, 20, 18, 20, 21, 22, 23, 23, 25, 26, 27, 25, 23, 24, 27, 30, 32, 32, 34, 36, 35, 42, 42, 40, 41, 38, 21, 15, 20, 25, 27, 28, 34, 36, 40, 39, 39, 44, 51, 50, 53, 64, 77, 80, 89, 98, 106, 115, 134, 154, 179, 202, 210, 227, 250, 243, 233, 239, 251, 250, 260, 251, 246, 240, 236, 255, 248, 247, 245, 269, 276, 292, 298, 301, 295, 309, 310, 319, 319, 319, 319, 319} 
, {279, 274, 275, 287, 291, 301, 308, 342, 346, 344, 351, 358, 366, 397, 356, 337, 350, 342, 326, 298, 333, 300, 338, 324, 377, 374, 309, 400, 398, 430, 402, 364, 332, 339, 365, 379, 396, 434, 429, 438, 420, 416, 413, 410, 364, 223, 310, 355, 386, 410, 420, 468, 473, 477, 501, 538, 566, 572, 559, 558, 599, 617, 652, 696, 717, 731, 742, 748, 789, 837, 847, 861, 882, 926, 900, 861, 920, 899, 924, 969, 951, 903, 871, 854, 852, 875, 866, 867, 843, 868, 874, 868, 853, 831, 822, 841, 872, 872, 873, 873, 874} 
, {33, 35, 35, 36, 36, 38, 41, 44, 46, 47, 46, 48, 53, 56, 48, 47, 52, 54, 45, 17, 38, 38, 37, 34, 35, 35, 36, 41, 43, 49, 42, 40, 35, 34, 36, 37, 40, 45, 49, 52, 87, 83, 89, 96, 89, 43, 62, 64, 67, 76, 76, 83, 90, 97, 104, 110, 119, 128, 133, 141, 149, 158, 169, 181, 193, 198, 202, 208, 221, 235, 250, 260, 268, 280, 287, 304, 319, 330, 345, 349, 354, 344, 347, 352, 358, 364, 370, 377, 370, 362, 314, 284, 249, 248, 238, 236, 245, 244, 243, 241, 240} 
, {17, 17, 17, 16, 18, 16, 18, 21, 21, 22, 22, 22, 25, 27, 25, 23, 24, 22, 9, 8, 7, 8, 9, 10, 12, 12, 17, 21, 24, 26, 32, 39, 43, 50, 61, 70, 81, 83, 89, 90, 108, 95, 66, 84, 78, 83, 93, 112, 119, 135, 152, 164, 176, 186, 203, 231, 253, 277, 295, 310, 323, 333, 350, 375, 399, 423, 447, 467, 480, 500, 513, 543, 572, 595, 619, 650, 676, 698, 721, 726, 754, 742, 759, 771, 780, 844, 844, 880, 903, 884, 827, 799, 731, 668, 576, 601, 556, 528, 500, 471, 443} 
, {3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 4, 5, 4, 2, 2, 2, 2, 3, 3, 3, 3, 5, 5, 5, 6, 7, 8, 9, 10, 14, 16, 18, 19, 21, 24, 26, 22, 18, 24, 23, 25, 33, 45, 34, 34, 35, 36, 38, 41, 50, 57, 62, 68, 72, 78, 83, 87, 95, 104, 114, 127, 137, 150, 161, 170, 176, 188, 203, 221, 222, 233, 253, 261, 267, 269, 273, 278, 284, 295, 304, 324, 344, 353, 366, 383, 382, 517, 407, 423, 425, 422, 343, 351, 359, 366, 374} 
, {0, 0, 0, 1, 1, 1, 5, 5, 6, 6, 5, 8, 3, 3, 4, 4, 5, 5, 6, 7, 7, 7, 7, 9, 10, 9, 8, 9, 9, 10, 10, 11, 11, 12, 13, 16, 18, 17, 15, 18, 24, 29, 31, 27, 27, 14, 9, 9, 7, 16, 22, 28, 35, 37, 45, 53, 60, 71, 144, 198, 214, 151, 121, 120, 120, 131, 144, 120, 130, 160, 212, 241, 256, 266, 271, 314, 329, 367, 408, 417, 408, 404, 433, 457, 496, 538, 566, 605, 648, 659, 663, 696, 731, 763, 827, 885, 925, 943, 961, 979, 997} 
, {1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 7, 7, 6, 4, 5, 5, 4, 5, 5, 7, 7, 5, 8, 9, 10, 11, 11, 10, 12, 10, 7, 9, 10, 11, 13, 12, 17, 17, 18, 18, 15, 14, 17, 18, 18, 37, 24, 26, 25, 44, 52, 54, 54, 59, 65, 71, 77, 75, 82, 83, 85, 90, 91, 97, 100, 106, 114, 123, 134, 138, 146, 152, 165, 176, 175, 190, 193, 209, 224, 232, 230, 246, 233, 228, 231, 234, 248, 253, 257, 261, 272, 287, 300, 320, 322, 327, 339, 352, 364, 376} 
, {1, 1, 0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 8, 8, 7, 7, 6, 7, 7, 7, 8, 9, 10, 11, 15, 20, 14, 16, 13, 5, 4, 5, 5, 6, 10, 12, 14, 15, 17, 21, 23, 23, 26, 28, 30, 34, 38, 39, 44, 49, 54, 62, 69, 81, 92, 107, 108, 121, 122, 129, 144, 156, 169, 178, 162, 165, 167, 179, 183, 199, 208, 220, 241, 256, 286, 306, 327, 352, 369, 409, 433, 473, 512, 551, 590} 
, {1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5, 5, 5, 5, 5, 6, 7, 7, 7, 8, 8, 7, 8, 8, 9, 10, 9, 10, 10, 10, 8, 8, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 18, 21, 18, 19, 19, 20, 21, 26, 28, 30, 31, 32, 35, 37, 39, 41, 40, 43, 44, 45, 48, 53, 58, 60, 60, 62, 67, 73, 84, 91, 98, 102, 101, 109, 111, 118, 126, 134, 136, 136, 144, 158, 160, 167, 167, 176, 179, 180, 184, 192, 193, 200, 199, 194, 197, 200, 203, 206} 
, {4, 4, 4, 4, 5, 5, 6, 7, 7, 7, 7, 8, 9, 10, 10, 10, 10, 11, 12, 13, 11, 12, 11, 12, 13, 13, 13, 13, 13, 13, 13, 12, 11, 11, 13, 13, 13, 15, 17, 16, 16, 17, 17, 15, 15, 18, 17, 17, 17, 19, 18, 19, 20, 20, 21, 23, 24, 27, 28, 30, 33, 36, 39, 42, 41, 45, 47, 47, 51, 52, 53, 56, 59, 61, 63, 69, 72, 86, 86, 90, 95, 102, 108, 118, 122, 133, 143, 152, 163, 178, 184, 197, 210, 220, 233, 246, 272, 286, 299, 313, 327} 
, {533, 551, 565, 616, 622, 662, 696, 787, 757, 787, 826, 840, 879, 949, 861, 850, 917, 956, 942, 813, 934, 814, 853, 975, 978, 988, 974, 1067, 1067, 1151, 1059, 947, 851, 896, 975, 1025, 1125, 1203, 1133, 1199, 1319, 1355, 1361, 1410, 1391, 1148, 1259, 1394, 1463, 1414, 1583, 1699, 1723, 1771, 1814, 1984, 2110, 2177, 2245, 2373, 2497, 2502, 2592, 2747, 2885, 3018, 3157, 3262, 3440, 3671, 3845, 3995, 4178, 4394, 4375, 4391, 4655, 4769, 4939, 5056, 5042, 4933, 4911, 4958, 5099, 5300, 5395, 5558, 5757, 5842, 5774, 5920, 5805, 5860, 5926, 6088, 6140, 6233, 6327, 6420, 6513} 
//denmark*100
, {144, 150, 154, 160, 173, 168, 182, 164, 202, 224, 208, 221, 262, 270, 276, 295, 289, 208, 238, 235, 210, 197, 281, 309, 362, 318, 317, 396, 377, 449, 421, 437, 414, 412, 450, 464, 484, 502, 469, 516, 417, 479, 455, 567, 557, 395, 533, 679, 562, 562, 600, 598, 625, 632, 698, 738, 719, 679, 731, 710, 812, 865, 1006, 1107, 1169, 1209, 1367, 1337, 1457, 1619, 1689, 1551, 1623, 1616, 1504, 1507, 1609, 1653, 1698, 1762, 1717, 1484, 1527, 1428, 1448, 1723, 1686, 1673, 1496, 1297, 1439, 1724, 1575, 1622, 1717, 1634, 1995, 1737, 1625, 1575, 1594}
//corrected , {144, 150, 154, 160, 173, 168, 182, 164, 202, 224, 208, 221, 262, 270, 276, 295, 289, 208, 238, 235, 210, 197, 281, 309, 362, 318, 317, 396, 377, 449, 421, 437, 414, 412, 450, 464, 484, 502, 469, 516, 417, 479, 455, 567, 557, 395, 533, 679, 562, 562, 600, 598, 625, 632, 698, 738, 719, 679, 731, 710, 812, 865, 1006, 1107, 1169, 1209, 1367, 1337, 1457, 1619, 1689, 1551, 1623, 1616, 1504, 1507, 1609, 1653, 1698, 1762, 1717, 1484, 1527, 1428, 1448, 1723, 1686, 1673, 1496, 1297, 1640, 1673, 1676, 1632, 1621, 1608, 1582, 1578, 1526, 1575, 1594}
};

double[][] pop={
{76, 77, 78, 79, 81, 82, 84, 85, 87, 88, 89, 91, 93, 94, 96, 97, 99, 101, 102, 104, 106, 108, 110, 111, 114, 115, 117, 119, 120, 121, 123, 124, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 135, 137, 138, 140, 141, 144, 147, 149, 152, 154, 157, 160, 163, 165, 168, 172, 174, 177, 180, 183, 186, 189, 191, 194, 196, 198, 200, 202, 205, 207, 209, 211, 213, 216, 218, 220, 222, 225, 227, 230, 232, 234, 236, 238, 240, 242, 245, 247, 250, 252, 255, 258, 260, 263, 265, 267, 270, 272, 275} 
, {9, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 18, 18, 18, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 21, 21, 21, 21, 22, 22, 23, 23, 24, 24, 25, 26, 26, 27, 28, 28, 29, 30, 31, 31, 32, 32, 33, 34, 34, 35, 35, 36, 37, 37, 38, 38, 39, 40, 40, 40, 41, 41, 42, 42, 43, 44, 44, 44, 45, 46, 46, 47, 48, 48, 49, 50, 50, 51, 51, 52, 52, 53, 53} 
, {46, 47, 47, 47, 48, 48, 49, 49, 50, 50, 51, 51, 52, 52, 53, 53, 53, 54, 54, 55, 55, 56, 57, 58, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 70, 71, 71, 72, 72, 73, 74, 74, 72, 76, 78, 80, 82, 83, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 105, 107, 108, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 120, 121, 122, 122, 123, 123, 123, 124, 124, 124, 125, 125, 125, 125, 126, 126} 
, {220, 222, 223, 225, 226, 228, 229, 231, 233, 234, 236, 237, 239, 240, 242, 243, 245, 246, 248, 250, 251, 252, 254, 257, 259, 260, 262, 264, 265, 267, 269, 271, 272, 274, 276, 277, 279, 281, 282, 284, 286, 288, 289, 291, 292, 294, 296, 298, 300, 302, 304, 306, 308, 310, 312, 314, 316, 318, 320, 323, 325, 328, 331, 334, 337, 340, 342, 345, 347, 349, 351, 354, 356, 358, 359, 361, 362, 363, 364, 365, 366, 368, 368, 369, 369, 370, 371, 372, 373, 374, 376, 378, 380, 381, 383, 384, 385, 386, 386, 387, 387} 
, {73, 74, 74, 75, 75, 76, 76, 77, 77, 78, 78, 79, 79, 80, 80, 81, 81, 82, 82, 83, 83, 84, 86, 87, 88, 89, 91, 92, 93, 94, 95, 96, 97, 98, 100, 101, 102, 103, 104, 105, 104, 101, 101, 100, 99, 96, 94, 92, 93, 94, 96, 97, 98, 99, 101, 102, 104, 105, 106, 107, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 131, 132, 133, 133, 134, 134, 135, 135, 135, 135, 135, 134, 134, 134, 134, 134, 134, 134} 
, {97, 97, 97, 98, 98, 99, 99, 100, 100, 101, 101, 102, 102, 103, 103, 104, 104, 105, 105, 106, 106, 108, 110, 111, 112, 113, 113, 115, 116, 118, 119, 120, 121, 122, 123, 124, 126, 127, 129, 130, 131, 133, 134, 136, 137, 139, 141, 142, 144, 145, 146, 148, 151, 153, 155, 158, 160, 163, 165, 168, 170, 172, 174, 176, 178, 180, 181, 183, 184, 185, 186, 187, 188, 190, 191, 192, 193, 195, 196, 197, 198, 199, 201, 202, 203, 204, 206, 207, 208, 209, 209, 210, 210, 210, 210, 209, 208, 208, 207, 206, 205} 
, {75, 76, 77, 77, 78, 78, 79, 79, 80, 80, 81, 82, 82, 83, 83, 84, 84, 85, 86, 86, 87, 88, 89, 90, 91, 92, 93, 94, 96, 97, 99, 100, 101, 103, 104, 106, 107, 109, 110, 112, 113, 115, 116, 118, 119, 121, 123, 124, 126, 128, 130, 134, 137, 141, 144, 148, 152, 156, 161, 166, 171, 176, 181, 186, 191, 196, 202, 207, 212, 218, 224, 230, 236, 242, 248, 255, 262, 268, 276, 283, 291, 299, 307, 316, 324, 334, 343, 352, 361, 370, 380, 388, 398, 407, 417, 426, 436, 445, 454, 464, 473} 
, {408, 411, 413, 415, 418, 420, 423, 425, 427, 430, 432, 435, 437, 440, 442, 445, 448, 450, 453, 455, 458, 461, 463, 466, 469, 471, 474, 477, 479, 482, 485, 485, 485, 485, 485, 485, 485, 485, 487, 490, 491, 487, 487, 483, 487, 490, 494, 507, 529, 543, 565, 569, 576, 586, 597, 609, 621, 636, 649, 657, 653, 648, 656, 677, 699, 719, 739, 759, 780, 802, 824, 846, 867, 887, 905, 922, 937, 950, 963, 977, 990, 1002, 1018, 1032, 1046, 1060, 1075, 1093, 1111, 1128, 1144, 1159, 1172, 1185, 1197, 1210, 1221, 1233, 1244, 1254, 1263} 
, {65, 67, 68, 69, 70, 72, 73, 74, 75, 77, 78, 79, 80, 81, 83, 84, 85, 86, 88, 89, 90, 92, 94, 96, 98, 99, 101, 103, 105, 107, 110, 112, 114, 116, 118, 120, 123, 125, 127, 130, 132, 135, 138, 141, 144, 147, 150, 153, 157, 161, 164, 169, 173, 178, 183, 188, 193, 199, 204, 210, 216, 222, 229, 235, 242, 249, 255, 262, 270, 277, 284, 292, 299, 307, 314, 322, 329, 337, 345, 352, 360, 368, 376, 384, 392, 400, 408, 416, 424, 433, 441, 449, 457, 465, 473, 482, 490, 498, 506, 513, 521} 
, {144, 146, 148, 150, 152, 154, 156, 158, 160, 162, 164, 166, 168, 170, 172, 174, 176, 178, 180, 182, 184, 186, 190, 192, 195, 198, 200, 203, 207, 210, 213, 217, 220, 224, 228, 231, 235, 239, 243, 247, 251, 256, 259, 263, 266, 270, 273, 277, 280, 284, 289, 293, 298, 304, 310, 317, 324, 331, 339, 348, 357, 366, 375, 385, 394, 403, 413, 423, 433, 443, 453, 464, 475, 486, 498, 509, 520, 532, 545, 557, 570, 583, 596, 609, 621, 633, 645, 657, 670, 682, 694, 707, 719, 731, 743, 756, 767, 779, 791, 803, 816} 
, {112, 114, 115, 117, 118, 120, 122, 123, 125, 127, 129, 130, 132, 134, 136, 137, 139, 141, 143, 145, 146, 148, 151, 153, 155, 156, 159, 161, 163, 166, 168, 172, 174, 176, 179, 181, 184, 187, 190, 193, 197, 199, 203, 206, 208, 211, 214, 217, 220, 224, 228, 233, 238, 243, 248, 253, 259, 264, 270, 276, 283, 289, 295, 303, 310, 318, 325, 334, 342, 351, 359, 368, 378, 388, 398, 408, 419, 430, 442, 455, 468, 481, 495, 510, 525, 540, 556, 572, 588, 604, 621, 638, 654, 672, 688, 705, 723, 742, 760, 778, 797} 
, {231, 232, 234, 235, 236, 238, 239, 240, 242, 243, 244, 246, 247, 248, 249, 251, 252, 253, 255, 256, 257, 259, 263, 265, 268, 271, 274, 277, 280, 283, 286, 288, 293, 297, 301, 305, 309, 313, 317, 321, 326, 329, 334, 338, 343, 347, 351, 356, 360, 365, 369, 376, 382, 389, 397, 404, 412, 420, 428, 437, 445, 454, 464, 474, 484, 495, 506, 518, 530, 542, 555, 567, 581, 594, 608, 621, 635, 649, 662, 676, 690, 705, 720, 735, 752, 768, 784, 800, 817, 833, 850, 866, 883, 899, 916, 933, 950, 967, 984, 1000, 1017} 
, {1563, 1577, 1590, 1604, 1618, 1632, 1645, 1659, 1673, 1687, 1701, 1715, 1730, 1744, 1758, 1773, 1787, 1802, 1816, 1831, 1845, 1864, 1886, 1908, 1928, 1947, 1968, 1990, 2011, 2033, 2054, 2073, 2093, 2113, 2132, 2152, 2173, 2193, 2216, 2240, 2262, 2274, 2295, 2312, 2335, 2354, 2381, 2417, 2464, 2506, 2556, 2594, 2636, 2681, 2729, 2780, 2833, 2889, 2945, 2997, 3039, 3080, 3136, 3205, 3276, 3345, 3416, 3485, 3557, 3631, 3707, 3784, 3861, 3937, 4013, 4086, 4158, 4231, 4303, 4378, 4454, 4530, 4610, 4690, 4770, 4851, 4933, 5018, 5105, 5190, 5277, 5359, 5442, 5523, 5603, 5682, 5761, 5840, 5919, 5996, 6073}
//denmark*100
, {250, 253, 257, 261, 264, 268, 272, 276, 279, 283, 287, 290, 294, 298, 302, 305, 309, 313, 316, 320, 324, 328, 332, 335, 338, 342, 345, 347, 349, 351, 354, 356, 360, 363, 366, 369, 372, 374, 377, 380, 383, 386, 390, 394, 399, 404, 410, 414, 419, 423, 427, 430, 433, 436, 440, 443, 446, 448, 451, 454, 455, 461, 465, 458, 472, 476, 480, 484, 486, 489, 493, 496, 499, 502, 505, 506, 507, 509, 510, 512, 512, 512, 511, 511, 511, 511, 512, 512, 513, 513, 511, 510, 510, 510, 510, 510, 510, 510, 510, 510, 510}
};

//gdp per capita from image, 1970-2000, 12 regions+ world average 
//(note transposed regions go across)
//(note image scenarios start 1995 so will be slight discontinuities up to 1% at 2000!)
double[][] gdppc= {
{18024, 11270, 20101, 12777, 2070, 1624, 3055, 255, 2642, 502, 573, 201, 3562}, 
{18369, 11649, 20762, 13137, 2180, 1699, 3167, 272, 2749, 521, 585, 199, 3631}, 
{19126, 11978, 22210, 13638, 2301, 1755, 3337, 281, 2866, 541, 594, 192, 3756}, 
{19929, 12513, 23697, 14332, 2416, 1898, 3374, 305, 3030, 578, 603, 194, 3914}, 
{19665, 12729, 23073, 14560, 2514, 1995, 3326, 315, 3152, 598, 627, 194, 3897}, 
{19405, 12821, 23453, 14383, 2596, 2113, 3397, 332, 3173, 611, 628, 204, 3868}, 
{20168, 13240, 24112, 14925, 2664, 2212, 3722, 346, 3264, 649, 644, 205, 3981}, 
{20839, 13346, 24888, 15257, 2757, 2305, 3672, 373, 3341, 685, 643, 213, 4061}, 
{21601, 13826, 25949, 15647, 2815, 2401, 3553, 411, 3358, 724, 646, 221, 4156}, 
{21861, 14111, 27157, 16153, 2833, 2450, 3521, 441, 3510, 759, 658, 210, 4239}, 
{21416, 14241, 27685, 16370, 2807, 2546, 3350, 459, 3649, 793, 672, 219, 4237}, 
{21606, 14550, 28342, 16362, 2697, 2607, 3233, 482, 3549, 822, 674, 229, 4232}, 
{20905, 14006, 28986, 16478, 2676, 2667, 3054, 510, 3436, 835, 671, 233, 4178}, 
{21308, 14412, 29438, 16728, 2765, 2750, 3099, 554, 3280, 867, 656, 243, 4208}, 
{22425, 15048, 30401, 17085, 2868, 2834, 3046, 608, 3339, 883, 664, 247, 4314}, 
{22949, 15457, 31568, 17485, 2931, 2852, 2986, 655, 3371, 869, 661, 255, 4382}, 
{23343, 15688, 32288, 17931, 3008, 2976, 2939, 712, 3470, 887, 657, 262, 4449}, 
{23794, 16119, 33479, 18361, 3037, 2988, 2974, 781, 3514, 925, 650, 268, 4525}, 
{24458, 16568, 35413, 19023, 3105, 3061, 2941, 847, 3457, 987, 657, 286, 4644}, 
{24967, 16736, 36990, 19612, 3098, 3096, 2873, 881, 3427, 1058, 660, 296, 4726}, 
{25001, 16603, 38752, 20109, 2897, 2964, 3018, 925, 3350, 1127, 653, 306, 4771}, 
{24490, 16048, 40114, 20646, 2608, 2782, 3114, 992, 3406, 1184, 641, 305, 4785}, 
{24906, 16123, 40406, 20762, 2531, 2381, 3187, 1072, 3438, 1238, 624, 316, 4793}, 
{25259, 16493, 40414, 20601, 2568, 2134, 3283, 1160, 3515, 1306, 614, 324, 4795}, 
{25947, 16999, 40576, 21137, 2665, 1844, 3218, 1260, 3642, 1388, 613, 340, 4869}, 
{26316, 17292, 41052, 21636, 2822, 1747, 3282, 1360, 3591, 1478, 614, 356, 4931}, 
{27295, 17676, 41319, 22063, 2916, 1718, 3329, 1444, 3662, 1483, 615, 369, 5017}, 
{28274, 18061, 41585, 22489, 3009, 1688, 3376, 1527, 3732, 1488, 617, 382, 5102}, 
{29252, 18445, 41852, 22916, 3103, 1659, 3423, 1611, 3803, 1493, 618, 395, 5186}, 
{30231, 18830, 42119, 23343, 3196, 1630, 3469, 1695, 3874, 1497, 620, 408, 5271}, 
{31210, 19214, 42385, 23769, 3290, 1600, 3516, 1778, 3945, 1502, 621, 422, 5354}
}; //end gdppc 

//Secondary energy per capita from 1971 to 2000 (note not 1970!)
double[][] enpc={
{221, 157, 68, 90, 60, 105, 31, 20, 26, 14, 21, 14, 47}, 
{227, 161, 72, 92, 65, 108, 33, 19, 27, 14, 21, 13, 47}, 
{231, 168, 76, 95, 70, 116, 33, 20, 29, 14, 21, 13, 49}, 
{224, 167, 71, 95, 73, 121, 34, 20, 31, 15, 22, 13, 49}, 
{218, 162, 71, 91, 77, 129, 37, 21, 31, 15, 22, 13, 48}, 
{222, 166, 71, 93, 79, 132, 42, 20, 32, 15, 22, 13, 49}, 
{225, 165, 71, 92, 82, 137, 44, 21, 32, 16, 22, 13, 49}, 
{230, 168, 73, 93, 84, 141, 44, 22, 33, 16, 23, 14, 50}, 
{229, 171, 76, 94, 84, 141, 45, 22, 35, 16, 23, 13, 50}, 
{221, 169, 76, 93, 82, 149, 41, 23, 37, 17, 23, 14, 51}, 
{216, 168, 75, 90, 77, 149, 41, 23, 35, 17, 24, 13, 49}, 
{200, 152, 73, 86, 73, 149, 38, 23, 33, 17, 24, 13, 47}, 
{198, 154, 72, 85, 77, 146, 39, 24, 30, 17, 23, 14, 47}, 
{204, 161, 72, 86, 81, 149, 39, 25, 31, 18, 23, 14, 48}, 
{206, 167, 74, 87, 82, 146, 38, 27, 32, 17, 23, 14, 48}, 
{206, 167, 74, 89, 85, 148, 38, 28, 34, 18, 23, 14, 49}, 
{207, 171, 76, 90, 85, 150, 38, 29, 34, 18, 23, 14, 49}, 
{211, 177, 81, 94, 86, 149, 38, 30, 33, 19, 23, 14, 50}, 
{212, 177, 84, 97, 83, 147, 37, 29, 33, 20, 23, 14, 50}, 
{207, 172, 87, 99, 71, 140, 39, 29, 32, 21, 23, 15, 49}, 
{199, 163, 91, 101, 59, 136, 41, 29, 32, 22, 22, 14, 48}, 
{200, 161, 92, 99, 54, 115, 42, 30, 32, 22, 22, 15, 47}, 
{200, 163, 93, 97, 54, 109, 45, 31, 33, 22, 21, 15, 46}, 
{203, 168, 93, 99, 56, 98, 43, 32, 35, 23, 21, 16, 46}, 
{204, 169, 95, 100, 59, 97, 44, 32, 33, 24, 21, 16, 47}, 
{207, 171, 96, 101, 60, 95, 45, 32, 34, 24, 21, 17, 47}, 
{210, 173, 97, 103, 61, 94, 46, 31, 35, 24, 21, 17, 47}, 
{213, 175, 97, 104, 61, 93, 47, 31, 36, 24, 21, 17, 47}, 
{215, 176, 98, 105, 62, 92, 48, 30, 37, 25, 21, 17, 47}, 
{217, 178, 98, 107, 62, 91, 49, 29, 37, 25, 21, 18, 47}
}; //end enpc


}//end histdata
