//extra historical data for brazilian proposal exercise

public interface histresp { 

/* Historical data from Edgar-Hyde Dataset (RIVM)
http://www.rivm.nl/env/int/coredata/edgar/
{Van Ardenne et al 2001
{from 1890 to 1990 in ten year intervals

EH Regions are:
Canada, USA, Latin America, Africa, 
OECD EU, E EU, CIS, mid east, 
"india", "china", east asia, oceania, japan,  
world

note Afg & Pak & Bangla in "India", mongolia, korea, taiwan in "China"
*/

//regions go down

double[][] ch4emit={ //TgC
{0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.2, 1.4, 1.8, 2.0, 2.8 },
{7.8, 9.6, 12.7, 15.8, 14.9, 15.4, 17.7, 18.6, 22.9, 25.3, 30.9},
{2.3, 2.7, 4.3, 4.9, 6.1, 6.4, 8.1, 14.5, 17.9, 22.1, 24.1},
{3.1, 3.1, 3.6, 4.6, 5.9, 6.0, 11.7, 10.4, 14.0, 17.0, 19.4},
{10.8, 15.9, 16.9, 16.1, 18.7, 19.9, 19.3, 21.2, 20.2, 19.9, 17.6},
{1.2, 1.4, 1.8, 2.2, 3.4, 3.6, 4.8, 6.4, 7.7, 9.6, 8.0},
{2.9, 3.5, 3.7, 4.7, 5.8, 7.2, 8.8, 14.1, 19.4, 24.6, 35.0},
{0.9, 0.8, 0.9, 1.0, 1.5, 1.8, 2.4, 3.5, 5.3, 6.8, 7.6},
{25.7, 27.2, 26.8, 29.6, 25.0, 30.8, 31.1, 33.9, 34.2, 36.5, 37.5},
{10.2, 10.7, 11.5, 12.5, 16.1, 15.9, 17.1, 31.3, 31.1, 36.4, 36.2},
{2.7, 2.9, 3.5, 4.7, 7.5, 6.4, 6.8, 9.2, 10.7, 12.7, 13.9},
{1.3, 1.2, 1.5, 1.8, 1.9, 2.0, 2.3, 2.9, 3.8, 4.2, 4.6},
{1.1, 1.3, 1.5, 1.9, 1.5, 2.6, 2.2, 2.7, 2.5, 2.0, 2.0},
{70.5, 80.8, 89.4, 100.7, 109.1, 119.1, 133.4, 170.1, 191.6, 219.1, 239.8}
};

double[][] n2oemit={ //Tg N
{0.005, 0.006, 0.007, 0.008, 0.009, 0.009, 0.012, 0.016, 0.024, 0.039, 0.050},
{0.062, 0.066, 0.071, 0.079, 0.074, 0.080, 0.123, 0.150, 0.239, 0.312, 0.353},
{0.017, 0.017, 0.042, 0.047, 0.048, 0.059, 0.077, 0.151, 0.191, 0.253, 0.291},
{0.030, 0.026, 0.038, 0.053, 0.068, 0.066, 0.186, 0.123, 0.167, 0.206, 0.244},
{0.044, 0.071, 0.061, 0.065, 0.075, 0.089, 0.133, 0.172, 0.257, 0.334, 0.364},
{0.008, 0.006, 0.007, 0.014, 0.026, 0.016, 0.041, 0.056, 0.092, 0.129, 0.127},
{0.039, 0.043, 0.045, 0.063, 0.068, 0.063, 0.079, 0.114, 0.188, 0.269, 0.293},
{0.009, 0.010, 0.010, 0.011, 0.017, 0.021, 0.028, 0.038, 0.045, 0.065, 0.085},
{0.142, 0.146, 0.151, 0.154, 0.160, 0.163, 0.172, 0.185, 0.215, 0.280, 0.377},
{0.023, 0.026, 0.029, 0.035, 0.040, 0.050, 0.069, 0.099, 0.166, 0.333, 0.486},
{0.007, 0.008, 0.010, 0.015, 0.019, 0.022, 0.027, 0.033, 0.043, 0.062, 0.096},
{0.020, 0.017, 0.022, 0.024, 0.027, 0.026, 0.030, 0.038, 0.047, 0.047, 0.053},
{0.002, 0.002, 0.002, 0.002, 0.003, 0.005, 0.015, 0.019, 0.026, 0.026, 0.034},
{0.409, 0.444, 0.496, 0.570, 0.633, 0.670, 0.993, 1.195, 1.699, 2.356, 2.853}
};

double[][] coemit= { //TgC
{1.29, 1.51, 1.75, 1.97, 2.27, 2.45, 2.82, 3.60, 4.15, 5.00, 4.77},
{7.86, 9.41, 11.36, 14.18, 18.35, 20.19, 26.17, 32.02, 36.06, 38.65, 40.79},
{15.72, 22.39, 26.67, 31.41, 36.23, 39.84, 41.90, 48.10, 53.56, 60.91, 63.30},
{24.65, 28.52, 31.06, 34.28, 38.16, 42.83, 48.21, 55.88, 64.53, 79.21, 95.54},
{11.95, 13.33, 15.31, 16.21, 18.14, 18.48, 17.83, 21.80, 24.53, 27.14, 29.33},
{2.27, 2.52, 2.89, 3.05, 3.43, 3.72, 5.30, 7.92, 6.83, 8.55, 7.26},
{5.44, 6.18, 7.04, 7.78, 9.16, 11.60, 13.94, 18.60, 22.00, 27.00, 28.04},
{3.35, 3.53, 3.86, 4.18, 4.71, 5.67, 6.56, 8.31, 9.59, 11.78, 14.33},
{20.61, 21.72, 22.90, 24.01, 25.57, 27.88, 30.16, 34.86, 40.23, 44.66, 50.12},
{19.53, 20.34, 21.40, 22.32, 23.10, 24.24, 25.72, 36.40, 44.71, 44.09, 51.33},
{4.85, 5.67, 6.63, 7.68, 8.90, 10.39, 11.56, 14.19, 16.78, 20.54, 24.40},
{2.84, 3.80, 4.03, 4.23, 4.46, 4.74, 5.12, 6.06, 6.79, 7.61, 8.63},
{0.16, 0.25, 0.38, 0.44, 0.57, 0.76, 0.86, 1.84, 3.34, 4.14, 5.03},
{120.51, 139.16, 155.27, 171.73, 193.04, 212.79, 236.16, 289.59, 333.08, 379.27, 422.87}
};

double[][] noxemit= { //TgN
{0.10, 0.12, 0.14, 0.15, 0.18, 0.19, 0.26, 0.33, 0.48, 0.66, 0.65},
{0.82, 1.07, 1.45, 1.79, 2.18, 2.25, 3.40, 4.26, 5.71, 7.01, 7.51},
{1.46, 1.57, 1.69, 1.84, 1.99, 2.10, 2.19, 2.61, 2.93, 3.52, 3.78},
{1.63, 1.70, 1.79, 1.90, 2.02, 2.19, 2.52, 2.88, 3.61, 4.38, 5.26},
{0.61, 0.76, 0.99, 1.11, 1.29, 1.38, 1.41, 2.00, 3.36, 4.00, 4.17},
{0.09, 0.11, 0.14, 0.15, 0.19, 0.22, 0.41, 0.76, 0.79, 1.04, 0.83},
{0.30, 0.32, 0.35, 0.37, 0.47, 0.72, 0.99, 1.68, 2.43, 3.45, 3.64},
{0.17, 0.17, 0.18, 0.19, 0.20, 0.24, 0.27, 0.36, 0.54, 0.85, 1.12},
{0.54, 0.56, 0.60, 0.62, 0.66, 0.72, 0.79, 0.96, 1.19, 1.49, 2.09},
{0.52, 0.54, 0.56, 0.58, 0.60, 0.63, 0.68, 1.11, 1.47, 2.30, 3.42},
{0.23, 0.24, 0.26, 0.29, 0.32, 0.34, 0.38, 0.47, 0.63, 0.86, 1.27},
{0.40, 0.41, 0.43, 0.44, 0.45, 0.47, 0.51, 0.58, 0.67, 0.81, 0.92},
{0.03, 0.05, 0.07, 0.08, 0.09, 0.14, 0.13, 0.29, 0.55, 0.69, 0.82},
{6.90, 7.62, 8.66, 9.52, 10.63, 11.60, 13.94, 18.31, 24.35, 31.06, 35.46}
};

double[][] vocemit= { //Tg (total) -nmvoc
{0.23, 0.29, 0.35, 0.40, 0.51, 0.60, 0.83, 1.49, 2.26, 2.97, 3.33},
{1.77, 2.45, 3.16, 4.30, 6.21, 7.67, 10.81, 14.65, 19.30, 22.44, 24.20},
{3.19, 4.58, 5.48, 6.69, 7.83, 8.77, 9.88, 12.62, 15.35, 18.57, 20.65},
{2.02, 2.35, 2.78, 3.27, 3.85, 4.60, 5.57, 7.35, 11.21, 13.81, 17.34},
{2.48, 3.10, 3.71, 4.09, 4.73, 5.12, 5.64, 9.01, 12.76, 17.38, 21.12},
{0.48, 0.57, 0.67, 0.72, 0.87, 0.97, 1.31, 2.20, 2.43, 3.43, 3.65},
{1.02, 1.31, 1.51, 1.65, 2.04, 2.67, 3.31, 5.58, 9.97, 14.93, 18.73},
{0.81, 0.87, 0.95, 1.05, 1.22, 1.50, 2.40, 4.30, 8.06, 10.91, 12.33},
{5.10, 5.53, 5.92, 6.30, 6.78, 7.43, 8.12, 10.01, 12.37, 14.76, 18.30},
{5.79, 6.09, 6.37, 6.67, 6.91, 7.22, 7.59, 9.70, 12.90, 15.91, 19.71},
{1.23, 1.51, 1.79, 2.10, 2.49, 2.94, 3.39, 4.55, 6.16, 8.53, 11.46},
{0.58, 0.78, 0.83, 0.88, 0.95, 1.05, 1.19, 1.55, 1.92, 2.37, 2.89},
{0.13, 0.25, 0.32, 0.40, 0.50, 0.69, 0.76, 1.63, 3.68, 5.44, 7.35},
{24.84, 29.67, 33.83, 38.52, 44.89, 51.22, 60.81, 84.64, 118.39, 151.46, 181.04}
};

double[][] so2emit= { //TgS
{0.12, 0.18, 0.27, 0.32, 0.38, 0.39, 0.61, 0.55, 0.86, 1.05, 1.17},
{2.80, 4.18, 6.33, 7.38, 7.48, 6.38, 9.06, 8.71, 11.36, 12.40, 10.81},
{0.28, 0.39, 0.54, 0.64, 0.83, 1.08, 1.23, 2.06, 3.21, 4.10, 4.50},
{0.37, 0.43, 0.53, 0.59, 0.70, 0.91, 1.10, 1.58, 2.02, 2.65, 3.40},
{1.85, 2.74, 4.16, 4.91, 6.03, 6.51, 6.18, 8.28, 12.20, 11.01, 10.87},
{0.20, 0.30, 0.45, 0.52, 0.70, 0.88, 1.58, 2.97, 2.67, 3.61, 5.38},
{0.17, 0.27, 0.40, 0.48, 1.01, 2.42, 3.50, 6.62, 9.40, 13.17, 11.38},
{0.03, 0.04, 0.05, 0.05, 0.07, 0.14, 0.19, 0.35, 0.94, 1.62, 2.32},
{0.18, 0.21, 0.27, 0.30, 0.33, 0.41, 0.48, 0.73, 0.98, 1.35, 2.35},
{0.25, 0.35, 0.49, 0.55, 0.66, 0.87, 1.11, 4.34, 6.03, 8.68, 13.86},
{0.06, 0.09, 0.13, 0.15, 0.23, 0.30, 0.29, 0.55, 1.00, 1.72, 2.49},
{0.09, 0.12, 0.16, 0.18, 0.19, 0.24, 0.30, 0.43, 0.58, 0.73, 0.80},
{0.03, 0.05, 0.08, 0.09, 0.12, 0.18, 0.15, 0.32, 1.05, 1.03, 0.88},
{6.44, 9.35, 13.84, 16.15, 18.73, 20.70, 25.76, 37.49, 52.31, 63.11, 70.22}
};


/* don't yet use NH3 but include for completeness 
double[][] nh3emit= { //TgN
{0.12, 0.14, 0.16, 0.19, 0.21, 0.23, 0.27, 0.31, 0.35, 0.43, 0.45},
{1.34, 1.42, 1.50, 1.70, 1.64, 1.75, 2.00, 2.23, 2.65, 2.95, 2.84},
{0.53, 0.71, 1.13, 1.29, 1.35, 1.63, 1.99, 3.54, 4.35, 5.56, 6.26},
{0.57, 0.65, 0.77, 1.09, 1.42, 1.48, 3.01, 2.76, 3.71, 4.68, 5.74},
{0.93, 1.48, 1.25, 1.34, 1.56, 1.75, 1.92, 2.19, 2.55, 2.86, 2.89},
{0.16, 0.12, 0.13, 0.28, 0.55, 0.34, 0.65, 0.80, 0.94, 1.18, 1.12},
{0.79, 0.90, 0.93, 1.26, 1.36, 1.32, 1.52, 2.02, 2.53, 3.17, 3.44},
{0.15, 0.15, 0.17, 0.19, 0.30, 0.38, 0.49, 0.67, 0.80, 1.02, 1.26},
{2.88, 2.96, 3.06, 3.15, 3.29, 3.41, 3.62, 3.95, 4.67, 5.94, 7.70},
{0.62, 0.68, 0.74, 0.86, 1.00, 1.22, 1.66, 2.40, 3.57, 6.10, 8.57},
{0.17, 0.21, 0.26, 0.37, 0.46, 0.53, 0.63, 0.78, 0.99, 1.36, 1.96},
{0.30, 0.27, 0.35, 0.41, 0.44, 0.46, 0.52, 0.64, 0.77, 0.83, 0.90},
{0.05, 0.05, 0.06, 0.07, 0.08, 0.09, 0.13, 0.17, 0.23, 0.27, 0.30},
{8.62, 9.75, 10.51, 12.18, 13.65, 14.59, 18.40, 22.44, 28.11, 36.34, 43.44}
};
*/

/*
//TOTAL co2 including industral fossil, BIOFUEL and deforestation!
double[][] co2totemit={ //TgC
{26.1, 31.2, 38.3, 42.3, 48.5, 52.1, 74.3, 90.1, 135.5, 165.9, 159.5},
{257.7, 347.3, 487.1, 569.2, 629.1, 617.3, 882.1, 1058.8, 1359.1, 1527.1, 1479.7},
{137.0, 165.9, 197.8, 234.5, 263.8, 284.9, 297.7, 383.6, 478.3, 573.7, 612.0},
{86.2, 98.1, 115.9, 134.8, 155.8, 186.0, 222.4, 286.2, 374.7, 497.1, 639.3},
{221.9, 282.9, 379.4, 426.5, 502.3, 522.3, 499.0, 657.4, 990.6, 1108.7, 1012.5},
{27.4, 35.7, 48.2, 53.5, 66.3, 76.6, 140.7, 261.6, 231.8, 322.4, 294.0},
{21.6, 25.7, 31.2, 35.6, 66.3, 157.2, 236.7, 477.3, 688.0, 947.1, 971.1},
{17.1, 17.1, 18.5, 20.4, 22.2, 29.3, 37.7, 63.1, 120.7, 183.8, 269.2},
{131.3, 143.8, 157.6, 170.7, 183.8, 201.1, 218.3, 281.8, 353.3, 443.4, 605.4},
{184.8, 191.4, 202.1, 209.9, 213.9, 221.4, 232.5, 417.9, 563.8, 757.1, 1087.5},
{39.3, 46.7, 56.0, 66.3, 78.6, 92.0, 100.6, 132.8, 187.7, 270.0, 363.1},
{8.8, 11.3, 15.1, 17.1, 16.7, 20.8, 28.4, 41.2, 58.8, 79.8, 92.4},
{8.6, 12.8, 19.2, 22.1, 27.6, 41.6, 31.7, 70.5, 268.1, 320.9, 318.1},
{1167.8, 1409.9, 1766.4, 2002.8, 2274.9, 2502.5, 3002.1, 4222.1, 5810.3, 7196.9, 7903.9}
};

//"Deforestation" category of Edgar-hyde - Looks strange!
double[][] co2lucemit={ //TgC
0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0
0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0
94.8, 114.0, 134.0, 156.0, 173.0, 182.0, 180.0, 204.0, 225.0, 233.0, 235.0
29.4, 32.9, 38.0, 44.3, 51.0, 58.9, 67.5, 81.4, 99.6, 124.0, 156.0
0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0
0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0
0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0
0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0
11.2, 12.1, 12.9, 13.8, 14.8, 15.9, 16.9, 20.6, 25.2, 30.2, 36.2
11.8, 12.0, 12.4, 12.7, 12.9, 13.0, 13.0, 14.0, 18.1, 21.2, 22.6
10.3, 12.1, 14.3, 16.9, 19.6, 22.5, 25.4, 30.6, 38.1, 45.7, 51.2
0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0
0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0
157.5, 183.1, 211.6, 243.7, 271.3, 292.3, 302.9, 350.7, 406.1, 454.2, 501.1
}; 
*/

//CDIAC NDP050 Houghton historical landuse:
//MtC/yr 1850-1990
//note regions go across
//Nth America, Sth/C America, Europe, Nth Af/MidE, TropAf, FSU, China, S/SE Asia, PacificDev, Total

double[][] regluc= { 
{87.28, 42.48, 55.04, 3.98, 5.61, 58.56, 56.52, 85.63, 2.05, 397.145},
{87.22, 42.18, 55.02, 3.98, 6.47, 58.55, 56.50, 85.20, 2.04, 397.164},
{90.37, 41.90, 54.99, 3.98, 6.60, 58.88, 56.48, 85.25, 2.04, 400.492},
{93.38, 41.66, 54.96, 3.98, 6.69, 59.22, 56.47, 85.33, 2.03, 403.713},
{96.28, 41.44, 54.93, 3.98, 6.77, 59.58, 56.45, 85.42, 2.03, 406.877},
{99.12, 41.24, 54.90, 3.98, 6.82, 59.96, 56.43, 85.53, 2.03, 410.017},
{101.93, 41.06, 54.87, 3.98, 6.86, 60.34, 56.42, 85.65, 2.02, 413.137},
{104.72, 40.91, 54.84, 3.98, 6.88, 60.72, 56.40, 85.77, 2.02, 416.250},
{107.50, 40.77, 54.81, 3.98, 6.90, 61.10, 56.39, 85.90, 2.01, 419.363},
{110.27, 40.64, 54.78, 3.98, 6.92, 61.48, 56.37, 86.02, 2.01, 422.481},
{113.06, 38.09, 54.75, 3.98, 6.93, 61.85, 56.36, 86.14, 2.01, 423.171},
{116.34, 32.46, 54.79, 9.01, 8.02, 62.22, 56.25, 86.26, 2.08, 427.422},
{119.70, 29.66, 54.86, 9.96, 8.18, 53.69, 56.13, 86.38, 2.18, 420.740},
{123.16, 26.89, 54.96, 10.82, 8.31, 53.75, 55.99, 86.49, 2.30, 422.672},
{126.70, 24.20, 55.06, 11.25, 8.41, 53.80, 55.85, 86.61, 2.43, 424.303},
{130.31, 21.57, 55.18, 11.64, 8.49, 53.86, 55.71, 86.71, 2.56, 426.033},
{131.46, 20.62, 55.31, 11.99, 8.53, 53.74, 55.55, 86.82, 2.70, 426.713},
{132.67, 19.74, 55.46, 12.31, 8.57, 53.62, 55.39, 86.91, 2.83, 427.495},
{133.95, 18.90, 55.61, 12.61, 8.59, 53.51, 55.23, 87.01, 2.96, 428.377},
{135.30, 18.11, 55.78, 12.89, 8.62, 53.41, 55.06, 87.10, 3.09, 429.350},
{136.72, 19.79, 55.95, 13.15, 8.64, 53.32, 54.88, 87.18, 3.21, 432.843},
{138.16, 23.97, 50.48, 13.40, 8.66, 53.23, 54.70, 108.79, 9.87, 461.264},
{139.64, 25.66, 49.60, 13.64, 8.67, 53.49, 54.53, 113.96, 11.93, 471.118},
{141.14, 27.32, 48.75, 13.87, 8.69, 53.75, 54.35, 117.71, 13.66, 479.236},
{142.67, 28.92, 47.95, 14.09, 8.70, 54.01, 51.69, 120.51, 14.33, 482.862},
{144.23, 30.47, 47.17, 14.30, 8.71, 54.27, 51.15, 122.69, 14.87, 487.850},
{144.64, 30.66, 46.53, 14.47, 9.79, 54.94, 50.74, 124.08, 15.35, 491.204},
{144.91, 31.36, 45.94, 14.63, 9.96, 55.04, 50.41, 125.23, 15.76, 493.231},
{145.05, 32.02, 45.39, 14.79, 10.08, 55.13, 50.11, 126.23, 16.12, 494.901},
{145.06, 32.63, 44.87, 14.93, 10.18, 55.21, 49.84, 127.11, 16.44, 496.273},
{144.94, 33.22, 44.39, 15.07, 10.26, 55.30, 49.59, 127.91, 16.75, 497.425},
{144.70, 70.55, 43.94, 15.21, 10.30, 55.40, 49.35, 128.27, 17.05, 534.771},
{144.34, 82.30, 43.52, 15.35, 10.33, 55.51, 49.14, 128.59, 17.34, 546.421},
{143.86, 92.24, 43.12, 15.49, 10.36, 55.63, 48.94, 128.87, 17.64, 556.158},
{143.27, 100.88, 42.74, 15.63, 10.39, 55.76, 48.75, 129.13, 17.94, 564.499},
{142.58, 108.58, 42.39, 15.77, 10.41, 55.90, 48.58, 129.37, 18.24, 571.807},
{141.82, 112.04, 42.56, 15.90, 11.71, 56.03, 48.42, 129.59, 18.54, 576.593},
{141.00, 114.43, 42.73, 16.03, 11.91, 56.17, 48.26, 129.79, 18.83, 579.162},
{140.14, 116.44, 42.92, 16.16, 12.06, 56.30, 48.11, 129.98, 19.12, 581.235},
{139.21, 118.15, 43.11, 16.29, 12.18, 56.44, 48.04, 130.16, 19.36, 582.940},
{138.09, 119.63, 43.31, 16.42, 12.28, 56.57, 47.97, 130.32, 19.60, 584.180},
{148.45, 92.35, 43.51, 16.54, 12.34, 56.70, 47.90, 146.76, 19.83, 584.388},
{150.16, 84.19, 43.72, 16.66, 12.38, 56.83, 47.84, 150.78, 20.06, 582.620},
{151.73, 77.09, 43.91, 16.78, 12.42, 56.96, 47.79, 153.67, 20.28, 580.630},
{153.18, 70.78, 44.11, 16.90, 12.45, 57.08, 47.75, 155.83, 20.50, 578.581},
{154.55, 65.05, 44.31, 17.01, 12.47, 57.21, 47.70, 157.53, 20.72, 576.549},
{155.52, 63.60, 44.50, 17.12, 12.50, 57.33, 47.66, 158.61, 20.93, 577.764},
{156.43, 62.47, 44.68, 17.23, 12.52, 57.45, 47.63, 159.49, 21.14, 579.038},
{157.30, 61.59, 44.86, 17.34, 12.53, 57.57, 47.60, 160.22, 21.35, 580.364},
{158.14, 60.90, 45.03, 17.45, 12.55, 57.68, 47.57, 160.87, 21.55, 581.740},
{158.92, 60.36, 45.19, 17.55, 12.56, 57.79, 47.54, 161.44, 21.75, 583.112},
{159.83, 124.92, 45.44, 20.07, 15.57, 57.90, 47.62, 161.69, 22.03, 655.075},
{160.75, 144.42, 45.70, 20.58, 16.02, 58.05, 47.72, 161.98, 22.34, 677.559},
{161.70, 160.67, 45.98, 21.04, 16.35, 58.19, 47.84, 162.24, 22.65, 696.656},
{162.67, 174.59, 46.28, 21.29, 16.61, 58.33, 47.96, 162.47, 22.97, 713.179},
{163.67, 186.84, 46.60, 21.52, 16.82, 58.47, 48.11, 162.67, 23.30, 727.993},
{163.10, 191.39, 46.93, 21.72, 16.93, 58.59, 48.25, 170.77, 23.62, 741.299},
{162.56, 195.05, 47.27, 21.89, 17.02, 58.59, 48.40, 172.83, 23.94, 747.540},
{162.04, 198.06, 47.62, 22.05, 17.10, 58.58, 48.55, 174.30, 24.25, 752.540},
{161.56, 200.56, 47.98, 22.20, 17.16, 58.56, 48.70, 175.40, 24.56, 756.671},
{161.10, 202.27, 48.35, 22.33, 17.21, 58.54, 48.85, 176.27, 24.87, 759.791},
{160.68, 140.60, 48.72, 22.48, 21.53, 58.53, 49.01, 176.84, 25.15, 703.522},
{160.30, 122.37, 49.10, 22.59, 22.20, 58.51, 49.16, 177.30, 25.41, 686.940},
{159.97, 107.21, 49.47, 22.69, 22.69, 63.68, 49.30, 156.93, 25.67, 657.631},
{159.68, 94.19, 49.85, 22.79, 23.08, 65.23, 55.07, 152.36, 25.91, 648.173},
{159.44, 82.67, 50.23, 22.88, 23.40, 66.59, 56.06, 149.05, 26.16, 636.474},
{159.22, 78.80, 50.66, 22.93, 23.57, 67.89, 56.94, 153.45, 26.39, 639.850},
{159.03, 75.71, 51.09, 22.97, 23.71, 69.21, 57.66, 153.09, 26.62, 639.076},
{158.88, 73.19, 51.51, 23.01, 23.82, 70.49, 58.32, 152.93, 26.84, 638.978},
{158.76, 71.09, 51.92, 23.03, 23.92, 71.76, 58.95, 152.69, 27.05, 639.181},
{158.68, 66.46, 52.32, 23.05, 24.00, 73.06, 59.55, 152.43, 27.26, 636.822},
{158.64, 104.94, 52.77, 23.06, 28.35, 74.38, 60.11, 152.08, 27.57, 681.924},
{158.64, 114.93, 53.20, 23.07, 29.04, 75.75, 60.66, 151.74, 27.79, 694.822},
{158.67, 122.76, 53.62, 23.08, 29.56, 77.06, 61.17, 151.80, 28.00, 705.725},
{158.75, 129.12, 54.03, 23.09, 29.97, 78.40, 61.61, 151.87, 28.18, 715.011},
{158.85, 134.47, 54.42, 23.09, 30.30, 79.78, 62.10, 151.96, 28.35, 723.319},
{158.29, 135.88, 54.08, 31.70, 30.49, 81.20, 62.42, 147.46, 28.57, 730.099},
{157.65, 136.87, 53.62, 33.63, 30.64, 82.53, 62.72, 146.83, 28.81, 733.300},
{157.22, 137.47, 53.05, 35.36, 30.77, 83.10, 62.98, 146.53, 29.05, 735.537},
{131.20, 137.78, 52.36, 35.79, 30.87, 83.70, 63.09, 146.44, 29.30, 710.527},
{124.19, 141.11, 51.56, 36.12, 30.97, 84.30, 63.17, 146.47, 29.54, 707.444},
{117.44, 157.80, 50.66, 36.74, 35.33, 84.91, 63.25, 146.66, 29.79, 722.578},
{110.89, 163.27, 49.66, 37.31, 36.02, 85.52, 63.31, 146.89, 30.04, 722.897},
{104.46, 167.92, 48.56, 37.82, 36.55, 86.15, 63.36, 147.15, 30.28, 722.256},
{98.14, 171.97, 47.36, 38.30, 36.96, 84.55, 67.10, 147.42, 30.53, 722.339},
{91.89, 175.55, 46.08, 38.75, 37.30, 82.80, 67.92, 147.70, 30.78, 718.768},
{85.51, 177.38, 44.76, 39.18, 37.49, 80.90, 68.63, 165.10, 31.02, 729.964},
{79.19, 179.58, 43.40, 39.59, 37.65, 78.84, 69.19, 169.48, 31.26, 728.172},
{72.92, 181.57, 42.01, 39.98, 37.78, 76.69, 69.70, 172.75, 31.50, 724.900},
{66.67, 183.40, 40.59, 40.35, 37.89, 74.51, 70.17, 175.29, 31.73, 720.611},
{60.51, 185.09, 39.15, 40.71, 37.99, 71.15, 70.61, 177.32, 31.96, 714.481},
{54.31, 194.01, 37.69, 41.03, 53.04, 54.42, 71.04, 182.27, 32.19, 719.998},
{48.15, 198.34, 36.23, 41.35, 55.30, 47.51, 71.44, 187.87, 32.41, 718.624},
{42.05, 202.54, 34.77, 41.65, 56.99, 40.84, 71.84, 193.64, 32.63, 716.943},
{39.63, 206.70, 33.31, 41.89, 58.30, 34.35, 72.21, 199.44, 32.84, 718.664},
{37.25, 210.70, 31.86, 42.13, 59.36, 28.04, 72.58, 205.19, 33.04, 720.135},
{34.91, 214.35, 30.40, 42.35, 59.93, 24.03, 72.93, 281.30, 33.24, 793.441},
{32.61, 217.62, 28.96, 42.56, 60.38, 20.43, 73.28, 302.11, 33.44, 811.378},
{30.35, 221.01, 27.52, 42.77, 60.75, 17.18, 73.62, 318.01, 33.63, 824.833},
{28.13, 224.51, 26.08, 42.97, 61.06, 14.31, 73.67, 329.78, 33.82, 834.320},
{25.97, 229.84, 24.66, 43.16, 61.33, 13.08, 73.72, 340.01, 34.00, 845.773},
{18.23, 286.38, 23.53, 34.40, 82.95, 126.91, 74.65, 349.78, 67.51, 1064.327},
{15.04, 304.72, 22.55, 32.64, 86.28, 149.64, 75.60, 362.04, 76.88, 1125.376},
{12.12, 319.58, 21.71, 30.83, 88.76, 171.48, 76.56, 322.62, 84.52, 1128.181},
{9.44, 331.78, 21.01, 28.61, 90.71, 192.67, 77.52, 323.13, 86.59, 1161.448},
{6.97, 342.05, 20.44, 26.39, 92.29, 213.75, 97.76, 326.78, 87.92, 1214.345},
{4.71, 348.10, 20.00, 25.71, 93.16, 236.15, 102.65, 326.49, 88.76, 1245.711},
{2.63, 353.04, 19.68, 25.04, 93.86, 258.25, 107.01, 326.34, 89.26, 1275.109},
{0.72, 357.15, 19.48, 24.41, 94.43, 279.95, 110.54, 320.70, 89.52, 1296.919},
{-1.02, 362.41, 19.40, 23.79, 94.92, 208.34, 113.79, 320.51, 89.62, 1231.770},
{-2.61, 366.65, 19.44, 23.21, 95.34, 210.89, 116.84, 321.34, 89.59, 1240.677},
{-4.09, 481.93, 16.70, 22.64, 129.92, 205.22, 119.69, 325.96, 89.48, 1387.432},
{-5.48, 517.55, 16.32, 22.08, 135.24, 201.87, 122.35, 332.01, 89.30, 1431.247},
{-6.76, 546.07, 16.01, 21.55, 139.22, 198.82, 124.84, 347.12, 89.09, 1475.961},
{-7.96, 572.04, 15.78, 21.03, 142.32, 196.18, 127.34, 356.56, 88.83, 1512.116},
{-9.08, 593.94, 15.61, 20.52, 144.85, 192.92, 129.51, 365.27, 88.56, 1542.088},
{-9.07, 603.87, 15.48, 21.63, 146.24, 181.17, 129.61, 374.12, 88.25, 1551.292},
{-9.03, 612.03, 15.39, 21.82, 147.36, 169.52, 130.71, 382.93, 87.94, 1558.677},
{-8.97, 619.05, 15.35, 21.96, 148.28, 157.92, 131.78, 397.51, 87.61, 1570.492},
{-8.87, 629.61, 15.33, 21.73, 149.06, 147.84, 132.89, 407.46, 87.04, 1582.089},
{-9.26, 638.01, 13.57, 21.48, 149.73, 114.46, 132.78, 416.75, 86.46, 1563.981},
{-9.53, 567.12, 11.18, 21.52, 184.52, 100.10, 104.98, 407.73, 50.23, 1437.845},
{-9.76, 547.71, 8.64, 21.57, 190.04, 85.37, 101.07, 410.06, 39.11, 1393.820},
{-9.93, 531.05, 5.96, 21.62, 194.18, 71.25, 97.25, 474.68, 29.74, 1415.799},
{-9.56, 516.35, 3.15, 21.66, 197.43, 64.85, 93.70, 492.08, 26.12, 1405.787},
{-9.15, 503.09, 0.21, 21.71, 200.09, 58.78, 90.12, 505.73, 23.24, 1393.830},
{-8.74, 501.64, -2.64, 21.75, 201.60, 55.92, 86.52, 619.65, 20.85, 1496.554},
{-8.32, 500.90, -5.64, 21.78, 202.82, 50.36, 82.85, 655.90, 18.78, 1519.441},
{-7.99, 500.34, -8.79, 21.81, 203.84, 44.82, 79.10, 682.44, 16.94, 1532.511},
{-7.48, 507.58, -12.08, 21.84, 233.70, 39.50, 75.22, 703.56, 15.26, 1577.084},
{-7.09, 511.59, -14.09, 21.85, 238.69, 35.44, 73.78, 721.19, 13.69, 1595.045},
{-7.01, 516.39, -15.34, 17.00, 256.24, 33.41, 73.42, 979.87, 15.58, 1869.544},
{-5.80, 517.03, -16.39, 16.56, 261.24, 30.73, 63.74, 1046.49, 14.94, 1928.539},
{-4.30, 516.74, -17.23, 16.44, 265.19, 28.82, 60.42, 1092.35, 14.13, 1972.563},
{-2.55, 552.39, -17.88, 18.04, 267.79, 27.16, 57.65, 1126.06, 12.75, 2041.413},
{-0.55, 563.87, -18.34, 19.80, 269.92, 25.77, 55.55, 1152.18, 11.29, 2079.482},
{1.67, 567.57, -18.62, 20.37, 318.45, 23.36, 53.90, 1173.82, 9.77, 2150.284},
{4.08, 592.06, -18.72, 21.02, 326.58, 22.57, 52.43, 1154.87, 8.22, 2163.104},
{6.69, 596.17, -18.65, 21.72, 332.71, 21.85, 51.09, 1166.73, 6.65, 2184.948},
{9.47, 579.12, -18.42, 22.47, 337.54, 21.19, 49.85, 1180.05, 5.29, 2186.550},
{12.42, 577.16, -18.08, 23.24, 341.50, 20.11, 48.69, 1094.39, 3.92, 2103.342}
};

} //end 

