import java.io.*;

public class savedata implements histdata, sresdata, sresreg {

static DataOutputStream datas;

public static void main(String[] args) throws IOException {

datas = new DataOutputStream(new FileOutputStream(new File("data.dat")));

//historical global data
savearray(histdata.fosemit);
savearray(histdata.lucemit);
savearray(histdata.ch4emit);
savearray(histdata.soxemit);
savearray(histdata.coemit);

savearray(histdata.co2conc);
savearray(histdata.ch4conc);
savearray(histdata.n2oconc);
savearray(histdata.tropo3du);

savearray(histdata.hfcconc);
savearray(histdata.cfcconc);

savearray(histdata.solrf);
savearray(histdata.volcano);

savearray(histdata.measuretemp);
savearray(histdata.proxytemp);

//historical regional data
savearray(histdata.regfosemit); 
savearray(histdata.pop);
savearrayt(histdata.gdppc); 
savearrayt(histdata.enpc);

//sres global data
savearrayt(sresdata.fosemit);
savearrayt(sresdata.lucemit);
savearrayt(sresdata.soxemit);
savearrayt(sresdata.ch4emit);
savearrayt(sresdata.n2oemit);
savearrayt(sresdata.noxemit);
savearrayt(sresdata.coemit);
savearrayt(sresdata.vocemit);
savearraysett(sresdata.hfcemit); 

//sres regional data
savearrayreg(sresdata.regfosemit);
savearrayreg(sresdata.pop);
savearrayreg(sresdata.gdppc);
savearrayreg(sresdata.enpc);

//sres calculated data for superimpose circles
savearrayt(sresdata.bernmid);

savearrayt(sresdata.co2bernrf);
savearrayt(sresdata.co2isamrf);
savearrayt(sresdata.ch4rf);
savearrayt(sresdata.n2orf);
savearrayt(sresdata.tropo3rf);
savearrayt(sresdata.hfcrf);
savearray(sresdata.cfcrf); //!
savearrayt(sresdata.sulfrf);
savearrayt(sresdata.bcocrf);
savearrayt(sresdata.totrf);

savearrayt(sresdata.tempchange);

savearrayt(sresdata.sealevelavg);
savearrayt(sresdata.sealevelmin);
savearrayt(sresdata.sealevelmax);
savearrayt(sresdata.thermalexp);
savearrayt(sresdata.glaciers);
savearrayt(sresdata.greenland);
savearrayt(sresdata.antarctica);

//added for brazilian proposal exercise
savearray(histresp.ch4emit);
savearray(histresp.n2oemit);
savearrayt(histresp.regluc);

savearrayset(sresreg.fosco2);
savearrayset(sresreg.lucco2);
savearrayset(sresreg.ch4);
savearrayset(sresreg.n2o);
savearrayset(sresreg.pop);
savearrayset(sresreg.gnp);


datas.close();
} //end main


//###################################
//methods for saving arrays

//simple vector
static void savearray(double[] od) { 
wlen(od.length); save(od); 
}

//2D array
static void savearray(double[][] od) { 
wlen(od.length); wlen(od[0].length); 
for (int i=0; i<od.length; i++) save(od[i]);
}

//2D transposed
static void savearrayt(double[][] od)  { 
wlen(od[0].length); wlen(od.length); 
double[] od2=new double[od.length];
for (int i=0; i<od[0].length; i++) { for (int j=0; j<od.length;j++) od2[j]=od[j][i]; save(od2); }
}

//3D: regular
static void savearrayset(double[][][] od) {
wlen (od.length); wlen(od[0].length); wlen(od[0][0].length);
for (int i=0; i<od.length;i++) for (int j=0; j<od[0].length; j++) save (od[i][j]);
} 

//3D: set of 2D transposed, not all same dimensions
static void savearraysett(double[][][] od) {
wlen(od.length);
for (int i=0;i<od.length;i++) savearrayt(od[i]);
}

//3D: int[][][], converts {sc, yr, reg} to {reg, sc, yr}
static void savearrayreg(int[][][] od) {
wlen(od[0][0].length); wlen(od.length); wlen(od[0].length); 
double[] od2=new double[od[0].length];
for (int i=0;i<od[0][0].length;i++) for (int j=0;j<od.length;j++) { for (int k=0;k<od[0].length;k++) od2[k]=od[j][k][i]; save(od2);}
}

//write an array length
static void wlen(int l) {try {datas.writeShort(l);} catch (IOException e) {System.out.println(e);}}

//general method to save an 1D array one byte per number:
static void save(double[] od) {
float min=Float.MAX_VALUE, max=Float.MIN_VALUE; 
for (int i=0;i<od.length;i++) {float val=(float)od[i]; if (val<min) min=val; if (val>max) max=val;}
float rf=255f/(max-min);

try {
datas.writeFloat(min); datas.writeFloat(max); 
for (int i=0;i<od.length;i++) datas.writeByte((int)(0.5f+rf*(od[i]-min)));
} catch (IOException e) {System.out.println(e);}

} //end save


//###################################
}//end savedata
