package jcm.gui;
import jcm.pan.*;
import jcm.*;

import java.awt.*;

public class control extends popob {
	
	graph graph; 
	
	int[] polydata; 
	Polygon poly; 
	
	public String type, shape; int pc; 
	boolean moved=false, xeffect, yeffect, madepoly=false; 
	
	//type = x,y,xy: scales with axes, xa, ya: arbitrary scale (fraction of visible axis)
	//pc = start posn as % of axis for unused direction,
	//dp is decimal places to display
	//c terms are on the real scale of the graph, whereas x,y are in pixels
	
	int xmin, xmax, ymin, ymax, oldx=0, oldy=0, newx, newy, oldex=0, oldey=0; 
	
	public int cx, cxmin, cxmax; 
	public double cy, cymin, cymax; 
	
	//****************************************
	//CONSTRUCTORS
	
	public control(param p, graph g, String t, String s, Color c, int pc ,int dp)  {	this( p, g, t, s, c, pc, dp, "basic"); }
	
	public control(param p, graph g, String t, String s, Color c, int pc, int dp, String l) {
		type=t; shape=s; color=c; level=l; 
		graph=g; owner=g; holder=g; 
		name=p.name+"control"; labelkey=p.name;
		param=p; param.setholder(this);  helpiob=param; 
		if (type=="xy" || type=="xy2") {	param.dp=pc; param.pair.dp=dp; xeffect=true; yeffect=true; } 	else {	param.dp=dp; this.pc=pc; }
		if (type=="y" || type=="ya") yeffect=true; 
		if (type=="x" || type=="xa")  xeffect=true; 
		register(); 
	}
	
	//********************************
	//LOOP functions
	
	public void setinteractions() {	super.setinteractions(); setaffectedby(graph.bufi); setaffectedby(graph); } //because need to redraw on top of plot
	
	
	//********************************
	// SETUP
	
	//called after plot dimensions changed -see popob setup
	public void setup() {
		
		xo=0; yo=16; //popup offset
		if (type=="x" || type=="xy" || type=="xy2" ) cx= (int)param.getval(); 
		if (type=="xa") cx=(int)(graph.xscale.min.val+(((param.getval()-param.min)/(param.max-param.min))*(graph.xscale.max.val-graph.xscale.min.val))); 
		if (!xeffect) cx=(int)(graph.xscale.min.val+(graph.xscale.max.val-graph.xscale.min.val)*pc/100); 
		
		if (type=="y") cy= param.getval(); 
		if (type=="xy" || type=="xy2" ) cy= param.pair.getval(); 
		if (type=="ya") cy=(graph.yscale.min.val+(((param.getval()-param.min)/(param.max-param.min))*(graph.yscale.max.val-graph.yscale.min.val))); 
		if (!yeffect) cy=(graph.yscale.min.val+(graph.yscale.max.val-graph.yscale.min.val)*pc/100); 
		
		cxmin= (int) (type=="x" || type=="xy" || type=="xy2" ? param.min : graph.xscale.min.val); 
		cxmax= (int) (type=="x" || type=="xy" || type=="xy2" ? param.max : graph.xscale.max.val); 
		cymin= (type=="y") ? param.min : (type=="xy" || type=="xy2") ? param.pair.min :  graph.yscale.min.val; 
		cymax= (type=="y") ? param.max : (type=="xy" || type=="xy2") ? param.pair.max :   graph.yscale.max.val; 
		
		xmin=graph.px(cxmin)-1; 
		xmax=graph.px(cxmax)+1; 
		ymin=(int)(type=="xy2" ? graph.py2(cymin) : graph.py(cymin))+1; 
		ymax=(int)(type=="xy2" ? graph.py2(cymax) : graph.py(cymax))-1; 
		
		madepoly=false; 
	} //end setup
	
	//**********************************
	//MOVE DRAW ETC.
	
	//sets x, y according to real cx, cy
	void pixelfromreal(int cx, double cy) {	x=graph.px(cx); y=(int)(type=="xy2" ? graph.py2(cy) : graph.py(cy)); }
	
	void draw(Graphics g){
		if (!madepoly)  {	pixelfromreal(cx,cy); makenewpoly(); }
		g.clipRect((graph.yscale.output ? graph.yscale.w : 0), graph.tmh, graph.plotw, graph.ploth); 
		g.setColor(selected ? color.darker() : color); g.fillPolygon(poly); 
		g.setColor(selected ? black : grey); g.drawPolygon(poly); 
	}
	
	void move() {
		moved=true; 
		Rectangle bb=poly.getBoundingBox(); 
		if (x<xmin) x=xmin; if (x>xmax) x=xmax; if (y>ymin) y=ymin; if (y<ymax) y=ymax; 
		
		if (xeffect) cx=graph.realx(x); 
		if (yeffect) cy=(type=="xy2" ? graph.realy2(y) : graph.realy(y)); 
		
		madepoly=false; 
		graph.setclip(bb.x, bb.y, bb.width, bb.height); 
		graph.bufi.draw(); 
		graph.noclip(); 
		g=graph.getGraphics(); 
		draw(g); 
		g.dispose(); 
		
	} //end move
	
	//relative to mouse clicks
	void reposition(int ex, int ey) {	jumpto(oldx+ex-oldex, oldy+ey-oldey); }
	
	void jumpto(int x, int y) {	this.x=x; this.y=y; move(); }
	
	//***********************************
	//RESPOND TO EVENTS OR INSTRUCTIONS
	
	public boolean inside(int x, int y) {	return (selected ) ? true : (poly!=null) ? poly.inside(x,y) : false; }
	
	void press(int ex, int ey) {
		if (selected ) {	if (popup) removepopup(); selected=false; if (graph.insiderel(ex,ey)) reposition(ex,ey); else draw(); }
		else {	selected=true; moved=false; draw(); }
		graph.changed=true; 
		super.press(ex,ey); 
	}
	
	void release(int ex, int ey) {	if (moved) {
			selected=false; popup=false; 
			if (graph.insiderel(ex,ey)) {	reposition(ex,ey); effect(); inside=true; enter(ex,ey); } else draw(); 
		}}
	
	//void leave() {	if (!selected) super.leave(); }
	
	void drag(int ex, int ey) {	if (selected) {
			if (popup) removepopup(); 
			reposition(ex,ey); 
			if (!loop.inmainloop && !graph.painting) effect(); 
		}}
	
	
	public void effect() {
		if (type=="x") param.setval(cx); 
		if (type=="y") param.setval(cy); 
		if (type=="xy" || type=="xy2" ) {	param.setval(cx); param.pair.setval(cy); }
		if (type=="xa") param.setval(param.min+(param.max-param.min)*(cx-cxmin)/(cxmax-cxmin)); 
		if (type=="ya") param.setval(param.min+(param.max-param.min)*(cy-cymin)/(cymax-cymin)); 
		message=getinfo(); 
		if (param!=null) param.respond(false); 
		loop.go(); 
		jcm.tls.recorder.record(this, ""+(xeffect ? "#x "+xval() : "") + (yeffect ? "#y "+yval() : "") + "#m"); 
	}
	
	
	//**********************************
	// LABELS
	
	public String getinfo() {
		//need special keys now!!!
		String sa=jcm.tls.labinf.getlabel(labelkey); 
		
		if (type=="xy" || type=="xy2") return sa +" "+jcm.tls.labinf.getlabel(param.name2)+" "+xval() +us(param) +jcm.tls.labinf.getlabel(param.pair.name2) +" " +yval() + us(param.pair); 
		if (type=="y" || type=="ya") return sa +" " +yval() + us(param); 
		else return sa+" " + xval() +us(param); 
	}
	
	public String us (param p) {	return " "+(p.units!="" ? jcm.tls.labinf.getshort(p.units) : ""); }
	
	
	String yval() {
		if (type=="xy" || type=="xy2" ) return jcm.tls.txt.dp(param.pair.getval()  / (type=="xy2" ? graph.y2scale.scaleu : graph.yscale.scaleu), param.pair.dp); 
		else return jcm.tls.txt.dp(param.getval()  / ( (type=="y") ? graph.yscale.scaleu : 1.0), param.dp); 
	}
	String xval() {	return  jcm.tls.txt.dp(param.getval(), param.dp); }
	
	
	//**********************************
	// POLYGONS
	
	void makenewpoly() {
		poly=new Polygon(); 
		polydata=getpolydata(shape); 
		for (int i=0; i<polydata.length; i+=2){
			poly.addPoint(x+(int)(graph.shrinkfactor*(double)polydata[i]),y+(int)(graph.shrinkfactor*(double)polydata[i+1])); 
		}
		madepoly=true; 
	}//end makenewpoly
	
	//***************************
	static int[]
		square={	0,0,20,0,20,20,0,20}
	,uptriangle={	0,0,15,30,-15,30,0,0}
	,downtriangle={	0,0,15,-30,-15,-30,0,0}
	,lefttriangle={	0,0,30,15,30,-15,0,0}
	,righttriangle={	0,0,-30,15,-30,-15,0,0}
	,leftarrow={	0,0,20,20,20,10,40,10,40,-10,20,-10,20,-20,0,0}
	,rightarrow={	0,0,-20,20,-20,10,-40,10,-40,-10,-20,-10,-20,-20,0,0}
	,uparrow={	0,0,20,20,10,20,10,40,-10,40,-10,20,-20,20,0,0}
	,downarrow={	0,0,20,-20,10,-20,10,-40,-10,-40,-10,-20,-20,-20,0,0}
	,nsew={	-5,5,-5,20,-10,20,0,30,10,20,5,20,5,5,20,5,20,10,30,0,20,-10,20,-5,5,-5,5,-20,10,-20,0,-30,-10,-20,-5,-20,-5,-5,-20,-5,-20,-10,-30,0,-20,10,-20,5,-5,5}
	,ns={	-5,20,-10,20,0,30,10,20,5,20,5,-20,10,-20,0,-30,-10,-20,-5,-20,-5,20}
	,ew={	20,5,20,10,30,0,20,-10,20,-5,-20,-5,-20,-10,-30,0,-20,10,-20,5,20,5}
	; 
	
	int[] getpolydata(String shape) {
		if (shape=="square") return square; 
		if (shape=="uptriangle") return uptriangle; 
		if (shape=="downtriangle") return downtriangle; 
		if (shape=="lefttriangle") return lefttriangle; 
		if (shape=="righttriangle") return righttriangle; 
		if (shape=="leftarrow") return leftarrow; 
		if (shape=="rightarrow") return rightarrow; 
		if (shape=="downarrow") return downarrow; 
		if (shape=="nsew") return nsew; 
		if (shape=="ns") return ns; 
		if (shape=="ew") return ew; 
		else return square; 
	}
	//***************************
	
} //end control
	
