package jcm.gui;
import jcm.*;
import jcm.tls.*;
import java.awt.*;

// a general line graph class

public abstract class graph extends jcmpanel {
	
	public param stacked=new param("stack", false); 
	
	//other public flags
	public boolean reversed=false; 
	public boolean doubleline=true;

	//size variables
	public int plotw, ploth, messagew=0; 
	public int  xsh=20, ysw=25, y2sw=25, legw=42; //size of scales and legend
	
	//for curves
	public float[][] yd; public int[] xd; 
	public String[] curvename, curvelevel; 
	public Color[] curvecolor; 
	public double[] scalefac;
	public boolean[] curveoutput, curveisy2; 
	
	public int nsegs, ncurves, startseg, calcstartseg, endseg, dy; 
	
	//working
	Polygon poly=new Polygon(), poly2=new Polygon(); 
	int i, inty, ns,nc, nvc, xs,xp,yp; 
	double[] ystack; 
	int[] x, y; 
	
	//scales legend etc
	public scale
		xscale=new scale(scale.X, this,"yr", time.gsy, time.gey, 50, 1.0),
		yscale=new scale(scale.Y, this),
		y2scale; 
	public legend legend=new legend(this); 
	
	//****************************************************
	//INITSETUP
	
	public void initsetup() {	super.initsetup(); makecurves(); makecurvearrays(); } //note must register self before make curvelabels to get curevoutput interactions right
	
	abstract public void makecurves(); 
	
	public void makecurves(int[]xdata, float[][]ydata, String[] name, Color[] color) {	makecurves( xdata, ydata, name, color, null, null); }
	public void makecurves(int[]xdata, float[][]ydata, String[] name, Color[] color, String[] level) {	makecurves( xdata, ydata, name, color, level, null); }
	public void makecurves(int[]xdata, float[][]ydata, String[] name, Color[] color, String[] level, boolean[] isy2) {
		xd=xdata; yd=ydata; curvecolor=color; curvename=name; curvelevel=level; curveisy2=isy2; 
	}
	
	public void makecurvearrays() {
		ncurves=yd.length; nsegs=xd.length; 
		x=new int[nsegs+1]; y=new int[nsegs+1]; ystack=new double[nsegs+1]; 
		if (curvelevel==null || curvelevel.length!=ncurves) {	curvelevel=new String[ncurves]; for (int i=0; i<ncurves; i++) curvelevel[i]="basic"; }
		if (curveisy2==null || curveisy2.length!=ncurves) {	curveisy2=new boolean[ncurves]; for (int i=0; i<ncurves; i++)  curveisy2[i]=false; }
		if (scalefac==null || scalefac.length!=ncurves) { scalefac=new double[ncurves];  for (int i=0; i<ncurves; i++) scalefac[i]=1.0; }
		curveoutput=new boolean[ncurves]; for (int i=0; i<ncurves; i++) curveoutput[i]=true; 
		legend.newcurves(); 
	}
	
	public void setinteractions() {
		super.setinteractions(); 
		for (nc=0; nc<ncurves; nc+=1) 	curveoutput[nc] =output && complexity.checklevel(curvelevel[nc]); 
		pansetup.affectedby(stacked); 
		pansetup.setaffectedby(scale.showscales); 
		bufi.setaffectedby(datapoints.showdata); 
		bufi.setaffectedby(stacked); 
	}
	
	public 	void autofindinteractions(float[][] curve)	 {
		for (int m=0; m<nmods; m++) {
			try {
				java.lang.reflect.Field[] f=mod[m].getClass().getFields(); 
				searchfield: for (int i=0; i<f.length; i++) if (f[i].get(mod[m])!=null) {
					if (f[i].get(mod[m])==curve) {	bufi.setaffectedby(mod[m]); break searchfield; }
					if (curve !=null) 	for (int c=0; c<curve.length; c++)  if (f[i].get(mod[m])==curve[c]) {	bufi.setaffectedby(mod[m]); break searchfield; }
				}
			} catch (IllegalAccessException e) {	System.out.println(e); }; 
		}
	}
	
	//******************************
	//DOC
	public String docinfo(String what) {
		if (what.equals("curves")) return "`curves "+doccurve();
		if (what.equals("scales")) return docscale();
		if (what.equals("controls"))  return doccontrol();
		return super.docinfo(what); 
	}
		
	public String curveinfo(int n) {
		if (curveoutput[n]) return "<li>"+hexcolor(curvecolor[n])+labinf.getshort(curvename[n])+(labinf.getlabel(curvename[n]) !=labinf.getshort(curvename[n]) ? " "+labinf.getlabel(curvename[n]) : "")+"</font>  "+curvename[n]+" "; 
		else return ""; 
	}
	
	public String doccurve() {	
	StringBuffer info=new StringBuffer(" "); 
	for (int n=0; n<ncurves; n++) {	info.append(curveinfo(stacked.flag && !reversed ? ncurves-n-1 : n )); } 
	return info.toString(); 
	}
	
	public String docscale() { 
		String info="`scales "; 
		try{
		info+=xscale.getinfo()+"<br>"+yscale.getinfo()+((y2scale!=null) ? "<br>"+y2scale.getinfo() : ""); 
		info+="<br> (scales) " ;
		return info; 
		} catch (Exception e) {return (info+" "+e); }
	}
	
	public String doccontrol() {
		StringBuffer info=new StringBuffer("`controls :  <form>"); 
		int n=0; for (int i=0; i<myiobs.size(); i++) {
			if (myiob(i) instanceof control) {
				control c=(control)myiob(i); if (c.output) {
					n++; 
					info.append(hexcolor(c.color)+c.param.docinfo(this)+"<br></font>");
				}}}
		info.append("<br>  (controls) "); 
		return (n>0) ? info.append("</form>").toString() : ""; 
	}

	//*******************************************
	//SIZING
	
	
	public void setup() {
		legend.resize(panw-legw, tmh, legw, panh-tmh); 
		plotw=panw-(legend.output ? legw : 0); ploth=panh-tmh; 
		if (xscale.output) {
			plotw -= ysw+(y2scale!=null ? y2sw : 0); ploth -= xsh; 
			xscale.resize(ysw, panh-xsh, plotw, xsh); 
			yscale.resize(0, tmh, ysw, ploth); 
			if (y2scale!=null) y2scale.resize(ysw+plotw, tmh, y2sw, ploth); 
		}
		else {
			//note scale size matter for calculations, even if they are not visible
			xscale.resize(0, panh, plotw, 0); 
			yscale.resize(0, tmh, 0, ploth); 
			if (y2scale!=null) y2scale.resize(plotw, tmh, 0, ploth); 
		}
		super.setup(); 
	}
	
	
	//*******************************************
	//LOOP METHODS
	
	public void mainplot(){
		painting=true; 
		super.postcalc(); 
		if (output && bufim.makebuf.istrue()) {	//because viewdata can make this needed without being visible
			if (!bufi.changed) bufi.draw(); //don't do twice
			if (bufi.x>yscale.w) clearRect(yscale.w, tmh, bufi.x-yscale.w, ploth); 
			if ((bufi.x+bufi.w)<(yscale.w+plotw)) clearRect(bufi.x+bufi.w, tmh, (yscale.w+plotw)-(bufi.x+bufi.w), ploth); 
			if (hadmouse) writeinfo(getGraphics()); 
		}
		painting=false; 
	} //end update
	
	
	protected void finalize() throws Throwable {	x=null; y=null; poly=null; poly2=null; super.finalize(); }
	
	
	//****************************************************
	//conversion shortcuts
	
	double py(double y, int nc) {	return (curveisy2[nc] ? py2(y*scalefac[nc]) : py(y*scalefac[nc])); }
	double py(double y) {	return yscale.pixel(y); }
	double py2(double y) {	return y2scale.pixel(y); }
	double realy(int py) {	return yscale.real(py); }
	double realy2(int py) {	return y2scale.real(py); }
	int px(int x) {	return (int)(xscale.pixel(x)); }
	int realx(int px) {	return (int)(xscale.real(px)); }
	int xmin() {	return (int)xscale.min.val; }
	int xmax() {	return (int)xscale.max.val; }
	double ymin() {	return yscale.min.val; }
	double ymax() {	return yscale.max.val; }
	
	//*******************************************
	//INFO
	
	public void writeinfo(Graphics g) {
		g.setFont(normalfont); g.setColor(red); 
		g.drawString(popob.message,(yscale.output ? yscale.w : 0) +8, tmh+40); 
		messagew=g.getFontMetrics(normalfont).stringWidth(popob.message); 
	}
	
	public void clearoldinfo(Graphics g) {	g.setColor(getBackground()); g.fillRect((yscale.output ? yscale.w : 0)+8, tmh+28, messagew, 16); }
	
	public boolean handleEvent(Event e) {
		if (e.id==e.MOUSE_MOVE) {
			popob.message=/*"x="+*/String.valueOf(realx(e.x))+" , "/*y="*/+String.valueOf(((int)(realy(e.y)*1000/yscale.scaleu))/1000f); 
			Graphics g=getGraphics(); clearoldinfo(g); writeinfo(g); g.dispose(); 
		}
		return super.handleEvent(e); 
	}
	
	
	
	//***********************************
	
	//gettable: currently used by viewdata & captab
	public String gettable(String sep) {
		StringBuffer info=new StringBuffer(); 
		info.append(jcm.tls.labinf.getlabel(name + name2 + name3)); 
		
		info.append(jcm.tls.labinf.getlabel(xscale.units)+sep); 
		for (int nc=0; nc<ncurves; nc++) {	info.append(jcm.tls.labinf.getlabel(curvename[nc])+sep); }
		info.append("\n"); 
		
		for (int ns=0; ns<xd.length; ns++) {
			info.append(String.valueOf(xd[ns])+sep); 
			
			String yval; 
			for (int nc=0; nc<ncurves; nc++) {
				if (ns<yd[nc].length) {
					if (name=="carbonplot" && nc>=5) yval=Float.toString(yd[nc][ns]/(float)y2scale.scaleu); 
					else yval=Float.toString(yd[nc][ns]/(float)yscale.scaleu); 
					info.append(yval+sep); 
					//yval.substring(0,yval.length() > 5 ? 6: yval.length())+sep);
				} else info.append(sep); 
			}
			info.append("\n"); 
		}
		
		return info.toString(); 
	} //end gettable
	
	//***********************************
	//MAIN PLOTTING ROUTINE
	public void makebuffer() {
		
		startseg=0; calcstartseg=0; 
		if (loop.calcfutureonly) for (i=0; i<nsegs; i++) if (xd[i]<=2000) calcstartseg=i; 
		
		// xvalues and range
		// note maybe don't need to keep repeating px(xd[]) if only y changing?
		//below avoids making buffer beyond visible x-limits
		for (ns=startseg; ns<nsegs; ns+=1) {
			x[ns]=px(xd[ns]); 
			if (xd[ns]<xmin()) startseg=ns+2; 
			if (xd[ns]>xmax()) break; 
		}
		endseg=ns-1; 
		
		bufi.newimage(x[startseg], tmh, x[endseg]-x[startseg], ploth  ); 
		bufi.g.fillRect(x[calcstartseg]-bufi.x,0,plotw*2,ploth); 
		bufi.g.translate(-bufi.x,0); 
		
		//stacked
		if (stacked.istrue()) {
			for (ns=calcstartseg; ns<=endseg; ns++) ystack[ns]=ploth; 
			poly=new Polygon(); poly.addPoint(x[endseg],ploth); poly.addPoint(x[calcstartseg],ploth); 
			
			nvc=0; //num visible curve
			for (nc=(reversed ? ncurves-1 : 0); (reversed ? nc>-1 : nc<ncurves ) ; nc=(reversed ? nc-1 : nc+1) ) {
				bufi.g.setColor(curvecolor[nc]); 
				if (curveoutput[nc]) {
					if ((nvc % 2)==1) {	//odd
						poly=new Polygon(); 
						for (ns=endseg; ns>=calcstartseg; ns-=1) {	if (yd[nc][ns]!=-999) {
								ystack[ns]+=(py(yd[nc][ns])-(ploth+tmh)); 
								y[ns]=(int)ystack[ns]; 
								poly.addPoint(x[ns],(int)y[ns]); 
								poly2.addPoint(x[ns],y[ns]); 
							}}
						bufi.g.fillPolygon(poly2); 
					}
					else {	//even
						poly2=new Polygon(); 
						for (ns=calcstartseg; ns<=endseg; ns+=1) {	if (yd[nc][ns]!=-999) {
								ystack[ns]+=(py(yd[nc][ns])-(ploth+tmh)); 
								y[ns]=(int)ystack[ns]; 
								poly.addPoint(x[ns],(int)y[ns]); 
								poly2.addPoint(x[ns],y[ns]); 
							}}
						bufi.g.fillPolygon(poly); 
					}
					nvc++; 
				}
			}
			bufi.g.setColor(getBackground()); 
			if ((nvc % 2)==1) {
				poly2.addPoint(x[endseg],0); 
				poly2.addPoint(x[calcstartseg],0); 
				bufi.g.fillPolygon(poly2); 
			}
			else {
				poly.addPoint(x[startseg],0); 
				poly.addPoint(x[endseg],0); 
				bufi.g.fillPolygon(poly); 
			}
		} //end stacked
		
		//just lines
		else {
			for (nc=0; nc<ncurves; nc+=1) {
				if (curveoutput[nc]) {
					
					poly=new Polygon(); 
					
					//note don't have this check in stacked!
					int curveendseg=(endseg>(yd[nc].length-1)) ? yd[nc].length-1 : endseg; 
					
					for (ns=calcstartseg; ns<=curveendseg; ns++) {
						if (yd[nc][ns]!=-999 && yd[nc][ns]!=0) {	y[ns]=(int)(py(yd[nc][ns], nc)-tmh); poly.addPoint(x[ns],y[ns]); } else y[ns]=-999; }
					for (ns=curveendseg; ns>=calcstartseg; ns-=1) {	if (y[ns]!=-999) {	poly.addPoint(x[ns],y[ns]+(doubleline ? 1 : 0)); }}
					bufi.g.setColor(curvecolor[nc]); bufi.g.drawPolygon(poly); 
				}
			}
		} //end lines
		
		bufi.g.dispose(); 
		
	} //end makebuffer
	
} //end graph
	
	
	
	
