package jcm.gui;

import jcm.*;
import jcm.mod.*;
import java.awt.*;
import java.util.*;

public class mapplot extends jcmpanel {
	
	public static String[] projections={	"grid",	"coslat",  "polar"}; 
	
	public param startlon=new param("mapstartlongitude", "degrees", 349, 0, 360); 
	public param projection=new param("projection", projections, "coslat"); 
	public param regions=new param("regions", regionset.list, regionset.jcmreg); 
	public menu projmenu=new menu(projection, this); 
	public menu regmenu=new menu(regions, this); 
	
	public double mx, oldmx, my; 
	public int top, left, plotw, ploth, sl; 
	
	public region regset; 
	public region insidereg; 
	
	public void precalc(iob i) {	super.precalc(i); if (i==regions) regset= (region) regions.choseniob; }
	
	public boolean 	needtoclear=true, addedyet=false, leftmap=false, gotevent=false,  inside=false, newpolys=true; 
	
	public void setinteractions() {
		super.setinteractions(); 
		bufi.setaffectedby(startlon); 
		bufi.setaffectedby(projection); 
		bufi.setaffectedby(regions); 
	}
	
	public String docinfo(String what) {
		if (what.equals("mapstartlongitude")) return startlon.docinfo(); 
		return super.docinfo(what); 
	}
	
	public void mainplot() {	if (!bufi.changed) 	bufi.draw(); }
	
	public void makebuffer() {
		setsize(0, 0, panw, panh-tmh, (int)startlon.val); 
		bufi.newimage(0, tmh, panw, panh-tmh); 
		paintreg(bufi.g); 
		paintline(bufi.g); 
		bufi.g.dispose(); 
	}
	
	public void setsize(int l, int t, int w, int h, int s) {	left=l; top=t; plotw=w; ploth=h; sl=s; }
	//note: coordinates start at zero for top, left of map (must translate mouse events)
	
	//***********************************
	//Event handling
	//note bufim's graphics context top is 0, so events need to subtract tmh
	public boolean handleEvent(Event e) {
		gotevent=true; 
		if (e.id==Event.MOUSE_MOVE || e.id==Event.MOUSE_DOWN || e.id==Event.MOUSE_DRAG) findpos(e.x, e.y-tmh); 
		if (e.id==Event.MOUSE_DOWN && inside) oldmx=mx; 
		if (e.id==Event.MOUSE_DRAG && inside)  dragplot(); 
		if (e.id==Event.MOUSE_MOVE) mousemove(); 
		super.handleEvent(e); 
		gotevent=false; 
		return false; 
	}  //end handlevent
	
	public region findreg(int x, int y) {
		for( regset.start(); regset.more(); ) 	if (regset.c.contains(translateback(x,y))) return regset.c; 
		return null; 
	}
	
	public void paintline(Graphics g) {
		g.setColor(Color.black); 
		for( regset.start(); regset.more(); ) 	{
			regset.c.makepolys(); 
			for (int j=0; j<regset.c.polyset.size(); j++) g.drawPolygon(translate(regset.c.poly(j))); 
		}
	}
	
	public Color regcol(region r) {	return r.getcolor(); } //changed in regclimap
	
	public void paintreg(Graphics g) {
		for( regset.start(); regset.more(); ) 	{
			g.setColor(regcol(regset.c)); 
			regset.c.makepolys(); 
			for (int j=0; j<regset.c.polyset.size(); j++) g.fillPolygon(translate(regset.c.poly(j))); 
		}
	}
	
	
	void dragplot() {	//dragging the plot to rotate it
		startlon.val=(int)(((int)startlon.val+(mx-oldmx)+360)%360); 
		newpolys=true; 
		startlon.respond(true); 
	}
	
	public void mousemove() {	//move mouse over plot
		if (inside) {	writepos(); leftmap=false; }
		else  {	if (!leftmap) cleartext(); leftmap=true; }
	}
	
	
	void cleartext() {
		Graphics g=getGraphics(); 
		g.clearRect(4,panh-48,35,16); 
		g.clearRect(4,panh-32,50,16); 
		g.clearRect(panw-85,panh-32,60,16); 
		g.dispose(); 
	}
	
	
	public boolean notwrap(Point a, Point b) {	return notwrap(a.x, a.y, b.x, b.y); }
	public boolean notwrap(int x1, int y1, int x2, int y2) {
		return
			(projection.chosen.equals("polar")) ? y1 * y2 >0
			: Math.abs(wrap(x1+sl)-wrap(x2+sl))<180
			; 
	}
	
	int wrap(int x) {	return (x+540)%360-180; }
	
	public Point translate(int x, int y) {	return translate((double)x, (double)y); }
	public Point translate(double x, double y) {
		int yy=
			(projection.chosen.equals("coslat") || projection.chosen.equals("grid")) ? top +(int)(ploth*(90-y)/180)
			: (projection.chosen.equals("polar")) ? top+(int)(ploth*(0.5+0.5*Math.sin(Math.PI*(x+sl)/180)*(90-Math.abs(y))/90))
			: (int) y
			; 
		int xx=
			(projection.chosen.equals("coslat")) ? left+(int)(plotw*(0.5+(wrap((int) (x+sl))/360.0)*Math.cos(Math.PI*y/180.0)))
			: (projection.chosen.equals("grid")) ?  left +plotw*(wrap((int) (x+sl))+180)/360
			: (projection.chosen.equals("polar")) ? left+(int)(plotw*(  (y>0 ? 0.25 : 0.75) - Math.cos(Math.PI*(x+sl)/180)* (Math.abs(y)/y)*0.25* (90-Math.abs(y))/90 ))
			: (int) x
			; 
		return new Point(xx, yy); 
	}
	
	public Point translateback(int xx, int yy) {
		int x,y; 
		double xf=(xx -left)/(double)plotw, yf=(yy-top)/(double)ploth; 
		
		if (projection.chosen.equals("polar")) {
			int ns=(xf>0.5 ? -1 : 1 ) ; 
			xf= 4.0*(xf>0.5 ? xf - 0.75 : xf - 0.25 ); 
			yf= 2.0*(yf-0.5)  ; 
			y= (int)(90.0* ns*(1.0-Math.pow(yf*yf + xf*xf, 0.5))); 
			x= wrap(- sl + (int)( (xf*ns<0 ? 360 : 180) -ns*Math.atan( yf / xf ) *180.0 / Math.PI) ); 
		}
		else {
			y=
				(projection.chosen.equals("coslat") || projection.chosen.equals("grid")) ? 90-(int)(180*yf)
				: yy
				; 
			x=
				(projection.chosen.equals("coslat")) ? wrap((int)((xf - 0.5)*360.0/Math.cos(Math.PI*y/180.0)) +360 -sl)
				: (projection.chosen.equals("grid")) ? wrap((int)(360*xf +180 -sl))
				: xx
				; 
		}
		return new Point(x, y); 
	}
	
	public Polygon translate(Polygon a) {
		Polygon b=new Polygon(); Point p; 
		for (int i=0; i<a.npoints; i++) {
			if (i==0 || notwrap(a.xpoints[i], a.ypoints[i], a.xpoints[0], a.ypoints[0])) {
				p=translate(a.xpoints[i], a.ypoints[i]); 
				b.addPoint(p.x, p.y); 
			}
		}
		return b; 
	}
	
	void findpos(int x, int y) {	//work out lat & lon corresponding to mouse position
		Point p=translateback(x,y); 
		mx=p.x; my=p.y; 
		insidereg= findreg(x,y); 
		inside= (my<90 && my>-90 && mx<180.0 && mx>-180); 
	}
	
	public void writepos() {	writelatlon(); writereg(); }
	public void writelatlon() {
		drawString((int)Math.abs(my)+ ( my>0 ? " N" : " S")+"   " , 4, panh-32) ; 
		drawString((int)Math.abs(mx)+ ( mx>0 ? " E" : " W")+"   " ,4 ,panh-16); 
	}
	public void writereg() {
		if (insidereg!=null) drawString(insidereg.code+"   ", panw-40 ,panh-16); 
		else  drawString("        ", panw-40 ,panh-16); 
	}
	
} //end class
	
	
	
