package jcm.gui;
import jcm.pan.*;
import jcm.*;
import jcm.tls.*;


import java.awt.*;

public class menu extends popob {
	
	public int focus; 
	
	//can only have one menu visible at a time, so static
	public static menu currentlistup=null, oldlistup=null; 
	
	int lw, lh, ih=16, lx, ly; 
	
	public int sml=2; 
	
	//constructors
	public menu(param param, jcmpanel owner) {	this(param,owner,"basic"); }
	
	public menu(param param, jcmpanel owner, String level) {
		this.param=param; helpiob=param; this.level=level; 
		name=param.name+"menu"; labelkey=param.name; 
		focus=0; 
		this.owner=owner; holder=owner; 
		param.setholder(this);
		x=0; y=0; h=20; xo=0; yo=20; focus=0; 
		register(); 
	}
	
	public void setup() {	listdimensions(); }
	public void postplot() {	listdimensions(); super.postplot(); }
	
	public void listdimensions() {
		w=menw(labw(labelkey)); 
		lw=w; 
		for (int i=0; i<param.numitems; i++) {
			int iw=4+sw(jcm.tls.labinf.getlabel(param.longname(i), sml) ); 
			if (lw<iw) lw=iw; 
		}
		lh=param.numitems*ih; 
		xpos(); 
	}//end dimensions
	
	public static int menw(int lw) {	return 12+(int)(0.9*(double) lw); }
	
	//draw public, also called from player
	public void draw(Graphics g) {
		g.setColor(holder.getBackground()); 
		g.fillRect(x,y,w,h); 
		drawbutton(g); 
		if (this==currentlistup && inside) drawlist(holder.getallGraphics()); 
	}
	
	void drawbutton(Graphics g) {
		g.setColor(black); g.drawRoundRect(x+1, y, w-2, h,8,8); 
		g.setColor(dkgrey); g.drawRoundRect(x+1, y, w-3, h-1,8,8); 
		g.setColor(grey); g.drawRoundRect(x+1, y, w-4, h-2,8,8); 
		g.setColor(white); g.fillRoundRect(x+2, y+1, w-5, h-3,8,8); 
		g.setColor(black); g.setFont(smallfont); 
		g.drawString(jcm.tls.labinf.getshort(labelkey), x+6, y+15); 
	}
	
	void drawlist(Graphics g) {
		lx = (x+lw)>holder.panw ? (x + w -lw) : x ; 
		ly = y +h; 
		holder.holder.cpl.hideawt(); //get rid of heavyweight AWT components which might cover menu
		g.setColor(white); g.fillRoundRect(lx, ly, lw, lh,8,8); 
		g.setColor(black); g.drawRoundRect(lx, ly, lw, lh,8,8); 
		g.setColor(yellow); g.fillRect(lx+1, ly+1+focus*ih, lw-1, ih-2); 
		g.setColor(red); g.fillRect(lx+1, ly+1+param.getchosenindex()*ih, lw-1, ih-2); 
		g.setColor(black); g.setFont(normalfont); 
		for (int i=0; i<param.numitems; i++) g.drawString(jcm.tls.labinf.getlabel(param.longname(i), sml), lx+4, ly+14+i*ih); 
	} //end drawlist
	
	public void removelist(boolean go) {
		if (currentlistup!=null && currentlistup.holder!=null) {
			Graphics g=currentlistup.holder.getallGraphics(); 
			g.setColor(currentlistup.holder.getBackground()); 
			g.fillRect(currentlistup.lx, currentlistup.ly, currentlistup.lw+1, currentlistup.lh+1); 
			g.dispose(); 
			plotlayout cpl=currentlistup.holder.holder.cpl;
			for (int p=0; p<cpl.np; p++) if (cpl.pan[p] instanceof textpan) cpl.pan[p].show();
			if (go) {	currentlistup.changed=true; iob.setallinteractions(); oldlistup=currentlistup; currentlistup=null; loop.go(); }
			else {	oldlistup=currentlistup; currentlistup=null; }
		}
	}
	public boolean inside(int ex, int ey) {
		if (currentlistup!=null) return (ex>lx && ex<(lx+lw) && ey>y && ey<(ly+lh)); //note includes the button!
		else return (ex>x && ex<(x+w) && ey>y && ey<(y+h)); 
	}
	
	public void demopreloop() {	popupinfo(); player.waitgap(); removepopup(); currentlistup=this; inside=true; draw(); focus=param.getchosenindex(); draw(); }
	public void demopostloop() {	draw(); player.waitgap(); inside=false; leave(); }
	public void demo() {	demopreloop() ; demopreloop() ; }
	
	void press(int ex, int ey) {
		if (currentlistup!=null) {
			param.choose(focus); 
			param.respond(true); 
			draw(); 
		}
		if (currentlistup==null) {
			removepopup(); 
			currentlistup=this; 
			focus=param.getchosenindex(); 
			draw(); 
		}
		super.press(ex, ey); 
	}
	
	void key(int key) {	if (currentlistup!=null) {
			if (key==Event.DOWN && focus<(param.numitems-1)) {	focus++; param.choose(focus); param.respond(true); draw(); }
			if (key==Event.UP && focus>0) {	focus--; param.choose(focus); param.respond(true); draw(); }
		}}
	
	void enter(int ex, int ey) {	if (currentlistup==null) popupinfo(ex+xo, ey+yo); }
	
	void leave() {
		if (currentlistup!=null) removelist(true); 
		else removepopup(); 
	}  //end leave
	
	void drag(int ex, int ey) {	dragging=true; if (currentlistup!=null) move(ex, ey); }
	void release(int ex, int ey) {	if (dragging) press(ex, ey); dragging=false; }
	
	void move(int ex, int ey) {	if (currentlistup!=null) {
			int f=(ey-ly)/ih; if (f!=focus && f<param.numitems && f>=0) {	focus=f; draw(); }
		}}
	
} //end menu
