//POPOB
//output object with popup info 
//extended by adjob and label

package jcm.gui;
import jcm.*;
import jcm.tls.*;


import java.awt.*;

public class popob extends iob implements colfont {
	
	public static param showcontrols=new param("showcontrols", true); 
	static {	showcontrols.owner=new popob(); }
	
	public param param; //implemented in menu, option, control
	
	public String level="basic"; //at which complexity level is this output
	public boolean
		inside=false, // if mouse inside
		selected=false,  //if user currently adjusting this iob -used for dragging controls, even if mouse moved off it
		dragging=false; 
	
	public jcmpanel holder; //holder is where it is placed
	public iob setup=new iob("popobsetup", this); 
	public iob helpiob=this; 
	
	public String labelkey; //usually same as name
	
	//static so can only have one popup label and others can remove it
	public static boolean popup=false; 
	public static String message=""; 
	static int pux, puy, puw, puh; //defines actual popup info rectangle
	static jcmpanel popupholder; 
	
	Graphics g; 
	
	public int x, y, w, h; //defines a rectangular detection area
	int xo=0, yo=8; //offset for popup-place
	
	public Color color=Color.black; 
	
	//*****************************
	//LOOP functions
	
	public void setinteractions() {
//	if (holder != owner) debug(name+" "+holder.name+" "+owner.name);
		setaffectedby(holder.pansetup); 
		setaffectedby(holder); 
		output=holder.output && complexity.checklevel(this); 
		if (this instanceof menu || this instanceof option || this instanceof control) output &= (showcontrols.istrue() || holder.alwayscontrols() ); 
	}
	public void precalc() {	setup(); }
	public void precalc(iob iob) {	if (iob==setup) setup(); }
	public void mainplot() {	draw(); }
	public void postplot() {	draw(); }
	public void setup() {	} //respond to resizing -aim to phase this out (ambiguous)
	
	//************* DRAW ****************
	
	void resize(int x, int y, int w, int h) {	this.x=x; this.y=y; this.w=w; this.h=h; }
	
	public void draw() {	g=holder.getGraphics(); draw(g); g.dispose(); }
	void draw(Graphics g) {	}
	
	//********** ACTIONS *******************
	public void handleEvent(Event e) {		
		if (inside || selected) {
			if (e.id==Event.MOUSE_DOWN) press(e.x, e.y); 
			if (e.id==Event.MOUSE_UP) release(e.x, e.y); 
			if (e.id==Event.MOUSE_DRAG) drag(e.x, e.y); 
			if (e.id==Event.MOUSE_MOVE) move(e.x, e.y); 
		}
		
		if (e.id==e.KEY_PRESS || e.id==e.KEY_ACTION) key(e.key); 
		if (e.id==e.KEY_RELEASE || e.id==e.KEY_ACTION_RELEASE) keyup(e.key); 
		
		if (e.id==Event.MOUSE_MOVE || e.id==Event.MOUSE_DRAG) {
			if (inside(e.x, e.y) && !inside) {	inside=true; enter(e.x, e.y); }
			if (!inside(e.x, e.y) && inside) {	inside=false; leave(); }
		}
		
	} //end handleEvent
	
	//*****************************
	//defines detection area: (override this for polygons)
	public boolean inside(int ex, int ey) {	return (ex>x && ex<(x+w) && ey>y && ey<(y+h)); }
	
	//popup on enter
	void enter(int ex, int ey) {	popupinfo(ex+xo, ey+yo); }
	void leave() {	removepopup(); }
	
	//fill these in for responding to specific actions
	void drag(int ex, int ey) {	}
	void move(int ex, int ey) {	}
	void release(int ex, int ey) {	}
	void key(int key) {	}
	void keyup(int key) {	}
	
	//make a web page open with specific info for this object
	void press(int ex, int ey) {	if (inside(ex,ey) && holder.holder==iob.applet) showwebpage.showhelp(helpiob); }
	
	public static void removepopup() {
	try {
			popupholder.noclip(); 
			popupholder.clearRect(pux, puy, puw, puh); 
			popupholder.setclip(pux, puy, puw, puh); 
			popupholder.changed=true; popup=false; 
			loop.go(); 
			popupholder.noclip(); 
		} catch (Exception e) { debug (e); popup=false; }
	}
	
	public int sw(String s) { Graphics g=holder.getGraphics(); return sw(g,s); }
	public int sw(Graphics g, String s) { return g.getFontMetrics(g.getFont()).stringWidth(s); }
	public int labw(String l) {	return sw(labinf.getshort(l)); }
	
	//********** POPUP INFO ***********
	
	public String getinfo() {	return labinf.getlabel(labelkey); }
	public void demopreloop() {	pointto(x,y); popupinfoy(); player.waitgap(); removepopup(); }
	public void demopostloop() {	demopreloop(); }
	public void demo() {	demopreloop(); }
	public void pointto(int x, int y) {	/* try { debug ("m "+x+" "+y);  (new Robot()).mouseMove(holder.rootx(x), holder.rooty(y)); } catch (AWTException e) {debug("point exception: "+e);} */} //this works but only in java 1.3+
	
	
	void popupinfoy() {	popupinfo(x+xo, y+yo+h/2); }
	void popupinfo() {	popupinfo(x+xo, y+yo); }
	void popupinfo(int ex, int ey) {	popupinfo( getinfo(), ex, ey); }
	
	void popupinfo(String info, int ex, int ey) {
		if (popup) removepopup(); 
		if (!popup && !selected){
			popupholder=holder; 
			Graphics g=holder.getGraphics(); 
			popup=true; 
			
			puw=g.getFontMetrics(normalfont).stringWidth(info)+16; 
			puh=19; 
			pux=ex+4; if ((pux+puw)>=holder.getSize().width) pux=holder.getSize().width -puw; 
			puy=ey-yo; 
			if ((puy+puh) > holder.panh) puy=holder.panh-puh; 
			
			g.setColor(Color.white); g.fillRoundRect(pux, puy, puw-1, puh-1, 8, 8); 
			g.setColor(color); g.drawRoundRect(pux, puy, puw-1, puh-1, 8, 8); 
			g.setFont(normalfont); g.setColor(Color.black); g.drawString(info, pux+4, puy+15); 
			g.dispose(); 
			jcm.tls.recorder.record(this, "#u"); 
		}
	}//end popupinfo
	
	//*****************************
	//for position in queue of popobs
	
	public popob joinedto, joinedfrom; 
	
	public void xpos() {	//add to other popobs, from right
		if (name.equals("plotmenu")) x=4; 
		else {
			if (joinedto==null) {	joinedto = (holder.lastob==null) ?  this  : holder.lastob; holder.lastob=this; }
			x =  (joinedto==this ? holder.panw  : joinedto.jx() ) - (output ? w : 0); 
			y= (joinedto==this ? 0 : joinedto.y); 
			if (x<(y==0 ? holder.titlepop.x+holder.titlepop.w : 0)) {	x=holder.panw - (output ? w : 0); y=joinedto.y+22; }
			if (holder.pansetup.changed) {	holder.tmh=y+24; holder.noclip(); }
		}
	}
	
	int jx() {	return (output ? x : joinedto==this ? holder.panw  : joinedto.jx()); }
	
	
	//*****************************
	
	
	
} //end class popob

