package jcm.gui;
import jcm.*;

import java.awt.*;

public class scale extends popob {
	
	public static int X=0, Y=1, Y2=2; 
	int type=X; 
	String[] ts={	"x","y","y2"}; 
	public String units; 
	
	public static param
		linkx=new param("linkx", false),
		showscales=new param("showscales", true); 
	static {	linkx.owner=new scale(); showscales.owner=new scale(); }
	
	public param min, max; 
	
	public double scales, scaleu; 
	public double pmin, prange; 
	public boolean autoscale=false, usebigfont=false; 
	
	//for dragging scales
	public double origin, dp; int ep, op; boolean dragorigin=false; 
	
	//**************************
	
	public scale (int type, jcmpanel owner, String units, double startmin, double startmax, double scales, double scaleu) {	construct(type, owner); setup(units, startmin, startmax, scales, scaleu); }
	public scale (int type, jcmpanel owner) {	construct(type, owner); } //do rest of setup later
	public scale() {	}
	
	public void construct(int type, jcmpanel owner) {
		this.type=type; this.owner=owner; this.holder=owner; 
		min=new param(ts[type]+"min","",0, Double.MIN_VALUE, Double.MAX_VALUE); 
		max=new param(ts[type]+"max","",0, Double.MIN_VALUE, Double.MAX_VALUE); 
		min.owner=owner; max.owner=owner; // handier in scripting
		min.holder=this; max.holder=this; 
		name=ts[type]+"scale"; 
		color=black; 
		register(); min.register(); max.register(); level="verysimple"; 
	}
	
	public String docinfo() {	return getinfo()+"<br>"+ min.docinfo()+"<br>"+max.docinfo(); }
	
	
	public void setup(String units, double startmin, double startmax, double scales, double scaleu) {
		this.scales=scales; this.scaleu=scaleu; this.units=units; 
		min.units=units; max.units=units; labelkey=units; name2="&"+units;
		min.val=startmin; min.defval=startmin; max.val=startmax; max.defval=startmax; 
		if (type==X) origin=2000; else origin=0; 
		if (type==Y) owner.name3= "&ob&"+units +"&cb"; 
	}
	
	public void setinteractions() {
		super.setinteractions(); 
		setaffectedby(((jcmpanel)owner).pansetup); 
		setaffectedby(min); setaffectedby(max); 
		min.setaffectedby(linkx); max.setaffectedby(linkx); 
		min.setaffects(((graph)owner).bufi); 
		max.setaffects(((graph)owner).bufi); 
		output &= (showscales.istrue() || holder==holder.holder.cpl.central || holder.holder!=iob.applet) ; 
	}
	
	public void resize(int x, int y, int w, int h) {	this.x=x; this.y=y; this.w=w; this.h=h; if (type==X) {	pmin=x; prange=w; } 	 else {	pmin=y+h; prange=-h; }}
	
	//convert pixels to real and vice versa
	double real(int p) {	return min.val+((p-pmin)*(max.val-min.val))/prange; }
	double pixel(double v) {	return (double)(pmin + prange*(v-min.val)/(max.val-min.val)); } //(double for stacking curves)
	
	//**********************************************
	
	/*
	this is causing an error because no max/min for linkx dummy owner! linkx still works once start dragging a scale
	public void precalc(iob iob) {
	if (iob==linkx) if (linkx.istrue()) linkx();
	}
	*/
	
	//public void postcalc() {	if (autoscale) autoscale(); super.postcalc(); } //call from regionplot to ensure after ratios done etc.
	
	public void postplot() {	draw(); }
	
	public void draw(Graphics gorig) {
		holder.clearRect(x,y,w,h); 
		
		Graphics g=gorig.create(); g.clipRect(x,y,w,h); 
		g.setColor(Color.black); g.setFont(usebigfont ? bigfont : scalefont); 
		
		if (type==X) g.drawLine(x, y, x+w, y); 
		if (type==Y) g.drawLine(x+w-1, y, x+w-1, y+h); 
		if (type==Y2) g.drawLine(x, y, x, y+h); 
		
		double v; int p; 
		String s; int sw;
		if (scales!=0) for (v=scales*(int)(0.8+(min.val / scales)); v<=max.val; v+=scales) {
			p=(int) pixel(v); 
			s=jcm.tls.txt.round(v, scaleu); sw=sw(g,s);
			if (type==X)  {	g.drawLine(p, y, p, y+5); if (h>8) g.drawString (s, p-sw/2, y+h-4); }
			if (type==Y) {	g.drawLine(x+w-5, p, x+w, p); if (w>8) g.drawString (s, x+w-(sw+5), p+4); }
			if (type==Y2) {	g.drawLine(x, p, x+5, p); if (w>8) g.drawString (s, x+6, p+4); }
		}
	} //draw
	
	public String getinfo() {	return ts[type]+": "+jcm.tls.txt.round(min.val, scaleu)+" - "+jcm.tls.txt.round(max.val, scaleu)+" "+jcm.tls.labinf.getshort(units)+" ("+jcm.tls.labinf.getlabel(units)+") "; }
	
	//**********************************************
	//adjusting by drag
	
	public void press(int x,int y) {
		op= (type==X ? x : y); 
		dragorigin= (op - pixel(origin))<40 && (op - pixel(origin))>-40 && !((graph)holder).stacked.istrue(); 
		super.press(x,y); 
	}
	
	public void drag(int x, int y) {
		if (popup) removepopup(); 
		ep=  (type==X ? x : y); 
		if (dragorigin) {
			dp=(double)((ep-op)*(max.val - min.val))/(double)(type==X ? -w : h); 
			max.val += dp; min.val+=dp; 
		} else {
			dp= ((double)op - pixel(origin)) / ((double)ep - pixel(origin)); 
			max.val = origin + (max.val-origin)*dp; min.val = origin + (min.val-origin)*dp; 
		}
		op= ep; 
		min.respond(false); max.respond(true); 
		if (linkx.istrue() && this.type==X) linkx(); 
	}
	
	//*******************
	//linkx -adjust all plots x-axis together
	
	void linkx() {
		for (int p=0; p<holder.holder.cpl.np; p++) 	if (holder.holder.cpl.pan[p] instanceof graph) {
			graph gpan=(graph) holder.holder.cpl.pan[p]; 
			if (gpan!=owner && gpan.output) {
				gpan.xscale.min.val=min.val; gpan.xscale.max.val=max.val; gpan.xscale.min.changed=true; 
			}}
	}
	
	//*******************************
	//autoscale
	
	
	public void autoscale() {	autoscale(0, getmax() ); }
	
	public void autoscale(double min, double max) {
		setup(units, min, max, 1.0,1.0); 
		checkunitfac(); 
		checkunitcancel(); 
		if (type==Y) owner.name3= "&ob&"+units +"&cb"; 
		autoscale=false; 
	} //end autoscale
	
	double getmax() {
		int mins, maxs; double max=0, stack; 
		//between which x limits?
		if (holder instanceof jcm.pan.distribplot || holder instanceof jcm.pan.costsplot) {	mins=90; maxs=160; } //skip first 80 and last 40 years
		else {	mins=0; maxs=jcm.mod.time.glos; }
		
		
		for (int rs=mins; rs<maxs; rs++) {
			if (((graph)holder).stacked.istrue()) {
				stack=0; 
				for (int nr=0; nr<((graph)holder).yd.length; nr++) if (((graph)holder).curveoutput[nr]) stack+=((graph)holder).yd[nr][rs]; 
				if (stack>max) max=stack; 
			}
			else for (int nr=0; nr<((graph)holder).yd.length; nr++) if (((graph)holder).yd[nr][rs]>max && ((graph)holder).curveoutput[nr]) max=((graph)holder).yd[nr][rs]; 
		}//end rs
		return max; 
	}
	
	
	
	//*******************************
	//checkunits
	
	static String[] qs={	"femto", "pico", "nano", "micro", "milli", "###", "kilo", "mega", "giga", "tera", "peta", "exa", "kiloexa"}; 
	static int[] 	qi= {	-15, -12, -9, -6, -3, 0, 3, 6, 9, 12, 15, 18, 21}; 
	
	//checkunits cancels megaton per megaperson, or ton/yr per dollar/yr , for example
	//assumes dividing two quantities with multipliers on denominators
	public void checkunitcancel() {
		int i,j,k,p,q,pp, qq, r; 
		//cancel yr/yr
		i=units.indexOf("&per&yr"); if (i>0) {	j=units.indexOf("&per&yr", i+1); if (j>0) {
				units=units.substring(0,i)+units.substring(i+5,j)+units.substring(j+5); 
			}}
		
		p=units.length(); pp=-1; for (j=0; j<qs.length; j++) {	k=units.indexOf(qs[j]); if (k>-1 && k<p) {	p=k; pp=j; }}
		if (p<units.length()) {
			q=-1; qq=-1; for (j=0; j<qs.length; j++) {	k=units.indexOf(qs[j], p+1); if (k>q) {	q=k; qq=j; }}
			if (q>-1) {
				r=5+ pp-qq; //System.out.println(units+"~"+qs[pp]+qs[qq]);
				if (r>-1 && r<qs.length) {
					String newfac=qs[r]+"&"; if (newfac.equals("###&")) newfac=""; 
					units=units.substring(0,p)+newfac+units.substring(p+qs[pp].length()+1,q)+units.substring(q+qs[qq].length()+1); 
					labelkey=units; 
				}}}
	} //checkunits
	
	//checkunitfac changes mega to giga and divide by 1000 etc.
	public void checkunitfac() {
		scales=Math.pow(10.0, Math.floor(
			(Math.log(max.val-min.val)/Math.log(10.0)) -0.4
			) ); 
		//		iob.debug("ss "+scales);
		
		int ou=5, fac=5, nu; 
		for (int i=0; i<qs.length; i++) if (units.startsWith(qs[i])) ou=i; 
		for (int i=0; i<qi.length; i++) if (scales>=Math.pow(10.0, qi[i])) fac=i; 
		
		scaleu=Math.pow(10.0,qi[fac]); 
		nu=ou+fac-5; 
		
		units=(nu==5 ? "" : qs[nu])+units.substring(ou==5 ? 0 : qs[ou].length()); 
		labelkey=units; 
		//System.out.println("scaleu="+scaleu+" units="+units);
	}
	
	//**********************************************
	
} //end scale
	
	
	
