//INTERACTION OBJECT CLASS
//Extended by modules and params, jcmpanels and popobs.

//Core JCM class for controlling interaction between model components
//so science modules can trigger panel repaint in main calculation loop,
//without the science code (MOD) making any reference to the panels (GUI/PAN)
//Also useful for interaction between GUI components


package jcm;
import java.util.Vector;
import jcm.tls.*;

public class iob {
	
	//######### INSTANCE FIELDS  #######################
	// data about this iob - kept to a minimum as there are many iobs!
	
	//CONSTRUCTOR
	
	public iob() {	} //initsetup();	}
	public iob(String n, iob i) {	name=n; owner=i; } //for iobs simply used as cause-effect logic links
	
	//****************************
	//IDENTIFICATION
	
	public iob owner=this; 
	public iob holder=this; 

	//an iob's owner is the module or panel containing code setting up this ob and any special effects
	//by default all iobs will affect their owner
	//its holder is the component containing it (may be different from owner)
	
	public String name=removepackagename(getClass().getName()), name2="", name3=""; 
	
	//name should be same as #codes in label files,
	//used for both pop-up info and scripting
	//note names not necessarily unique, but owner.getname()+name usually unique
	
	//****************************
	//FLAGS
	public boolean
	
	changed=true,	//changed since last recalc (and likewise everything which this *affects*)
		//triggered when you adjust a parameter
	//note for params must start as false!
	
	checked=false, 	//for changed loop below
	
	output=false,	//needed for direct output, e.g. visible panel or popob
	
	needed=false, //needed (maybe indirectly) because of output (and likewise everything which this is *affected by*)
	
	triggerset=false, //is this still used?
	
	disposed=false, //no longer needed
	
	skip=false; //if false, will skip calcs but remain changed
	
	//****************************
	//INTERACTIONS
	
	// all the other iobs this interacts with
	public Vector vaffectedby =new Vector(), vaffects =new Vector(); 
	//list of iobs that are fields of this one
	public Vector myiobs=new Vector(); 
	
	public iob triggeriob; 
	
	long timespent; //for checking performance
	
	
	//################### INSTANCE METHODS ######################
	//methods specific to this iob
	
	//INTERACTIONS
	
	public iob myiob(int i) {	return (iob)(myiobs.elementAt(i)); }
	
	public void setaffectedby(iob iob) {	if (!vaffectedby.contains(iob)) {	vaffectedby.addElement(iob); iob.vaffects.addElement(this); }}
	public void setaffects(iob iob) {	if (!vaffects.contains(iob)) {	vaffects.addElement(iob); iob.vaffectedby.addElement(this); }}
	public void setnotaffectedby(iob iob) {	vaffectedby.removeElement(iob); iob.vaffects.removeElement(this); }
	public void setnotaffects(iob iob) {	vaffects.removeElement(iob); iob.vaffectedby.removeElement(this); }
	public void setaffectedby(iob iob, boolean flag) {	if (flag) setaffectedby(iob); else setnotaffectedby(iob); }
	public void setaffects(iob iob, boolean flag) {	if (flag) setaffects(iob); else setnotaffects(iob); }
	public boolean affectedby(iob iob) {	return vaffectedby.contains(iob); }
	public boolean affects(iob iob) {	return vaffects.contains(iob); }
	
	//setinteractions() of all modules and panels: called whenever changed
	//this should contain affected, affectedby interactions as needed
	//maybe can make general conditional interactions function?
	public void setinteractions() {	}
	
	//before calling all interactions, all affectedby and affects vectors are cleared
	public void clearinteractions() {	vaffectedby.removeAllElements(); vaffects.removeAllElements(); }
	
	//************************************
	//EFFECTS -override  below as needed
	
	public void initsetup() {	getiobs(); register(); } //initial setup
	public void initsetuppanel() {	initsetup(); } //overridden by jcmpanel, here for ref from autodoc
	
	public void reset() {	} //when press reset button - mostly affects params
	public void preinterac() {	} //effect before interactions -e.g. that change output
	public void precalc() {	} //effect before main calc loop
	//see module for calcstep in main loop
	public void postcalc(){	} //after main calc loop -main plotting
	public void mainplot(){	} //after main calc loop -main plotting
	public void postplot(){	} //after main plot loop -for items on top of plots
	//for owners to specify special effects of params etc.
	public void preinterac(iob i) {	}
	public void precalc(iob i) {	}
	public void postcalc(iob i){	}
	public void mainplot(iob i){	}
	public void postplot(iob i){	}
	
	//scripting - called by player
	public void doscript (String ins) {	owner.doscript(this,ins); }
	public void doscript (iob iob, String ins) {	debug(iob.getstate()); }
	
	//called by param on its controller (popobs) for demo mode
	public void demo() {	}
	public void demopreloop() {	}
	public void demopostloop() {	}
	
	//****************************
	//NAME AND INFO
	
	public String getname() {	return name; }
	public String getfullname() {	return  (owner != this ? owner.getname()+"." : "") +name; }
	public String removepackagename(String s) {	int i= s.indexOf("."); return i>0 ? removepackagename(s.substring(i+1)) : s ; }
	//return getClass().getName().substring(getClass().getPackage().getName().length()+1); } getPackage() fails in IE java!
	
	public double getval() {	return 0; }
	public String getstringval()  {	return ""; } //used by param in scripts
	public String getstate() {	return getfullname()+" "+getstringval() + " " + interacinfo(); }
	
	public String gettable(String sep) {	return getstate(); } //used by viewdata and captab
	
	public String interacinfo() {	String s= (output ? "O" : "") + (needed ? "N" : "") + (changed ? "C" : "") + " "; 
		for (int i=0; i<vaffects.size(); i++) s+=">"+((iob)vaffects.elementAt(i)).name+" "; 
		for (int i=0; i<vaffectedby.size(); i++) s+="<"+((iob)vaffectedby.elementAt(i)).name+" "; 
		return s; 
	}
	public void writedebuginfo(String s) {	} //direct debug output - to notepad, System.out, a webpage etc.
	
	//****************************
	//DOC
	
	public String docallinfo() {
		String doc= labinf.getdoc(name); 
		if ( doc.indexOf("^")<0 && doc.indexOf("")<0) doc= docinfo()+" "+doc(this)+ " "+docinteracs()+docparam()+"<p>"; 
		return doc; 
	}
	
	public String doc(iob caller) {return  (caller==this ? "" : "") +labinf.getdoc(name)+ (caller==this ? "" : ""); }
	
	public String docinfo(iob caller) {
		return "<br><li>"+docinfo()+" "+doc(caller)+" "+ownhold(caller)+"<p>"; 
	}
	public String docinfo() {	return "("+labinf.getextralabel(name)+ ") "; }
	
	public String docinfo(String what) {
		if (what.equals("apptag")) return autodoc.makeapptag(name); 
		if (what.equals("params")) return docparam(); 
		if (what.equals("interacs")) return docinteracs(); 
		if (what.equals("info")) return docinfo(); 
		return " ("+ what+" info not found) "; 
	}
	
	public String docinteracs() {
		String affinfo= docaffects()+docaffectedby(); if (affinfo.length()>5) affinfo+="<br>interacs "; 
		String oh=ownhold(this); 
		if (oh.length()>0) return "`relations "+oh+affinfo; 
		else return "`interacs / `javacode "+affinfo+"<hr>"+autodoc.javacode(getClass()) ; 
	}
	
	
	public String docaffects() {
		String info=""; int c=0; 
		for (int i=0; i<vaffects.size(); i++) 	{	iob io= (iob)vaffects.elementAt(i); if (io.indoc() && io.owner!=owner && io.owner!=owner && !io.disposed) {	c++; info+=(c>1 ? ", " : "") +autodoc.linklong(io.owner); }}
		return (c>0 ? "<br><nobr>cogs `affects : "+info+" </nobr>" : ""); 
	}
	public String docaffectedby() {	//note jcmpanels return bufim.docaffectdby()
		String info=""; int c=0; 
		for (int i=0; i<vaffectedby.size(); i++) 	{	iob io= (iob)vaffectedby.elementAt(i); if (io.indoc() && io!=holder.owner && !io.disposed) {	c++; info+=(c>1 ? ", " : "") +autodoc.linklong(io.owner); } }
		return (c>0 ? "<br><nobr>cogs `affectedby : "+ info+" </nobr>" : ""); 
	}
	
	public String ownhold(iob caller) {
		if (owner!=this && owner!=caller && holder.owner==owner) return "<br><nobr> cogs  "+((holder!=this) ? autodoc.link(holder.type()) + " / " : "")+ autodoc.link(type()) + " `of " + autodoc.linklong(owner)+"  </nobr> "; 
		else 	return 	( (owner!=this && owner!=caller ) ? "<br><nobr> cogs  "+ autodoc.link(type()) +" `of " +autodoc.linklong(owner)+"  </nobr> " : "" )
			+ ( (holder!=this && holder.owner!=caller) ? " <br><nobr> adju "+ autodoc.link(holder.type()) +" `of " + autodoc.linklong(holder.owner) + " </nobr> " : "" )	; 
	}
	
	public String type() {	return removepackagename(getClass().getName()); }
	
	public String docparam() {
		StringBuffer info=new StringBuffer(" `params  <form>"); 
		int n=0; for (int i=0; i<myiobs.size(); i++) {	if (myiob(i) instanceof param && !((param)myiob(i)).pairof) {	info.append(myiob(i).docinfo(this)); n++; }		}
		return (n>0 ? info.append("</form>").toString() : ""); 
	}
	
	public boolean indoc() {	return owner==this; }
	
	//****************************
	//FIND OTHER IOBS
	
	//get Vector of all iobs that are fields of this one
	//set each iobs owner = this iob, and set it to affect this iob
	//should call this during initial setup of a module/panel
	//note Field is a java 1.1 class so maybe not supported in oldest browsers!
	//also this only works for iobs which are declared public!
	
	public void getiobs() {
		try {
			Class c=getClass(); 
			while (c!=null) {
				java.lang.reflect.Field[] f=c.getFields(); 
				for (int i=0; i<f.length; i++) if (f[i].get(this) instanceof iob) {
					if (f[i].getDeclaringClass()==c) {
						iob iob=(iob)f[i].get(this); 
						if (!myiobs.contains(iob)) myiobs.addElement(iob); 
						iob.owner=this; 
						iob.register(); 
					}}
				c=c.getSuperclass(); 
			}
		} catch (IllegalAccessException e) {	System.out.println(e); }; 
	} //end get iobs
	
	//find iob with specified name
	//use ownername.name to specify in case of ambiguity - now obligatory unless they are  the same
	public static iob findiob(String seek) {
		int s=seek.indexOf(".",0); 
		if (s>0) {
			String ownername=seek.substring(0,s), seekname=seek.substring(s+1); 
			int i=0; while (i<alliobs.size()) {
				if (!(alliob(i).disposed) && (alliob(i).name.equals(seekname) || (alliob(i).name+alliob(i).name2).equals(seekname)) 
				&& alliob(i).owner.getname().equals(ownername)
				) return alliob(i); i++; 
				}
		}
		else {
			int i=0; while (i<alliobs.size()) {
				if (!(alliob(i).disposed) && (alliob(i).name.equals(seek) ||  (alliob(i).name+alliob(i).name2).equals(seek))
					&& ( (alliob(i).owner.name== alliob(i).name) || (!alliob(i).name.equals(alliob(i).removepackagename(alliob(i).getClass().getName()))   )) //this ensures it's unique! -i.e. autodoc doesn't find carbon.scale while looking for scale
					) return alliob(i); 
				i++; 
			}
		}
		return null; 
	}
	
	
	//REGISTER
	public void register(){
		if (!alliobs.contains(this)) {
			alliobs.addElement(this); 
			if (checkreg) {
				debug("R: "+(owner.getname().equals(name) ? "" : owner.getname()+"~")+name+" "); 
				/*
				if (owner.getname()!=on) {	on=owner.getname(); if (checkreg) System.out.print("\n O:"+on+" "); }
				newcn=getClass().getName().substring(8);
				if (!newcn.equals(cn)) {	cn=newcn; *if (checkreg) { if (cn.equals(on)) System.out.print("(C) "); else System.out.print("\n (C:"+cn+") "); } }
				if (on!=name)  if (checkreg) System.out.println(owner.getname()+"~"+name+" ");
				*/
			}}
	}
	
	//************************************
	//TRIGGER
	//currently just used in regcli to make regclimap  draw again when data is loaded
	
	public void trigger() {	} //overwrite if needed
	public void settrigger(iob i) {	triggeriob=i; triggerset=true; }
	
	
	
	//************************************
	//DISPOSE
	public void dispose() {	//beware this will also remove refs to static iobs!
		for (int i=0; i<alliobs.size(); i++) if (alliob(i).owner==this) {
			for (int j=0; j<alliobs.size(); j++) {	alliob(j).setnotaffectedby(alliob(i)); alliob(j).setnotaffects(alliob(i)); }
			if (alliob(i)!=this) {	alliob(i).dispose(); if (i<=loop.i) loop.i--; i--; } //recursive! note the i-- to step back because alliobs has changed!
		}
		//if (checkreg) debug( "disposing "+name);
		alliobs.removeElement(this); name+="&disposed"; disposed=true; 
		try {	finalize(); }catch (Throwable e) {	debug(e); }
	}
	
	
	// #################### STATIC  fields and methods #############
	//affect set of all iobs
	
	public static java.net.URL codebase; //use for loading (saving) data files
	public static java.applet.Applet applet; //use for appletcontext to open webpages
	public static java.applet.AppletContext appletcontext; //use for appletcontext to open webpages
	
	//****************************
	//VECTORS
	//static register for looping through all iobs
	
	public static Vector alliobs=new Vector(); 
	public static iob alliob(int i) {	return (iob)(alliobs.elementAt(i)); }
	public static void clearalliobs() {	alliobs=new Vector(); }
	
	static String on="", cn="", newcn; boolean checkreg=false; 
	
	
	//****************************
	//STATIC METHODS CALLED FROM MAINLOOP
	//ALLINTERACTIONS, ALLEFFECTS, NEEDED, CHANGED, RESET
	
	//note no longer clears old interactions!
	static public void setallinteractions() {
		for (int i=0; i<alliobs.size(); i++) alliob(i).setinteractions(); 
		for (int i=0; i<alliobs.size(); i++) alliob(i).needed=false; 
		for (int i=0; i<alliobs.size(); i++) if (alliob(i).output) neededloop(alliob(i)); 
		for (int i=0; i<alliobs.size(); i++) if (alliob(i).changed) changedloop(alliob(i)); 
	}
	//set interactions for specific iob changed and needed - for iteration
	//assume no change in fundamental interactions
	static public void setchangedifneeded(iob c, iob n) {
		for (int i=0; i<alliobs.size(); i++) alliob(i).needed=false; 
		for (int i=0; i<alliobs.size(); i++) neededloop(n); 
		for (int i=0; i<alliobs.size(); i++) changedloop(c); 
	}
	
	
	//RECURSIVE NEEDED & CHANGED LOOPS
	
	static void neededloop(iob thisiob){	//recursive needed loop
		//		System.out.print(thisiob.name+" ");
		if (!thisiob.needed) {	//only if not already done!
			thisiob.needed=true; 
			//System.out.print("needs ");
			for (int i=0; i<thisiob.vaffectedby.size(); i++) neededloop((iob)(thisiob.vaffectedby.elementAt(i))); 
		}
		//System.out.println();
	} //end needed rec
	
	static void changedloop(iob thisiob){	//recursive changed loop
		if (!thisiob.checked) {	//only if not already done!
			thisiob.changed=true; thisiob.checked=true; 
			for (int i=0; i<thisiob.vaffects.size(); i++) changedloop((iob)(thisiob.vaffects.elementAt(i))); 
			thisiob.checked=false; 
		}
	} //end changed rec
	
	
	//resets all iobs, so long as they were registered!
	public static void resetall() {	for (int i=0; i<alliobs.size(); i++) alliob(i).reset(); loop.calcfutureonly=false; }
	
	//****************************
	//DEBUG
	static StringBuffer accuminfo=new StringBuffer(""); 
	public static iob debugiob=null; 
	public static void debug(Object[] o) {	StringBuffer s=new StringBuffer(""); for (int i=0; i<o.length; i++) s.append(o[i]+" "); debug(s); }
	public static void debug(Object o) {
		if (debugiob==null) {	System.out.println(""+o); accuminfo.append(" <nobr> "+o+" <br>\n").toString(); }
		else debugiob.writedebuginfo(""+o); 
	}
	
	
	
} //end class
	
	
	
