//Kyoto protocol
//Adjusts both total emissions, and the shares, for period 2000-2013
//uses SRES data for Non-annex B (and USA if not included)
//only affects CO2 emissions, unless other gases are scaled to CO2 (see oghga module)

//Originally developed summer 2000, US option added autumn 2001! 
//note region definitions in reg interface

package jcm.mod;
import jcm.*;
public class kyoto extends module {
	
	//known bug strange effect combine !incusa + stabtemp
	
	//*********************
	//INTERACTIONS
	public void setinteractions() {
			setaffectedby(sres, kyotop.istrue()); // sres for non annex1 /US
			setaffectedby(mitigation, kyotop.istrue()); //why?
			setaffectedby(mitigation.scenario, kyotop.istrue()); 
			setaffectedby(regshares.distribution, kyotop.istrue()); 
		}
	
	//*********************
	//PARAMETERS
	
	public param
		kyotop=new param("kyotoopt", false),
		incusa=new param("incusaopt", true)
		; 
	
/* This shouldn't be necessary any more as all changes will be checked
	public void precalc(iob p) {
		//if kyoto switched off, need to trigger changes elsewhere anyway
		if (mitigation.scenario.chosen=="nopolicy") sres.changed(); else mitigation.changed(); 
		if (regshares.distribution.chosen!="unspecified") regshares.changed(); 
		if (regshares.distribution.chosen=="sresdist") sres.changed(); 
	}
*/	
	//******************
	//kyoto targets US, CANZ, Jap, EU+, EEuro, RUB :
	//note regional targets were calculated in an excel file using CDIAC emissions data
	
	double[] targetfrac={	0.93, 0.995285031, 0.94, 0.921698359, 0.95, 0.997184973}; 
	double targetemit[]=new double[6]; 
	
	//note EU+ includes norway & iceland with higher targets then EU,
	//EEuro includes Ex-Yugo and Albania without target,
	//original figure for EEu with linear projections was 0.987934518
	//but these unrealistically high, so 0.95 is a guess
	//also original targets were for all six basket gases and here were applied to CO2 only
	//so total (CO2) reduction for six regions is less than 5%
	//should improve this module to apply to six gases!
	
	//working
	int ns, year, nr; 
	
	//****************************************************
	//MAIN CALC routine
	
	public void precalc() {	if (kyotop.istrue()){
			
			//if sres sc>5 no shares data so use b1 for non annexb
			int oldsc=sres.sc; if (sres.sc>5) sres.sc=4; 
			//shares for all years a bit inefficient but no one-year sres method due to normalising
			sres.emitshare(); 
			
			for (nr=(incusa.istrue()? 0 : 1) ; nr<6 ; nr++) targetemit[nr]=regshares.emit[nr][1990-time.rsy]*targetfrac[nr]; 
			
			for (year=2001; year<2013; year++) {
				int rs=year-time.rsy, gs=year-time.gsy; 
				
				for (nr=(incusa.istrue()? 0 : 1) ; nr<6 ; nr++) {
					if (year<2008) regshares.emit[nr][rs]=(float)(((2008-year)*regshares.emit[nr][2000-time.rsy]+(year-2000)*targetemit[nr])/8.0); 
					else regshares.emit[nr][rs]=(float)targetemit[nr]; 
				}
				//denmark
				if (year<2008) regshares.emit[13][rs]=(float)(((2008-year)*regshares.emit[13][2000-time.rsy]+(year-2000)*regshares.emit[13][1990-time.rsy]*0.92)/8.0); 
				else regshares.emit[13][rs]=(float)(regshares.emit[13][1990-time.rsy]*0.92); 
				
				//set emissions for regions not included using sres data (set above)
				carboncycle.fossil[gs]=1000f*sres.interpns(sres.fosemit,gs); 
				for (nr=6 ; nr<12 ; nr++) {
					regshares.emit[nr][rs]=carboncycle.fossil[gs]*regshares.share[nr][rs]; 
				}
				if (!incusa.istrue()) regshares.emit[0][rs]=carboncycle.fossil[gs]*regshares.share[0][rs]; 
				
				
				//now got all the emits ok, work out the new total and shares
				carboncycle.fossil[gs]=0; 
				for (nr=0 ; nr<12 ; nr++) carboncycle.fossil[gs]+=regshares.emit[nr][rs]; 
				regshares.emit[12][rs]=carboncycle.fossil[gs]; 
				for (nr=0 ; nr<14 ; nr++) regshares.share[nr][rs]=regshares.emit[nr][rs]/carboncycle.fossil[gs]; 
				
			} //end year
			
			sres.sc=oldsc; 
			
		} //end if kyotop
		else sres.emitshare(); 
		
	} //end precalc
	
	//******************************
} //end kyoto class



