package jcm.mod;

class mathcurve {
	/*
	General mathematical curves used for stabilisation etc. (see jcm/mod/mitigation)
	Note, to keep equations simple, usually scale to make x=0 at x0 and x=1 at xs.
	*/
	static double xr, xd, yd, fa ,fb, fc ,fd, fe, ff, fk, p; 
	
	//************************************************
	static double padequartic(float[] curve, int x0, int xs, double y0, double dy0, double d2y0,  double ys, double dys) {
		/*
		Make Pad type quartic curve  y = ( a + b.x + c.x.x ) / ( 1 + d.x + e.x.x ) as used by Enting et al (1994) for IPCC S scenarios
		Constrained by y & dy/dx at beginning and end of curve, plus initial d2y/dx2 which is a more general solution for a smooth start than the arbitrary point of Enting et al.
		Make the final dy/dx zero for stabilisation. The final d2y/dx is not controlled, and its value is returned
		*/
		
		xd=(double)xs-x0; yd=ys-y0; 
		dy0*=xd; dys*=xd; d2y0*=(xd*xd); 
		
		fa= y0; 
		fd= (dy0 - 2.0*yd + dys*((dy0 / yd) + d2y0 / (2.0*yd)  )) / (yd - dys*dy0 / yd); 
		fb= y0*fd + dy0; 
		fe= (1.0+fd) * (dy0/yd - 1.0) + d2y0/(2.0*yd); 
		fc= fe*y0 + fd*dy0 + d2y0/2.0; 
		
		for (int x=x0; x<=(xs < time.gey ? xs : time.gey); x++) {
			xr=(double)(x-x0)/xd; 
			curve[x-time.gsy]=(float)((fa + fb*xr + fc*xr*xr)/(1.0 + fd*xr + fe*xr*xr)); 
		}
		
		double d2ys= (2.0 * (fc - fe*ys  - (fd+2.0*fe)*dys) / (1.0 + fd + fe) ); 
		d2ys /=  (xd*xd) ; 
		//debug (" xd "+aa(xd)+" yd "+aa(yd)+" dy0 "+aa(dy0/ (xd))+" d2y0 "+aa(d2y0/ (xd*xd)) +" dys "+aa(dys/(xd)) +" d2ys "+aa(d2ys)+" fa "+aa(fa)+" fb "+aa(fb)+" fc "+aa(fc)+" fd "+aa(fd)+" fe "+aa(fe));
		return 	d2ys; 
	}
	
	//************************************************
	static void padequintic(float[] curve, int x0, int xs, double y0, double dy0, double d2y0,  double ys, double dys, double d2ys) {
		/* 	This one has an extra sixth term on top, to allow additional constraint on d2ys 	*/
		
		xd=(double)xs-x0; yd=ys-y0; 
		dy0*=xd; dys*=xd; d2y0*=(xd*xd); d2ys*=(xd*xd); 
		
		fa= y0; 
		fd= ( (dys - yd) * (3.0*yd - dy0 - 2.0*dys) + d2ys * (yd -  dy0 - d2y0 / 4.0) ) /  ( (dys - yd)* (dys - yd) +  (dy0 - yd) * d2ys /2.0  ); 
		fb= y0*fd + dy0; 
		fe= (3.0 * yd - 2.0 * dy0 - d2y0/2.0 - dys -fd * (dys + dy0 - 2.0*yd) ) / (dys - yd); 
		fc= fe*y0 + fd*dy0 + d2y0/2.0; 
		ff= yd - dy0 - fc + fd*yd + fe*ys; 
		
		for (int x=x0; x<=(xs < time.gey ? xs : time.gey); x++) {
			xr=(double)(x-x0)/xd; 
			curve[x-time.gsy]=(float)((fa + fb*xr + fc*xr*xr + ff*xr*xr*xr)/(1.0 + fd*xr + fe*xr*xr)); 
		}
		//debug (" xd "+aa(xd)+" yd "+aa(yd)+" dy0 "+aa(dy0/ (xd))+" d2y0 "+aa(d2y0/ (xd*xd)) +" dys "+aa(dys/(xd)) +" d2ys "+aa(d2ys)+" fa "+aa(fa)+" fb "+aa(fb)+" fc "+aa(fc)+" fd "+aa(fd)+" fe "+aa(fe));
	}
	
	
	//************************************************
	static void padecubictop(float[] curve, int x0, int xs, double y0, double dy0, double d2y0, double ys) {
		xd=(double)(xs-x0); yd=ys-y0; 
		dy0*=xd; d2y0*=(xd*xd); 
		
		fa= y0; 
		fd = d2y0 / (2.0*(yd-dy0)) - 1.0; 
		fc = dy0 * fd + d2y0 / 2.0; 
		fb = y0 * fd + dy0; 
		
		for (int x=x0; x<=(xs < time.gey ? xs : time.gey); x++) {
			xr=(double)(x-x0)/xd; 
			curve[x-time.gsy]=(float)((fa + fb*xr + fc*xr*xr) / (1.0 + fd * xr )); 
		}
	}
	
	//************************************************
	static void padecubicbottom(float[] curve, int x0,  int xs, double y0, double dy0, double d2y0,double ys) {
		xd=(double)(xs-x0); yd=ys-y0; 
		dy0*=xd; d2y0*=(xd*xd); 
		
		fa= y0; 
		fd= ( yd - dy0 - (ys/y0)*(d2y0/2.0) ) / ( dy0*(ys/y0) - yd); 
		fe = - (fd* dy0 + d2y0/2.0) / y0; 
		fb = y0 * fd + dy0; 
		
		for (int x=x0; x<=(xs < time.gey ? xs : time.gey); x++) {
			xr=(double)(x-x0)/xd; 
			curve[x-time.gsy]=(float)((fa + fb*xr ) / (1.0 + fd * xr + fe* xr*xr)); 
		}
	}
	
	//****************************************************
	static void flatquadratic(float[] curve, int x0,  int xs, double y0, double dy0,double ys) {
		//y = a + bp + cp^2 + dp^3 +ep^4, p =x/(1+x)
		xd=(double)(xs-x0); yd=ys-y0; 
		dy0*=xd; 
		fa = y0; fb =dy0; 
		fc= 4.0 * yd - 2.0 * dy0; 
		for (int x=x0; x<=time.gey; x++) {
			xr=(double)(x-x0)/xd; p = xr/(1.0+xr); 
			curve[x-time.gsy]=(float)(fa + fb*p + fc*p*p ); 
		}
	}
	
	static void flatquartic(float[] curve, int x0, int xs, double y0, double dy0, double d2y0,  double ys, double dys) {
		//y = a + bp + cp^2 + dp^3 +ep^4, p =x/(1+x)
		xd=(double)(xs-x0); yd=ys-y0; 
		dy0*=xd; dys*=xd; d2y0*=(xd*xd); 
		fa = y0; fb =dy0; 
		fc = dy0 + d2y0/2.0; 
		fe = 48.0 * yd - 8.0 * dys - 16.0 * fb  - 4.0 * fc; 
		fd = 8.0 * yd - 4.0* fb -  2.0*fc - fe/2.0; 
		for (int x=x0; x<=time.gey; x++) {
			xr=(double)(x-x0)/xd; p = xr/(1.0+xr); 
			curve[x-time.gsy]=(float)(fa + fb*p + fc*p*p + fd*p*p*p + fe*p*p*p*p ); 
		}
	}
	
	//************************************************
	static void simplecubic(float[] curve, int x0, int xs,  double y0, double dy0, double d2y0, double ys) {
		/* 		normal cubic curve constrained by start y, dy/dx and d2y/dx2, plus y at end */
		xd=(double)(xs-x0); 
		dy0*=xd; d2y0*=(xd*xd); 
		
		fa= y0; fb=dy0; fc=d2y0 / 2.0; 
		fd=ys-(fa+fb+fc); 
		
		for (int x=x0; x<=(xs < time.gey ? xs : time.gey); x++) {
			xr=(double)(x-x0)/xd; 
			curve[x-time.gsy]=(float)(fa + fb*xr + fc*xr*xr + fd * xr*xr*xr ); 
		}
	}
	//************************************************
	void simplequartic(float[] curve, int x0, int xs, double y0, double dy0, double d2y0, double ys, double yh) {
		/* 		as above plus halfway constraint (yh) */
		xd=(double)(xs-x0); 
		dy0*=xd; d2y0*=(xd*xd); 
		
		fa= y0; fb=dy0; fc=d2y0 / 2.0; 
		fd= 16.0*yh - ys - 15.0*y0  -7.0*dy0 - 1.5*d2y0; 
		fe= 2.0*ys - 16.0*yh + 14.0*y0 + 6.0*dy0 +d2y0; 
		
		for (int x=x0; x<=(xs < time.gey ? xs : time.gey); x++) {
			xr=(double)(x-x0)/xd; 
			curve[x-time.gsy]=(float)(fa + fb*xr + fc*xr*xr + fd * xr*xr*xr + fe * xr*xr*xr*xr); 
		}
	}
	
	//****************************************************
	static void expdecay(float[] curve, int x0, double y0, double dy0, double d2y0) {
		// y = (a + bx) exp(-kx)
		fk= (dy0 - Math.pow((dy0*dy0 - y0*d2y0) , 0.5) ) / y0; 
		fa=y0; fb=dy0 + y0*fk; 
		for (int x=x0; x<= time.gey ; x++) 	curve[x-time.gsy]=(float)((fa + fb*(x-x0)) *Math.exp(-fk*(x-x0))); 
	}
	double aa(double d) {	return ((int) (d*10000.0))/10000.0; }
	//************************************************
	
} //end class

	//old pade formula! //fd=(dy0/yd)-2.0, fe=1.0 + d2y0/(2.0*yd), fc= y0+ ys*d2y0/(2.0*yd);
	/*
	old cubic curve - not so good as tend to extreme slopes at end
	for (int x=xs; x<=time.gey; x++) {
	xr=(double)(x-xs)/(double)xd;
	target[x-time.gsy]=(float)(ys +(3.0*yde-dye)*(xr*xr)+(dye-2.0*yde)*(xr*xr*xr));
}
	*/
	/*
	if (halfway) {
	double yhd=dys/(double)xd - y0;
	fd= ( 3.0*yd*yhd + dy0*(2.0*yd - yhd) + (yd-yhd)*d2y0/2.0 ) / (yd*yhd - dy0*(yd-yhd));
}
	else
	*/
	
	//OLD code for temp target
		/*
		//ipcc enting 94 pade type curve
		dy0*=(double)xd; d2y0*=(double)(xd*xd); 
		double fa=y0, fe=(dy0/yd)-2.0, fb=y0*fe+dy0, ff=1.0+ d2y0/(2.0*yd), fc= y0+ ys*d2y0/(2.0*yd); 
		double xr; 
		for (x=x0; x<=(xs < time.gey ? xs : time.gey); x++) {
			xr=(double)(x-x0)/(double)xd; 
			target[x-time.gsy]=(float)((fa + fb*xr + fc*xr*xr)/(1.0 + fe*xr + ff*xr*xr)); 
		}
		*/
		
