//Other (non co2) greenhouse gases and aerosols, 
//CH4, N2O, O3, Nox, SOx, VOC, CO, SF6, HFCs, PFCs, CFCs, HCFCs
//SRES Emissions which may be scaled to CO2 reduction)
//Atmospheric chemistry including Ozone/OH
//Radiative forcing for these gases
//Applies formula from Bern-CC / IPCC WG1ch6

//Developed February 2002, Bern

package jcm.mod;
import jcm.*;

public class oghga extends module {
	
	//*******************************************************
	//INTERACTIONS
	public void setinteractions() {
		setaffectedby(loaddata); 
		setaffectedby(sres, emitoption.chosen=="sresfix" || emitoption.chosen=="sresscale"); 
		setaffectedby(mitigation, (emitoption.chosen=="sresscale" && mitigation.scenario.chosen!="nopolicy") || emitoption.chosen=="2000scale"); 
		setaffectedby(radfor.only4gas); 
	}
	
	//*******************************************************
	//PARAMETERS
	
	String[] emitoptions={	"sresfix", "sresscale", "2000fix", "2000scale"}; 
	
	public param
		emitoption=new param("othgasemit", emitoptions, "sresscale"),
		bcocwig=new param("bcocwig", false),
		strato3base1930=new param("o3s1930", false), //otherwise 1970 as ipcc
		//below added for unfccc-brazilian proposal exercise
	oheffect=new param("OHef", true),
	taro3=new param("TARO3", false),
		hadleyaero=new param("HadA", false)
		; 
	
	public void precalc(iob p) {	if (p==strato3base1930) cfcrf(); }
	
	//*******************************************************
	//PLOTARRAYS
	
	public float[]
		soxemit=time.fyd(),
		ch4emit=time.fyd(), n2oemit=time.fyd(),
		coemit=time.fyd(), vocemit=time.fyd(), noxemit=time.fyd(),
		ch4conc=time.fyd(), n2oconc=time.fyd(), tropo3du=time.fyd(),
		reloh=time.fyd(); //OH relative to 2000
	
	//fgas emit/conc/rf arrays in 5 year intervals from 1930 to end
	public float[][]
		fgemit=new float[26][(time.gey-1925)/5],
		fgconc=new float[26][(time.gey-1925)/5],
		fgrf=new float[26][(time.gey-1925)/5]
		; 
	//note original data for montreal gases 5-yr, and sres 10-yr intervals
	//note also yearly arrays for total hfcrf and cfcrf in radfor module
	
	//*******************************************************
	
	//before step-loop
	public void precalc() {
		if (loaddata.changed) {	//put here because should come after loaddata precalc
			histn2o(); 
			histnoxvoc(); 
			oghgrf0(); 
			fgashist(); 
			cfcrf(); 
		}
		scalegas(); 
	}
	
	//*******************************************************
	public void calcstep(int ns){
		
		if (ns>=250) emit(ns); 
		
		calcreloh(ns); 
		
		//used to fix historical concentrations of CH4, N2O
		//now vary them to show effect of lifetime, and for consistency with responsibility calculations
		
		if (ns>0) {
			ch4conc(ns); 
			n2oconc(ns); 
		}
		
		if (ns>=250) {
			tropo3conc(ns); 
			hfcconc(ns); 
		}
		
		oghgrf(ns); 
		bcocrf(ns); 
		sulfrf(ns); 
		hfcrf(ns); 
		
	} //end calcstep
	
	
	//*******************************************************
	//EMISSIONS
	//(future only)
	
	float scale; float[] scgas=new float[6]; 
	float[][][] scgasdata={	sres.soxemit, sres.ch4emit, sres.n2oemit, sres.coemit, sres.vocemit, sres.noxemit}; 
	
	//scale is92a to same 2000 values as SRES to match TAR calculations
	void scalegas() {	for (int i=0; i<6; i++) {
			if (sres.sc==6) scgas[i]=(float)(scgasdata[i][0][0]/scgasdata[i][6][0]); 
			else scgas[i]=1f; 
		}}
	
	void emit(int ns) {
		//scale to CO2 - note use fossil CO2 emissions not total (inc landuse)
		scale =1f; 
		if (ns>250 && emitoption.chosen=="sresscale") scale=carboncycle.fossil[ns]/(1000f*sres.interpns(sres.fosemit,ns)); 
		if (ns>250 && emitoption.chosen=="2000scale" ) scale=carboncycle.fossil[ns]/carboncycle.fossil[250]; 
	
		int bs=((emitoption.chosen=="sresfix" ||  emitoption.chosen=="sresscale")? ns : 250); 
		
		soxemit[ns]=sres.interpns(sres.soxemit,bs)*scale*scgas[0]; 
		ch4emit[ns]=sres.interpns(sres.ch4emit,bs)*scale; //*scgas[1]; //scgas doesn't help for CH4 is92a!
		n2oemit[ns]=sres.interpns(sres.n2oemit,bs)*scale*scgas[2]; 
		coemit[ns]=sres.interpns(sres.coemit,bs)*scale*scgas[3]; 
		vocemit[ns]=sres.interpns(sres.vocemit,bs)*scale*scgas[4]; 
		noxemit[ns]=sres.interpns(sres.noxemit,bs)*scale*scgas[5]; 
	
		//hfcs -note cfcs constant
		int year=ns+time.gsy+5, yearb=((emitoption.chosen=="sresfix" ||  emitoption.chosen=="sresscale") ? year : 2000); 
		if ((year%5)==0 && year>1930 && year<=time.gey) for (int g=0; g<12; g++) fgemit[g][(year/5)-386]=sres.interphfc(g, yearb)*scale; 
		
	}
	
	
	//calculate historical nox & voc by scaling to CO, only for plot not further calculations
	
	void histnoxvoc() {
		noxemit[250]=sres.interpns(sres.noxemit,250); 
		vocemit[250]=sres.interpns(sres.vocemit,250); 
		for (int ns=0; ns<250; ns++) {
			noxemit[ns]=noxemit[250]*coemit[ns]/coemit[250]; 
			vocemit[ns]=vocemit[250]*coemit[ns]/coemit[250]; 
		}}
	
	//*******************************************************
	//CHEMISTRY
	//CH4, CO, VOC, NOX, => OH, tropO3
	float tropo3prein=25; 
	
	//calculate OH relative to 2000
	void calcreloh(int ns) {
		if (oheffect.istrue()) {
			//note ch4 <=> oh, calc oh first using previous year's ch4 projected
			float projectch4conc= ns>1 ? 2*ch4conc[ns-1]-ch4conc[ns-2] : ch4prein; 
			
			reloh[ns]= (float)Math.exp(
				-0.32 * Math.log(projectch4conc/ch4conc[250])
				+0.0042 *(noxemit[ns]-noxemit[250])
				-0.000105 *(coemit[ns]-coemit[250])
				-0.000315 *(vocemit[ns]-vocemit[250])
				); 
		}
		else reloh[ns]=1f; 
	}
	
	//TROP O3 calculate tropospheric ozone (dobson units)
	void tropo3conc(int ns) {
		tropo3du[ns]=tropo3du[250]+(float)(
		 taro3.istrue() ? ( 	//coefficients used in TAR -too sensitive, can go below preindustrial level (hence rf<0) if emissions drop a lot
			6.7 * Math.log(ch4conc[ns]/ch4conc[250])
			+0.17 *(noxemit[ns]-noxemit[250])
			+0.0014 *(coemit[ns]-coemit[250])
			+0.0042 *(vocemit[ns]-vocemit[250])
			) : ( 	//later corrected coefficients from Prather -see also Joos paper
			5.0 * Math.log(ch4conc[ns]/ch4conc[250])
			+0.125 *(noxemit[ns]-noxemit[250])
			+0.0011 *(coemit[ns]-coemit[250])
			+0.0033 *(vocemit[ns]-vocemit[250])
			)
			); 
		if (tropo3du[ns]<0) tropo3du[ns]=0; 
	}
	
	//N2O
	float n2oemitnat=9.5f, ppbpmtn=0.20789f, n2oprein=272f; 
	//n2o lifetime: affected by n2o concentration or emissions (as implied in IPCC / Joos / Prather ?)
	//float n2olife(int ns) {return 120f*(float)Math.pow((n2oconc[ns])/(n2oconc[250]),-0.055);}
	float n2olife(int ns) {	return 120f*(float)Math.pow((n2oemitnat+n2oemit[ns])/(n2oemitnat+n2oemit[250]),-0.055); }
	
	
	//calculate future n2o conc from emit
	void n2oconc(int ns) {	n2oconc[ns]=n2oconc[ns-1]*(1f-1f/n2olife(ns-1))+ppbpmtn*(n2oemitnat+n2oemit[ns]); }
	
	//calculate historical n2o emit from conc
	void histn2o() {	for (int ns=250; ns>0; ns--) n2oemit[ns-1]=( (n2oconc[ns]-n2oconc[ns-1]*(1f-1f/n2olife(ns))) /ppbpmtn)-n2oemitnat; }
	
	//CH4
	//puzzle regarding ppbpmtch4: derived from ppmpmtc should be 0.35325, joos paper has ppbpmtch4=0.3603, tar says 1/2.78 =0.35971
	float ppbpmtch4=0.36f, ch4prein=742.2f; 
	
	float ch4emitnat() {	return 301f; }
	//ch4nat adjusted to be consistent with initial lifetime and concentration:
	//float ch4emitnat() {return ch4prein  / (ch4life(0) *ppbpmtch4);}
	
	float ch4life(int ns){	return 1f/((reloh[ns]/9.58f)+(1f/68.2f)); }
	
	void ch4conc(int ns) {	ch4conc[ns]=ch4conc[ns-1]*(1f-1f/ch4life(ns))+ppbpmtch4*(ch4emitnat()+ch4emit[ns]); }
	//note, if no OH effect, would need to use a different natural CH4 flux to start in steady state
	
	//*******************************************************
	//OGHG RF
	
	//overlap between ch4 and n2o rf
	float overlap(float ch4, float n2o) {
		return (float)(0.47* Math.log(
			1.0 + 2.01e-5 * Math.pow(ch4*n2o,0.75)
			+ 5.31e-15 * ch4 * Math.pow(ch4*n2o,1.52)
			)); }
	
	float overlap0, ch4rf0, n2orf0; 
	
	void oghgrf0() {
		overlap0=overlap(ch4conc[0], n2oconc[0]); 
		ch4rf0=(float)(0.036 * Math.pow(ch4conc[0],0.5)); 
		n2orf0=(float)(0.12 * Math.pow(n2oconc[0],0.5)); 
	}
	
	void oghgrf(int ns) {
		radfor.ch4rf[ns]=(float)(0.036*Math.pow(ch4conc[ns],0.5) -ch4rf0) -(overlap(ch4conc[ns],n2oconc[0])-overlap0); 
		radfor.n2orf[ns]=(float)(0.12*Math.pow(n2oconc[ns],0.5) -n2orf0) -(overlap(ch4conc[0],n2oconc[ns])-overlap0); 
		radfor.tropo3rf[ns]=(float) (0.042*(tropo3du[ns]-tropo3prein)); 
		radfor.strath2orf[ns]=-0.05f*radfor.ch4rf[ns]; 
	}
	
	
	//*******************************************************
	//F GASES (HFCs CFCs etc)
	
	public String[] fgname={
		//these first 12 vary with sres and are included in kyoto etc.
		"SF6", "CF4", "C2F6", "HFC23",   	//(yearly data pre 1960-1989)
			"HFC134a", "HFC152a", "HFC125", 	//(only 3 included in is92a, 152a not in sres)
			"HFC32", "HFC143a", "HFC227ea", "HFC245ca", "HFC4310mee",
			//below 14 montreal protocol gases (contain Cl/Br damages ozone)
		//concentrations prescribed by data, no emissions
		"HCFC22", "HCFC141b", "HCFC142b", "HCFC123", "CH3CCl3", //hcfcs h=> shorter lifetimes
			"CFC11", "CFC12", "CFC113", "CFC114", "CFC115", "CCl4", //cfcs
			"CF2BrCl", "CF3Br", //br gases data to 2100 only
			"EESCL" //effective equivalent stratospheric chlorine -affects ozone loss -data to 2100 only
	}; 
	
	//note info below also used to make labels and colors in fgasplot
	public String[] atom={	"S","C","H","F","Cl","Br"}; 
	public byte[][] fo={
		{	1,0,0,6,0,0},{	0,1,0,4,0,0},{	0,2,0,6,0,0},{	0,1,1,3,0,0},
		{	0,2,2,4,0,0},{	0,2,4,2,0,0},{	0,2,1,5,0,0},
		{	0,1,2,2,0,0},{	0,2,3,3,0,0},{	0,3,1,7,0,0},{	0,3,3,5,0,0},{	0,5,2,10,0,0},
		{	0,1,1,2,1,0},{	0,2,3,1,2,0},{	0,2,3,2,1,0},{	0,2,1,3,2,0},{	0,2,3,0,3,0},
		{	0,1,0,1,3,0},{	0,1,0,2,2,0},{	0,2,0,3,3,0},{	0,2,0,4,2,0},{	0,2,0,5,1,0},{	0,1,0,0,4,0},
		{	0,1,0,2,1,1},{	0,1,0,3,0,1},
		{	0,0,0,0,1,0}
	}; 
	
	//radiative forcing impact W/m2/ppb, note concs in ppt (now including eescl!)
	double[] fgrfalpha={
		0.52, 0.08, 0.26, 0.16,
			0.15, 0.09, 0.23,
			0.09, 0.13, 0.30, 0.23, 0.40,
			0.20, 0.14, 0.20, 0.20, 0.06,
			0.25, 0.32, 0.30, 0.31, 0.18, 0.13,
			0.30, 0.32,
			-0.07317
	}; 
	
	//lifetime years
	double[] fglt={
		3200, 50000, 10000, 257,
			13.7, 1.4, 29.4,
			5.0, 51.6, 33.0, 5.9, 1.56,
			11.9, 9.3, 19, 1.4, 4.8,
			45, 100, 85, 300, 1700, 35,
			11, 65,
			0
	}; 
	
	//kiloton per ppt or Tg/ppb or Gt/ppm
	double[] fgktpppt={
		25.3, 15.3, 23.9, 12.1, 17.7, 10.9, 20.8, 8.56, 14.6, 29.5, 22.1, 41.5, //hfcs joos data slightly higher than equiv to CO2(C)=2.123 ?
			15.31, 20.71, 17.79, 32.92, 23.6, 24.34, 21.41, 33.17, 30.27, 27.35, 27.26, 29.28, 26.36, 0  //cfcs (used for inverse emit only) -scaled to C=2.123
	}; 
	
	//chemical formulae for CFCs: first digit (maybe missing) = # C - 1 ; second digit = # H + 1; third digit = # F
	//so mol mass xyz = 12(x+1) + (y-1) +19z +35.5(5+ 2x -y -z) = 188.5 + 83x -34.5y - 16.5z  Note Br=79.9
	//F11 =137.5 , F12=121 , F113=187.5 , F114=171 , F115=154.5 ,
	//F10(CCl4)=154, F140(CH3CCl3)=133.5,  F22 =86.5, F141=117, F142=100.5, F123=186
	//CF2BrCl=165.4, CF3Br=148.9
	
	float cf4natconc=44; //preindustrial background concn CF4 =44 ppt
	//cf4natemit=15.3*44f/50000f; 0.01 so small we can ignore compared to anthropogenic
	//note c4f10 removed as only in old sres-p
	//CH3Br = 9.06 ppt constant (so no rf?)
	
	//holds yearly concentration data for sf6, cf4, c2f6, hfc23 from 1960-1990
	float[][] hfchistconc=new float[4][31]; 
	
	//***********************
	//HFCHIST
	void fgashist() {
		//historical concentrations for hfcs and cfcs
		//1930-1955 -only CF4
		for (int i=0; i<6; i++) for (int g=0; g<12; g++) fgconc[g][i]= (g==1 ? cf4natconc :0); 
		//1960-1990 -use historical conc data for first 4 gases, otherwise zero
		for (int i=6; i<13; i++) for (int g=0; g<12; g++) fgconc[g][i]= (g<4 ? hfchistconc[g][5*(i-6)] : 0); 
		//data for 2000 for first six, otherwise zero, interpolate 1995
		float[] hfc2000={	4.4f, 80f, 3.1f, 15f, 10f, 0.5f}; 
		for (int g=0; g<6; g++) {	fgconc[g][14]=hfc2000[g]; fgconc[g][13]=(fgconc[g][14]+fgconc[g][12])/2f; }
		for (int g=6; g<12; g++) {	fgconc[g][14]=0; fgconc[g][13]=0; }
		
		//calc emissions by inverse: just history for hfcs, all for cfcs (except eescl)
		for (int g=0; g<25; g++) {
			if (g<12) fgemit[g][14]=(float)sres.hfcemit[g][0][0]; //but note different for hfc134a in is92a!
			else fgemit[g][(time.gey-1930)/5]=0; 
			//hfcs 4-12 emissions zero pre 2000, 0.001 makes line start
			if (g>3 && g<12) {	for (int i=0; i<14; i++) fgemit[g][i]=0; fgemit[g][14]=0.001f; }
			else {	//not zero
				double fac1=Math.exp(-5.0/fglt[g]), fac2=(1.0-fac1)*fglt[g]/5.0; 
				for (int i=(g<12 ? 13 : 73); i>=0; i--) {
					double fac3=fgktpppt[g]*(fgconc[g][i+1]-fac1*fgconc[g][i]); 
					if (fac3>0.001) fgemit[g][i]=0.5f*(float)( (fac3 + fgemit[g][i+1]*fglt[g]*(fac2 - 1.0) ) / (fglt[g]*(fac2 - fac1)) ); 
					else fgemit[g][i]=0; 
					if (fgemit[g][i]<0) fgemit[g][i]=0; 
				}
			} //else
		} //g
		//smooth oscillations
		float[][] fgemit2=(float[][])fgemit.clone(); 
		for (int g=0; g<25; g++) for (int i=2; i<(g<12 ? 13 : 72); i++) fgemit[g][i]=(fgemit2[g][i-2]+4f*fgemit2[g][i-1]+6f*fgemit2[g][i]+4f*fgemit2[g][i+1]+fgemit2[g][i+2])/12f; 
	} //end fgashist
	
	//***********************
	//future hfc emissions=>concentration
	//calculates in 5 years steps AHEAD
	//(using reloh for starting year, but little difference)
	void hfcconc(int ns) {
		int year=ns+time.gsy; if ((year % 5)==0 && year>=2000) {
			int i=(year-1930)/5; if (i<(time.gey-1930)/5) {
				for (int g=0; g<12; g++) {
					double deltaemit=(fgemit[g][i+1]-fgemit[g][i]); 
					double fglta=(g<4 ? fglt[g] : fglt[g]/reloh[ns]); //scale to reloh except for sf6, cf2, c2f6
					double fac=Math.exp(-5.0/fglta); 
					fgconc[g][i+1]=(float)(fac*fgconc[g][i]+(fglta/fgktpppt[g])*(deltaemit+(1.0-fac)*(fgemit[g][i]-deltaemit*fglta/5.0)) ); 
				} //g
			}} //ifs
	} //end calchfc
	
	void cfcrf() {
		//if change eesclbaseyear, still get correct 2000rf
		float eesclbase=fgconc[25][((strato3base1930.istrue() ? 1930 : 1970)-1930)/5]; 
		fgrfalpha[25]=-0.15f*1000f/(fgconc[25][14]-eesclbase); 
		//eescl scale to cfc12 after 2100
		for (int i=34; i<(time.gey-1925)/5; i++) fgconc[25][i]=eesclbase +(fgconc[25][34]-eesclbase)*fgconc[18][i]/fgconc[18][34]; 
		
		//calc radiative forcing
		for (int i=0; i<(time.gey-1925)/5; i++) {
			for (int g=12; g<25; g++) fgrf[g][i]=fgconc[g][i]*(float)fgrfalpha[g]/1000f; 
			fgrf[25][i]=(fgconc[25][i]-eesclbase)*(float)fgrfalpha[25]/1000f; 
			if (fgrf[25][i]>0) fgrf[25][i]=-0.0001f; 
		}
		//fill radfor.cfcrf & strato3rf (interpolating linearly)
		for (int i=0; i<(time.gey-1925)/5; i++) {
			int ns=i*5+(1930-time.gsy); 
			radfor.cfcrf[ns]=0; for (int g=12; g<25; g++) radfor.cfcrf[ns]+=fgrf[g][i]; 
			radfor.strato3rf[ns]=fgrf[25][i]; 
			if (i>0) for (int j=1; j<5; j++) radfor.cfcrf[ns-j]=(radfor.cfcrf[ns]*(5-j)+radfor.cfcrf[ns-5]*j)/5f; 
			if (i>0) for (int j=1; j<5; j++) radfor.strato3rf[ns-j]=(radfor.strato3rf[ns]*(5-j)+radfor.strato3rf[ns-5]*j)/5f; 
		}
	} //end  cfcrf
	
	void hfcrf(int ns) {
		//works in 5 year steps AHEAD (note concs also calculated 5yr ahead)
		if ((ns%5)==0) {
			int i=(ns+time.gsy-1930)/5; 
			if (i>=-1 && i<(time.gey-1930)/5) {
				//calc radiative forcing
				radfor.hfcrf[ns+5]=0; 
				for (int g=0; g<12; g++) {
					fgrf[g][i+1]=(fgconc[g][i+1]-(g==1 ? cf4natconc : 0)) *(float)fgrfalpha[g]/1000f; 
					radfor.hfcrf[ns+5]+=fgrf[g][i+1]; 
				} //g
				if (i>=0) for (int j=1; j<5; j++) radfor.hfcrf[ns+j]=(radfor.hfcrf[ns]*(5-j)+radfor.hfcrf[ns+5]*j)/5f; 
			}} //ifs
	} //end hfcrf
	
	
	//*******************************************************
	
	//AEROSOLS
	
	//sulphur constants
	double se2000=69,  senat=42; 
	double sdqdir2000= -0.4, sdqind2000= -0.8; //to fit TAR
	//double se1990=69, sdqdir1990= -0.3, sdqind1990= -0.8;  old figures
	
	void sulfrf(int ns) {
		if (hadleyaero.istrue()) {
			int hai=(ns<110 ? 0 : ns<350 ? ns-110 : 240); 
			radfor.sulfdirrf[ns]=(float)hadleyaerosol[hai][0]; radfor.sulfindrf[ns]=(float)hadleyaerosol[hai][1]; 
		} else {
			radfor.sulfdirrf[ns]=(float)((radfor.sulfrf2000.getval()/(sdqdir2000+sdqind2000))*(sdqdir2000*soxemit[ns]/se2000) ); 
			radfor.sulfindrf[ns]=(float)((radfor.sulfrf2000.getval()/(sdqdir2000+sdqind2000))*(sdqind2000*(Math.log(1.0+soxemit[ns]/senat)/Math.log(1.0+se2000/senat))) ); 
		}
	}
	
	//called if adjust the sulf rf parameter
	void changesulfrf() {	for (int ns=0; ns<(time.gey-time.gsy); ns++) sulfrf(ns); }
	
	
	//extra aerosol scenario added temporarily for UNFCCC intercomparison on attribution of climate change
	//1860-2100
	static double[][] hadleyaerosol={
		{	-0.002000,-0.030000}, {	-0.002350,-0.033000}, {	-0.002700,-0.036000}, {	-0.003050,-0.039000}, {	-0.003400,-0.042000}, {	-0.003750,-0.045000}, {	-0.004100,-0.048000}, {	-0.004450,-0.051000}, {	-0.004800,-0.054000}, {	-0.005150,-0.057000}, {	-0.005500,-0.060000}, {	-0.005850,-0.063000}, {	-0.006200,-0.066000}, {	-0.006550,-0.069000}, {	-0.006900,-0.072000}, {	-0.007250,-0.075000}, {	-0.007600,-0.078000}, {	-0.007950,-0.081000}, {	-0.008300,-0.084000}, {	-0.008650,-0.087000}, {	-0.009000,-0.090000}, {	-0.009350,-0.093000}, {	-0.009700,-0.096000}, {	-0.010050,-0.099000}, {	-0.010400,-0.102000}, {	-0.010750,-0.105000}, {	-0.011100,-0.108000}, {	-0.011450,-0.111000}, {	-0.011800,-0.114000}, {	-0.012150,-0.117000}, {	-0.012500,-0.120000}, {	-0.012850,-0.123000}, {	-0.013200,-0.126000}, {	-0.013550,-0.129000}, {	-0.013900,-0.132000}, {	-0.014250,-0.135000}, {	-0.014600,-0.138000}, {	-0.014950,-0.141000}, {	-0.015300,-0.144000}, {	-0.015650,-0.147000},
		{	-0.016000,-0.150000}, {	-0.016640,-0.155200}, {	-0.017280,-0.160400}, {	-0.017920,-0.165600}, {	-0.018560,-0.170800}, {	-0.019200,-0.176000}, {	-0.019840,-0.181200}, {	-0.020480,-0.186400}, {	-0.021120,-0.191600}, {	-0.021760,-0.196800}, {	-0.022400,-0.202000}, {	-0.023040,-0.207200}, {	-0.023680,-0.212400}, {	-0.024320,-0.217600}, {	-0.024960,-0.222800}, {	-0.025600,-0.228000}, {	-0.026240,-0.233200}, {	-0.026880,-0.238400}, {	-0.027520,-0.243600}, {	-0.028160,-0.248800}, {	-0.028800,-0.254000}, {	-0.029440,-0.259200}, {	-0.030080,-0.264400}, {	-0.030720,-0.269600}, {	-0.031360,-0.274800}, {	-0.032000,-0.280000}, {	-0.032640,-0.285200}, {	-0.033280,-0.290400}, {	-0.033920,-0.295600}, {	-0.034560,-0.300800}, {	-0.035200,-0.306000}, {	-0.035840,-0.311200}, {	-0.036480,-0.316400}, {	-0.037120,-0.321600}, {	-0.037760,-0.326800}, {	-0.038400,-0.332000}, {	-0.039040,-0.337200}, {	-0.039680,-0.342400}, {	-0.040320,-0.347600}, {	-0.040960,-0.352800},
		{	-0.041600,-0.358000}, {	-0.042240,-0.363200}, {	-0.042880,-0.368400}, {	-0.043520,-0.373600}, {	-0.044160,-0.378800}, {	-0.044800,-0.384000}, {	-0.045440,-0.389200}, {	-0.046080,-0.394400}, {	-0.046720,-0.399600}, {	-0.047360,-0.404800}, {	-0.048000,-0.410000}, {	-0.051680,-0.425600}, {	-0.055360,-0.441200}, {	-0.059040,-0.456800}, {	-0.062720,-0.472400}, {	-0.066400,-0.488000}, {	-0.070080,-0.503600}, {	-0.073760,-0.519200}, {	-0.077440,-0.534800}, {	-0.081120,-0.550400}, {	-0.084800,-0.566000}, {	-0.088480,-0.581600}, {	-0.092160,-0.597200}, {	-0.095840,-0.612800}, {	-0.099520,-0.628400}, {	-0.103200,-0.644000}, {	-0.106880,-0.659600}, {	-0.110560,-0.675200}, {	-0.114240,-0.690800}, {	-0.117920,-0.706400}, {	-0.121600,-0.722000}, {	-0.125280,-0.737600}, {	-0.128960,-0.753200}, {	-0.132640,-0.768800}, {	-0.136320,-0.784400}, {	-0.140000,-0.800000}, {	-0.141600,-0.804400}, {	-0.143200,-0.808800}, {	-0.144800,-0.813200}, {	-0.146400,-0.817600},
		{	-0.148000,-0.822000}, {	-0.149600,-0.826400}, {	-0.151200,-0.830800}, {	-0.152800,-0.835200}, {	-0.154400,-0.839600}, {	-0.156000,-0.844000}, {	-0.157600,-0.848400}, {	-0.159200,-0.852800}, {	-0.160800,-0.857200}, {	-0.162400,-0.861600}, {	-0.164000,-0.866000}, {	-0.165600,-0.870400}, {	-0.167200,-0.874800}, {	-0.168800,-0.879200}, {	-0.170400,-0.883600}, {	-0.172000,-0.888000}, {	-0.173600,-0.892400}, {	-0.175200,-0.896800}, {	-0.176800,-0.901200}, {	-0.178400,-0.905600}, {	-0.180000,-0.910000}, {	-0.183400,-0.913800}, {	-0.186800,-0.917600}, {	-0.190200,-0.921400}, {	-0.193600,-0.925200}, {	-0.197000,-0.929000}, {	-0.200400,-0.932800}, {	-0.203800,-0.936600}, {	-0.207200,-0.940400}, {	-0.210600,-0.944200}, {	-0.214000,-0.948000}, {	-0.217400,-0.951800}, {	-0.220800,-0.955600}, {	-0.224200,-0.959400}, {	-0.227600,-0.963200}, {	-0.231000,-0.967000}, {	-0.234400,-0.970800}, {	-0.237800,-0.974600}, {	-0.241200,-0.978400}, {	-0.244600,-0.982200},
		{	-0.248000,-0.986000}, {	-0.251400,-0.989800}, {	-0.254800,-0.993600}, {	-0.258200,-0.997400}, {	-0.261600,-1.001200}, {	-0.265000,-1.005000}, {	-0.268400,-1.008800}, {	-0.271800,-1.012600}, {	-0.275200,-1.016400}, {	-0.278600,-1.020200}, {	-0.282000,-1.024000}, {	-0.285400,-1.027800}, {	-0.288800,-1.031600}, {	-0.292200,-1.035400}, {	-0.295600,-1.039200}, {	-0.299000,-1.043000}, {	-0.302400,-1.046800}, {	-0.305800,-1.050600}, {	-0.309200,-1.054400}, {	-0.312600,-1.058200}, {	-0.316000,-1.062000}, {	-0.319400,-1.065800}, {	-0.322800,-1.069600}, {	-0.326200,-1.073400}, {	-0.329600,-1.077200}, {	-0.333000,-1.081000}, {	-0.336400,-1.084800}, {	-0.339800,-1.088600}, {	-0.343200,-1.092400}, {	-0.346600,-1.096200}, {	-0.350000,-1.100000}, {	-0.347800,-1.093800}, {	-0.345600,-1.087600}, {	-0.343400,-1.081400}, {	-0.341200,-1.075200}, {	-0.339000,-1.069000}, {	-0.336800,-1.062800}, {	-0.334600,-1.056600}, {	-0.332400,-1.050400}, {	-0.330200,-1.044200},
		{	-0.328000,-1.038000}, {	-0.325800,-1.031800}, {	-0.323600,-1.025600}, {	-0.321400,-1.019400}, {	-0.319200,-1.013200}, {	-0.317000,-1.007000}, {	-0.314800,-1.000800}, {	-0.312600,-0.994600}, {	-0.310400,-0.988400}, {	-0.308200,-0.982200}, {	-0.306000,-0.976000}, {	-0.303800,-0.969800}, {	-0.301600,-0.963600}, {	-0.299400,-0.957400}, {	-0.297200,-0.951200}, {	-0.295000,-0.945000}, {	-0.292800,-0.938800}, {	-0.290600,-0.932600}, {	-0.288400,-0.926400}, {	-0.286200,-0.920200}, {	-0.284000,-0.914000}, {	-0.281800,-0.907800}, {	-0.279600,-0.901600}, {	-0.277400,-0.895400}, {	-0.275200,-0.889200}, {	-0.273000,-0.883000}, {	-0.270800,-0.876800}, {	-0.268600,-0.870600}, {	-0.266400,-0.864400}, {	-0.264200,-0.858200}, {	-0.262000,-0.852000}, {	-0.259800,-0.845800}, {	-0.257600,-0.839600}, {	-0.255400,-0.833400}, {	-0.253200,-0.827200}, {	-0.251000,-0.821000}, {	-0.248800,-0.814800}, {	-0.246600,-0.808600}, {	-0.244400,-0.802400}, {	-0.242200,-0.796200},
		{	-0.240000,-0.790000}
	}; 
	
	
	void bcocrf(int ns){
		
		//carbon aerosols -very uncertain, 2000 figures below:
		//              FF      BB
		// RF(OC, 2000) = -0.1 + (-0.4) = -0.5
		// RF(BC,2000)  = +0.2 + (+0.2) = +0.4
		
		
		if (bcocwig.istrue()) {
			//wigley magicc method scale fossil to sulphate and biomass to "gross deforestation" (both using 1990 baseline)
			float ff=soxemit[ns]/soxemit[240]; 
			float bb=(grossdefor(ns)>0 ? grossdefor(ns) : 0) /grossdefor(240); 
			radfor.bcrf[ns]=0.2f*ff+0.2f*bb; 
			radfor.ocrf[ns]=-0.1f*ff-0.4f*bb; 
		}
		
		else {
			//joos simple scale to co
			radfor.bcrf[ns]=0.4f*(coemit[ns]+1036f-coemit[250])/1036f; 
			radfor.ocrf[ns]=-0.5f*(coemit[ns]+1036f-coemit[250])/1036f; 
		}
		
		if (hadleyaero.istrue()) {	radfor.bcrf[ns]=0; radfor.ocrf[ns]=0; }
		
	} //end bcocrf
	
	//for biomass bcoc aerosol -approximate to wigley's "gross deforestation":
	float grossdefor(int ns) {	return carboncycle.lucf[ns]+5f*(ns>100 ? ns<350 ? ns-100 : 250: 0); }
	
	//********************
} //end class


