//Radiative forcing: 
//calculate rf for CO2 and natural variability, 
//combine with oghga rf to calc totals
//also split between l/o n/s boxes of heatflux model

//originally developed spring 2000, more forcings added Edinburgh spring 2001
//most moved to new oghga module Bern February 2002 

package jcm.mod;
import jcm.*;

public class radfor extends module {
	
	//*****************************************************
	//INTERACTIONS
	
	public void setinteractions() {
		setaffectedby(loaddata); 
		setaffectedby(carboncycle); 
		setaffectedby(oghga); 
		setaffectedby(heatflux.climod); //rfco2-double param
	} //end interactions
	
	//*****************************************************
	//PARAMETERS
	
	public param
		sulfrf2000=new param("sulfrf2000", "w&per&m2", -1.2, -2.4, 0),
		solarrf2000=new param("solarrf2000", "w&per&m2", 0.3, 0, 0.6),
		volcfac=new param("volcfac", "", -1.5, -3.0, 0), //note negative!
		futuresolar=new param("futsolopt",false),
		//below added for unfccc-brazilian exercise
	unifdist=new param("unif", false),
		only4gas=new param("4gas", false),
		includesv=new param("sv", true)
		; 
	//note rfco2double stored in heatflux class
	
	//*******************************************************
	//PLOTARRAYS
	public float[]
		co2rf= time.fyd(), ch4rf= time.fyd(), n2orf= time.fyd(),
		cfcrf= time.fyd(), hfcrf= time.fyd(), //see oghga module for individual F-gases
		strath2orf= time.fyd(),
		tropo3rf= time.fyd(), strato3rf=time.fyd(),
		sulfdirrf=time.fyd(), sulfindrf=time.fyd(),
		bioburnrf= time.fyd(), albedorf =time.fyd(), dustrf=time.fyd(),
		aircontrf= time.fyd(),
		bcrf= time.fyd(), ocrf= time.fyd(),
		solarrf= time.fyd(),
		totalrf= time.fyd(),
		totanthrorf = time.fyd(),
		totghgrf= time.fyd(),
		totoghgrf = time.fyd(),
		totaerorf = time.fyd(),
		totnatvrf = time.fyd(),
		solarrfdata= new float[time.hiss1],
		volcanorf= new float[time.hiss1], volcorig= new float[time.hiss1],
		co2eqghg=time.fyd(), co2eqghgaero=time.fyd(), co2eqkyoto=time.fyd()
		; 
	
	//************ mainloop calculations **********************************
	//MAIN CALCULATIONS
	
	public void precalc(iob p) {	//note this comes before any mod precalc inc loaddata!!
		if (p==unifdist) distribute(); 
		if (p==only4gas || p==includesv || p==volcfac) makevolcanorf(); //only4gas will also make oghga recalc
		if (p==solarrf2000 || p==includesv) solarrf(); 
		if (p==sulfrf2000) oghga.changesulfrf(); 
	}
	
	public void precalc() {	//initial setup, note distribute called by unifdist changed at beginning
		if (loaddata.changed) {	solarrf(); makevolcanorf(); }
	}
	
	public void calcstep(int ns){
		//note histdatall and sres fill the arrays -here just extra calculations
		co2rf(ns); 
		only4gas(ns); 
		calctotals(ns); 
		calcsplit(ns); 
	}
	
	//******************************************
	//CO2 RF
	void co2rf(int ns) {
		co2rf[ns]=(float)(heatflux.rfco2double.getval()*Math.log(carboncycle.atppm[ns]/carboncycle.atppmprein)/Math.log(2.0)); 
	}
	
	//******************************************
	//VOLCANO
	//asume the values taken from graph are the peak max, so much of it decays before end first year
	//integral of Ve(-lt) dt is -(V/l)e(-lt) so from 0 to 1  =(1-e(-lt))*V/l
	void makevolcanorf() {
		double volcdecay=2; // decay rate (lambda) of volcano rf (note need *dt if not 1!)
		for (int i=0; i<time.hiss1; i++) volcanorf[i]=volcorig[i]; 
		for (int ns=1; ns<time.hiss; ns++) {
			volcanorf[ns]=(float)(-volcfac.getval()*volcanorf[ns]*(1.0-Math.exp(-volcdecay))/volcdecay +volcanorf[ns-1]*Math.exp(-volcdecay)); 
		}
	}
	
	//******************************************
	//SOLAR
	//solar radiative forcing
	void solarrf() {
		double scf=2.0*Math.PI/11.0, ecf=2.0*Math.PI/4.5; 
		for (int ns=0; ns<(time.hiss); ns++) solarrf[ns]=(float)(solarrf2000.getval()/0.3)*solarrfdata[ns]; 
		for (int ns=time.hiss; ns<=time.glos; ns++) solarrf[ns]=(float)((solarrf2000.getval()/0.3)*(futuresolar.istrue() ? (0.3+0.06*Math.sin(scf*(ns+time.gsy-2003))) : 0.3) ); 
	}
	
	
	//****************************************************
	//DISTRIBUTE
	//distribute radiative forcing between N/S & L/O boxes
	//now this code become complex, could tidy using Jama matrices?
	
	float[][] splitrf=new float[time.glos2][4]; 
	double[] frac, splitnls=new double[4], splitnlw=new double[4], splitl=new double[4], splitsl=new double[4], splits=new double[4]; 
	
	void distribute() {
		if (unifdist.istrue()) {
			for (int i=0; i<4; i++) {	splitnls[i]=1f; splitnlw[i]=1f; splitl[i]=1f; splitsl[i]=1f; splits[i]=1f; }
		}
		else {
			frac=heatflux.frac; 
			//new N/S  and L/O splits based roughly on table 6.4 , 6.11 in TAR
			splitnls[0]=0.8*0.75/(0.75*frac[0]+0.25*frac[1]); splitnls[1]=splitnls[0]/3; 
			splitnls[3]=0.2*0.75/(0.75*frac[3]+0.25*frac[2]); splitnls[2]=splitnls[3]/3; 
			splitnlw[0]=0.6667*0.6667/(0.6667*frac[0]+0.3333*frac[1]); splitnlw[1]=splitnlw[0]/2; 
			splitnlw[3]=0.3333*0.6667/(0.6667*frac[3]+0.3333*frac[2]); splitnlw[2]=splitnlw[3]/2; 
			splitl[0]=0.6667/frac[0]; splitl[1]=0; splitl[3]=0.3333/frac[3]; splitl[2]=0; 
			splitsl[0]=0.3333*0.75/(0.75*frac[0]+0.25*frac[1]); splitsl[1]=splitsl[0]/3; 
			splitsl[3]=0.6667*0.75/(0.75*frac[3]+0.25*frac[2]); splitsl[2]=splitnls[3]/3; 
			splits[0]=0.25/0.5; splits[1]=0.25/0.5; splits[2]=0.75/0.5; splits[3]=0.75/0.5; 
		}
	} //end distribute
	
	//old distribution of sulphate forcing:
	//fsul[0]=0.6667*0.9/(0.9*heatflux.frac[0]+0.1*heatflux.frac[1]); fsul[1]=fsul[0]/9;
	//fsul[3]=0.3333*0.9/(0.9*heatflux.frac[3]+0.1*heatflux.frac[2]); fsul[2]=fsul[3]/9;
	
	void only4gas(int ns) {
		if (only4gas.istrue()) {
			cfcrf[ns]=0; hfcrf[ns]=0; tropo3rf[ns]=0; 
			strath2orf[ns]=0; strato3rf[ns]=0; 
			solarrf[ns]=0; if(ns<time.hiss) volcanorf[ns]=0; 
			bcrf[ns]=0; ocrf[ns]=0; aircontrf[ns]=0; 
			albedorf[ns]=0; bioburnrf[ns]=0; 
		}
		if (!(includesv.istrue())) {	solarrf[ns]=0; if(ns<time.hiss) volcanorf[ns]=0; }
	}
	
	void calcsplit(int ns) {
		
		for (int i=0; i<4; i++) {
			splitrf[ns][i]=(float)(
				co2rf[ns]+ch4rf[ns]+n2orf[ns]+cfcrf[ns]+hfcrf[ns]+strath2orf[ns]	//well mixed ghgs
				+solarrf[ns] + (ns<time.hiss ? volcanorf[ns] :0) 			//solar & volcano
				+(sulfdirrf[ns]+ bcrf[ns]+ocrf[ns]+aircontrf[ns])*splitnls[i]  	//strong bias to northern land
				+(sulfindrf[ns]+ tropo3rf[ns])*splitnlw[i] 				//weaker bias to northern land
				+albedorf[ns]*splitl[i]								//all on land
				+bioburnrf[ns]*splitsl[i]							//bias to southern land
				+strato3rf[ns]*splits[i]							//bias to south
				); 
		}
	}
	//******************************
	//TOTALS
	
	void calctotals(int ns) {
		totoghgrf[ns]= ch4rf[ns]+n2orf[ns]+cfcrf[ns]+ hfcrf[ns] +tropo3rf[ns]+strato3rf[ns] +strath2orf[ns] ; 
		totnatvrf[ns]= solarrf[ns] + (ns<time.hiss ? volcanorf[ns] :0) + albedorf[ns]; //note albedo here!
		totaerorf[ns]= sulfdirrf[ns]+ sulfindrf[ns]+ bcrf[ns]+ocrf[ns]+aircontrf[ns] +bioburnrf[ns]; //+dustrf[ns];
		totghgrf[ns]= co2rf[ns] + totoghgrf[ns];
		
		totanthrorf[ns]= totghgrf[ns] + totaerorf[ns];
		totalrf[ns]=  totanthrorf[ns] + totnatvrf[ns];
		
		co2eqkyoto[ns]=(float)( carboncycle.atppmprein* Math.exp((hfcrf[ns]+ch4rf[ns]+n2orf[ns]+co2rf[ns])*Math.log(2.0)/heatflux.rfco2double.getval() ) ); 
		co2eqghg[ns]=(float)( carboncycle.atppmprein* Math.exp((totoghgrf[ns]+co2rf[ns])*Math.log(2.0)/heatflux.rfco2double.getval() ) ); 
		co2eqghgaero[ns]=(float)( carboncycle.atppmprein* Math.exp((totoghgrf[ns]+co2rf[ns]+totaerorf[ns])*Math.log(2.0)/heatflux.rfco2double.getval() ) ); 
		
	}
	
	
	
	//*******************************************************
} //end radfor class


