//Calculations for regional climate changes

//Regclimap module originally developed March 2001 Copenhagen
//calculations moved here Autumn 2002 Louvain-la-neuve

package jcm.mod;

import jcm.*;
import java.awt.Color;

public class regcli extends module 	implements Runnable {
	
	public Thread datacalcthread; 
	
	public void setinteractions() {	setaffectedby(heatflux); }
	
	public String[]
		datasets={	"had3_A2_80", "had3_A2_50", "had3_A2_20", "hhgsax80", "hhgsax20", "eegga180", "gggsa150", "jjgsa180", "basehad3", "baseline", "both1", "both2"} ,
	quantities={	"tmp", "tmn", "tmx", "dtr", "pre", "cld", "vap", "wnd", "rad", "slp", "hum", "mix&tmx&tmn&pre", "mix&experimental"},
	months={	"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"}
	; 
	
	public param
		dataset=new param("dataset", datasets, "had3_A2_80"),
		month=new param("month", months, "jan"),
		year=new param("regcliyear", "yr", 2100, 1750, 2300),
		quantity=new param("quantity", quantities, "tmp"),
		scale=new param("scaletojcm", true)
		; 
	
	String oldqd=""; 
	
	public void precalc(iob iob) {
		if (iob==quantity || iob==dataset) {
			if (!(oldqd.equals(dataset.chosen+quantity.chosen))) {	//this stops it reloading if menu requests same thing twice
				oldqd=dataset.chosen+quantity.chosen; 
				gotdata=false; 
			}
		}
	}
	
	public static boolean 	 gotdata=false, ready=false; 
	
	public mapdata d=new mapdata(), d2=new mapdata(), d3=new mapdata(), d4=new mapdata(), d5=new mapdata(), d6=new mapdata(); 
	public double dataav; //average temp of dataset
	public int om=-1; //old month
	
	public void initsetup() {
		makeland(); 
		om=-1; //force recscale
		super.initsetup(); 
	}
	
	//main calculation
	//called by loop after change to parameters or heatflux module
	public void postcalc() {
		ready=false; 
		datacalcthread=new Thread (this); datacalcthread.start(); //load and calc data in a separate thread, so rest of model can plot
	}
	
	public void run() {
		
		if (!gotdata) {	getdata(); om=-1; }
		
		if (om!=month.getchosenindex()) om=month.getchosenindex(); 
		
		//note below is inefficient: don't always need to restore *and* scale
		if (quantity.chosen.startsWith("mix")) {
			if (dataset.chosen.startsWith("both")) {
				d.restore(om); d2.restore(om); d3.restore(om); d4.restore(om); d5.restore(om); d6.restore(om); 
				if (scale.istrue()) {	d4.scaledata(modelav()/dataav); d5.scaledata(modelav()/dataav); d6.scaledata(modelav()/dataav); }
				combine(d,d4); combine (d2,d5); combine (d3, d6); 
			}
			else {
				d.restore(om); d2.restore(om); d3.restore(om); 
				if (scale.istrue()  && !(dataset.chosen.startsWith("base"))) {	d.scaledata(modelav()/dataav); d2.scaledata(modelav()/dataav); d3.scaledata(modelav()/dataav); }
			}
			if (quantity.chosen=="mix&experimental") mix(d,d2); 
		}
		else {
			if (dataset.chosen.startsWith("both")) {	d2.restore(om); d2.scaledata(modelav()/dataav); d.restore(om); combine (d,d2); }
			else {
				d.restore(om); 
				if(scale.istrue()  && !(dataset.chosen.startsWith("base"))) d.scaledata(modelav()/dataav); 
			}
		}
			ready=true; 
		//this should make regclimap repaint (in case loading data takes some time and it failed before)
		if (triggerset) { while (loop.inmainloop) datacalcthread.yield(); /*debug ("rc"+ready+gotdata);*/ triggeriob.trigger(); triggerset=false; }
	} //end run
	
	//combine change and baseline - stores result in first dataset
	public void combine(mapdata d1, mapdata d2) {
		int k,k2; 
		for (int i=0; i<d.nlat; i++) for (int j=0; j<d.nlon; j++) {
			k=i*d.nlon+j; 
			//be careful with doubles and ints below! check by swap += with =
			k2=(int)(i*((double)d2.nlat/d.nlat))*d2.nlon+ (int)(j*((double)d2.nlon/d.nlon)); 
			if (d.r[k]>-999) {
				d.r[k]+=d2.r[k2]; 
			}
		}
	}
	
	
	//load data
	public void getdata() {
		gotdata=false; 
		if (quantity.chosen.startsWith("mix")) {
			if(dataset.chosen.startsWith("both")) {
				if(dataset.chosen=="both1") {
					d.getdata("basehad3", "tmx"); 
					d2.getdata("basehad3", "pre"); 
					d3.getdata("basehad3", "tmn"); 
				}
				else {
					d.getdata("baseline", "tmx"); 
					d2.getdata("baseline", "pre"); 
					d3.getdata("baseline", "tmn"); 
				}
				d4.getdata("had3_A2_80", "tmx"); 
				d5.getdata("had3_A2_80", "pre"); 
				d6.getdata("had3_A2_80", "tmn"); 
			}
			else {
				d.getdata(dataset.chosen, "tmx"); 
				d2.getdata(dataset.chosen, "pre"); 
				d3.getdata(dataset.chosen, "tmn"); 
			}
		}
		
		else if(dataset.chosen.startsWith("both")) {
			if(dataset.chosen=="both1") d.getdata("basehad3", quantity.chosen); else d.getdata("baseline", quantity.chosen); 
			d2.getdata("had3_A2_80", quantity.chosen); 
		}
		
		else {
			d.getdata(dataset.chosen, quantity.chosen); 
		}
		if (quantity.chosen=="tmp") {
			if (dataset.chosen.startsWith("both")) dataav=d2.av; 
			else if (dataset.chosen!="baseline") dataav=d.av; 
		}
		gotdata=true; 
	}
	
	//to get the average climate from the model
	//for the moment we assume baseline 1961-1990 is 0.3 above preindustrial
	//note the baseline climatology is 1961-1990
	public float modelav() {	return (heatflux.glotemp[(int)(year.val-time.gsy)]-heatflux.glotemp[0])-0.3f; }
	
	//old method not currently used!
	public float tempbase() {	return heatflux.glotemp[(int)heatflux.baseyear.getval()-time.gsy]-heatflux.glotemp[0]; }
	
	
	//make land-ocean mask
	public int[] land; 
	void makeland() {
		int[] hadoc= {
			//hadley grid (96*73) , numbers show number of consecutive cells ocean or land (wrap at end)
	363,4,5,6,78,20,31,2,43,4,2,13,29,7,41,3,6,10,24,1,2,13,28,4,4,5,6,9,11,3,9,25,11,3,6,6,2,7,4,8,10,7,3,37,2,22,2,2,3,6,12,2,1,41,5,21,3,2,4,3,5,2,5,3,1,42,5,19,6,1,4,2,13,3,2,35,2,1,8,18,5,2,22,1,2,31,5,1,16,12,4,4,15,1,3,1,2,31,5,2,17,13,2,5,14,2,1,36,4,1,19,13,1,6,12,40,25,19,14,13,2,23,25,10,1,5,2,1,14,8,3,2,1,23,1,1,24,10,2,4,17,1,2,1,1,3,3,2,1,22,2,1,24,15,16,3,5,8,1,20,3,1,24,14,17,2,8,6,1,17,2,1,2,1,26,12,18,5,7,22,4,2,26,12,19,5,6,23,32,10,19,15,1,19,33,9,19,15,2,18,34,4,22,19,2,14,36,3,22,13,1,5,3,12,37,3,4,1,16,14,1,5,4,3,2,4,39,3,1,1,3,2,14,15,1,3,5,3,3,3,40,4,19,15,1,2,6,2,5,3,2,1,39,2,18,17,8,1,5,3,3,1,39,1,18,18,7,1,5,2,4,1,40,1,1,4,13,17,19,1,41,6,12,3,2,11,14,1,3,1,44,6,12,2,3,10,14,1,2,2,44,7,16,9,15,1,2,2,43,8,16,8,16,2,1,3,4,1,37,10,15,7,17,1,8,2,36,12,13,7,27,2,35,12,13,7,65,11,13,7,25,1,39,10,14,7,2,1,20,3,1,1,37,10,14,7,2,1,19,6,38,9,14,6,3,1,19,7,38,8,14,6,2,1,18,10,37,7,15,6,2,1,18,10,37,6,17,4,22,10,37,6,17,4,22,10,36,6,18,3,23,3,2,5,36,6,50,4,36,5,52,2,37,4,62,1,29,3,62,1,30,2,62,1,31,2,94,2,94,1,95,1,96,1,384,1,29,3,7,16,39,2,24,35,34,3,16,45,32,3,13,48,15,20,10,53,4,29,8,54,5,94,5,330 	
		}; 
		land = new int[73*96]; 
		
		int k=0; int l=-1; 
		for (int i=0; i<hadoc.length; i++) {
			for (int j=0; j<hadoc[i]; j++) {	land[k]=l; k++; }
			l=-l; 
		}
		//check: for (int y=0; y<73; y++) {	System.out.println(); for (int x=0; x<96; x++) System.out.print(1+land[x+y*96]); }
	}//land
	
	
	public void mix(mapdata d1, mapdata d2) {
		int k; 
		for (int i=0; i<d.nlat; i++) for (int j=0; j<d.nlon; j++) {
			k=i*d.nlon+j; 
			d.r[k]=16*(
				4*( d.r[k]<(d.av-0.5*d.sd) ? 0 : d.r[k]<d.av ? 1 : d.r[k]<(d.av+0.5*d.sd) ? 2 : 3 )
				+( d2.r[k]<(d2.av-0.5*d2.sd) ? 0 : d2.r[k]<d2.av ? 1 : d2.r[k]<(d2.av+0.5*d2.sd) ? 2 : 3 )
				); 
		}
	}
	
} //end class regcli
	
	
	//*****************************************
	
	
	
	
