//Responsibility of each region for climate change
//developed for UNFCCC Brazilian proposal exercise

//Louvain-la-neuve July 02

/*
Note, this module comes at the end of the calculation step loop (see modlist),
so it can draw on results from other modules, but it should not affect them.
It won't be called unless an attribution plot is visible.
*/

package jcm.mod;
import jcm.*;


public class responsibility extends module {
	
	//*****************************
	//standard module bits
	
	public void setinteractions() {
		setaffectedby(loaddata); 
		setaffectedby(regshares); 
		setaffectedby(carboncycle); 
		setaffectedby(oghga); 
		setaffectedby(heatflux); 
		//note also precalc method
	}
	
	
	public param
		differential=new param("differential", false), //use Enting differential formula for RF
		simplecarbon=new param("simplecarbon", false), //ignore back fluxes
		startyear=new param("startyear", "", 1890, 1890, 2000),
		endyear=new param("endyear", "", 2100, 1990, 2100),
		regions=new param("regions", regionset.list, regionset.allreg.find("JCM12"))
		; 
	
	public void preinterac(iob i) {
		if (i==regions) makearrays(); 
		super.precalc(i); 
	}
	
	public void initsetup() {	super.initsetup(); makearrays(); }
	
	//****************************
	//attribution emissions start and end year, impact calculation year, number of years (for array)
	public int aesy=1890, aeey=2100, aiy=2100, nay=1+aiy-aesy, ally=time.glos2; 
	
	public int nreg, nemit, nrf, oth; 
	int ncb=carboncycle.ncb,  nhb=heatflux.nhb; 
	public float[][] emitfos, emitluc, emitch4, emitn2o, atco2, atch4, atn2o,  rfco2, rfch4, rfn2o, rftot, surftemp, sealevte, pop, gnp; 
	float[] ls,hs,so,hu; 
	float[][]ciq; float[][][] hiq; 
	public region regset; 
	
	/*
	public float[][] 	emitfos=new float[nemit][ally], 		emitluc=new float[nemit][ally], 		emitch4=new float[nemit][ally], 		emitn2o=new float[nemit][ally];
	public float[][]	atco2=new float[nemit][ally], atn2o=new float[nemit][ally], atch4=new float[nemit+1][ally]; //note extra for CH4 due to other gases affect lifetime!
	public float[][] 	rfco2=new float[nemit][ally], 		rfch4=new float[nemit+1][ally], 		rfn2o=new float[nemit][ally], 		rftot=new float[nrf][ally];
	public float[][] 	surftemp=new float[nrf][ally], 		sealevte=new float[nrf][ally];
	public float[][] 	pop=new float[nrf][ally] ,		gnp=new float[nrf][ally];
	float [] ls=new float[nemit], hs=new float [nemit], so=new float[nemit], hu=new float[nemit];
	float[][] ciq =new float[nemit][ncb];
	*/
	
	
	
	//set number of regions here; so changeable
	public void makearrays() {
		//note +1 for other/unattributed before start, after end, +4 adds also other gas, aerosol, solvol
		regset=	(region) regions.choseniob; 
		if (regset.code.equals("JCM12") && startyear.val<1900) startyear.val=1900; 
		nreg=regset.reg.size(); nemit=nreg+1; nrf=nreg+4; oth=nreg; 
		
		emitfos=new float[nemit][ally]; 
		emitluc=new float[nemit][ally]; 
		emitch4=new float[nemit][ally]; 
		emitn2o=new float[nemit][ally]; 
		
		atco2=new float[nemit][ally]; 
		atch4=new float[nemit+1][ally]; //note extra for CH4 due to other gases affect lifetime!
		atn2o=new float[nemit][ally]; 
		
		rfco2=new float[nemit][ally]; 
		rfch4=new float[nemit+1][ally]; 
		rfn2o=new float[nemit][ally]; 
		
		rftot=new float[nrf][ally]; 
		surftemp=new float[nrf][ally]; 
		sealevte=new float[nrf][ally]; 
		
		//pop, gnp data for ratios
		pop=new float[nrf][ally]; 
		gnp=new float[nrf][ally]; 
		
		//for carbon cycle
		ciq=new float[nemit][ncb]; 
		ls=new float[nemit]; hs=new float [nemit]; so=new float[nemit]; hu=new float[nemit]; 
		//for heat fluxes
		hiq=new float[nrf][2][nhb]; 
	}
	
	//****************************
	//data
	//edgar hyde emissions 1890-1990, 14 regions (last is total)
	//houghton regional landuse 1850-1990, 10 regions (last is total)
	//sres regional emissions 1990-2100, 6 scenarios, 5 regions (1st is total)
	float[][]
		ehch4=new float[14][11],
		ehn2o=new float[14][11],
		regluc=new float[10][141]
		; 
	float[][][]
		sresfos=new float[5][6][12],
		sresluc=new float[5][6][12],
		sresch4=new float[5][6][12],
		sresn2o=new float[5][6][12],
		srespop=new float[5][6][12],
		sresgnp=new float[5][6][12]
		; 
	
	float zero=0; //0.0000000001f; //dummy zero to prevent plot ignoring points
	float fostot, luctot, ch4tot, n2otot, n2omod, aviafrac, shipfrac, bunfrac, extrach4, extran2o, fracn2o; 
	String debug=""; 
	
	//####################################
	//PRECALC
	public void precalc() {
		if (changed && needed) {	loop.calcfutureonly=false; carboncycle.changed=true; heatflux.changed=true; }
		//this forces carboncycle and heatflux to recalc, so that this module can access their temporary state of boxes/fluxes within the timestep loop
		//but these modules are not affected by responsibility (would be very inefficient)
		if (startyear.getval()<1890) startyear.setval(1890); 
		if (endyear.getval()>2100) endyear.setval(2100); 
		debug=""; 
	}
	
	//CALCSTEP
	public void calcstep(int ns) {
		
		int year=ns+time.gsy, rs=ns; //year-aesy;
		if (rs>=0 && rs<(ally)) {
			
			emitstep(rs, ns, year); 
			carbonstep(rs, ns, year); 
			atchemstep(rs, ns, year); 
			rfstep(rs, ns, year); 
			heatfluxstep(rs, ns, year); 
			popgnp(rs, ns, year); 
		} //if rs
	} //end calcstep
	
	public void postcalc() {	iob.debug(debug); }
	
	//####################################
	//EMISSIONS
	
	void emitstep(int rs, int ns, int year) {
		
		if (year>=startyear.getval() && year<=endyear.getval()) {
			
			if (regset.code.equals("SRES4")) {
				for (int nr=0; nr<nreg ; nr++) {
					if (year<1990) {
						emitfos[nr][rs] = regionset.jcmtosres(regshares.emit, nr, year); 
						emitluc[nr][rs] = regionset.houghtontosres(regluc, nr, year); 
						emitch4[nr][rs] = regionset.ehtosresinterp(ehch4, nr, year) * 16f/12f ; //EH uses MtC, SRES uses MtCH4
						emitn2o[nr][rs] = regionset.ehtosresinterp(ehn2o, nr, year); 
					} else {
						if (mitigation.scenario.chosen.equals("nopolicy")) 	emitfos[nr][rs] = regionset.sresinterp(sresfos, nr, year) * 1000f; 
						else 	emitfos[nr][rs] = regionset.jcmtosres(regshares.emit, nr, year); 
						//others should be scaled down to correct global totals by methods below
						emitluc[nr][rs] = regionset.sresinterp(sresluc, nr, year) * 1000f; 
						emitch4[nr][rs] = regionset.sresinterp(sresch4, nr, year); 
						emitn2o[nr][rs] = regionset.sresinterp(sresn2o, nr, year); 
					}
				} //nr
			} //sres4
			
			else 	if (regset.code.equals("JCM12")) {
				
				for (int nr=0; nr<nreg ; nr++) {
					emitfos[nr][rs] = (year>=1900 && year<=2100 && nr!=12)  ? regshares.emit[nr][year-1900] : 0; 
					if (year<1990) {
						emitluc[nr][rs] = regionset.houghtontojcm(regluc, nr, year); 
						emitch4[nr][rs] = regionset.ehtojcm(ehch4, nr, year) * 16f/12f ; //EH uses MtC
						emitn2o[nr][rs] = regionset.ehtojcm(ehn2o, nr, year); 
					} else {
						//keep 1990 distribution (scaling below will adjust to right total). maybe would be better to scale also to SRES distn?
						emitluc[nr][rs] = emitluc[nr][rs-1]; 
						emitch4[nr][rs] = emitch4[nr][rs-1]; 
						emitn2o[nr][rs] = emitn2o[nr][rs-1]; 
					}
				}
			} //jcmset
			else {	}	//not yet implemented
			
			//*************************
			//other unattributed etc
			
			emitfos[oth][rs] = zero; emitluc[oth][rs] = zero; emitch4[oth][rs] = zero; emitn2o[oth][rs] = zero; 
			if (year>2000 && regset.code.equals("SRES4") && !mitigation.scenario.chosen.equals("nopolicy") && regshares.distribution.chosen.equals("unspecified")) emitfos[oth][rs] = carboncycle.fossil[ns]; 
			
			//scale land use emissions, according to options on carbonplot (usually down as houghton too high)
			luctot=0; for (int nr=0; nr<nreg ; nr++) luctot += emitluc[nr][rs]; 
			for (int nr=0; nr<nreg ; nr++) emitluc[nr][rs]*=carboncycle.lucf[ns] /luctot; 
			
			//scale n2o up as edgar-hyde far too low (note oghga.n2oemit based on inverse from conc)
			n2otot=0; for (int nr=0; nr<nreg ; nr++) n2otot += emitn2o[nr][rs]; 
			for (int nr=0; nr<nreg; nr++) emitn2o[nr][rs]*= oghga.n2oemit[ns]/n2otot; 
			/*
			//add extra n2o emissions to "other" category as such a big difference
			n2otot=0; for (int nr=0; nr<nreg ; nr++) n2otot += emitn2o[nr][rs];
			emitn2o[oth][rs] +=oghga.n2oemit[ns]-n2otot;
			*/
			
			//scale down ch4 emissions to match oghga total (small adjustment)
			ch4tot=0; for (int nr=0; nr<nreg ; nr++) ch4tot += emitch4[nr][rs]; 
			for (int nr=0; nr<nreg; nr++) emitch4[nr][rs]*= oghga.ch4emit[ns]/ch4tot; 
			
			/*
			if put CH4 difference in other category as for N2O,
			extra is slightly negative - hard to see on stacked plot
			also it makes it look like lifetime of emissions before start too long
			but if don't correct at all, differential RF (cumulative) higher than total RF
			*/
			
		} else {	//outside regional year range
			for (int nr=0; nr<nreg ; nr++) {	emitfos[nr][rs] = zero; emitluc[nr][rs] = zero; emitch4[nr][rs] = zero; emitn2o[nr][rs] = zero; }
			emitfos[oth][rs] = carboncycle.fossil[ns]; 
			emitluc[oth][rs] = carboncycle.lucf[ns]; 
			emitch4[oth][rs] = oghga.ch4emit[ns]; 
			emitn2o[oth][rs] = oghga.n2oemit[ns]; 
		}
		
	} //emitstep
	
	//####################################
	//calc pop and gnp for dividing
	//note not efficient to put this in loop as only changes with sres!
	void popgnp(int rs, int ns, int year) {
		float poptot=0, gnptot=0; 
		year=(year<2100 ? year : 2100); //after 2100, assume fixed
		
		for (int nr=0; nr<nreg; nr++) {
			if (regset.code.equals("SRES4")) {
				if (year<1990) {
					pop[nr][rs] = regionset.jcmtosres(people.pop, nr, year); 
					gnp[nr][rs] = regionset.jcmtosres(people.gdp, nr, year); 
				} else {
					pop[nr][rs] = regionset.sresinterp(srespop, nr, year); 
					gnp[nr][rs] = regionset.sresinterp(sresgnp, nr, year)*1000f; 
				}
			}	else 	if (regset.code.equals("JCM12")) {
				pop[nr][rs] = (year>=1900 && year<=2100 && nr<12)  ? people.pop[nr][year-1900] : 0; 
				gnp[nr][rs] = (year>=1970 && year<=2100 && nr<12)  ? people.pop[nr][year-1900] : 0; 
			}
			poptot+=pop[nr][rs]; gnptot+=gnp[nr][rs]; 
		}
		
		
		//bunker, other gases etc. use world total
		for (int nr=oth; nr<(nrf); nr++) {
			pop[nr][rs] =poptot; gnp[nr][rs]=gnptot; 
		}
		
	} //popgnp
	
	
	
	//####################################
	//ATCHEM
	void atchemstep(int rs, int ns, int year) {
		
		if (rs==0) {
			for (int nr=0; nr<nreg ; nr++) {	atch4[nr][rs]=0; atn2o[nr][rs]=0; }
			atch4[oth][rs]=oghga.ch4conc[ns]-oghga.ch4prein; atch4[nemit][rs]=0; 
			atn2o[oth][rs]=oghga.n2oconc[ns]-oghga.n2oprein; 
		}
		else {
			
			for (int nr=0; nr<(nemit) ; nr++) {
				atch4[nr][rs]=
					atch4[nr][rs-1]*(1f-1f/oghga.ch4life(ns))
					+(float)(oghga.ppbpmtch4 * emitch4[nr][rs]); 
				atn2o[nr][rs]=
					atn2o[nr][rs-1]*(1f-1f/oghga.n2olife(ns))
					+(float)(oghga.ppbpmtn * emitn2o[nr][rs]); 
			} //nr
			
			
			/*correction for any effect of changing baseline if natural emissions not consistent with lifetime or latter changing
			this should ensure consistency with concentrations in main JCM calculations
			But how to attribute this extra change in concentration?
			for co2 extra (nonlinear) sea-air flux attributed according to fraction of extra carbon in mixed layer
			for n2o which affects its own lifetime, apply similar principle, according to concentration
			however for ch4, this is due to changing OH which is affected by several gases
			- so until we can attribute OH, assign this to "other gas" category (nemit)
			*/
			extrach4=(oghga.ppbpmtch4 * oghga.ch4emitnat() - oghga.ch4prein /oghga.ch4life(ns) ); 
			atch4[nemit][rs] = atch4[nemit][rs-1]*(1f-1f/oghga.ch4life(ns)) + extrach4; //other gas category
			
			extran2o=(oghga.ppbpmtn * oghga.n2oemitnat - oghga.n2oprein /oghga.n2olife(ns) ); 
			fracn2o=(oghga.n2oconc[ns]-oghga.n2oprein); //avoid dividing by tiny quantities
			if (fracn2o>0.1) for (int nr=0; nr<(nemit); nr++) atn2o[nr][rs]+= extran2o*atn2o[nr][rs]/fracn2o; 
		} //rs>0
	} //atchemstep
	
	//#######################
	//CARBON CYCLE
	
	float sink, atinc, lsinc, hsinc, fracat, fracls, frachs,  totls, toths, totat, npinc, dls, dhs, dnp, dat, totemit, oldtotemit; 
	float soinc, huinc, fracso, frachu, totso, tothu, dso, dhu; 
	
	void carbonstep(int rs, int ns, int year) {
		
		if (simplecarbon.istrue()) {
			if (rs==0) {
				for (int nr=0; nr<nreg ; nr++) 	atco2[nr][rs]=0; 
				atco2[oth][rs]=carboncycle.atppm[ns]-(float)carboncycle.atppmprein; 
			}
			else {
				// simple method assumes fraction of *NET* sinks proportional to fraction of (anthrop) atmospheric concentration
				for (int nr=0; nr<nemit; nr++) {
					atco2[nr][rs]=
						atco2[nr][rs-1]*(1f-((float)carboncycle.ppmpmtc*carboncycle.totsink[ns]/(carboncycle.atppm[ns]-(float)carboncycle.atppmprein)))
						+(float)(carboncycle.ppmpmtc*( emitfos[nr][rs] + emitluc[nr][rs])) ; 
				}
			}
			
		}
		
		else {	//not simple method
			
			/*
			Since this module follows carboncycle.java in same step loop,
			we can scale the global nonlinear fluxes in proportion to the attributed fraction from the source box,
			i.e. fraction of the atmosphere for npinc (fertilisation air=>bio),
			and of ls and hs boxes for lsinc and hsinc which are sea=>air fluxes (the extra due to carbonate chemistry).
			This proportionality based on previous timestep to avoid iteration.
			(the iteration and chemistry are the slow parts of carbon calcstep)
			Note that this only works if carbon module always calculated!
			*/
			
			if (rs==0) 	{
				for (int n=0; n<ncb; n++) {
					for (int nr=0; nr<nreg; nr++) ciq[nr][n]=0; 
					//"oth" category gets all the anthrop CO2 already accumulated in start year
					ciq[oth][n]=(float)carboncycle.ciq[n]; 
				}
			}
			
			
			//if (ns<100) debug+="\n"+ns+((rs>0) ? " "+heatflux.glotemp[ns-1] : "");
			for (int nr=0; nr<nemit; nr++) {
				
				oldtotemit= rs>0 ? (emitfos[nr][rs-1] + emitluc[nr][rs-1]) : 0; 
				totemit= emitfos[nr][rs] + emitluc[nr][rs]; 
				
				fracat= (rs>0) ? (atco2[nr][rs-1]/(carboncycle.atppm[ns-1]-(float)carboncycle.atppmprein)) : 0; 
				fracls= (rs>0) ? ls[nr]/totls : 0; //(float)carboncycle.oldls : 0;
				frachs= (rs>0) ? hs[nr]/toths : 0; 
				
				/*
				//below is not correct- because effect is due to temperature! - should attribute accordingly
				//also problems when anthropogenic soil carbon goes negative
				fracso= (rs>0) ? so[nr]/totso : 0;
				frachu= (rs>0) ? hu[nr]/tothu : 0;
				*/
				fracso= (rs>0) ? surftemp[nr][rs-1]/heatflux.glotemp[ns-1] : 0; 
				if ((fracso>0 && fracso<0.01) || (fracso<0 && fracso>-0.01)) fracso=0; 
				//if (ns<100) debug+=(rs>0) ? (" *"+nr+" "+surftemp[nr][rs-1]+" "+fracso) : "";
				frachu= fracso; 
				
				//use the *old* values for the step function
				lsinc=(float)carboncycle.oldlsinc*fracls; 
				hsinc=(float)carboncycle.oldhsinc*frachs; 
				npinc=(float)carboncycle.oldnpinc*fracat; 
				soinc=(float)carboncycle.oldsoinc*fracso; 
				huinc=(float)carboncycle.oldhuinc*frachu; 
				atinc= oldtotemit - (lsinc+hsinc+npinc+soinc+huinc); 
				//and changes for the ramp function
				dls=(float)carboncycle.dls*fracls; 
				dhs=(float)carboncycle.dhs*frachs; 
				dnp=(float)carboncycle.dnp*fracat; 
				dso=(float)carboncycle.dso*fracso; 
				dhu=(float)carboncycle.dhu*frachu; 
				
				dat= (totemit-oldtotemit) -(dls+dhs+dnp+dso+dhu); 
				atco2[nr][rs]=0; ls[nr]=0; hs[nr]=0; so[nr]=0; hu[nr]=0; 
				
				for (int n=0; n<ncb; n++) {
					
					//apply the prop & step & ramp functions
					ciq[nr][n]=(float)(
						ciq[nr][n]*carboncycle.cpropf[n]
						+carboncycle.scicAT[n]*atinc
						+carboncycle.scicLS[n]*lsinc
						+carboncycle.scicHS[n]*hsinc
						+carboncycle.scicNP[n]*npinc
						+carboncycle.rcicAT[n]*dat
						+carboncycle.rcicLS[n]*dls
						+carboncycle.rcicHS[n]*dhs
						+carboncycle.rcicNP[n]*dnp
						+carboncycle.scicSO[n]*soinc
						+carboncycle.rcicSO[n]*dso
						+carboncycle.scicHU[n]*huinc
						+carboncycle.rcicHU[n]*dhu
						); 
					//and calculate new concentration
					atco2[nr][rs]+=(float)carboncycle.crAT[n]*ciq[nr][n]; 
					ls[nr]+=(float)carboncycle.crLS[n]*ciq[nr][n]; 
					hs[nr]+=(float)carboncycle.crHS[n]*ciq[nr][n]; 
					so[nr]+=(float)carboncycle.crSO[n]*ciq[nr][n]; 
					hu[nr]+=(float)carboncycle.crHU[n]*ciq[nr][n]; 
				} //n
				atco2[nr][rs]*=(float)carboncycle.ppmpmtc; 
				
			} //nr
			
			//new totals
			totls=0; toths=0; totat=0; totso=0; tothu=0; 
			for (int nr=0; nr<(nemit); nr++) {
				totls+=ls[nr]; toths+=hs[nr]; totat+=atco2[nr][rs]; totso+=so[nr]; tothu+=hu[nr]; 
			}
		} //not simple
	} //carbonstep
	
	//####################################
	//RADIATIVE FORCING
	
	/* differential RF formula taken from Enting papers,
	it seems OK with CO2,
	however causes a long "memory" with CH4
	beware total emissions must be consistent with oghga if use oghga concs!
	*/
	float dc; 
	
	void rfstep(int rs, int ns, int year) {
		
		float totarf; 
		for (int nr=0; nr<(nemit+1) ; nr++) {
			
			if (differential.istrue() && year>(startyear.getval()+1)) {
				if (nr<(nemit)){
					//year because first step is too big to apply differential rate
					dc=(carboncycle.atppm[ns]-carboncycle.atppm[ns-1]); 
					rfco2[nr][rs]=rfco2[nr][rs-1]+ ((Math.abs(dc)>0.00001) ? (radfor.co2rf[ns]-radfor.co2rf[ns-1])*(atco2[nr][rs]-atco2[nr][rs-1])/dc : 0); 
					dc=(oghga.n2oconc[ns]-oghga.n2oconc[ns-1]); 
					rfn2o[nr][rs]=rfn2o[nr][rs-1]+ ((Math.abs(dc)>0.00001) ? (radfor.n2orf[ns]-radfor.n2orf[ns-1])*(atn2o[nr][rs]-atn2o[nr][rs-1])/dc: 0); 
				}
				dc=(oghga.ch4conc[ns]-oghga.ch4conc[ns-1]); 
				rfch4[nr][rs]=rfch4[nr][rs-1]+ ((Math.abs(dc)>0.00001) ? (radfor.ch4rf[ns]-radfor.ch4rf[ns-1])*(atch4[nr][rs]-atch4[nr][rs-1])/dc : 0); 
			}
			
			else {
				if (nr<(nemit)){
					dc=(carboncycle.atppm[ns]-(float)carboncycle.atppmprein); 
					rfco2[nr][rs]=atco2[nr][rs]* ((Math.abs(dc)>0.00001) ? radfor.co2rf[ns]/dc : 0); 
					dc=(oghga.n2oconc[ns]-oghga.n2oprein); 
					rfn2o[nr][rs]=atn2o[nr][rs]* ((Math.abs(dc)>0.00001) ? radfor.n2orf[ns]/dc : 0); 
				}
				dc=(oghga.ch4conc[ns]-oghga.ch4prein); 
				rfch4[nr][rs]=atch4[nr][rs]* ((Math.abs(dc)>0.00001) ? radfor.ch4rf[ns]/dc : 0); 
			}
			
		} //nr
		
		
		
		totarf=0; 
		for (int nr=0; nr<(nemit) ; nr++) {
			rftot[nr][rs]=rfco2[nr][rs]+rfch4[nr][rs]+rfn2o[nr][rs]; 
			totarf+=rftot[nr][rs]; 
		}
		
		rftot[nemit][rs]=rfch4[nemit][rs]+radfor.cfcrf[ns]+radfor.hfcrf[ns]+radfor.strath2orf[ns]+radfor.tropo3rf[ns]+radfor.strato3rf[ns]; 
		rftot[nemit+1][rs]=radfor.totaerorf[ns]; 
		rftot[nreg+3][rs]=radfor.totnatvrf[ns]; 
		
	} //rfstep
	
	/*
	Note: RF from other gases includes any due to accumulated conc before start
	also includes effect of changing CH4 lifetime (see note above)!
	OK if start before 1970 (as no fgases and ozone has short life)
	but if start much later should calc separately to shift to "other" category
	*/
	
	//####################################
	/*
	HEAT FLUXES: surface temp and sealevel
	adapted from heatflux.java but a bit simpler:
	no upwelling feedback (yet)
	only well mixed rf same for all surface boxes
	no north-south flux (as setting the rate to zero makes hardly any difference to global temp)
	(note the two oceans are still different as northern has more land => cools/warms faster).
	*/
	
	float qin, qinold, dqin; 
	float[] rff=new float[2], sf=new float[2], mlt=new float[2], boxtemp=new float[4]; 
	
	void heatfluxsetup() {
		for (int o=0; o<2; o++) {
			//factor to combine direct input from rf + input via land
			rff[o]=(float)(1f+ (heatflux.frac[o*3]/heatflux.frac[o+1])*heatflux.klo/(heatflux.kls*heatflux.frac[o*3]+heatflux.klo)); 
			sf[o]=(float)(heatflux.spaceflux[o]*heatflux.qpt*heatflux.tstart); 
			for (int n=0; n<nhb; n++) {
				//fill boxes: oth gets all the heat already accumulated, others start with steady-state
				for (int nr=0; nr<(nrf) ; nr++)
					hiq[nr][o][n]=(float) ( (nr==oth) ?  heatflux.hiq[o][n] : heatflux.hiqstart[o][n]) ; 
			}
		} //o
	} //hf setup
	
	void heatfluxstep(int rs, int ns, int year) {
		
		if (rs==0) heatfluxsetup(); 
		
		for (int nr=0; nr<nrf ; nr++) {
			surftemp[nr][rs]=0; 
			sealevte[nr][rs]=0; 
			
			for (int o=0; o<2; o++) {	//for each ocean
				
				mlt[o]=0; 
				
				//calc heat input to each ocean mixed layer (watt-year per m2)
				qinold = sf[o] + (rs>0 ? rftot[nr][rs-1] : 0) *rff[o]; 
				qin=  sf[o] + rftot[nr][rs]*rff[o]; 
				dqin= qin-qinold; 
				
				for (int n=0; n<nhb; n++) {	//for each layer
					
					//apply prop, step, ramp functions
					hiq[nr][o][n]= (float)(
						heatflux.hpropf[o][n]*hiq[nr][o][n]
						+ heatflux.shicML[o][n]*qinold
						+ heatflux.rhicML[o][n]*dqin
						); 
					
					//calc new surface temperatures
					mlt[o]+=(float)heatflux.hrML[o][n]*hiq[nr][o][n]; 
					//sea-level rise due to thermal expansion (averages both oceans)
					sealevte[nr][rs]+=(float)heatflux.hrsl[o][n]*hiq[nr][o][n]; 
					
				} //nhb
				
				mlt[o]= (float)(mlt[o]/heatflux.qpt - heatflux.tstart); //convert to temp rise
			} //o
			
			sealevte[nr][rs]-=(float)heatflux.sealevteinit; //convert to change
			
			boxtemp[0]=(float)((mlt[0]*heatflux.cice*heatflux.klo + heatflux.frac[0]*rftot[nr][rs])/(heatflux.kls*heatflux.frac[0]+heatflux.klo)); 
			boxtemp[3]=(float)((mlt[1]*heatflux.cice*heatflux.klo + heatflux.frac[3]*rftot[nr][rs])/(heatflux.kls*heatflux.frac[3]+heatflux.klo)); 
			boxtemp[1]=(float)(mlt[0]*heatflux.cice); 
			boxtemp[2]=(float)(mlt[1]*heatflux.cice); 
			for (int i=0; i<4; i++) surftemp[nr][rs]+=(float)(boxtemp[i]*heatflux.frac[i]); 
			if (surftemp[nr][rs]>0 && surftemp[nr][rs]<0.01 ||  surftemp[nr][rs]<0 && surftemp[nr][rs]>-0.01) 		surftemp[nr][rs]=0; 
		} //nr
		
	} //end heatfluxstep
	
} //end responsibility
	
	
	
	/*
	//BUNKER
	//if bunker not separate, share out historical bunker according to fossil emissions
	if (!bunker.istrue() && year<1990) {
	fostot=0; for (int r=0; r<4; r++) fostot+=emitfos[r][rs];
	for (int r=0; r<4; r++) emitfos[r][rs]+=emitfos[4][rs]*emitfos[r][rs]/fostot;
	emitfos[4][rs]=zero;
}
	//SRES doesn't include bunker fuels
	//so if separate bunker, take same fraction from each region,
	//aviation fraction increases over time approx consistent with IPCC SR Aviation scenario Fa1 as frac of IS92A
	if (bunker.istrue() && year>=1990) {
	shipfrac=0.019f; aviafrac= (year<2020) ? (0.024f + 0.0002f*(year-1990)) : 0.03f;
	for (int r=0; r<4; r++) {
	bunfrac=emitfos[r][rs]*(aviafrac+shipfrac);
	emitfos[4][rs]+=bunfrac; emitfos[r][rs]-=bunfrac;
}
}
	
	//and from jcmtosres:
	//		if (reg==4) return regshares.bunker[year-time.gsy];
	
	*/
